/*
This code was originally written by Gabriel Perez-Quiros for the paper
McConnell, M.M. and Perez-Quiros, G. (2000), "Output Fluctuations 
in the United States: What has Changed since the Early 1980s?", 
American Economic Review, 90: 1464-1476.
We thank the author for giving us permission to use and distribute it. 
*/

@ These GAUSS procedures evaluate Markov transition matrix, evaluate
   likelihood function, and evaluate filter and smoothed probababilities @

/* ============================================================== */
proc matf1(pm1);  @This proc returns the (n x n) matrix F of Markov
                  transition probabilities for state vector @
local iz,iw,ib,na,nb,nc,fz,fm;

@ set initial values for use with iteration @
na = 1;
nb = ns;
nc = ns*ns;
fm = pm1;
iz = 1;
  do until iz > ps1;
     fz = fm;
     fm = zeros(nc,nc);
     iw = 1;
     do until iw > ns;
         fm[((iw-1)*nb+1):(iw*nb),((iw-1)*na+1):(iw*na)]
            = fz[1:nb,((iw-1)*na+1):iw*na];
     iw = iw+1;
     endo;
     ib = 2;
     do until ib > ns;
        fm[1:nc,((ib-1)*nb+1):ib*nb]  = fm[1:nc,1:nb];
     ib = ib+1;
     endo;
     na = na*ns;
     nb = nb*ns;
     nc = nc*ns;
  iz = iz+1;
  endo;
retp(fm);
endp;
/* ==================================================================== */

proc matf2(pm2);  @This proc returns the (n x n) matrix F of Markov
                  transition probabilities for state vector @
local iz,iw,ib,na,nb,nc,fz,fm;

@ set initial values for use with iteration @
na = 1;
nb = ns;
nc = ns*ns;
fm = pm2;
iz = 1;
  do until iz > ps2;
     fz = fm;
     fm = zeros(nc,nc);
     iw = 1;
     do until iw > ns;
         fm[((iw-1)*nb+1):(iw*nb),((iw-1)*na+1):(iw*na)]
            = fz[1:nb,((iw-1)*na+1):iw*na];
     iw = iw+1;
     endo;
     ib = 2;
     do until ib > ns;
        fm[1:nc,((ib-1)*nb+1):ib*nb]  = fm[1:nc,1:nb];
     ib = ib+1;
     endo;
     na = na*ns;
     nb = nb*ns;
     nc = nc*ns;
  iz = iz+1;
  endo;
retp(fm);
endp;
/* ==================================================================== */

/* ================================================================= */
proc ofn(th);  @ this proc evaluates filter probs and likelihood @
    local ncount,mu,phi,sig,pm,eta,iz,fm,chsi,it,f,fit,fx,hw,fj,
    fit1,fit2,fx1,fx2, ij,ap,const,pq1,pq2,hk,ihk,sigs,pm1,pm2,
ap1,ap2,chsi1,chsi2,fm1,fm2,mus,consts,phi2,eta1,eta2,elo,elo1,elo2;

@ Convert parameter vector to convenient form @
   mu = th[1:xox,1];
   mus = th[3:4,1];

   ncount = xox+2+ 1;  @ ncount is the number of params read @
      phi = 1 | -th[ncount:ncount+pphi-1];
   ncount = ncount + pphi;


        sig = th[ncount:ncount+ns-1,1].*hp2[1:ns,.];
        sig = sumc(sig);
        ncount = ncount + ns;
      if izz == 1;
         sig = sig^2;
      endif;
   pm1 = matpm(th[ncount:ncount+1,1]);
   pm2 = matpm(th[ncount+2:ncount+3,1]);

@ Construct constant term to be subtracted for each observation @
const = phi .*. mu;
const = const'*hp1;
consts = phi .*. mus;
consts = consts'*hp1;

@ Convert data to AR resids @
  eta = y[nk:capt,1];
  iz = 1;
    do until iz > pphi;
       eta = eta ~y[nk-iz:capt-iz,1];
    iz = iz+1;
    endo;

  eta1 = ((eta*phi - const)^2).*. (1/sig[1]);

  eta2 = ((eta*phi - consts)^2).*. (1/sig[2]);

  elo1 = eta*phi - const;
  elo2 = eta*phi - const;
 elo=elo1[.,1]~elo2[.,1]~
elo1[.,2]~elo2[.,2]~elo1[.,3]~elo2[.,3]~elo1[.,4]~elo2[.,4];


  sigs=ones(1,4).*.sig';
 eta=eta1[.,1]~eta2[.,1]~
eta1[.,2]~eta2[.,2]~eta1[.,3]~eta2[.,3]~eta1[.,4]~eta2[.,4];

  eta =(1/sqrt(2*pi))* (1./sqrt(sigs)).*exp(-eta/2);

@ Calculate ergodic probabilities @
     fm1 = matf1(pm1);
     ap1 = (eye(n1)-fm1)|ones(1,n1);
    chsi1 = sumc((invpd(ap1'*ap1))');
    chsi1 = maxc(chsi1'|zeros(1,n1));  @ This line eliminates roundoff error @
     if kc > 1;
         "";"Matrix of Markov transition probabilities 1:";pm1;
                  pq1 = hp1*chsi1;pq1[1:ns,1]';
     endif;

     fm2 = matf2(pm2);
     ap2 = (eye(n2)-fm2)|ones(1,n2);
    chsi2 = sumc((invpd(ap2'*ap2))');
    chsi2 = maxc(chsi2'|zeros(1,n2));  @ This line eliminates roundoff error @
     if kc > 1;
         "";"Matrix of Markov transition probabilities 2:";pm2;
                  pq2 = hp2*chsi2;pq2[1:ns,1]';
     endif;
  chsi=chsi1.*.chsi2;
@ Filter iteration @
   f = 0;
   it = 1;
   do until it > captst;
     fx = chsi .* eta[it,.]';
     fit = sumc(fx);
     fx1 =
 (fx[1,.]+fx[2,.])|(fx[3,.]+fx[4,.])|(fx[5,.]+fx[6,.])|(fx[7,.]+fx[8,.]);
     fit1 = sumc(fx1);
     fx2 =
 (fx[1,.]+fx[3,.]+fx[5,.]+fx[7,.])|(fx[2,.]+fx[4,.]+fx[6,.]+fx[8,.]);
     fit2 = sumc(fx2);


     skif[it,.] = fx'/fit;
     f = f + ln(fit);
     chsi1 = fm1*fx1/fit1;
     chsi2 = fm2*fx2/fit2;
  chsi=chsi1.*.chsi2;
   it = it+1;
   endo;


eloles=elo.*skif;
eloles=eloles';
eloles=sumc(eloles);
@ Calculate smoothed probs if desired @
if ks == 2;
skif1=skif[.,1]+skif[.,2]~skif[.,3]+skif[.,4]~
skif[.,5]+skif[.,6]~skif[.,7]+skif[.,8];
skif2=skif[.,1]+skif[.,3]+skif[.,5]+skif[.,7]~
skif[.,2]+skif[.,4]+skif[.,6]+skif[.,8];


   skis1[captst,.] = skif1[captst,.];
   it = 1;
   do until it == captst;
      if minc(skif1[captst-it,.]') > 1.e-150;
         skis1[captst-it,.] = skif1[captst-it,.].*
               ((skis1[captst-it+1,.]./(skif1[captst-it,.]*fm1'))*fm1);
      else;   @ adjust code so as not to divide by zero @
          hk = skif1[captst-it,.]*fm1';
          ihk = 1;
          do until ihk > n;
              if hk[1,ihk] > 1.e-150;
                 hk[1,ihk] = skis1[captst-it+1,ihk]/hk[1,ihk];
              else;
                 hk[1,ihk] = 0;
              endif;
          ihk = ihk + 1;
          endo;
          skis1[captst-it,.] = skif1[captst-it,.].*(hk*fm1);
      endif;
   it = it+1;
   endo;

   skis2[captst,.] = skif2[captst,.];
   it = 1;
   do until it == captst;
      if minc(skif2[captst-it,.]') > 1.e-150;
         skis2[captst-it,.] = skif2[captst-it,.].*
               ((skis2[captst-it+1,.]./(skif2[captst-it,.]*fm2'))*fm2);
      else;   @ adjust code so as not to divide by zero @
          hk = skif2[captst-it,.]*fm2';
          ihk = 1;
          do until ihk > n;
              if hk[1,ihk] > 1.e-150;
                 hk[1,ihk] = skis2[captst-it+1,ihk]/hk[1,ihk];
              else;
                 hk[1,ihk] = 0;
              endif;
          ihk = ihk + 1;
          endo;
          skis2[captst-it,.] = skif2[captst-it,.].*(hk*fm2);
      endif;
   it = it+1;
   endo;


endif;

@ Print out value of log likelihood if desired @
if kc == 2;
    "";"Log likelihood:";f;
 endif;

retp(-f);
endp;
/*=========================================================================*/
