/*Applies Structural Break Tests and P-Value Computations*/
cls;
#include st_ch.prc;
data="gdp";  //alternatives are gdp, ip, sales, emp

if data$=="gdp"; 
    arorder=5;
    trendflag=1;
    salesflag=0;
    first=1953;
    start=196;
    offset=0;
    hcc=1;
elseif data$=="ip"; 
    arorder=5;
    trendflag=0;
    salesflag=0;
    first=1960;
    start=160;
    offset=8;
    hcc=1;
elseif data$=="emp"; 
    arorder=5;
    trendflag=0;
    salesflag=0;
    first=1960;
    start=168;
    offset=0;
    hcc=1;
elseif data$=="sales";  
    arorder=1;
    trendflag=0;
    salesflag=1;
    first=1967;
    start=140;
    offset=0;
    hcc=1;
endif;

outfile="htest_"$+data$+".out";
output file = ^outfile reset;
strdat="us_"$+data$+"_nsa.txt";

load dat[]=^strdat;
nobs_data=rows(dat);
y=ln(dat[2+offset:nobs_data])-ln(dat[1+offset:nobs_data-1]);

nobs=nobs_data-offset-1;

if data$=="sales";
    dummy97=zeros(nobs,1);
    dummy97[120,1]=1;  //97Q1
endif;

seas=zeros(nobs_data,4);
trend=ones(nobs_data,1);
strend=zeros(nobs_data,4);
const=ones(nobs,1);

for i (1,floor(nobs_data/4)*4,4);
    seas[i:i+3,1:4]=eye(4);
endfor;
for i (floor(nobs/4)*4,nobs_data,1);
    seas[i,1:4]=seas[i-4,1:4];
endfor;
for i (2,nobs_data,1);
    trend[i,1]=trend[i-1,1]+0.25;
endfor;
xtrend=trend[offset+1:offset+nobs,1];
sdiff=zeros(nobs,3);
sdiff[.,1]=seas[offset+1:offset+nobs,1]-seas[offset+1:offset+nobs,4];
sdiff[.,2]=seas[offset+1:offset+nobs,2]-seas[offset+1:offset+nobs,4];
sdiff[.,3]=seas[offset+1:offset+nobs,3]-seas[offset+1:offset+nobs,4];
strend=xtrend.*sdiff;

if arorder>0;
    ar=zeros(nobs,arorder);
    for i (1,arorder,1);
        ar[.,i]=lagn(y,i);
    endfor;
    ar=missrv(ar,zeros(nobs,arorder));
    if trendflag>0;
        x=const~xtrend~sdiff~strend~ar;
    else;
        x=const~sdiff~ar;
    endif;
else;
    if trendflag>0;
        x=const~xtrend~sdiff~strend;
    else;
        x=const~sdiff;
    endif;
endif;
if data$=="sales";
    x=x~dummy97;
endif;

brdate=zeros(nobs-start+1,4);
tmp=0;
for t (start,nobs,1);
    {tmp,supf,expf,avef,tlm}=st_ch(y[1:t,1],x[1:t,.],.15,.85,hcc,arorder,trendflag,salesflag);
    brdate[t-start+1,1]=t/4+first+offset/4;
    brdate[t-start+1,2]=tmp[1,1];
    brdate[t-start+1,3]=supf[1,2];
    brdate[t-start+1,4]=tmp[1,1]/4+first+offset/4;
endfor;

data " - AR order" arorder;
let fmt[1,3] = "%*.*lf" 4 2;
"         End of sample     Breakpoint         P-value       Breakdate"
"";
format /rd 16,3; 
print brdate;
output off;
format /rd 16,6; 