// This program produces Figure 2 of the paper, i.e. analysis of correct regime predictions around recessions of a given 
// duration 

// *.out files need to be supplied coming from the Montecarlo simulation program
// with this files containing all the markov-switching smoother estimates for each replication 
// Hence the number of columns per record in such *.out files quite large (117+96) 



cls;


ncols = 117+96; @cols when regime inference included in *.out files are 117+96, otherwise they are 19+96@ 
library pgraph; 
load dato[]=mcarlo.out;
dato = reshape(dato,rows(dato)/ncols,ncols);

par=0.9; // Selects the value of the DGPs difference between upper and lower regime mean  n expansion vs recession mean 


// From the *.out files, select the data for the replications under seasonal adjustment vs those under no seasonal adjustment 
fil=selif(dato,dato[.,2].eq 1 .and dato[.,3].eq par .and dato[.,12] .ge 0.01);
nfil=selif(dato,dato[.,2].eq 0 .and dato[.,3].eq par .and dato[.,12] .ge 0.01);
rowsall = minc(rows(fil)|rows(nfil)); 


fil=fil[1:rowsall,.]; 
nfil=nfil[1:rowsall,.];
clear dato; // Memory management 



grandtable = miss(ones(1,21),1); // Initialise table  


MAXREPL = ROWSALL; // This could be tidied !  
xaxis = seqa(1,1,96);



pkims = 117-96+1; // Start and end positions of estimated state probabilities  
pkime = 117;
csos = 117+1; // Start and end positions of  "true" state observations  
csoe = 117+96;


cls;

reverse=-1;
do while reverse<1; reverse=reverse+1;


  fcollect = miss(ones(1,21),1); 
  nfcollect= fcollect; 

  repl_num =1;
  do while repl_num <MAXREPL; // loop over all replications 
  repl_num =repl_num +1;
  filflag=-1; 
  do while filflag<1; filflag=filflag+1;  // distinguish between replications of seas adj data vs non seas adj data 
  //"filflag";filflag;


    // Following block simply collects the data into easier-to-handle vectors       
    // For each replication repl_num , we construct the following row vectors : 
    // pkim :  estimated state probabilities 
    // cso :   true state observations 
    // counter : observation number 

    if reverse eq 1; // When reverse=1, we will be scanning (see below) for a peak and preceding expansion periods  
      if filflag eq 0; 
        cso=rev(nfil[repl_num ,csos:csoe]')';
        pkim=rev(nfil[repl_num ,pkims:pkime]')';     
        counter=rev(seqa(1,1,96)); 
      else; 
        cso=rev(fil[repl_num ,csos:csoe]')';
        pkim=rev(fil[repl_num ,pkims:pkime]')';     
        counter=rev(seqa(1,1,96));
      endif; 
      else;        // When reverse=0, we will be scanning (see below) for a trough and subsequent expansion periods 
      if filflag eq 0;
        cso=nfil[repl_num ,csos:csoe];
        pkim=nfil[repl_num ,pkims:pkime];   
        counter=seqa(1,1,96);  
      else; 
        cso=fil[repl_num ,csos:csoe];
        pkim=fil[repl_num ,pkims:pkime];     
        counter=seqa(1,1,96);  
      endif; 
    endif; 



    // Define vector bc so that it collects the position of regime switches 
    // Under reverse=0 that will be troughs (recession ends) 
    // Under reverse=1 that they will be peaks (expansion ends) as data have been time-reversed 
    
    i=0;switch=0;localcollect = miss(ones(1,21),1);  

    do while i<cols(cso)-1;
      i=i+1;
      if cso[i:i+1] eq 1~0; 
        switch = switch~i;
      endif; 
    endo; 

    if cols(switch) eq 1;
      "No trough in this replication"; continue; 
    else; 
      switch=switch[2:cols(switch)]; // Get rid of trailing zero 
      if cso[1] eq 1; // Do not analyse recessions that are at sample ends
        if cols(switch) gt 1;  
          switch=switch[2:cols(switch)]; 
        else;
          " Replication has only a single recession at sample end"; 
        endif;       
      endif;    
    endif; 



    // Now loop over all regime switches and collect information of regime detection accuracy 
    // around them 
    reg_switch_counter=0;
    do while reg_switch_counter<cols(switch); reg_switch_counter=reg_switch_counter+1; 

      // determine regime duration; 
      loc = switch[reg_switch_counter]; 
      do while cso[loc] eq 1; 
        loc= loc-1;
      endo; 

      duration = switch[reg_switch_counter]-loc; 

      if reg_switch_counter+1 le cols(switch);      
        nextswitch = switch[reg_switch_counter+1]; 
      else; 
        nextswitch = 96;
      endif;     

      // Select trough to trough interval eg. 0 1 (1 0 0 0 0 1 1 1 1) 0 0 
      chop = pkim[switch[reg_switch_counter]:nextswitch]'~cso[switch[reg_switch_counter]:nextswitch]'~counter[switch[reg_switch_counter]:nextswitch]; 
      chop = delif(chop,chop[.,2] .eq 1);  // Isolate expansion (remove 1st trough 1 and full recession)
      chop = pkim[switch[reg_switch_counter]-(duration-1):switch[reg_switch_counter]]'~cso[switch[reg_switch_counter]-(duration-1):switch[reg_switch_counter]]'~counter[switch[reg_switch_counter]-(duration-1):switch[reg_switch_counter]]|chop; // Isolate current recession and add to chop matrix 


      localcollect = localcollect|duration~patch((CHOP[.,1]' .ge 0.5) .eq CHOP[.,2]' ,20); // COLLECT correct regime inferences according to the 0.5 rule 

    endo; @reg_switch_counter@ 



   // Collect in tables fcollect and nfcollect 
    if filflag eq 0; 
      nfcollect=nfcollect|localcollect; 
    else; 
      fcollect=fcollect|localcollect; 
    endif; 


  endo; @ filflag @   
  endo; @repl_num @



  // Now store compute proportion of correct predictions around recessions of a given duration j 
  // Each duration considered, j = 1 to 6 , is stocked in collecting matrix grandtable 

  j=0;do while j <6; j=j+1; 
    if reverse; 
        grandtable=grandtable|rev(meancmiss(selif(nfcollect,nfcollect[.,1] .eq j)))'; 
        grandtable=grandtable|rev(meancmiss(selif(fcollect,fcollect[.,1] .eq j)))'; 
        grandtable=grandtable|rev(meancmiss(selif(nfcollect,nfcollect[.,1] .eq j)))'-rev(meancmiss(selif(fcollect,fcollect[.,1] .eq j)))'; 
    else; 
        grandtable=grandtable|(meancmiss(selif(nfcollect,nfcollect[.,1] .eq j)))'; 
        grandtable=grandtable|(meancmiss(selif(fcollect,fcollect[.,1] .eq j)))'; 
        grandtable=grandtable|(meancmiss(selif(nfcollect,nfcollect[.,1] .eq j)))'-(meancmiss(selif(fcollect,fcollect[.,1] .eq j)))'; 
    endif; 
  endo; 


endo; @reverse@



// Final processing and graphing of results 

  
grandtable=grandtable[2:rows(grandtable),.]; // Get rid of initialising row 
grandtable_nr = grandtable[1:18,.];  
grandtable_r = grandtable[19:36,.]; 


call setvwrmode("many"); 


BEGWIND; 
WINDOW(2,3,0); 
j=1;do while j <18; 
    clean_row_v = grandtable_r[j:j+1,1:21-(j/3+1)]~grandtable_nr[j:j+1,2:21];
    clean_row_v;
    TITLE("DURATION = "$+ftos(GRANDTABLE_NR[J,1],"%*lf",1,0));
    xy(seqa(1,1,cols(clean_row_v)),clean_row_v[1,.]'~clean_row_v[2,.]');NEXTWIND; 
     j=j+3;
endo;   
ENDWIND;
            
   

end; 








proc patch(rowv,n);
// Takes row vector rowv and patches it with missings if its length < n
// if length > n it chops off columns n+1 ... n+k 

local result,j;

if cols(rowv) lt N; 
   result=rowv~miss(ones(1,N-cols(rowv)),1); 
elseif cols(rowv) ge N; 
   result=rowv[1:N];
endif; 

retp(result);
endp;






proc meancmiss(mx);
// meancmiss(x) computes same as meanc but ignoring missng observations 
local result,j;

result=miss(1,1);

j = 0;
  do while j<cols(mx);
  j=j+1;
  result=result~meanc(delif(mx[.,j],mx[.,j] .eq miss(1,1)));
endo;

result=result[.,2:cols(result)];

retp(result');
endp;


