/*
This code was originally written by Gabriel Perez-Quiros for the paper
McConnell, M.M. and Perez-Quiros, G. (2000), "Output Fluctuations 
in the United States: What has Changed since the Early 1980s?", 
American Economic Review, 90: 1464-1476.
We thank the author for giving us permission to use and distribute it. 
*/

           output file=results.out reset;
           xox=2;@number of constants@
           isig=2;@number of variances@

           offset = 0;   
           obs = 177; start = offset+1;
           strend=0;
           sbreak=0;
           load bbbb2[obs+1,1] = us_emp_sa.txt; adjust=0; jointest=0;

           bbbb = bbbb2[start:obs,1]~bbbb2[start+1:obs+1,1];
           obs = obs-start+1; 
           y2 = 100*ln(bbbb[.,2]./bbbb[.,1]);         
           y=y2;
           capt=rows(y);

cls;

@ 35 is 1968.50 empl no trend no hcc@
@ 33 is 1968.00 empl no trend hcc@
@ 53 is 1973.00 empl trend no hcc@
@ 56 is 1973.75 empl trend hcc@
@ 95 is 1983.50 empl trend hcc@

@ 141 is 1995.00 sales no trend no hcc@
@ 141 is 1995.00 sales no trend hcc@
@ 128 is 1991.75 sales trend no hcc@
@ 131 is 1992.50 sales trend hcc@

sbrkdate = 35+offset+1;
seasonbreak = zeros(sbrkdate-1,1)|ones(rows(y)-sbrkdate+1,1);  
seasont = seqa(1,1,rows(y)).*(1-seasonbreak);
season2t = seqa(1,1,rows(y)).*(seasonbreak);

dummies = 1|0|0|0; 
j = 1;
     do until j > (obs/4)+8;
        dummies = dummies|1|0|0|0;
        j = j+1;   
     endo;
@ Mean -deviation dummies @
dummies = dummies-lagn(dummies,3)~lagn(dummies,1)-lagn(dummies,3)~lagn(dummies,2)-lagn(dummies,3); 
dummies = dummies[4:rows(dummies),.]; 
dummies = dummies[1:rows(y),.]; 

dummiesx = dummies.*(seasonbreak.*.ones(1,3)); 
dummiest = dummies.*(seasont.*.ones(1,3)); 
dummies2t = dummies.*(season2t.*.ones(1,3)); 


if adjust==1; 
@ Eliminate seasonality using break trend model @
if sbreak==1;
    if strend==1;
        xx = ones(rows(y),1)~dummies~dummiesx~dummiest ; //trend
    else;
        xx = ones(rows(y),1)~dummies~dummiesx; //no trend
    endif;
else;
    if strend==1;
        xx = ones(rows(y),1)~dummies~dummiest ; //trend
    else;
        xx = ones(rows(y),1)~dummies; //no trend
    endif;
endif;
//xx = ones(rows(y),1)~dummies; //no break 
beta = invpd(xx'*xx)*(xx'*y); 
yorig = y; 
y = y-xx*beta+beta[1]; 
endif;        







          @  Adjust any of the following to control specification desired @
           ns = 2;           @ ns is the number of primitive states @
           ps1 = 1;           @ ps is the number of lagged states that matter
                               for y;  use ps = 0 if only the current state
                               matters @
           ps2 = 0;           @ ps is the number of lagged states that matter
                               for y;  use ps = 0 if only the current state
                               matters @

           pphi = ps1;         @ pphi is the number of lags in autoregression
                                for y; pphi should be greater than or equal
                                to ps @
           ipm = 1;          @ ipm specifies way in which transition probs
                               are parameterized
                                  ipm = 1 implies p11 and p22 estimated
                                  ipm = 2 implies pij for i=1,..,n j=1,..,n-1
                                  ipm = 3 user input code @


        let th1=
       1.21      -0.35       0.91      0.07      0.06; //th1 includes means (4) and ar1
        let th2= 0.89       0.41        3.62        1.67        12.87        10.73;
       if pphi>1; //insert zeros as starting values for ar lags >1
             th=th1|zeros(pphi-1,1)|th2;       
       else;
            th=th1|th2;
       endif;

        if jointest==0;
              nth = 4+pphi+xox+isig;@ nth is the number of params to be estimated@
          else;
            if strend==1;
            nth = 4+pphi+xox+isig+9;
            th=th|zeros(9,1);
            else;
            nth = 4+pphi+xox+isig+6;
            th=th|zeros(6,1);
            endif;
        endif;

/* ======================================================================= */
  @ In general no parts of this section should be changed @

nk = pphi+1;       @ nk is the first observation for which the
                             likelihood will be evaluated @
izz = 1;           @ izz = 1 when params read in so as to assure inequality
                     constraints; izz = 2 for final reporting of results @
n1 = ns^(ps1+1);     @ n1 is the dimension of the state vector @
n2 = ns^(ps2+1);     @ n1 is the dimension of the state vector @
n=n1*n2;
kc = 1;            @ kc = 2 to echo parameter values @
ks = 1;            @ ks = 2 if smoothed probs are to be calculated @
captst = capt - nk +1; @ captst is the effective sample size @
skif = zeros(captst,n); @ skif is the matrix of filtered probs @
skif1 = zeros(captst,n1); @ skif is the matrix of filtered probs @
skis1 = zeros(captst,n1); @ skis is the matrix of smoothed probs @
skif2 = zeros(captst,n2); @ skif is the matrix of filtered probs @
skis2 = zeros(captst,n2); @ skis is the matrix of smoothed probs @
eloles=0;
id = eye(ns);           @ used in certain calculations below @


proc pattern11; @ This proc returns a (ps+1)*ns x n matrix.  The ith
                column contains a one in row j if st = j, contains a
                one in row ns+j if st-1 = j, and so on @
     local i1,ix,iq,na;
     na = n1/ns;
     ix = eye(ns).*.ones(1,na);
     i1 = 1;
     do until i1 > ps1;
       na = na/ns;
       iq = ones(1,ns^i1).*.(eye(ns).*.ones(1,na));
       ix = iq|ix;
     i1 = i1+1;
     endo;
retp(ix);
endp;
proc pattern12; @ This proc returns a (ps+1)*ns x n matrix.  The ith
                column contains a one in row j if st = j, contains a
                one in row ns+j if st-1 = j, and so on @
     local i1,ix,iq,na;
     na = n2/ns;
     ix = eye(ns).*.ones(1,na);
     i1 = 1;
     do until i1 > ps2;
       na = na/ns;
       iq = ones(1,ns^i1).*.(eye(ns).*.ones(1,na));
       ix = iq|ix;
     i1 = i1+1;
     endo;
retp(ix);
endp;

hp1 = pattern11;
hp2 = pattern12;
if jointest==0;
    #include markovs4.prc;
else;
    #include markovs4_v2.prc;
endif;
/* ================================================================= */

/* ======================================================================= */
proc matpm(xth);  @This proc defines the user's conventions for reading
                 elements of Markov transition probabilities from
                 parameter vector @
   local pm,ixth;
   ixth = rows(xth);
   pm = zeros(ns,ns);
     if ipm == 1;  @ for ns =2 this option has parameters as p11 and p22 @
          if izz == 1;
             pm[1,1] = xth[1,1]^2/(1 +xth[1,1]^2);
             pm[2,2] = xth[2,1]^2/(1 + xth[2,1]^2);
          else;
             pm[1,1] = xth[1,1];
             pm[2,2] = xth[2,1];
          endif;
          pm[2,1] = 1 - pm[1,1];
          pm[1,2] = 1 - pm[2,2];
     elseif ipm == 2;  @ general case has parameters pij for i = 1,...,n and
                          j = 1,...,n-1 @
        pm[1:ns-1,.] = reshape(xth[1:ixth,1],ns-1,ns);
        if izz == 1;
           pm[ns,.] = ones(1,ns);
           pm = pm^2;
           pm = pm./(sumc(pm)');
        else;
           pm[ns,.] = (1 - sumc(pm))';
        endif;
     elseif ipm == 3;  @ This section can be rewritten by user to impose zeros
                          and ones where desired @
        if izz == 1;
             pm[1,1] = xth[1,1]^2/(1 + xth[1,1]^2);
             pm[1,2] = xth[2,1]^2/(1 + xth[2,1]^2);
             pm[2,3] = xth[3,1]^2/(1 + xth[3,1]^2);
        elseif izz == 2;
             pm[1,1] = xth[1,1];
             pm[1,2] = xth[2,1];
             pm[2,3] = xth[3,1];
        endif;
        pm[3,1] = 1 - pm[1,1];
        pm[2,2] = 1 - pm[1,2];
        pm[3,3] = 1 - pm[2,3];
    endif;
retp(pm);
endp;
/* ======================================================================= */
@ Set parameters to use Gauss numerical optimizer @
library optmum pgraph;
optset;
@ Next call  the GAUSS numerical optimizer @
        output off;
        {x,f,g,h} =optmum(&ofn,th);
        output file=results.out on;


"";"";"MLE as parameterized for numerical optimization ";
"Coefficients:";x';
"";"Value of log likelihood:";;-f;
bic=2*f/capt+rows(th)*ln(capt)/capt;
"";"BIC:";;bic;
"";"Gradient vector:";g';
/* ======================================================================= */

/*======================================================================== */
@ In general no parts of this section need be changed @

@ Reparameterize for reporting final results @
   izz = 2;
@   x = th;  @
"";"Vector is reparameterized to report final results as follows";
   "Means for each state 1:";x[1:xox,1]';
   "Means for each state 2:";x[xox+1:xox+xox,1]';
   ncount=xox+xox+1;
   if pphi > 0;
      "Autoregressive coefficients:";x[ncount:ncount+pphi-1,1]';
   endif;
   ncount = ncount + pphi ;
   x[ncount:ncount+isig-1,1] = x[ncount:ncount+isig-1,1]^2;
   "Variances:";x[ncount:ncount+isig-1,1];
   ncount = ncount + isig - 1;
/* ======================================================================= */

/* ======================================================================= */
proc pmth; @ This proc converts the last elements of parameter vector
                  (which relates to transition probabilities) from the
                   th[i,j]^2/{sum j th[i,j]^2} form that is used for
                   numerical estimation into the p[i,j] form that is used
                   to calculate standard errors @
local pm;
if ipm == 1;
        x[ncount+1,1] = x[ncount+1,1]^2/(1 + x[ncount+1,1]^2);
        x[ncount+2,1] = x[ncount+2,1]^2/(1 + x[ncount+2,1]^2);
elseif ipm == 2;
        pm = zeros(ns,ns);
        pm[1:ns-1,.] = reshape(th[ncount+1:nth],ns-1,ns);
        pm[ns,.] =  ones(1,ns);
        pm = pm^2;
        pm = pm./(sumc(pm)');
        x[ncount+1:nth,1] = reshape(pm[1:ns-1,.],ns*(ns-1),1);
  elseif ipm == 3;    @ User may want to alter these next lines @
        x[ncount+1:nth,1]
          = (x[ncount+1:nth,1]^2)./(1 + x[ncount+1:nth,1]^2);
 endif;
retp(x);
endp;
/* ======================================================================= */

/* ======================================================================= */
@ In general no changes are necessary from here out @

call pmth;
ncount=ncount+2;
call pmth;
h = (hessp(&ofn,x));
   va = eigrs(h);
kc = 2;
ks = 2;
call ofn(x);
   if minc(eigrs(h)) <= 0;
        "Negative of Hessian is not positive definite";
        "Either you have not found local maximum, or else estimates are up "
        "against boundary condition.  In latter case, impose the restricted "
        "params rather than estimate them to calculate standard errors";
    else;
       h = invpd(h);
       std = diag(h)^.5;
       "For vector of coefficients parameterized as follows,";x';
       "the standard errors are";std';
    endif;



R = {1 0 -1 0,0 1 0 -1}; b = x[1:4]; i = h[1:4,1:4];
"Chi-sq statistic for change in means after 1977 (DF =2) hessian  ";
B'*R'*inv(R*i*r')*R*b;cdfchic(B'*R'*inv(R*i*r')*R*b,2);

R = {1 -1}; b = x[1]|x[3]; i = (h[1,1]|h[3,1])~(h[1,3]|h[3,3]);
"Chi-sq statistic for change in means after 1977 (DF =1) Expansions  ";
B'*R'*inv(R*i*r')*R*b;cdfchic(B'*R'*inv(R*i*r')*R*b,1);

R = {1 -1}; b = x[2]|x[4]; i = (h[2,2]|h[4,2])~(h[2,4]|h[4,4]);
"Chi-sq statistic for change in means after 1977 (DF =1) Expansions  ";
B'*R'*inv(R*i*r')*R*b;cdfchic(B'*R'*inv(R*i*r')*R*b,1);



/*"";"-------------------------------";"";
"Probabilities for primitive states";
"filtered probabilities";format /rd 1,0;
"Obs ";;
t = 0;
do until t > ps;
  i = 1;
    do until i == ns;
       "P(st-";;t;;"=";;i;;") ";;
     i = i+1;
     endo;
  t = t+1;
endo;"";
format /rd 6,4;
 skif = (skif*hp')*(eye(ps+1).*.id[.,1:ns-1]);
 skif =  seqa(nk,1,captst)~skif;
"";"smoothed probabilities";
format /rd 1,0;
"Obs ";;
i = 1;
   do until i > ns;
      "P(st = ";;i;;") ";;
   i = i+1;
   endo;
format /rd 6,4;
 skis = skis*hp';
 skis = seqa(nk,1,captst)~skis[.,1:ns];skis;*/
/*========================================================================*/
/*========================================================================*/
pexp=skif[.,1]+skif[.,2];//+skif[.,5]+skif[.,6];
prec=skif[.,3]+skif[.,4];//+skif[.,7]+skif[.,8];
plv=skif[.,1];//+skif[.,3]+skif[.,5]+skif[.,7];
phv=skif[.,2];//+skif[.,4]+skif[.,6]+skif[.,8];

pexp2=skis1[.,1];//+skis1[.,3];
prec2=skis1[.,2];//+skis1[.,4];

iz=5;
do while iz<n-2;
    pexp=pexp+skif[.,iz]+skif[.,iz+1];    
    prec=prec+skif[.,iz+2]+skif[.,iz+3];
    iz=iz+4;
endo;
iz=3;
do while iz<n;
    plv=plv+skif[.,iz];    
    phv=phv+skif[.,iz+1];
    iz=iz+2;
endo;
iz=3;
do while iz<n1;
    pexp2=pexp2+skis1[.,iz];
    prec2=prec2+skis1[.,iz+1];
    iz=iz+2;
endo;

plv2=skis2[.,1];
phv2=skis2[.,2];

@P of variance state@
//xy(seqa(60.00+(start+1-offset)/4.0,.25,rows(plv)),plv2);


@P of recession@
begwind;
    window(2,1,0);
    setwind(1);
    xy(seqa(1953.00+(start+pphi)/4.0,.25,rows(plv)),prec2);
    nextwind;
    xy(seqa(1953.00+(start+pphi)/4.0,.25,rows(plv)),plv2);
endwind;
table = seqa(1953.00+(start+pphi)/4.0,.25,rows(plv))~prec2;

output off;

