// All this routines are a minor adaptation of van Norden, S. and Vigfusson, R., 1996, "Regime-Switching Models : A Guide 
// to the Bank of Canada Gauss Procedures", Working Paper 96-3, Bank of Canada. 


/*LFMKV.G :  This proc evaluates the Markov switching likelihood function

    Global variable meanings:
        y = data to be analyzed
        ix = 0 to make innovation variance independent of the state
           = 1 to have different variances for each state
        iy = 0 means that the probability that the first observation is
             drawn from state 1 (rho) is related to the Markov transition
             probabilities (p and q) by the formula rho = (1-q)/(2-p-q)
           = 1 means rho is treated as a free parameter
           = 2 means rho is fixed at 1
           = 3 means rho is fixed at 0
        sameness = 0 means that explanitory variables differ for all 4 eqn's
                 = 1 means that same variables used for means in states 1&2
                 = 2 means that same variables used for probs in states 1&2
                 = 3 is the combination of sameness=1 and sameness=2
                 = 4 means that same variables used for all 4 equations
        vei[i] = number of parameters in equation i

To use the external MKL procedure, include the lines
    NEW;    mkl = zeros(1600,1);    loadexe mkl = mkl.gxe;
as the first thing in your program.

The order in which parameters are passed is:
    { alpha1, alpha2, pth, qth, sigma1, [sigma2,] [rho] }
where
    alpha1 = parameters for mean in state 1
    alpha2 = parameters for mean in state 2
    cdfn(x3*pth) = prob. of going from state 1 to state 1
    cdfn(x4*qth) = prob. of going from state 2 to state 2
    sigma1 = std. dev. in state 1 (same as std. dev. in state 2 when ix=0)
    sigma2 = std. deviations in state 2 [when ix = 1, omit otherwise]
    rho = ex post probability of state 1 at t=0

*** GLOBAL VARIABLES LISTED ABOVE MUST BE SET BEFORE PROC IS CALLED! ***   */




@ Run this procedure once after y, sameness and vei are defined.
  The syntax is "mkvstart2(y);"                                                @

proc(1) = mkvstart2(y,vei,nstat); @where vei contains the number of variables@

local i,terms,nrows;
nrows=rows(y);
terms=zeros(2*nstat,2);

if sameness == 0;       @ Explanitory variables differ for all 4 equations @
    terms[1,1]=2;                  terms[1,2]=1+vei[1,1];
i=2;
do while i<= 2*nstat;
terms[i,1]=terms[i-1,2]+1;    terms[i,2]=terms[i,1]+vei[i,1]-1;
i=i+1;
endo;


elseif sameness == 1;   @ Same variables for mean of states 1 and 2 @
  
terms[1:nstat,1]=2*ones(nstat,1);  terms[1:nstat,2]  =(1+vei[1,1])*ones(nstat,1);

i=nstat+1;
do while i<= 2*nstat;
terms[i,1]=terms[i-1,2]+1;    terms[i,2]=terms[i,1]+vei[i,1]-1;
i=i+1;
endo;

elseif sameness == 2;   @ Same variables for prob. of states 1 and 2 @

  terms[1,1]=2;                  terms[1,2]=1+vei[1,1];
i=2;
do while i<= nstat;
terms[i,1]=terms[i-1,2]+1;    terms[i,2]=terms[i,1]+vei[i,1]-1;
i=i+1;
endo;

terms[(nstat+1):(2*nstat),1]=(terms[nstat,2]+1)*ones(nstat,1); terms[(nstat+1):(2*nstat),2]=terms[(nstat+1):(2*nstat),1]+vei[nstat+1,1]-1;


elseif sameness == 3;   @ Same variables for means and same for probs @
  terms[1:nstat,1]=2*ones(nstat,1);  terms[1:nstat,2]  =(1+vei[1,1])*ones(nstat,1);

terms[(nstat+1):(2*nstat),1]=(terms[nstat,2]+1)*ones(nstat,1); terms[(nstat+1):(2*nstat),2]=(terms[nstat+1,1]+vei[nstat+1,1]-1)*ones(nstat,1);

else;                   @ Same variables for all 4 equations @
 
  terms[1:(2*nstat),1]=2*ones(2*nstat,1);  terms[1:(2*nstat),2]=(1+vei[1,1])*ones(2*nstat,1);
endif;
retp(terms);
endp;





proc(1) =swmkv2(th,y);

local bayesian, prior, problemf,delta1f,pprobf,qprobf,pprob,qprob,lost2;
BAYESIAN = 0; PRIOR = 0; problemf = 0 ; // Controls use of bayesian prior - not used in JAE paper. 
delta1f = 0;pprobf = 0; qprobf = 0;pprob = 0; qprob = 0; // allows for restricted MS estimation - not used in JAE paper.  
lost2 = 0; // allows for extra conditioning variables - not used in JAE paper.  


 local  alpha1,alpha2, alpha1x,p,q,sig2,sig1,rho,pxp2,pxp1,
          pxa1,pxpkim,fit,it,qq1,qq2,lf,pth,qth,x,z,nrows,nu2,posqx,qx;

@ Number of parameters that are made equal under regime 2 and 1 in
the levels equation @
  
@ Establish values of parameters @
  alpha1 = th[1:vei[1,1],1];
@ Allows delta 1 to be fixed @
  
  nu2 = th[1+vei[1,1]-delta1f,1];
  alpha2 = alpha1;
  alpha2[1,1] = nu2;
  @alpha2 = th[1+vei[1,1]:vei[1,1]+vei[2,1],1];@
  @alpha2[2:rows(alpha2),1] = alpha1[2:rows(alpha1),1];@
  
  pth = th[1+sumc(vei[1:nstat,1])-lost-delta1f:sumc(vei[1:nstat,1])+vei[3,1]-lost-delta1f,1];
  if pprobf ;
     pth=(rotater(pth',1))';
     pth[1,1]=pprob ;
  endif ;

  qth = th[1+sumc(vei[1:nstat+1,1])-lost-delta1f-pprobf:sumc(vei[1:nstat+1,1])+vei[4,1]-lost-delta1f-pprobf,1];
  if qprobf ;
     qth=(rotater(qth',1))';
     qth[1,1]=qprob ;
  endif ;


  if lost2 > 0 ;
  posqx = 1+sumc(vei[1:nstat+1,1])-lost-delta1f-pprobf-qprobf;
  qx = th[posqx,1];
  qth = -pth ;
  qth[1,1] = qx ;
  endif; 
  
  sig1 = abs(th[sumc(vei)+1-lost-lost2-delta1f-pprobf-qprobf,1]);
  if ix == 0;
    sig2 = sig1;                                    
  else;
    sig2 = abs(th[sumc(vei)+2,1]);
  endif;
nrows=rows(y);
  lf = zeros(nrows,1);

@ Set the p and q for each period @

  p = cdfn(y[.,terms[nstat+1,1]:terms[nstat+1,2]]*pth);
  q = cdfn(y[.,terms[nstat+2,1]:terms[nstat+2,2]]*qth); /**/

@ Select the correct value of rho (prob of state 1 at time 0) @
  if iy == 0;             rho = (1-meanc(q))/(2-meanc(p)-meanc(q));
  elseif iy == 1;         rho = cdfn(th[sumc(vei)+2+ix-lost-delta1f-pprobf-qprobf,1]);
  elseif iy == 2;         rho = 1.0;
  elseif iy == 3;         rho = 0;
  endif;

  pxp2 = 1-rho;
  pxp1 = rho;

@ Set PDF's of y for each regime @
  qq1 = pdfn((y[.,1]-y[.,terms[1,1]:terms[1,2]]*alpha1)/sig1)/sig1;
  qq2 = pdfn((y[.,1]-y[.,terms[2,1]:terms[2,2]]*alpha2)/sig2)/sig2;
    @ This allows for underflows in the above expression. @
    if ndpchk(3);   ndpclex;    endif;
/*
    NOTE: The qq's in the above expressions differs from those in the Hamilton
    likelihood function LIKEPROC.  First, the division by sig2 and sig1 is
    moved up from the lines setting pxp2 and pxp1, below.  Second, they are
    smaller by a factor of sqrt(2*pi); this is required to make it a true
    log-likelihood.  To correct; Hamilton's llf - llf swmkv = (n/2)*ln(2*pi).
*/
@ Everything up to this point is copied from lfmkv.g.  @

@ Start the first loop @ 
/* This loop is the same as mksmooth.g except that we now store the values for pxa1 in a matrix */

it = 1;     pxp1=zeros(nrows,1);    fit=zeros(nrows,1);     pxa1=zeros(nrows,1);

    do until it > nrows;
      if it == 1;                  @ Step 1 : Ex Ante probability of State 1 @
        pxa1[it,1] = (1-q[it,1])*(1-rho) + p[it,1]*rho;
      else;
        pxa1[it,1] = (1-q[it,1])*(1-pxp1[it-1,1]) + p[it,1]*pxp1[it-1,1];
      endif;
      pxp1[it,1] = pxa1[it,1]*qq1[it,1]; @ Step 2 : Ex Post joint density of State 1 @
                                   @ Step 3 : Likelihood Function @
      fit[it,1] = pxp1[it,1]+(1-pxa1[it,1])*qq2[it,1];
                                   @ Step 4 : Ex Post probability of State 1 @
      pxp1[it,1] = pxp1[it,1]/fit[it,1];
    it = it+1;
    endo;
    @ Bayesian correction @
    if bayesian == 1 and delta1f == 0;

         fit[nrows,1] = exp(-PRIOR*LN(SIG1)-(1/(SIG1^2))
        -PRIOR*ALPHA1[1,1]^2/(2*SIG1^2)-PRIOR*ALPHA2[1,1]^2/(2*SIG1^2));
      elseif bayesian ==1 and delta1f == 1 ;
         @ If alpha1[1,1] is fixed then there should be no prior on it@
         @ hence c1 = 0 @
         fit[nrows,1] = exp(-PRIOR*LN(SIG1)-(1/(SIG1^2))
         -PRIOR*ALPHA2[1,1]^2/(2*SIG1^2));
    endif ;  
@ end of first loop @
if ones(1,rows(fit))*(fit.<=0) ;
   bayesian = 0 ; fit[nrows,1]=.02 ; problemf = 1 ;  
endif ;

retp(ln(fit));
endp;





proc(1) =rswmkv2(th,y);

local beta,llf;
beta=th[1]|th[2:vei[1]]|th[1]|th[1+vei[1]:rows(th)];
{llf}=swmkv2(beta,y);
retp(llf);


endp;



 proc (1)=incdfn(p);

   /* Calculates the inverse of a standard normal CDF given a value 
      (p) between  zero and one.          */

      local x,t,n,d,t2,tlow,thgh;
      tlow = 1e-307;
      thgh = 1 - 1e-16;
      p = tlow.*(p .< tlow) + p.*(p .ge tlow);
      p = thgh.*(p .> thgh) + p.*(p .le thgh);
      t=sqrt(-2*ln(abs((p.>0.5)-p)));
      t2=t^2;
      n=2.515517+0.802853*t+0.010328*t2;
      d=1+1.432788*t+0.189269*t2+0.001308*t^3;
      x=t-(n./d);
      x=(p.>0.5).*x-(p.<=0.5).*x;
      retp(x);
    endp;


@ Kim's Smoother @
@ This procedure requires the globals vei, nstat,terms,nrows @


proc(3) =kimsmth2(th,y);
 local  alpha1,alpha2,p,q,sig2,sig1,rho,pxp2,pxp1,
          pxa1,pxpkim,fit,it,qq1,qq2,lf,pth,qth,x,z,nu2,posqx;

local delta1f,pprobf,qprobf,pprob,qprob,lost2;
delta1f = 0;pprobf = 0; qprobf = 0;pprob = 0; qprob = 0; // allows for restricted MS estimation - not used in JAE paper.  
lost2 = 0; // allows for extra conditioning variables - nout used in JAE paper.  


@ Establish values of parameters @
   alpha1 = th[1:vei[1,1],1];
@ Allows delta 1 to be fixed @
 
   nu2 = th[1+vei[1,1]-delta1f,1];
   alpha2 = alpha1;
   alpha2[1,1] = nu2;
@  alpha2 = th[1+vei[1,1]:vei[1,1]+vei[2,1],1];@
  pth = th[1+sumc(vei[1:nstat,1])-lost-delta1f:sumc(vei[1:nstat,1])+vei[3,1]-lost-delta1f,1];
  if pprobf ;
     pth=(rotater(pth',1))';
     pth[1,1]=pprob ;
  endif ;

  qth = th[1+sumc(vei[1:nstat+1,1])-lost-delta1f-pprobf:sumc(vei[1:nstat+1,1])+vei[4,1]-lost-delta1f-pprobf,1];
  if qprobf ;
     qth=(rotater(qth',1))';
     qth[1,1]=qprob ;
  endif ;

  sig1 = abs(th[sumc(vei)+1-lost-lost2-delta1f-pprobf-qprobf,1]);
  if ix == 0;
    sig2 = sig1;
  else;
    sig2 = abs(th[sumc(vei)+2,1]);
  endif;
  lf = zeros(nrows,1);

@ Set the p and q for each period @

  p = cdfn(y[.,terms[nstat+1,1]:terms[nstat+1,2]]*pth);
  q = cdfn(y[.,terms[nstat+2,1]:terms[nstat+2,2]]*qth); 
  px = p;
  qx = q;

@ Select the correct value of rho (prob of state 1 at time 0) @
  if iy == 0;             rho = (1-meanc(q))/(2-meanc(p)-meanc(q));
  elseif iy == 1;         rho = cdfn(th[sumc(vei)+2+ix-lost-delta1f-pprobf-qprobf,1]);
  elseif iy == 2;         rho = 1.0;
  elseif iy == 3;         rho = 0;
  endif;

  pxp2 = 1-rho;
  pxp1 = rho;

@ Set PDF's of y for each regime @
  qq1 = pdfn((y[.,1]-y[.,terms[1,1]:terms[1,2]]*alpha1)/sig1)/sig1;
  qq2 = pdfn((y[.,1]-y[.,terms[2,1]:terms[2,2]]*alpha2)/sig2)/sig2;

    @ This allows for underflows in the above expression. @
    if ndpchk(3);   ndpclex;    endif;
/*
    NOTE: The qq's in the above expressions differs from those in the Hamilton
    likelihood function LIKEPROC.  First, the division by sig2 and sig1 is
    moved up from the lines setting pxp2 and pxp1, below.  Second, they are
    smaller by a factor of sqrt(2*pi); this is required to make it a true
    log-likelihood.  To correct; Hamilton's llf - llf swmkv = (n/2)*ln(2*pi).
*/
@ Everything up to this point is copied from lfmkv.g.  @

@ Start the first loop @ 
/* This loop is the same as mksmooth.g except that we now store the values for pxa1 in a matrix */

it = 1;     pxp1=zeros(nrows,1);    fit=zeros(nrows,1);     pxa1=zeros(nrows,1);

    do until it > nrows;
      if it == 1;                  @ Step 1 : Ex Ante probability of State 1 @
        pxa1[it,1] = (1-q[it,1])*(1-rho) + p[it,1]*rho;
      else;
        pxa1[it,1] = (1-q[it,1])*(1-pxp1[it-1,1]) + p[it,1]*pxp1[it-1,1];
      endif;
      pxp1[it,1] = pxa1[it,1]*qq1[it,1]; @ Step 2 : Ex Post joint density of State 1 @
                                   @ Step 3 : Likelihood Function @
      fit[it,1] = pxp1[it,1]+(1-pxa1[it,1])*qq2[it,1];
                                   @ Step 4 : Ex Post probability of State 1 @
      pxp1[it,1] = pxp1[it,1]/fit[it,1];
    it = it+1;
    endo;
@ end of first loop @

@Kim's Smoothing Algorithm Kim(1994)@
x = pxp1[1:nrows-1,.].*(p[2:nrows,.]./pxa1[2:nrows,.] - (1-p[2:nrows,.])./(1-pxa1[2:nrows,.]));
x = pxp1[nrows,.]|rev(x);  
z = pxp1[1:nrows-1,.].*(1-p[2:nrows,.])./(1-pxa1[2:nrows,.]);
z = zeros(1,1)|rev(z);
pxpkim = rev(recsercp(x,z));

retp(pxpkim,pxa1,pxp1);                                                                                                               
endp;



