
/*
**  US deficit sustainability: a new approach based on
**                                   multiple endogenous breaks
**
**  PROGRAM 4
**
**  Program produces all results in the `Model 3' column in Table 1,
**
**  To produce all results OTHER THAN THE POSTERIOR ODD RATIO,
**  the program needs to be run under the alternative hypothesis (h1),
**  with beta1 unrestricted
**
**  Main aspects of program:
**
**     1) Triangular cointegration model with m endogenous breaks
**        assumed (Eqn (10) in paper), with m = 3,
**        with value for intercept and intercept shifts estimated
**        in Gaelm3.prg and IMPOSED HERE
**     2) Hybrid Gibbs/Metropolis-Hastings simulation method used,
**        along the lines of the algorithm described in Appendix B
**        in the paper
**     3) Lag length of upto 5 allowed for in code for AR(p) polynomial for
**        the cointegrating error (ut). (p=1 specified, based on a
**        preliminary model selection procedure)
**     4) Program written for the change in G (expenditure) being i.i.d.
**        with an intercept term (as specified by a preliminary
**        model selection procedure)
**     5) One set of code cycled through 6 times under ho and h1
**        to produce necessary input for the posterior odds ratio
*/


library pgraph,maxlik;
#include maxlik.ext;
graphset;
maxset;
gausset;

_pnotify = 0;

fonts("simplex complex microb simgrma");


/**
**  Loading in deficit data
**/

/*  debt.dat
**
**  The data are quarterly starting in 1947(2) and ending in 1992(3)
**
**  The data are:
**
**          1    real tax revenues
**          2    real government expenditures, inclusive of interest paid on
**               debt
*/

load debt[182,8] = c:\gauss\sbreak\debt.dat;
reven = debt[.,1];
expen = debt[.,2];

   yall = reven[1:182];

/*
**  Intercept and intercept shifts imposed
*/

   yall[7:112]   = yall[7:112] - 0.13507109;
   yall[113:152] = yall[113:152] - 0.28910093;
   yall[153:160] = yall[153:160] + 1.3127948;
   yall[161:182] = yall[161:182] + 0.25118340;

      xall = expen[1:182];
      n = 182;
      beg = 1947+1/4;
      period = 1/4;
      start = 6;
      ntime = n - start;
      time1n = seqa(beg+start*period,period,ntime);
      lowr1 = 100;
      lowr2 = 131;
      lowr3 = 150;
      numrgr1 = 30;
      numrgr2 = 18;
      numrgr3 = 20;
      begst1 = beg+start*period+(lowr1-1)*period;
      begst2 = beg+start*period+(lowr2-1)*period;
      begst3 = beg+start*period+(lowr3-1)*period;

      p11 = 1;  /* p in the paper */

   x   = (xall[start+1:n]);
   xu  = x;
   xl  = (xall[start:n-1]);
   xl2 = (xall[start-1:n-2]);
   xl3 = (xall[start-2:n-3]);
   xl4 = (xall[start-3:n-4]);
   xl5 = (xall[start-4:n-5]);

   y   = (yall[start+1:n]);
   yl  = (yall[start:n-1]);
   yl2 = (yall[start-1:n-2]);
   yl3 = (yall[start-2:n-3]);
   yl4 = (yall[start-3:n-4]);
   yl5 = (yall[start-4:n-5]);

   xlmat = xl~xl2~xl3~xl4~xl5;

   ylmat = yl~yl2~yl3~yl4~yl5;

  xlmatr = xl~(xl-xl2)~(xl2-xl3)~(xl3-xl4)~(xl4-xl5);
  xlmatr1 = xlmatr[.,1:p11];

  ylmatr = yl~(yl-yl2)~(yl2-yl3)~(yl3-yl4)~(yl4-yl5);
  ylmatr1 = ylmatr[.,1:p11];

timer1 = seqa(begst1,period,numrgr1);
timer2 = seqa(begst2,period,numrgr2);
timer3 = seqa(begst3,period,numrgr3);
rval1  = seqa(lowr1,1,numrgr1);
rval2  = seqa(lowr2,1,numrgr2);
rval3  = seqa(lowr3,1,numrgr3);

ulmat = zeros(ntime,p11);
ulmatr = zeros(ntime,p11);

xrm = zeros(ntime,ntime);
x1rm = zeros(ntime,ntime);

   col = 1;
   do while col <= ntime;
      xrm[.,col] = x;
      x1rm[.,col] = ones(ntime,1);
      col = col + 1;
   endo;

   xrmat = lowmat(xrm);
   x1rmat = lowmat(x1rm);


   xr1matl = zeros(ntime,p11);
   xr2matl = zeros(ntime,p11);
   xr3matl = zeros(ntime,p11);
   fxr1matl = zeros(ntime,p11);
   fxr2matl = zeros(ntime,p11);
   fxr3matl = zeros(ntime,p11);
   xr1mtlr = zeros(ntime,p11);
   xr2mtlr = zeros(ntime,p11);
   xr3mtlr = zeros(ntime,p11);


ho = 1;
do while ho <= 2;

if ho == 1;
   output file = gaelm4ho.out reset;
else;
   output file = gaelm4h1.out reset;
endif;

  print " ";
  print "Program produces all results in the `Model 3' column in Table 1";
  print "To produce all results OTHER THAN THE POSTERIOR ODD RATIO";
  print "the program needs to be run under the alternative hypothesis (h1)";
  print "with beta1 unrestricted";

      lbeta = 0.6;
      ubeta = 0.999;   /* When beta1 unrestricted, this upper limit is 1.5 */
      lbetdif1 = -0.3;
      ubetdif1 = 0.2;
      lbetdif2 = -0.1;
      ubetdif2 = 0.4;
      lbetdif3 = -0.3;
      ubetdif3 = 0.3;
      lphi1 = 0.251;
      uphi1 = 1.3;
      widthb = 0.005;
      widthp = 0.01;
      la = -0.1;
      ua = 0.2;
      wida = 0.005;


sampa = 0;
sampb = 0;
sampb1 = 0;
sampb234 = 0;
sampr = 0;
samps12 = 0;
samps11 = 0;
samps22 = 0;
samp1r = 0;
samp2r = 0;
samp3r = 0;

   bur = 100;
   repl = 5000 + bur;
   it = 10;
   nmetrop = 1;

fbetav = zeros(repl,4);
fav = zeros(repl,1);
fphv = zeros(repl,p11);
fph11v = zeros(repl,p11);
fs12v = zeros(repl,1);
fs11v = zeros(repl,1);
fs22v = zeros(repl,1);
fr1v = zeros(repl,1);
fr2v = zeros(repl,1);
fr3v = zeros(repl,1);

bev = zeros(it,4);
av = zeros(it,1);
phiv = zeros(it,p11);
phi11v = zeros(it,p11);
si12v = zeros(it,1);
si11v = zeros(it,1);
si22v = zeros(it,1);
rr1v = zeros(it,1);
rr2v = zeros(it,1);
rr3v = zeros(it,1);

nplota = ((ua - la)/wida) + 1;
aval = seqa(la,wida,nplota);

numphi = round((uphi1 - lphi1)/widthp + 1);
nplotp = numphi;
phi = seqa(lphi1,widthp,numphi);

nplotb = round(((ubeta-lbeta)/widthb) + 1);
bv1 = seqa(lbeta,widthb,nplotb);
bv2 = seqa(lbetdif1,widthb,nplotb);
bv3 = seqa(lbetdif2,widthb,nplotb);
bv4 = seqa(lbetdif3,widthb,nplotb);

expbb1 = zeros(nplotb,1);
cob1 = zeros(nplotb,1);
expbb2 = zeros(nplotb,1);
cob2 = zeros(nplotb,1);
expbb3 = zeros(nplotb,1);
cob3 = zeros(nplotb,1);
expbb4 = zeros(nplotb,1);
cob4 = zeros(nplotb,1);

condb1 = zeros(1,nplotb);
condb2 = zeros(1,nplotb);
condb3 = zeros(1,nplotb);
condb4 = zeros(1,nplotb);

condb11 = zeros(nplotb,1);
condb22 = zeros(nplotb,1);
condb33 = zeros(nplotb,1);
condb44 = zeros(nplotb,1);

condp = zeros(numphi,1);
densps = zeros(numphi,1);

conda = zeros(nplota,1);

condr1 = zeros(numrgr1,1);
condr2 = zeros(numrgr2,1);
condr3 = zeros(numrgr3,1);


print " ";
print " Initial No. of Gibbs values          = " repl;
print " No. of iterations per repl.          = " it;
print " No. of Metropolis iterations per it. = " nmetrop;
print " ";
print " Hypothesis                           = " ho-1;
print " ";


den = 0;
do while den <= 5;

cona = zeros(nplota,1);

condbf1 = zeros(1,nplotb);
condbf2 = zeros(1,nplotb);
condbf3 = zeros(1,nplotb);
condbf4 = zeros(1,nplotb);
condppf = zeros(nplotp,1);

conr1 = zeros(numrgr1,1);
conr2 = zeros(numrgr2,1);
conr3 = zeros(numrgr3,1);

condrrr3 = 0;
cb3 = 0;
cb4 = 0;
cb1 = 0;
cona2 = 0;
condrh = 0;
integ = 1;


seed = 223461.0;

print " seed = " seed;
print " den = " den;


ts = hsec;


/*
**
** Hybrid Gibbs/Metropolis algorithm.
**
*/


ph = zeros(nmetrop+1,p11);
counter = 0;
mycount = 0;


/* Starting values */

k = 1;
do while k <= repl;

   if k == 1;

   if ho == 1;
      bev[1,.] = 1.0~0.1~0.1~0.1;
   else;
      bev[1,.] = 0.9~0.1~0.1~0.1;
   endif;

   phiv[1,.] = 0.9;
   rr1v[1] = 106;
   rr2v[1] = 146;
   rr3v[1] = 154;
   av[1] = 0.06;

if den == 1;

   bev[1,.] = sampb[1]~0.1~0.1~sampb[4];
   av[1,.] = sampa;
   phiv[1,.] = sampr';
   rr1v[1] = samp1r;
   rr2v[1] = samp2r;
   rr3v[1] = samp3r;

elseif den == 2;

   bev[1,.] = sampb[1]~0.1~0.1~0.1;
   av[1,.] = sampa;
   phiv[1,.] = sampr';
   rr1v[1] = samp1r;
   rr2v[1] = samp2r;
   rr3v[1] = samp3r;

elseif den == 3;

if ho == 1;

   goto endbit3;

else;

   bev[1,.] = 0.9~0.1~0.1~0.1;
   av[1,.] = sampa;
   phiv[1,.] = sampr';
   rr1v[1] = samp1r;
   rr2v[1] = samp2r;
   rr3v[1] = samp3r;

endif;

elseif den == 4;

   if ho == 1;
      bev[1,.] = 1.0~0.1~0.1~0.1;
   else;
      bev[1,.] = 0.9~0.1~0.1~0.1;
   endif;

   phiv[1,.] = sampr';
   av[1] = 0.06;
   rr1v[1] = samp1r;
   rr2v[1] = samp2r;
   rr3v[1] = samp3r;

elseif den == 5;

   if ho == 1;
      bev[1,.] = 1.0~0.1~0.1~0.1;
   else;
      bev[1,.] = 0.9~0.1~0.1~0.1;
   endif;

   phiv[1,.] = 0.9;
   av[1] = 0.06;
   rr1v[1] = samp1r;
   rr2v[1] = samp2r;
   rr3v[1] = samp3r;

endif;

   else;

av[1] = fav[k-1,.];
phiv[1,.] = fphv[k-1,.];
bev[1,.] = fbetav[k-1,.];
rr1v[1] = fr1v[k-1,.];
rr2v[1] = fr2v[k-1,.];
rr3v[1] = fr3v[k-1,.];

   endif;

ranr1 = rndus(it,1,seed);
ranr2 = rndus(it,1,seed);
ranr3 = rndus(it,1,seed);
rana = rndus(it,1,seed);

i = 2;
do while i <= it;

/*
** Generation of the elements of the sigma matrix
*/

   f = (x - xl) - av[i-1];
   xstar = x - xlmatr1*phiv[i-1,.]';

   in = 1;
   do while in <= p11;
      xr1matl[.,in] = (zeros(in,1)|xrmat[1:ntime-in,rr1v[i-1]+1]);
      xr2matl[.,in] = (zeros(in,1)|xrmat[1:ntime-in,rr2v[i-1]+1]);
      xr3matl[.,in] = (zeros(in,1)|xrmat[1:ntime-in,rr3v[i-1]+1]);
      in = in +1;
   endo;
   lg = 1;
   do while lg <= p11;
         xr1mtlr[.,1] = xr1matl[.,1];
         xr2mtlr[.,1] = xr2matl[.,1];
         xr3mtlr[.,1] = xr3matl[.,1];
         if p11 > 1;
            if lg > 1;
               xr1mtlr[.,lg] = xr1matl[.,lg-1] - xr1matl[.,lg];
               xr2mtlr[.,lg] = xr2matl[.,lg-1] - xr2matl[.,lg];
               xr3mtlr[.,lg] = xr3matl[.,lg-1] - xr3matl[.,lg];
            endif;
         endif;
   lg = lg + 1;
   endo;

   xr1 = xrmat[.,rr1v[i-1]+1];
   xr2 = xrmat[.,rr2v[i-1]+1];
   xr3 = xrmat[.,rr3v[i-1]+1];

   xr1star = xr1 - xr1mtlr*phiv[i-1,.]';
   xr2star = xr2 - xr2mtlr*phiv[i-1,.]';
   xr3star = xr3 - xr3mtlr*phiv[i-1,.]';

   ys = y - ylmatr1*phiv[i-1,.]';
   xstarmat = xstar~xr1star~xr2star~xr3star;

   g = (ys - xstarmat*bev[i-1,.]');
   e1 = g;
   e2 = f;

   smatrix = {1.0 1.0,
              1.0 1.0};
   smatrix[1,1] = e1'e1;
   smatrix[1,2] = e1'e2;
   smatrix[2,1] = smatrix[1,2];
   smatrix[2,2] = e2'e2;
   sinv = invpd(smatrix);

   fn multn2(ntime,sig) = rndns(ntime,rows(sig),seed)*chol(sig);

   zvec  = multn2(ntime,sinv);

   zvec1 = zvec[.,1];
   zvec2 = zvec[.,2];

   zmatrix = {1.0 1.0,
              1.0 1.0};
   zmatrix[1,1] = sumc(zvec1.^2);
   zmatrix[1,2] = zvec1'zvec2;
   zmatrix[2,1] = zmatrix[1,2];
   zmatrix[2,2] = sumc(zvec2.^2);
   zinv = invpd(zmatrix);

   si11v[i] = zinv[1,1];
   si12v[i] = zinv[1,2];
   si22v[i] = zinv[2,2];

/*
** Generation of phi (rho in paper) via Metropolis-Hastings
*/

if den == 1;

phiv[i,.] = sampr';
goto nexta;

elseif den == 2;

phiv[i,.] = sampr';
goto nexta;

elseif den == 3;

phiv[i,.] = sampr';
goto nexta;

elseif den == 4;

phiv[i,.] = sampr';
goto nexta;

elseif den == 5;

goto dorho;

endif;

dorho:

   ustar1 = y - (x~xr1~xr2~xr3)*bev[i-1,.]' - (si12v[i]/si22v[i])*f;

   lg = 1;
   do while lg <= p11;
      ulmat[.,lg] = ylmat[.,lg]
     - (xlmat[.,lg]~xr1matl[.,lg]~xr2matl[.,lg]~xr3matl[.,lg])*bev[i-1,.]';
      ulmatr[.,1] = ulmat[.,1];
         if p11 > 1;
            if lg > 1;
               ulmatr[.,lg] = ulmat[.,lg-1] - ulmat[.,lg];
            endif;
         endif;
   lg = lg + 1;
   endo;

meanphiq = inv(ulmatr'ulmatr)*(ulmatr'ustar1);
varphiq = (si11v[i] - (si12v[i]^2/si22v[i]))*inv(ulmatr'ulmatr);

count = 0;
im = 2;
ims = 2;
ime = 2;
conphi = zeros(nmetrop+1,1);
normphi = zeros(nmetrop+1,1);
ph[im-1,.] = phiv[i-1,.];

stnphi = rndns(nmetrop+1,p11,seed);
stnphie = rndns(50,p11,seed);
stnphis = rndns(100,p11,seed);
cphi1 = rndus(nmetrop+1,1,seed);

do until im == nmetrop + 2;

/*
** Generation of candidate value and evaluation of the actual and candidate
** densities at it
*/

   pst = chol(varphiq)*stnphi[im,.]' + meanphiq;

   phidraw:

   pstt = zeros(p11,1);
   if p11 == 1;
      pstt[1] = pst[1];
   else;
      pstt[1] = pst[1] + pst[2];
      pstt[p11] = -pst[p11];
   endif;
   if p11 > 2;
      j = 2;
      do while j < p11;
         pstt[j] = -(pst[j] - pst[j+1]);
         j = j + 1;
      endo;
   endif;


/*
** Checking whether the implied AR process for u1t has at most one root <= 1.
*/

   proot = -rev(pstt)|1;
   yroot = polyroot(proot);
   absroot = abs(yroot);

   noroot = 0;
   if p11 > 1;
     j = 1;
     do while j <= p11;
        if absroot[j] <= 1;
           noroot = noroot + 1;
        endif;
        j = j + 1;
     endo;
   endif;

   if noroot > 1;
      redophi:
      ims = ims + 1;
      pst = chol(varphiq)*stnphis[ims,.]' + meanphiq;
      pstt = zeros(p11,1);
      if p11 == 1;
         pstt[1] = pst[1];
      else;
         pstt[1] = pst[1] + pst[2];
         pstt[p11] = -pst[p11];
      endif;
      if p11 > 2;
         j = 2;
         do while j < p11;
            pstt[j] = -(pst[j] - pst[j+1]);
            j = j + 1;
         endo;
      endif;
   endif;

   proot = -rev(pstt)|1;
   yroot = polyroot(proot);
   absroot = abs(yroot);

   noroot = 0;
   if p11 > 1;
   j = 1;
   do while j <= p11;
      if absroot[j] <= 1;
         noroot = noroot + 1;
      endif;
      j = j + 1;
   endo;
   endif;

   if noroot > 1;
      goto redophi;
    endif;

/*
**  Specification of Jeffreys' conditional prior c2^1/2
*/

c2 = zeros(4,4);

   xstar = x - xlmatr1*pst;

   xr1star = xr1 - xr1mtlr*pst;
   xr2star = xr2 - xr2mtlr*pst;
   xr3star = xr3 - xr3mtlr*pst;

c2[1,1] = (xstar'xstar)*f'f - (xstar'f)^2;
c2[2,2] = (xr1star'xr1star)*f'f - (xr1star'f)^2;
c2[3,3] = (xr2star'xr2star)*f'f - (xr2star'f)^2;
c2[4,4] = (xr3star'xr3star)*f'f - (xr3star'f)^2;

c2[1,2] = (xstar'xr1star)*f'f - (xstar'f)*(xr1star'f);
c2[1,3] = (xstar'xr2star)*f'f - (xstar'f)*(xr2star'f);
c2[1,4] = (xstar'xr3star)*f'f - (xstar'f)*(xr3star'f);

c2[2,1] = c2[1,2];
c2[3,1] = c2[1,3];
c2[4,1] = c2[1,4];

c2[2,3] = (xr1star'xr2star)*f'f - (xr1star'f)*(xr2star'f);
c2[2,4] = (xr1star'xr3star)*f'f - (xr1star'f)*(xr3star'f);
c2[3,2] = c2[2,3];
c2[4,2] = c2[2,4];

c2[3,4] = (xr2star'xr3star)*f'f - (xr2star'f)*(xr3star'f);
c2[4,3] = c2[3,4];

jp1 = 1;

j12 = sqrt(det(c2))*jp1;

conphi1 = exp((-1/2)*(pst-meanphiq)'*inv(varphiq)*(pst-meanphiq))*j12;

nc = (2*pi)^(-p11/2)*(det(varphiq))^(-1/2);
normphi1 = nc*exp((-1/2)*(pst-meanphiq)'*inv(varphiq)*(pst-meanphiq));

if conphi1 == 0;
   ime = ime + 1;
   pst = chol(varphiq)*stnphie[ime,.]' + meanphiq;
   goto phidraw;
endif;

/*
** Evaluation of the actual and candidate densities at the previous value
*/

c2 = zeros(4,4);

   xstar = x - xlmatr1*ph[im-1,.]';

   xr1star = xr1 - xr1mtlr*ph[im-1,.]';
   xr2star = xr2 - xr2mtlr*ph[im-1,.]';
   xr3star = xr3 - xr3mtlr*ph[im-1,.]';

c2[1,1] = (xstar'xstar)*f'f - (xstar'f)^2;
c2[2,2] = (xr1star'xr1star)*f'f - (xr1star'f)^2;
c2[3,3] = (xr2star'xr2star)*f'f - (xr2star'f)^2;
c2[4,4] = (xr3star'xr3star)*f'f - (xr3star'f)^2;

c2[1,2] = (xstar'xr1star)*f'f - (xstar'f)*(xr1star'f);
c2[1,3] = (xstar'xr2star)*f'f - (xstar'f)*(xr2star'f);
c2[1,4] = (xstar'xr3star)*f'f - (xstar'f)*(xr3star'f);

c2[2,1] = c2[1,2];
c2[3,1] = c2[1,3];
c2[4,1] = c2[1,4];

c2[2,3] = (xr1star'xr2star)*f'f - (xr1star'f)*(xr2star'f);
c2[2,4] = (xr1star'xr3star)*f'f - (xr1star'f)*(xr3star'f);
c2[3,2] = c2[2,3];
c2[4,2] = c2[2,4];

c2[3,4] = (xr2star'xr3star)*f'f - (xr2star'f)*(xr3star'f);
c2[4,3] = c2[3,4];

j12 = sqrt(det(c2));


expph = (-1/2)*(ph[im-1,.]-meanphiq')*inv(varphiq)*(ph[im-1,.]'-meanphiq);
conphi[im-1] = exp(expph)*j12;

nc = (2*pi)^(-p11/2)*(det(varphiq))^(-1/2);
normphi[im-1] = nc*exp(expph);

if conphi[im-1] == 0.0;
   ratio = 1;
else;
   ratio = (conphi1/normphi1)/(conphi[im-1]/normphi[im-1]);
endif;

alph = ones(2,1);
alph[1] = ratio;
alpha = minc(alph);
if cphi1[im] <= alpha;
   ph[im,.] = pst';
   count = count + 1;
else;
   ph[im,.] = ph[im-1,.];
endif;

im = im + 1;
endo;

if k >= bur;
counter = counter + count/nmetrop;
mycount = mycount + 1;
endif;

phiv[i,.] = ph[im-1,.];

nexta:

   xstar = x - xlmatr1*phiv[i,.]';

   xr1star = xr1 - xr1mtlr*phiv[i,.]';
   xr2star = xr2 - xr2mtlr*phiv[i,.]';
   xr3star = xr3 - xr3mtlr*phiv[i,.]';

   ys = y - ylmatr1*phiv[i,.]';

   xstarmat = xstar~xr1star~xr2star~xr3star;

   g = (ys - xstarmat*bev[i-1,.]');


if den == 1;

av[i] = sampa;
goto nextb1;

elseif den == 2;

av[i] = sampa;
goto nextb2;

elseif den == 3;

av[i] = sampa;
goto nextb;

if ho == 1;
   goto nextr;
else;
   goto nextb;
endif;

elseif den == 4;

goto doa;

elseif den == 5;

goto doa;

endif;

doa:

/*
** Generation of drift term a
*/

abar = meanc(x-xl - (si12v[i]/si11v[i])*g);
variana = (si22v[i] - (si12v[i]^2/si11v[i]))/ntime;


l = 1;
do while l <= nplota;
   f = (x - xl) - aval[l];

c2 = zeros(4,4);

c2[1,1] = (xstar'xstar)*f'f - (xstar'f)^2;
c2[2,2] = (xr1star'xr1star)*f'f - (xr1star'f)^2;
c2[3,3] = (xr2star'xr2star)*f'f - (xr2star'f)^2;
c2[4,4] = (xr3star'xr3star)*f'f - (xr3star'f)^2;

c2[1,2] = (xstar'xr1star)*f'f - (xstar'f)*(xr1star'f);
c2[1,3] = (xstar'xr2star)*f'f - (xstar'f)*(xr2star'f);
c2[1,4] = (xstar'xr3star)*f'f - (xstar'f)*(xr3star'f);

c2[2,1] = c2[1,2];
c2[3,1] = c2[1,3];
c2[4,1] = c2[1,4];

c2[2,3] = (xr1star'xr2star)*f'f - (xr1star'f)*(xr2star'f);
c2[2,4] = (xr1star'xr3star)*f'f - (xr1star'f)*(xr3star'f);
c2[3,2] = c2[2,3];
c2[4,2] = c2[2,4];

c2[3,4] = (xr2star'xr3star)*f'f - (xr2star'f)*(xr3star'f);
c2[4,3] = c2[3,4];


prior = sqrt(det(c2))*(f'f)^(-(3+1-1)/2);

expa = (-1/2)*((aval[l]-abar)^2)/variana;
conda[l] = exp(expa)*prior;

l = l + 1;
endo;

cumaden = cumsumc(conda)./sumc(conda);

diffa = cumaden - rana[i];
mina = minindc(abs(cumaden - rana[i]));

av[i] = aval[mina];


nextb:


f = (x - xl) - av[i];


/*
** Generation of beta
*/

if ho == 1;
   ys = (y - ylmatr1*phiv[i,.]') - xstar;
   ystar = ys - (si12v[i]/si22v[i])*f;
   xstarmat = xr1star~xr2star~xr3star;
   meanbe = inv(xstarmat'xstarmat)*(xstarmat'ystar);
   varbe = (si11v[i] - (si12v[i]^2/si22v[i]))*inv(xstarmat'xstarmat);
   bgen = chol(varbe)*rndns(3,1,seed) + meanbe;
   bev[i,.] = 1~bgen';

else;
   ys = y - ylmatr1*phiv[i,.]';
   ystar = ys - (si12v[i]/si22v[i])*f;
   xstarmat = xstar~xr1star~xr2star~xr3star;
   meanbe = inv(xstarmat'xstarmat)*(xstarmat'ystar);
   varbe = (si11v[i] - (si12v[i]^2/si22v[i]))*inv(xstarmat'xstarmat);
   bgen = chol(varbe)*rndns(4,1,seed) + meanbe;


if bgen[1] >= 1.0;
   redobeta:
   bgen = chol(varbe)*rndns(4,1,seed) + meanbe;
endif;

if bgen <= 0.0;
   redob0:
   bgen = chol(varbe)*rndns(4,1,seed) + meanbe;
endif;

   if bgen <= 0.0;
      goto redob0;
   endif;

  if bgen[1] >= 1.0;
      goto redobeta;
   endif;


bev[i,.] = bgen';

endif;

if bev[i,2] == 0;
   print k i;
   stop;
endif;

if bev[i,3] == 0;
   print k i;
   stop;
endif;

if bev[i,4] == 0;
   print k i;
   stop;
endif;


goto nextr;

nextb1:

f = (x - xl) - av[i];


/*
** Generation of beta  (den = 1)
*/

   ys = y - ylmatr1*phiv[i,.]' - sampb[1]*xstar - sampb[4]*xr3star;
   ystar = ys - (si12v[i]/si22v[i])*f;
   xstarmat = xr1star~xr2star;
   meanbe = inv(xstarmat'xstarmat)*(xstarmat'ystar);
   varbe = (si11v[i] - (si12v[i]^2/si22v[i]))*inv(xstarmat'xstarmat);
   bgen = chol(varbe)*rndns(2,1,seed) + meanbe;

bev[i,.] = sampb[1]~(bgen')~sampb[4];

if bev[i,2] == 0;
   print k i;
   stop;
endif;

if bev[i,3] == 0;
   print k i;
   stop;
endif;

if bev[i,4] == 0;
   print k i;
   stop;
endif;

goto nextr;

nextb2:

f = (x - xl) - av[i];

/*
** Generation of beta (den = 2)
*/

   f = (x - xl) - av[i];

   ys = y - ylmatr1*phiv[i,.]' - sampb[1]*xstar;
   ystar = ys - (si12v[i]/si22v[i])*f;
   xstarmat = xr1star~xr2star~xr3star;
   meanbe = inv(xstarmat'xstarmat)*(xstarmat'ystar);
   varbe = (si11v[i] - (si12v[i]^2/si22v[i]))*inv(xstarmat'xstarmat);
   bgen = chol(varbe)*rndns(3,1,seed) + meanbe;

bev[i,.] = sampb[1]~bgen';

if bev[i,2] == 0;
   print k i;
   stop;
endif;

if bev[i,3] == 0;
   print k i;
   stop;
endif;

if bev[i,4] == 0;
   print k i;
   stop;
endif;

nextr:

if den >= 1;

rr1v[i] = samp1r;
goto contin1;

endif;


/**
**  Generation of r1 via GG
**/

si112v = si11v[i] - (si12v[i]^2/si22v[i]);

m = 1;
do while m <= numrgr1;
   r1 = lowr1+(m-1);
   xr1 = xrmat[.,r1+1];

   in = 1;
   do while in <= p11;
      xr1matl[.,in] = (zeros(in,1)|xrmat[1:ntime-in,r1+1]);
      in = in + 1;
   endo;

   /* p11 = 1 */

   xr1mtlr = xr1matl;
   xr1star = xr1 - xr1mtlr*phiv[i,.]';

   xstarmat = xstar~xr1star~xr2star~xr3star;

   ys = y - ylmatr1*phiv[i,.]';
   g = (ys - xstarmat*bev[i,.]');

c2 = zeros(4,4);

c2[1,1] = (xstar'xstar)*f'f - (xstar'f)^2;
c2[2,2] = (xr1star'xr1star)*f'f - (xr1star'f)^2;
c2[3,3] = (xr2star'xr2star)*f'f - (xr2star'f)^2;
c2[4,4] = (xr3star'xr3star)*f'f - (xr3star'f)^2;

c2[1,2] = (xstar'xr1star)*f'f - (xstar'f)*(xr1star'f);
c2[1,3] = (xstar'xr2star)*f'f - (xstar'f)*(xr2star'f);
c2[1,4] = (xstar'xr3star)*f'f - (xstar'f)*(xr3star'f);

c2[2,1] = c2[1,2];
c2[3,1] = c2[1,3];
c2[4,1] = c2[1,4];

c2[2,3] = (xr1star'xr2star)*f'f - (xr1star'f)*(xr2star'f);
c2[2,4] = (xr1star'xr3star)*f'f - (xr1star'f)*(xr3star'f);
c2[3,2] = c2[2,3];
c2[4,2] = c2[2,4];

c2[3,4] = (xr2star'xr3star)*f'f - (xr2star'f)*(xr3star'f);
c2[4,3] = c2[3,4];

rprior = sqrt(det(c2));

   expterm1 = g'g - 2*(si12v[i]/si22v[i])*g'f;
   expterm2 = (-1/(2*si112v))*(g'g - 2*(si12v[i]/si22v[i])*g'f);
   if expterm2 <= 700;
      condr1[m] = exp((-1/(2*si112v))*(g'g - 2*(si12v[i]/si22v[i])*g'f))
                        *rprior;
   else;
      condr1[m] = exp((-1/(2*si112v))*(g'g - 2*(si12v[i]/si22v[i])*g'f)-300)
                        *exp(300)*rprior;
   endif;
   m = m + 1;
endo;
cumr1den = cumsumc(condr1)./sumc(condr1);

/**
**  The following selection criterion is employed in order
**  to avoid the possibility of encountering
**  numerical problems when applying the inverse cumulative
**  distribution technique to a highly concentrated
**  (conditional) mass function
**  The program would probably be fine without it
**/


   if maxc(condr1./sumc(condr1)) >= 0.99;
      rr1v[i] = lowr1 + (maxindc(condr1./sumc(condr1)) - 1);
      goto contin1;
   else;
      goto gg1;
   endif;


gg1:

diffr1 = cumr1den - ranr1[i];
minr1 = minindc(abs(cumr1den - ranr1[i]));

rr1v[i] = lowr1 + (minr1-1);

contin1:

/**
**  Update everything which depends on r1
**/

   xr1 = xrmat[.,rr1v[i]+1];

   in = 1;
   do while in <= p11;
      xr1matl[.,in] = (zeros(in,1)|xrmat[1:ntime-in,rr1v[i]+1]);
      in = in + 1;
   endo;

   /* p11 = 1 */

   xr1mtlr = xr1matl;
   xr1star = xr1 - xr1mtlr*phiv[i,.]';

if den >= 1;

rr2v[i] = samp2r;
goto contin2;

endif;


/**
**  Generation of r2 via GG
**/

m = 1;
do while m <= numrgr2;
   r2 = lowr2+(m-1);
   xr2 = xrmat[.,r2+1];

   in = 1;
   do while in <= p11;
      xr2matl[.,in] = (zeros(in,1)|xrmat[1:ntime-in,r2+1]);
      in = in + 1;
   endo;

   /* p11 = 1 */

   xr2mtlr = xr2matl;
   xr2star = xr2 - xr2mtlr*phiv[i,.]';

   xstarmat = xstar~xr1star~xr2star~xr3star;

   g = (ys - xstarmat*bev[i,.]');

c2 = zeros(4,4);

c2[1,1] = (xstar'xstar)*f'f - (xstar'f)^2;
c2[2,2] = (xr1star'xr1star)*f'f - (xr1star'f)^2;
c2[3,3] = (xr2star'xr2star)*f'f - (xr2star'f)^2;
c2[4,4] = (xr3star'xr3star)*f'f - (xr3star'f)^2;

c2[1,2] = (xstar'xr1star)*f'f - (xstar'f)*(xr1star'f);
c2[1,3] = (xstar'xr2star)*f'f - (xstar'f)*(xr2star'f);
c2[1,4] = (xstar'xr3star)*f'f - (xstar'f)*(xr3star'f);

c2[2,1] = c2[1,2];
c2[3,1] = c2[1,3];
c2[4,1] = c2[1,4];

c2[2,3] = (xr1star'xr2star)*f'f - (xr1star'f)*(xr2star'f);
c2[2,4] = (xr1star'xr3star)*f'f - (xr1star'f)*(xr3star'f);
c2[3,2] = c2[2,3];
c2[4,2] = c2[2,4];

c2[3,4] = (xr2star'xr3star)*f'f - (xr2star'f)*(xr3star'f);
c2[4,3] = c2[3,4];

rprior = sqrt(det(c2));

   condr2[m] = exp((-1/(2*si112v))*(g'g - 2*(si12v[i]/si22v[i])*g'f))*rprior;
   m = m + 1;
endo;

cumr2den = cumsumc(condr2)./sumc(condr2);


   if maxc(condr2./sumc(condr2)) >= 0.99;
      rr2v[i] = lowr2 + (maxindc(condr2./sumc(condr2)) - 1);
      goto contin2;
   else;
      goto gg2;
   endif;

gg2:

diffr2 = cumr2den - ranr2[i];
minr2 = minindc(abs(cumr2den - ranr2[i]));

rr2v[i] = lowr2 + (minr2-1);

contin2:

/**
**  Update everything which depends on r2
**/

   xr2 = xrmat[.,rr2v[i]+1];

   in = 1;
   do while in <= p11;
      xr2matl[.,in] = (zeros(in,1)|xrmat[1:ntime-in,rr2v[i]+1]);
      in = in + 1;
   endo;

   /* p11 = 1 */

   xr2mtlr = xr2matl;
   xr2star = xr2 - xr2mtlr*phiv[i,.]';


if den >= 1;

rr3v[i] = samp3r;
goto contin3;

endif;


/**
**  Generation of r3 via GG
**/

m = 1;
do while m <= numrgr3;
   r3 = lowr3+(m-1);
   xr3 = xrmat[.,r3+1];

   in = 1;
   do while in <= p11;
      xr3matl[.,in] = (zeros(in,1)|xrmat[1:ntime-in,r3+1]);
      in = in + 1;
   endo;

   /* p11 = 1 */

   xr3mtlr = xr3matl;
   xr3star = xr3 - xr3mtlr*phiv[i,.]';

   xstarmat = xstar~xr1star~xr2star~xr3star;

   g = (ys - xstarmat*bev[i,.]');

c2 = zeros(4,4);

c2[1,1] = (xstar'xstar)*f'f - (xstar'f)^2;
c2[2,2] = (xr1star'xr1star)*f'f - (xr1star'f)^2;
c2[3,3] = (xr2star'xr2star)*f'f - (xr2star'f)^2;
c2[4,4] = (xr3star'xr3star)*f'f - (xr3star'f)^2;

c2[1,2] = (xstar'xr1star)*f'f - (xstar'f)*(xr1star'f);
c2[1,3] = (xstar'xr2star)*f'f - (xstar'f)*(xr2star'f);
c2[1,4] = (xstar'xr3star)*f'f - (xstar'f)*(xr3star'f);

c2[2,1] = c2[1,2];
c2[3,1] = c2[1,3];
c2[4,1] = c2[1,4];

c2[2,3] = (xr1star'xr2star)*f'f - (xr1star'f)*(xr2star'f);
c2[2,4] = (xr1star'xr3star)*f'f - (xr1star'f)*(xr3star'f);
c2[3,2] = c2[2,3];
c2[4,2] = c2[2,4];

c2[3,4] = (xr2star'xr3star)*f'f - (xr2star'f)*(xr3star'f);
c2[4,3] = c2[3,4];

rprior = sqrt(det(c2));

   condr3[m] = exp((-1/(2*si112v))*(g'g - 2*(si12v[i]/si22v[i])*g'f))*rprior;
   m = m + 1;
endo;

cumr3den = cumsumc(condr3)./sumc(condr3);


   if maxc(condr3./sumc(condr3)) >= 0.99;
      rr3v[i] = lowr3 + (maxindc(condr3./sumc(condr3)) - 1);
      goto contin3;
   else;
      goto gg3;
   endif;


gg3:

diffr3 = cumr3den - ranr3[i];
minr3 = minindc(abs(cumr3den - ranr3[i]));

rr3v[i] = lowr3 + (minr3-1);

contin3:

/**
**  Update everything which depends on r3
**/

   xr3 = xrmat[.,rr3v[i]+1];

   in = 1;
   do while in <= p11;
      xr3matl[.,in] = (zeros(in,1)|xrmat[1:ntime-in,rr3v[i]+1]);
      in = in + 1;
   endo;

   /* p11 = 1 */
   xr3mtlr = xr3matl;
   xr3star = xr3 - xr3mtlr*phiv[i,.]';

   xstarmat = xstar~xr1star~xr2star~xr3star;

if den == 1;

/***
****  Saving of conditional density for second betadiff at iteration it
****  after burn-in period `bur'.
****
****/

if k >= bur;

if i == it;

ys = y - ylmatr1*phiv[i,.]';

t = 1;
do while t <= nplotb;
   fullb = sampb[1]|bev[i,2]|bv3[t]|sampb[4];
   bepss = (ys - xstarmat*fullb)'(ys - xstarmat*fullb);
   bepsf = (ys - xstarmat*fullb)'f;

bsmat = zeros(2,2);
bsmat[1,1] = bepss;
bsmat[1,2] = bepsf;
bsmat[2,1] = bepsf;
bsmat[2,2] = f'f;

sig = zeros(2,2);
sig[1,1] = si11v[i];
sig[1,2] = si12v[i];
sig[2,1] = si12v[i];
sig[2,2] = si22v[i];

   tr3 = sumc(diag(invpd(sig)*bsmat));

   condb33[t] = exp(-(1/2)*tr3);

   t = t + 1;
endo;

etab3 = sumc(condb33)*widthb;

   ffullb = sampb[1]|bev[i,2]|sampb[3]|sampb[4];
   fbepss = (ys - xstarmat*ffullb)'(ys - xstarmat*ffullb);
   fbepsf = (ys - xstarmat*ffullb)'f;

fbsmat = zeros(2,2);
fbsmat[1,1] = fbepss;
fbsmat[1,2] = fbepsf;
fbsmat[2,1] = fbepsf;
fbsmat[2,2] = f'f;

   tr3 = sumc(diag(invpd(sig)*fbsmat));
   condb3ev = (1/etab3)*exp(-(1/2)*tr3);

   cb3 = cb3 + condb3ev;

endif;

endif;

goto finish;

elseif den == 2;

/***
****  Saving of conditional density for third betadiff at iteration it
****  after burn-in period `bur'.
****
****/


if k >= bur;

if i == it;

ys = y - ylmatr1*phiv[i,.]';

t = 1;
do while t <= nplotb;
   fullb = sampb[1]|bev[i,2]|bev[i,3]|bv4[t];
   bepss = (ys - xstarmat*fullb)'(ys - xstarmat*fullb);
   bepsf = (ys - xstarmat*fullb)'f;

bsmat = zeros(2,2);
bsmat[1,1] = bepss;
bsmat[1,2] = bepsf;
bsmat[2,1] = bepsf;
bsmat[2,2] = f'f;

sig = zeros(2,2);
sig[1,1] = si11v[i];
sig[1,2] = si12v[i];
sig[2,1] = si12v[i];
sig[2,2] = si22v[i];

   tr4 = sumc(diag(invpd(sig)*bsmat));

   condb44[t] = exp(-(1/2)*tr4);

   t = t + 1;
endo;

etab4 = sumc(condb44)*widthb;

   ffullb = sampb[1]|bev[i,2]|bev[i,3]|sampb[4];
   fbepss = (ys - xstarmat*ffullb)'(ys - xstarmat*ffullb);
   fbepsf = (ys - xstarmat*ffullb)'f;

fbsmat = zeros(2,2);
fbsmat[1,1] = fbepss;
fbsmat[1,2] = fbepsf;
fbsmat[2,1] = fbepsf;
fbsmat[2,2] = f'f;

   tr4 = sumc(diag(invpd(sig)*fbsmat));
   condb4ev = (1/etab4)*exp(-(1/2)*tr4);

   cb4 = cb4 + condb4ev;

endif;

endif;

goto finish;

elseif den == 3;


/***
****  Saving of conditional density for beta1 at iteration it
****  after burn-in period `bur'.
****
****/

if k >= bur;

if i == it;

ys = y - ylmatr1*phiv[i,.]';

t = 1;
do while t <= nplotb;
   fullb = bv1[t]|bev[i,2]|bev[i,3]|bev[i,4];
   bepss = (ys - xstarmat*fullb)'(ys - xstarmat*fullb);
   bepsf = (ys - xstarmat*fullb)'f;

bsmat = zeros(2,2);
bsmat[1,1] = bepss;
bsmat[1,2] = bepsf;
bsmat[2,1] = bepsf;
bsmat[2,2] = f'f;

sig = zeros(2,2);
sig[1,1] = si11v[i];
sig[1,2] = si12v[i];
sig[2,1] = si12v[i];
sig[2,2] = si22v[i];

   tr1 = sumc(diag(invpd(sig)*bsmat));

   condb11[t] = exp(-(1/2)*tr1);

   t = t + 1;
endo;

etab1 = sumc(condb11)*widthb;

   ffullb = sampb[1]|bev[i,2]|bev[i,3]|bev[i,4];
   fbepss = (ys - xstarmat*ffullb)'(ys - xstarmat*ffullb);
   fbepsf = (ys - xstarmat*ffullb)'f;

fbsmat = zeros(2,2);
fbsmat[1,1] = fbepss;
fbsmat[1,2] = fbepsf;
fbsmat[2,1] = fbepsf;
fbsmat[2,2] = f'f;

   tr1 = sumc(diag(invpd(sig)*fbsmat));

   condb1ev = (1/etab1)*exp(-(1/2)*tr1);

   cb1 = cb1 + condb1ev;

endif;

endif;

elseif den == 4;


/***
****  Saving of conditional density for a at iteration it
****  after burn-in period `bur'. Evaluated at sampa (saved)
****
****/

if k >= bur;

if i == it;

etaa = sumc(conda)*wida;

f = (x - xl) - sampa ;

c2 = zeros(4,4);

c2[1,1] = (xstar'xstar)*f'f - (xstar'f)^2;
c2[2,2] = (xr1star'xr1star)*f'f - (xr1star'f)^2;
c2[3,3] = (xr2star'xr2star)*f'f - (xr2star'f)^2;
c2[4,4] = (xr3star'xr3star)*f'f - (xr3star'f)^2;

c2[1,2] = (xstar'xr1star)*f'f - (xstar'f)*(xr1star'f);
c2[1,3] = (xstar'xr2star)*f'f - (xstar'f)*(xr2star'f);
c2[1,4] = (xstar'xr3star)*f'f - (xstar'f)*(xr3star'f);

c2[2,1] = c2[1,2];
c2[3,1] = c2[1,3];
c2[4,1] = c2[1,4];

c2[2,3] = (xr1star'xr2star)*f'f - (xr1star'f)*(xr2star'f);
c2[2,4] = (xr1star'xr3star)*f'f - (xr1star'f)*(xr3star'f);
c2[3,2] = c2[2,3];
c2[4,2] = c2[2,4];

c2[3,4] = (xr2star'xr3star)*f'f - (xr2star'f)*(xr3star'f);
c2[4,3] = c2[3,4];

prior = sqrt(det(c2))*(f'f)^(-(3+1-1)/2);

conda2 = (1/etaa)*exp((-1/2)*((sampa - abar)^2)/variana)*prior;

cona2 = cona2 + conda2;

endif;

endif;

goto finish;

elseif den == 5;

/***
****  Saving of conditional density for phi  at iteration it
****  after burn-in period `bur'. Evaluated at sampr (saved)
****
****/

if k >= bur;

if i == it;

   ustar1 = y - (x~xr1~xr2~xr3)*bev[i,.]' - (si12v[i]/si22v[i])*f;

   lg = 1;
   do while lg <= p11;
      ulmat[.,lg] = ylmat[.,lg]
      - (xlmat[.,lg]~xr1matl[.,lg]~xr2matl[.,lg]~xr3matl[.,lg])*bev[i,.]';
      ulmatr[.,1] = ulmat[.,1];
         if p11 > 1;
            if lg > 1;
               ulmatr[.,lg] = ulmat[.,lg-1] - ulmat[.,lg];
            endif;
         endif;
   lg = lg + 1;
   endo;

meanphiq = invpd(ulmatr'ulmatr)*(ulmatr'ustar1);
varphiq = (si11v[i] - (si12v[i]^2/si22v[i]))*invpd(ulmatr'ulmatr);

t = 1;
do while t <= numphi;
   phi[t] = lphi1 + (t-1)*widthp;
   p = phi[t];

   xstar = x - p*xl;
   xr1star = xr1 - xr1mtlr*p;
   xr2star = xr2 - xr2mtlr*p;
   xr3star = xr3 - xr3mtlr*p;

c2 = zeros(4,4);

c2[1,1] = (xstar'xstar)*f'f - (xstar'f)^2;
c2[2,2] = (xr1star'xr1star)*f'f - (xr1star'f)^2;
c2[3,3] = (xr2star'xr2star)*f'f - (xr2star'f)^2;
c2[4,4] = (xr3star'xr3star)*f'f - (xr3star'f)^2;

c2[1,2] = (xstar'xr1star)*f'f - (xstar'f)*(xr1star'f);
c2[1,3] = (xstar'xr2star)*f'f - (xstar'f)*(xr2star'f);
c2[1,4] = (xstar'xr3star)*f'f - (xstar'f)*(xr3star'f);

c2[2,1] = c2[1,2];
c2[3,1] = c2[1,3];
c2[4,1] = c2[1,4];

c2[2,3] = (xr1star'xr2star)*f'f - (xr1star'f)*(xr2star'f);
c2[2,4] = (xr1star'xr3star)*f'f - (xr1star'f)*(xr3star'f);
c2[3,2] = c2[2,3];
c2[4,2] = c2[2,4];

c2[3,4] = (xr2star'xr3star)*f'f - (xr2star'f)*(xr3star'f);
c2[4,3] = c2[3,4];

jp1 = 1;

j12p = sqrt(det(c2))*jp1;

condp[t] = exp((-1/2)*(p-meanphiq)'*inv(varphiq)*(p-meanphiq))*j12p;

t = t + 1;
endo;

   etap = sumc(condp)*widthp;
   xstar = x - sampr*xl;
   xr1star = xr1 - xr1mtlr*sampr;
   xr2star = xr2 - xr2mtlr*sampr;
   xr3star = xr3 - xr3mtlr*sampr;

c2 = zeros(4,4);

c2[1,1] = (xstar'xstar)*f'f - (xstar'f)^2;
c2[2,2] = (xr1star'xr1star)*f'f - (xr1star'f)^2;
c2[3,3] = (xr2star'xr2star)*f'f - (xr2star'f)^2;
c2[4,4] = (xr3star'xr3star)*f'f - (xr3star'f)^2;

c2[1,2] = (xstar'xr1star)*f'f - (xstar'f)*(xr1star'f);
c2[1,3] = (xstar'xr2star)*f'f - (xstar'f)*(xr2star'f);
c2[1,4] = (xstar'xr3star)*f'f - (xstar'f)*(xr3star'f);

c2[2,1] = c2[1,2];
c2[3,1] = c2[1,3];
c2[4,1] = c2[1,4];

c2[2,3] = (xr1star'xr2star)*f'f - (xr1star'f)*(xr2star'f);
c2[2,4] = (xr1star'xr3star)*f'f - (xr1star'f)*(xr3star'f);
c2[3,2] = c2[2,3];
c2[4,2] = c2[2,4];

c2[3,4] = (xr2star'xr3star)*f'f - (xr2star'f)*(xr3star'f);
c2[4,3] = c2[3,4];

jp1 = 1;

j12p = sqrt(det(c2))*jp1;

condrho = (1/etap)*exp((-1/2)*
    (sampr - meanphiq)'*inv(varphiq)*(sampr-meanphiq))*(det(c2))^(1/2);
condrh = condrh + condrho;

endif;

endif;


endif;


/***
****  Saving of conditional densities at iteration it
****  after burn-in period `bur'.
****
****/

if k >= bur;

if i == it;

   etaa = sumc(conda)*wida;
   etar1 = sumc(condr1);
   etar2 = sumc(condr2);
   etar3 = sumc(condr3);
   condr1 = condr1./etar1;
   condr2 = condr2./etar2;
   condr3 = condr3./etar3;
   conda = conda./etaa;

   conr1 = conr1 + condr1;
   conr2 = conr2 + condr2;
   conr3 = conr3 + condr3;
   cona  = cona  + conda;

if ho == 1;

/**
**  bd1, bd2 and bd3
**/

meanbe2 = meanbe[1];
varbe2 = varbe[1,1];

meanbe3 = meanbe[2];
varbe3 = varbe[2,2];

meanbe4 = meanbe[3];
varbe4 = varbe[3,3];

j = 1;
do while j<=nplotb;
   expbb2[j] = (-1/(2*varbe2))*(bv2[j]-meanbe2)^2;
   cob2[j] = ((2*pi*varbe2)^(-1/2))*exp(expbb2[j]);
   condb2[1,j] = cob2[j];

   expbb3[j] = (-1/(2*varbe3))*(bv3[j]-meanbe3)^2;
   cob3[j] = ((2*pi*varbe3)^(-1/2))*exp(expbb3[j]);
   condb3[1,j] = cob3[j];

   expbb4[j] = (-1/(2*varbe4))*(bv4[j]-meanbe4)^2;
   cob4[j] = ((2*pi*varbe4)^(-1/2))*exp(expbb4[j]);
   condb4[1,j] = cob4[j];

j = j + 1;
endo;

   etab2 = sumc(cob2)*widthb;
   condb2 = condb2./etab2;

   etab3 = sumc(cob3)*widthb;
   condb3 = condb3./etab3;

   etab4 = sumc(cob4)*widthb;
   condb4 = condb4./etab4;

condbf2 = condbf2 + condb2;
condbf3 = condbf3 + condb3;
condbf4 = condbf4 + condb4;

else;

/**
**  Beta, bd1, bd2 and bd3
**/

meanbe1 = meanbe[1];
varbe1 = varbe[1,1];

meanbe2 = meanbe[2];
varbe2 = varbe[2,2];

meanbe3 = meanbe[3];
varbe3 = varbe[3,3];

meanbe4 = meanbe[4];
varbe4 = varbe[4,4];

j = 1;
do while j<=nplotb;
   expbb1[j] = (-1/(2*varbe1))*(bv1[j]-meanbe1)^2;
   cob1[j] = ((2*pi*varbe1)^(-1/2))*exp(expbb1[j]);
   condb1[1,j] = cob1[j];

   expbb2[j] = (-1/(2*varbe2))*(bv2[j]-meanbe2)^2;
   cob2[j] = ((2*pi*varbe2)^(-1/2))*exp(expbb2[j]);
   condb2[1,j] = cob2[j];

   expbb3[j] = (-1/(2*varbe3))*(bv3[j]-meanbe3)^2;
   cob3[j] = ((2*pi*varbe3)^(-1/2))*exp(expbb3[j]);
   condb3[1,j] = cob3[j];

   expbb4[j] = (-1/(2*varbe4))*(bv4[j]-meanbe4)^2;
   cob4[j] = ((2*pi*varbe4)^(-1/2))*exp(expbb4[j]);
   condb4[1,j] = cob4[j];

j = j + 1;
endo;

   etab1 = sumc(cob1)*widthb;
   condb1 = condb1./etab1;

   etab2 = sumc(cob2)*widthb;
   condb2 = condb2./etab2;

   etab3 = sumc(cob3)*widthb;
   condb3 = condb3./etab3;

   etab4 = sumc(cob4)*widthb;
   condb4 = condb4./etab4;

condbf1 = condbf1 + condb1;
condbf2 = condbf2 + condb2;
condbf3 = condbf3 + condb3;
condbf4 = condbf4 + condb4;

endif;


/**
**  phi
**/

   ustar1 = y - (x~xr1~xr2~xr3)*bev[i,.]' - (si12v[i]/si22v[i])*f;

   lg = 1;
   do while lg <= p11;
      ulmat[.,lg] = ylmat[.,lg]
    - (xlmat[.,lg]~xr1matl[.,lg]~xr2matl[.,lg]~xr3matl[.,lg])*bev[i,.]';
      ulmatr[.,1] = ulmat[.,1];
         if p11 > 1;
            if lg > 1;
               ulmatr[.,lg] = ulmat[.,lg-1] - ulmat[.,lg];
            endif;
         endif;
   lg = lg + 1;
   endo;

meanphiq = invpd(ulmatr'ulmatr)*(ulmatr'ustar1);
varphiq = (si11v[i] - (si12v[i]^2/si22v[i]))*invpd(ulmatr'ulmatr);

t = 1;
do while t <= numphi;
   phi[t] = lphi1 + (t-1)*widthp;
   p = phi[t];

if p11 == 1;

   xstar = x - p*xl;

   xr1star = xr1 - xr1mtlr*p;
   xr2star = xr2 - xr2mtlr*p;
   xr3star = xr3 - xr3mtlr*p;

c2 = zeros(4,4);

c2[1,1] = (xstar'xstar)*f'f - (xstar'f)^2;
c2[2,2] = (xr1star'xr1star)*f'f - (xr1star'f)^2;
c2[3,3] = (xr2star'xr2star)*f'f - (xr2star'f)^2;
c2[4,4] = (xr3star'xr3star)*f'f - (xr3star'f)^2;

c2[1,2] = (xstar'xr1star)*f'f - (xstar'f)*(xr1star'f);
c2[1,3] = (xstar'xr2star)*f'f - (xstar'f)*(xr2star'f);
c2[1,4] = (xstar'xr3star)*f'f - (xstar'f)*(xr3star'f);

c2[2,1] = c2[1,2];
c2[3,1] = c2[1,3];
c2[4,1] = c2[1,4];

c2[2,3] = (xr1star'xr2star)*f'f - (xr1star'f)*(xr2star'f);
c2[2,4] = (xr1star'xr3star)*f'f - (xr1star'f)*(xr3star'f);
c2[3,2] = c2[2,3];
c2[4,2] = c2[2,4];

c2[3,4] = (xr2star'xr3star)*f'f - (xr2star'f)*(xr3star'f);
c2[4,3] = c2[3,4];


j12p = sqrt(det(c2));

condp[t] = exp((-1/2)*(p-meanphiq)'*inv(varphiq)*(p-meanphiq))*j12p;

else;

   xstar = x - xlmatr1*(p|phiv[i,2:p11]');

   xr1star = xr1 - xr1mtlr*(p|phiv[i,2:p11]');
   xr2star = xr2 - xr2mtlr*(p|phiv[i,2:p11]');
   xr3star = xr3 - xr3mtlr*(p|phiv[i,2:p11]');

c2 = zeros(4,4);

c2[1,1] = (xstar'xstar)*f'f - (xstar'f)^2;
c2[2,2] = (xr1star'xr1star)*f'f - (xr1star'f)^2;
c2[3,3] = (xr2star'xr2star)*f'f - (xr2star'f)^2;
c2[4,4] = (xr3star'xr3star)*f'f - (xr3star'f)^2;

c2[1,2] = (xstar'xr1star)*f'f - (xstar'f)*(xr1star'f);
c2[1,3] = (xstar'xr2star)*f'f - (xstar'f)*(xr2star'f);
c2[1,4] = (xstar'xr3star)*f'f - (xstar'f)*(xr3star'f);

c2[2,1] = c2[1,2];
c2[3,1] = c2[1,3];
c2[4,1] = c2[1,4];

c2[2,3] = (xr1star'xr2star)*f'f - (xr1star'f)*(xr2star'f);
c2[2,4] = (xr1star'xr3star)*f'f - (xr1star'f)*(xr3star'f);
c2[3,2] = c2[2,3];
c2[4,2] = c2[2,4];

c2[3,4] = (xr2star'xr3star)*f'f - (xr2star'f)*(xr3star'f);
c2[4,3] = c2[3,4];


j12p = sqrt(det(c2));

p2 = phiv[i,2:p11]';
pall = p|p2;
condp[t] = exp((-1/2)*(pall - meanphiq)'*inv(varphiq)*(pall - meanphiq))*j12p;

endif;

t = t + 1;
endo;

   etap = sumc(condp)*widthp;
   condpp = condp./etap;

condppf = condppf + condpp;

/**
**  Specification of conditional posterior for r3
**  for use in the posterior odds calculations below
**  evaluated at samp3r (saved)
**/

if ho == 1;
   samp3r = 154;
else;
   samp3r = 154;
endif;

   xr3 = xrmat[.,samp3r+1];

   in = 1;
   do while in <= p11;
      xr3matl[.,in] = zeros(in,1)|xrmat[1:ntime-in,samp3r+1];
      in = in + 1;
   endo;

   xr3mtlr = xr3matl;
   xr3star = xr3 - xr3mtlr*phiv[i,.]';
   xstarmat = xstar~xr1star~xr2star~xr3star;

   g = (ys - xstarmat*bev[i,.]');

c2 = zeros(4,4);

c2[1,1] = (xstar'xstar)*f'f - (xstar'f)^2;
c2[2,2] = (xr1star'xr1star)*f'f - (xr1star'f)^2;
c2[3,3] = (xr2star'xr2star)*f'f - (xr2star'f)^2;
c2[4,4] = (xr3star'xr3star)*f'f - (xr3star'f)^2;

c2[1,2] = (xstar'xr1star)*f'f - (xstar'f)*(xr1star'f);
c2[1,3] = (xstar'xr2star)*f'f - (xstar'f)*(xr2star'f);
c2[1,4] = (xstar'xr3star)*f'f - (xstar'f)*(xr3star'f);

c2[2,1] = c2[1,2];
c2[3,1] = c2[1,3];
c2[4,1] = c2[1,4];

c2[2,3] = (xr1star'xr2star)*f'f - (xr1star'f)*(xr2star'f);
c2[2,4] = (xr1star'xr3star)*f'f - (xr1star'f)*(xr3star'f);
c2[3,2] = c2[2,3];
c2[4,2] = c2[2,4];

c2[3,4] = (xr2star'xr3star)*f'f - (xr2star'f)*(xr3star'f);
c2[4,3] = c2[3,4];

rprior = sqrt(det(c2));

condrr3 = (1/etar3)*exp((-1/(2*si112v))
         *(g'g - 2*(si12v[i]/si22v[i])*g'f))*rprior;

condrr3 = condr3[5];

condrrr3 = condrrr3 + condrr3;

endif;

endif;

finish:

i = i + 1;

endo;


/*
** Gibbs values
*/


fbetav[k,.] = bev[it,.];
fav[k,.] = av[it,.];
fphv[k,.] = phiv[it,.];
fph11v[k,.] = phi11v[it,.];
fs12v[k] = si12v[it];
fs11v[k] = si11v[it];
fs22v[k] = si22v[it];
fr1v[k] = rr1v[it];
fr2v[k] = rr2v[it];
fr3v[k] = rr3v[it];

k = k + 1;
endo;

/*
** Choice of "burnout" period
*/

if den == 1;
   goto endbit1;
elseif den == 2;
   goto endbit2;
elseif den == 3;
   goto endbit3;
elseif den == 4;
   goto endbit4;
elseif den == 5;
   goto endbit5;
endif;

betav = fbetav[bur:repl,.];
aav = fav[bur:repl,.];
phv = fphv[bur:repl,.];
s12v = fs12v[bur:repl];
s11v = fs11v[bur:repl];
s22v = fs22v[bur:repl];
r1v = fr1v[bur:repl];
r2v = fr2v[bur:repl];
r3v = fr3v[bur:repl];

sampa = meanc(aav);
sampb = meanc(betav);
sampb1 = sampb[1];
sampb234 = sampb[2:4];
sampr = meanc(phv);
samps12 = meanc(s12v);
samps11 = meanc(s11v);
samps22 = meanc(s22v);


repl = repl - bur + 1;

densa = (1/repl)*cona;
densb1 = (1/repl)*condbf1';
densb2 = (1/repl)*condbf2';
densb3 = (1/repl)*condbf3';
densb4 = (1/repl)*condbf4';
densp = (1/repl)*condppf;
densr1 = (1/repl)*conr1;
densr2 = (1/repl)*conr2;
densr3 = (1/repl)*conr3;

samp1r = rval1[maxindc(densr1)];
samp2r = rval2[maxindc(densr2)];
samp3r = rval3[maxindc(densr3)];
/*sampr = phi[maxindc(densp)];
sampb[1] = bv1[maxindc(densb1)];
sampb[2] = bv2[maxindc(densb2)];
sampb[3] = bv3[maxindc(densb3)];
sampb[4] = bv4[maxindc(densb4)];*/


/*xy(bv1,densb1);
xy(bv2,densb2);
xy(bv3,densb3);
xy(bv4,densb4);
xy(aval,densa);
xy(phi,densp);
bar(timer1,densr1);
bar(timer2,densr2);
bar(timer3,densr3);*/

i = 1;
do while i <= numphi;
    phi[i] = (lphi1) + (i-1)*widthp;
    if phi[i] < 1;
       densps[i] = densp[i];
    endif;
    i = i + 1;
endo;

gsprob = sumc(densps)*widthp;

pmean2 = counter/mycount;

print " Final no. of replications after burnout =               " repl;
print " ";
print " Average proportion of accepted Metropolis draws (phi) = " pmean2;

et = hsec - ts;


gmodep = phi[maxindc(densp)];
gmodea = aval[maxindc(densa)];
gmodeb1 = bv1[maxindc(densb1)];
gmodeb2 = bv2[maxindc(densb2)];
gmodeb3 = bv3[maxindc(densb3)];
gmodeb4 = bv4[maxindc(densb4)];

print " ";
print "Gibbs output:";
print "Gibbs mode for rho1     = " gmodep;
print "Gibbs mode for a        = " gmodea;
print "Gibbs mode for beta     = " gmodeb1;
print "Gibbs mode for betadif1 = " gmodeb2;
print "Gibbs mode for betadif2 = " gmodeb3;
print "Gibbs mode for betadif3 = " gmodeb4;
print " ";


print " ";
print " Probability of stationarity  (Gibbs)   = " gsprob;
print " ";

print "Time (in minutes) for MCMC computations  = " et/6000;
print " ";

print " sampb = " sampb;
print " sampa = " sampa;
print " sampr = " sampr;
print " samps12 = " samps12;
print " samps11 = " samps11;
print " samps22 = " samps22;
print " samp1r = " samp1r;
print " samp2r = " samp2r;
print " samp3r = " samp3r;

fdensr3 = (1/repl)*condrrr3;

print " fdensr3 = " fdensr3;


/**
**  Evaluation of posterior odds under ho and h1 at
**  simulation mean values for the parameters
**/


/*
** Likelihood function
*/

sigmam = zeros(2,2);
sigmam[1,1] = samps11;
sigmam[1,2] = samps12;
sigmam[2,1] = samps12;
sigmam[2,2] = samps22;


invsig = inv(sigmam);

fys =  y - ylmatr1*sampr;
fxstar = x - xlmatr1*sampr;

   fxr1 = xrmat[.,samp1r+1];

   in = 1;
   do while in <= p11;
      fxr1matl[.,in] = zeros(in,1)|xrmat[1:ntime-in,samp1r+1];
      in = in + 1;
   endo;

   fxr1mtlr = fxr1matl;
   fxr1star = fxr1 - fxr1mtlr*sampr;

   fxr2 = xrmat[.,samp2r+1];

   in = 1;
   do while in <= p11;
      fxr2matl[.,in] = zeros(in,1)|xrmat[1:ntime-in,samp2r+1];
      in = in + 1;
   endo;

   fxr2mtlr = fxr2matl;
   fxr2star = fxr2 - fxr2mtlr*sampr;

   fxr3 = xrmat[.,samp3r+1];

   in = 1;
   do while in <= p11;
      fxr3matl[.,in] = zeros(in,1)|xrmat[1:ntime-in,samp3r+1];
      in = in + 1;
   endo;

   fxr3mtlr = fxr3matl;
   fxr3star = fxr3 - fxr3mtlr*sampr;

finf = (x - xl) - sampa;

fxstarmt = fxstar~fxr1star~fxr2star~fxr3star;

epss = (fys - fxstarmt*sampb)'(fys - fxstarmt*sampb);
epsf = (fys - fxstarmt*sampb)'finf;
finff = finf'finf;

smat = zeros(2,2);
smat[1,1] = epss;
smat[1,2] = epsf;
smat[2,1] = epsf;
smat[2,2] = finff;

tr = sumc(diag(invsig*smat));
like = ((2*pi)^(-ntime))*(det(sigmam))^(-ntime/2)*exp(-(1/2)*tr);

if ho == 1;
   lho = like;
else;
   lh1 = like;
endif;

/*
** Prior
*/

fc2 = zeros(4,4);
fc3 = zeros(4,1);

fc2[1,1] = (fxstar'fxstar)*finf'finf - (fxstar'finf)^2;
fc2[2,2] = (fxr1star'fxr1star)*finf'finf - (fxr1star'finf)^2;
fc2[3,3] = (fxr2star'fxr2star)*finf'finf - (fxr2star'finf)^2;
fc2[4,4] = (fxr3star'fxr3star)*finf'finf - (fxr3star'finf)^2;

fc2[1,2] = (fxstar'fxr1star)*finf'finf - (fxstar'finf)*(fxr1star'finf);
fc2[1,3] = (fxstar'fxr2star)*finf'finf - (fxstar'finf)*(fxr2star'finf);
fc2[1,4] = (fxstar'fxr3star)*finf'finf - (fxstar'finf)*(fxr3star'finf);

fc2[2,1] = fc2[1,2];
fc2[3,1] = fc2[1,3];
fc2[4,1] = fc2[1,4];

fc2[2,3] = (fxr1star'fxr2star)*finf'finf - (fxr1star'finf)*(fxr2star'finf);
fc2[2,4] = (fxr1star'fxr3star)*finf'finf - (fxr1star'finf)*(fxr3star'finf);

fc2[3,2] = fc2[2,3];
fc2[4,2] = fc2[2,4];

fc2[3,4] = (fxr2star'fxr3star)*finf'finf - (fxr2star'finf)*(fxr3star'finf);
fc2[4,3] = fc2[3,4];

fc1 = (fys'fys)*finff - (fys'finf)^2;

fc3[1] = (fys'fxstar)*finf'finf - (fys'fxstar)*(fxstar'finf);
fc3[2] = (fys'fxr1star)*finf'finf - (fys'finf)*(fxr1star'finf);
fc3[3] = (fys'fxr2star)*finf'finf - (fys'finf)*(fxr2star'finf);
fc3[4] = (fys'fxr3star)*finf'finf - (fys'finf)*(fxr3star'finf);

ifc2 = invpd(fc2);
fc4 = fc1 - fc3'ifc2*fc3;

prior = ((det(sigmam))^(-3/2))*((det(fc2))^(1/2))*(finf'finf)^(-3/2);

if ho == 1;
   pho = prior;
else;
   ph1 = prior;
endif;

/*
** Posterior
*/

/*
** IW Conditional for sigma given beta, a, phi, r1, r2 and r3
**
*/


g1 = exp(lnfact((ntime/2)-1));
g2 = exp(lnfact(((ntime-1)/2)-1));
g1 = gamma(ntime/2);
g2 = gamma((ntime-1)/2);
invcons = (pi^(1/2))*g1*g2;

fcndsig1 = (inv(invcons))*((det(smat))^(ntime/2));

fcndsig2 =  fcndsig1*((det(sigmam))^(-(ntime+3)/2));

fcondsig =  fcndsig2*exp(-(1/2)*tr)*(2^(-ntime));

print " fcondsig = " fcondsig;

/*
** Univariate conditional for first
** beta shift given second and third beta shifts, beta1, a, phi, r1
** r2 and r3
*/

t = 1;
do while t <= nplotb;
   fullb = sampb[1]|bv2[t]|sampb[3]|sampb[4];
   bepss = (fys - fxstarmt*fullb)'(fys - fxstarmt*fullb);
   bepsf = (fys - fxstarmt*fullb)'finf;

bsmat = zeros(2,2);
bsmat[1,1] = bepss;
bsmat[1,2] = bepsf;
bsmat[2,1] = bepsf;
bsmat[2,2] = finff;

   condb22[t] = (det(bsmat))^(-ntime/2);

   t = t + 1;
endo;

etab2 = sumc(condb22)*widthb;

   ffullb = sampb[1]|sampb[2]|sampb[3]|sampb[4];
   fbepss = (fys - fxstarmt*ffullb)'(fys - fxstarmt*ffullb);
   fbepsf = (fys - fxstarmt*ffullb)'finf;

fbsmat = zeros(2,2);
fbsmat[1,1] = fbepss;
fbsmat[1,2] = fbepsf;
fbsmat[2,1] = fbepsf;
fbsmat[2,2] = finff;

   fcondb2 = (1/etab2)*(det(fbsmat))^(-ntime/2);

print " fcondb2 = " sampb[2] fcondb2;

   goto final;

endbit1:

      print " ";
      print " Estimation of ordinate of conditional posterior for: ";
      print " second beta shift given the third beta shift, ";
      print " beta1, a, phi, r1, r2 and r3";
      print " ";

repl = repl - bur + 1;

fcondb3 = (1/repl)*cb3;

print " sampb[3] fcondb3 = " sampb[3] fcondb3;

    goto final;

endbit2:

      print " ";
      print " Estimation of ordinate of conditional posterior for: ";
      print " third beta shift given ";
      print " beta1, a, phi, r1, r2 and r3";
      print " ";

repl = repl - bur + 1;

fcondb4 = (1/repl)*cb4;

print " sampb[4] fcondb4 = " sampb[4] fcondb4;

    goto final;

endbit3:

      print " ";
      print " Estimation of ordinate of conditional posterior for: ";
      print " beta1 given a, phi, r1, r2 and r3";
      print " ";

repl = repl - bur + 1;

if ho == 1;
   fcondb1 = 1;
else;
   fcondb1 = (1/repl)*cb1;
endif;

print " sampb[1] fcondb1 = " sampb[1] fcondb1;

    goto final;

endbit4:

      print " ";
      print " Estimation of ordinate of conditional posterior for: ";
      print " a given phi, r1, r2 and r3";
      print " ";

repl = repl - bur + 1;

fconda = (1/repl)*cona2;

print " sampa fconda = " sampa fconda;

    goto final;

endbit5:

      print " ";
      print " ";
      print " Estimation of ordinate of conditional posterior for: ";
      print " phi given r1, r2 and r3";
      print " ";

repl = repl - bur + 1;

fcondrho = (1/repl)*condrh;

print " sampr fcondrho = " sampr fcondrho;

fcondr1 = 0.9999;

print " fcondr1 = " fcondr1;

fcondr2 = 0.9999;

print " fcondr2 = " fcondr2;

/*
** p(r3)
*/


post = fcondsig*fcondb2*fcondb3*fcondb4*
         fcondb1*fconda*fcondrho*fcondr1*fcondr2*fdensr3;

if ho == 1;
   postho = post;
   print "postho" postho;
else;
   posth1 = post;
   print "posth1" posth1;
endif;

final:

den = den + 1;
endo;

output off;

ho = ho + 1;
endo;

output off;

output file = gaelm4.out reset;

/**
**  Computation of posterior odds
**/

      print " ";
      print "Posterior odds ratio for Model 3";
      print " ";


hoy = lho*pho/postho;

print " For Ho; lho pho postho hoy";
print lho pho postho hoy;
print " ";

h1y = lh1*ph1/posth1;

print " For H1; lh1 ph1 posth1 h1y";
print lh1 ph1 posth1 h1y;
print " ";


po = hoy/h1y;

print " Posterior odds for Ho: beta1 = 1 versus H1: 0 < beta1 < 1 = " po;

output off;


