

/*
**  US deficit sustainability: a new approach based on
**                                   multiple endogenous breaks
**
**  PROGRAM 2
**
**  Program produces the posterior odds ratio
**  in the `Model 1' column in Table 1,
**
**
**  Main aspects of program:
**
**     1) Triangular cointegration model assumed (Eqn (32) in paper)
**        with value for intercept (alpha1) estimated in Gaelm1.prg
**        and IMPOSED HERE
**     2) Hybrid Gibbs/Metropolis-Hastings simulation method used,
**        along the lines of the algorithm described in Appendix B
**        in the paper, with all references to breaks ommitted
**     3) Lag length of upto 5 allowed for in code for AR(p) polynomial for
**        the cointegrating error (ut). (p=1 specified, based on a
**        preliminary model selection procedure)
**     4) Program written for the change in G (expenditure) being i.i.d.
**        with an intercept term (as specified by a preliminary
**        model selection procedure)
**
*/


library pgraph,maxlik;
#include maxlik.ext;
graphset;
maxset;
gausset;

_pnotify = 0;

fonts("simplex complex microb simgrma");


/**
**  Loading in deficit data
**/

/*  debt.dat
**
**  The data are quarterly starting in 1947(2) and ending in 1992(3)
**
**  The data are:
**
**          1    real tax revenues
**          2    real government expenditures, inclusive of interest paid on
**               debt
*/

load debt[182,8] = c:\gauss\sbreak\debt.dat;
reven = debt[.,1];
expen = debt[.,2];

/*
**    Intercept imposed
*/

      yall = reven[1:182] - 0.79319372;
      xall = expen[1:182];
      n = 182;
      beg = 1947+1/4;
      period = 1/4;
      start = 6;
      ntime = n - start;
      time1n = seqa(beg+start*period,period,ntime);

      p11 = 1;  /* p in the paper */

   x   = (xall[start+1:n]);
   xl  = (xall[start:n-1]);
   xl2 = (xall[start-1:n-2]);
   xl3 = (xall[start-2:n-3]);
   xl4 = (xall[start-3:n-4]);
   xl5 = (xall[start-4:n-5]);

   y   = (yall[start+1:n]);
   yl  = (yall[start:n-1]);
   yl2 = (yall[start-1:n-2]);
   yl3 = (yall[start-2:n-3]);
   yl4 = (yall[start-3:n-4]);
   yl5 = (yall[start-4:n-5]);

  xlmat = xl~xl2~xl3~xl4~xl5;
  xlmat = xlmat[.,1:p11];

  ylmat = yl~yl2~yl3~yl4~yl5;
  ylmat = ylmat[.,1:p11];

  xlmatr = xl~(xl-xl2)~(xl2-xl3)~(xl3-xl4)~(xl4-xl5);
  xlmatr1 = xlmatr[.,1:p11];

  ylmatr = yl~(yl-yl2)~(yl2-yl3)~(yl3-yl4)~(yl4-yl5);
  ylmatr1 = ylmatr[.,1:p11];

ulmat = zeros(ntime,p11);
ulmatr = zeros(ntime,p11);


ho = 1;
do while ho <= 2;


      lbeta = 0.4;
      ubeta = 0.999;
      la = -0.1;
      ua = 0.2;
      lphi1 = 0.551;
      uphi1 = 1.2;
      widthb = 0.01;
      wida = 0.005;
      widthp = 0.01;


ts = hsec;


/*
** Generation of values of sigma, beta, phi (rho in paper) and a
** from their respective marginal
** posteriors via the hybrid Gibbs/Metropolis algorithm.
*/

   bur = 100;
   repl = 5000 + bur;
   it = 10;
   nmetrop = 1;
   seed = 223461.0;



print " ";
print " Initial No. of Gibbs values          = " repl;
print " No. of iterations per repl.          = " it;
print " No. of Metropolis iterations per it. = " nmetrop;
print " Hypothesis = " ho-1;
print " ";


fbetav = zeros(repl,1);
fav = zeros(repl,1);
fphv = zeros(repl,p11);
fs12v = zeros(repl,1);
fs11v = zeros(repl,1);
fs22v = zeros(repl,1);

av = zeros(it,1);
bev = zeros(it,1);
phiv = zeros(it,p11);
si12v = zeros(it,1);
si11v = zeros(it,1);
si22v = zeros(it,1);

numphi = round((uphi1 - lphi1)/widthp + 1);
nplotp = numphi;

phi = zeros(numphi,1);
condp = zeros(numphi,1);
densps = zeros(numphi,1);
condpp = zeros(1,numphi);

nplotb = round(((ubeta-lbeta)/widthb) + 1);

bv = seqa(lbeta,widthb,nplotb);
beta = zeros(nplotb,1);
expb = zeros(nplotb,1);
cob = zeros(nplotb,1);
conbtr = zeros(nplotb,1);
condb = zeros(1,nplotb);
condbf = zeros(1,nplotb);
condppf = zeros(1,nplotp);

nplota = ((ua - la)/wida) + 1;
aval = seqa(la,wida,nplota);
conda = zeros(nplota,1);
condatry = zeros(nplota,1);
cona = zeros(nplota,1);

etap = zeros(repl,1);
condpe = zeros(1,nplotp);

condrj = 0;
counter = 0;
mycount = 0;
integ = 1;


ph = zeros(nmetrop+1,p11);


/* Starting values */

k = 1;
do while k <= repl;

   if k == 1;

if ho == 1;
   bev[1,.] = 1.0;
else;
   bev[1,.] = 0.9;
endif;

   phiv[1,.] = 0.9;
   av[1] = 0.06;

   else;

phiv[1,.] = fphv[k-1,.];
bev[1,.] = fbetav[k-1,.];
av[1] = fav[k-1];

   endif;

ib = 0;
stnbe = rndns(it,1,seed);
rana = rndus(it,1,seed);
stnber = rndns(200,1,seed);


i = 2;
do while i <= it;

/*
** Generation of the elements of the sigma matrix
*/

   f = (x - xl) - av[i-1];

   ys = y - ylmatr1*phiv[i-1,.]';

   xstar = x - xlmatr1*phiv[i-1,.]';


   g = (ys - xstar*bev[i-1,.]');
   e1 = g;
   e2 = f;


   smatrix = {1.0 1.0,
              1.0 1.0};
   smatrix[1,1] = e1'e1;
   smatrix[1,2] = e1'e2;
   smatrix[2,1] = smatrix[1,2];
   smatrix[2,2] = e2'e2;
   sinv = invpd(smatrix);

   fn multn2(ntime,sig) = rndns(ntime,rows(sig),seed)*chol(sig);

   zvec  = multn2(ntime,sinv);

   zvec1 = zvec[.,1];
   zvec2 = zvec[.,2];

   zmatrix = {1.0 1.0,
              1.0 1.0};
   zmatrix[1,1] = sumc(zvec1.^2);
   zmatrix[1,2] = zvec1'zvec2;
   zmatrix[2,1] = zmatrix[1,2];
   zmatrix[2,2] = sumc(zvec2.^2);
   zinv = invpd(zmatrix);

   si11v[i] = zinv[1,1];
   si12v[i] = zinv[1,2];
   si22v[i] = zinv[2,2];


/*
** Generation of phi (rho in paper) via Metropolis-Hastings
*/

   ustar1 = y - x*bev[i-1,.]' - (si12v[i]/si22v[i])*f;

   lg = 1;
   do while lg <= p11;
      ulmat[.,lg] = ylmat[.,lg]
                      - xlmat[.,lg]*bev[i-1,.]';
      ulmatr[.,1] = ulmat[.,1];
         if p11 > 1;
            if lg > 1;
               ulmatr[.,lg] = ulmat[.,lg-1] - ulmat[.,lg];
            endif;
         endif;
   lg = lg + 1;
   endo;

meanphiq = inv(ulmatr'ulmatr)*(ulmatr'ustar1);
varphiq = (si11v[i] - (si12v[i]^2/si22v[i]))*inv(ulmatr'ulmatr);

count = 0;
im = 2;
ims = 2;
ime = 2;
conphi = zeros(nmetrop+1,1);
normphi = zeros(nmetrop+1,1);
ph[im-1,.] = phiv[i-1,.];

stnphi = rndns(nmetrop+1,p11,seed);
stnphie = rndns(50,p11,seed);
stnphis = rndns(100,p11,seed);
cphi1 = rndus(nmetrop+1,1,seed);

do until im == nmetrop + 2;

/*
** Generation of candidate value and evaluation of the actual and candidate
** densities at it
*/

   pst = chol(varphiq)*stnphi[im,.]' + meanphiq;

   phidraw:

   pstt = zeros(p11,1);
   if p11 == 1;
      pstt[1] = pst[1];
   else;
      pstt[1] = pst[1] + pst[2];
      pstt[p11] = -pst[p11];
   endif;
   if p11 > 2;
      j = 2;
      do while j < p11;
         pstt[j] = -(pst[j] - pst[j+1]);
         j = j + 1;
      endo;
   endif;


/*
** Checking whether the implied AR process for u1t has at most one root <= 1.
*/

   proot = -rev(pstt)|1;
   yroot = polyroot(proot);
   absroot = abs(yroot);

   noroot = 0;
   if p11 > 1;
     j = 1;
     do while j <= p11;
        if absroot[j] <= 1;
           noroot = noroot + 1;
        endif;
        j = j + 1;
     endo;
   endif;

   if noroot > 1;
      redophi:
      ims = ims + 1;
      pst = chol(varphiq)*stnphis[ims,.]' + meanphiq;
      pstt = zeros(p11,1);
      if p11 == 1;
         pstt[1] = pst[1];
      else;
         pstt[1] = pst[1] + pst[2];
         pstt[p11] = -pst[p11];
      endif;
      if p11 > 2;
         j = 2;
         do while j < p11;
            pstt[j] = -(pst[j] - pst[j+1]);
            j = j + 1;
         endo;
      endif;
   endif;

   proot = -rev(pstt)|1;
   yroot = polyroot(proot);
   absroot = abs(yroot);

   noroot = 0;
   if p11 > 1;
   j = 1;
   do while j <= p11;
      if absroot[j] <= 1;
         noroot = noroot + 1;
      endif;
      j = j + 1;
   endo;
   endif;

   if noroot > 1;
      goto redophi;
    endif;


/*
**  Specification of Jeffreys' conditional prior c2^1/2
*/

xstar = x - xlmatr1*pst;

c2 = (xstar'xstar)*(f'f) - (xstar'f)^2;

j12 = sqrt(c2);

conphi1 = exp((-1/2)*(pst-meanphiq)'*inv(varphiq)*(pst-meanphiq))*j12;

nc = (2*pi)^(-p11/2)*(det(varphiq))^(-1/2);
normphi1 = nc*exp((-1/2)*(pst-meanphiq)'*inv(varphiq)*(pst-meanphiq));

if conphi1 == 0;
   ime = ime + 1;
   pst = chol(varphiq)*stnphie[ime,.]' + meanphiq;
   goto phidraw;
endif;

/*
** Evaluation of the actual and candidate densities at the previous value
*/

xstar = x - xlmatr1*ph[im-1,.]';

c2 = (xstar'xstar)*(f'f) - (xstar'f)^2;

jp1 = 1;

j12 = sqrt(c2)*jp1;


expph = (-1/2)*(ph[im-1,.]-meanphiq')*inv(varphiq)*(ph[im-1,.]'-meanphiq);
conphi[im-1] = exp(expph)*j12;

nc = (2*pi)^(-p11/2)*(det(varphiq))^(-1/2);
normphi[im-1] = nc*exp(expph);

if conphi[im-1] == 0.0;
   ratio = 1;
else;
   ratio = (conphi1/normphi1)/(conphi[im-1]/normphi[im-1]);
endif;

alph = ones(2,1);
alph[1] = ratio;
alpha = minc(alph);
if cphi1[im] <= alpha;
   ph[im,.] = pst';
   count = count + 1;
else;
   ph[im,.] = ph[im-1,.];
endif;

im = im + 1;
endo;

if k >= bur;
counter = counter + count/nmetrop;
mycount = mycount + 1;
endif;

phiv[i,.] = ph[im-1,.];

   ys = y - ylmatr1*phiv[i,.]';
   xstar = x - xlmatr1*phiv[i,.]';

   g = (ys - xstar*bev[i-1,.]');


/*
** Generation of drift term a for G process
*/

abar = meanc(x-xl - (si12v[i]/si11v[i])*g);
variana = (si22v[i] - (si12v[i]^2/si11v[i]))/ntime;

l = 1;
do while l <= nplota;
   ef = (x - xl) - aval[l];

   smatrix      = zeros(2,2);
   smatrix[1,1] = g'g;
   smatrix[1,2] = g'ef;
   smatrix[2,1] = smatrix[1,2];
   smatrix[2,2] = ef'ef;

   sigmatr  = zeros(2,2);
   sigmatr[1,1] = si11v[i];
   sigmatr[1,2] = si12v[i];
   sigmatr[2,1] = si12v[i];
   sigmatr[2,2] = si22v[i];

invsig = inv(sigmatr);

prior = sqrt((xstar'xstar)*(ef'ef) - (xstar'ef)^2);

expa = (-1/2)*((aval[l]-abar)^2)/variana;
conda[l] = exp(expa)*prior;

l = l + 1;
endo;

cumaden = cumsumc(conda)./sumc(conda);

diffa = cumaden - rana[i];
mina = minindc(abs(cumaden - rana[i]));

av[i] = aval[mina];

/*
** Generation of beta
*/


   f = (x - xl) - av[i];
   ys = y - ylmatr1*phiv[i,.]';
   ystar = ys - (si12v[i]/si22v[i])*f;


if ho == 1;
   bev[i,.] = 1;
   goto skipb1;
endif;


meanbe = inv(xstar'xstar)*(xstar'ystar);
varbe = (si11v[i] - (si12v[i]^2/si22v[i]))*inv(xstar'xstar);
bgen = chol(varbe)*stnbe[i,.]' + meanbe;

if bgen >= 1.0;
   redobeta:
   ib = ib + 1;
   bgen = chol(varbe)*stnber[ib,.]' + meanbe;
endif;

   if bgen >= 1.0;
      goto redobeta;
   endif;

if bgen <= 0.0;
   redob0:
   ib = ib + 1;
   bgen = chol(varbe)*stnber[ib,.]' + meanbe;
endif;

   if bgen <= 0.0;
      goto redob0;
   endif;

   if bgen >= 1.0;
      goto redobeta;
   endif;


bev[i,.] = bgen';

skipb1:


/***
****  Saving of conditional densities at iteration it
****  after burn-in period `bur'.
****
****/


if k >= bur;

if i == it;

/**
**  a
**/

cona = cona + conda./(sumc(conda)*wida);

if ho == 1;
   goto skipb2;
endif;

/**
**  Beta
**/

j = 1;
do while j<=nplotb;
   expb[j] = (-1/(2*varbe))*(bv[j]-meanbe)^2;
   cob[j] = ((2*pi*varbe)^(-1/2))*exp(expb[j]);
   condb[1,j] = cob[j];

j = j + 1;
endo;

   etab = sumc(cob)*widthb;
   condb = condb./etab;


condbf = condbf + condb;

skipb2:


/**
**  phi
**/

   ustar1 = y - x*bev[i,.]' - (si12v[i]/si22v[i])*f;

   lg = 1;
   do while lg <= p11;
      ulmat[.,lg] = ylmat[.,lg]
                      - xlmat[.,lg]*bev[i,.]';
      ulmatr[.,1] = ulmat[.,1];
         if p11 > 1;
            if lg > 1;
               ulmatr[.,lg] = ulmat[.,lg-1] - ulmat[.,lg];
            endif;
         endif;
   lg = lg + 1;
   endo;

meanphiq = invpd(ulmatr'ulmatr)*(ulmatr'ustar1);
varphiq = (si11v[i] - (si12v[i]^2/si22v[i]))*invpd(ulmatr'ulmatr);

t = 1;
do while t <= numphi;
   phi[t] = lphi1 + (t-1)*widthp;
   p = phi[t];

if p11 == 1;

   xstar = x - p*xl;


c2 = (xstar'xstar)*(f'f) - (xstar'f)^2;

j12p = sqrt(c2);

condp[t] = exp((-1/2)*(p-meanphiq)'*inv(varphiq)*(p-meanphiq))*j12p;

else;

   xstar = x - xlmatr1*(p|phiv[i,2:p11]');

c2 = (xstar'xstar)*(f'f) - (xstar'f)^2;

j12p = sqrt(c2);

p2 = phiv[i,2:p11]';
pall = p|p2;
condp[t] = exp((-1/2)*(pall - meanphiq)'*inv(varphiq)*(pall - meanphiq))*j12p;

endif;

t = t + 1;
endo;

   etap = sumc(condp)*widthp;
   condpp[1,.] = condp'./etap;

condppf = condppf + condpp;

/**
**  Specification of conditional posterior for phi1
**  for use in the posterior odds calculations below
**  evaluated at sampr (saved)
**/


if ho == 1;
   sampr = 0.98895261;
else;
   sampr = 0.91771493;
endif;

fxstar = x - xlmatr1*sampr;

fc2 = (fxstar'fxstar)*(f'f) - (fxstar'f)^2;

condrho = (1/etap)*exp(-(1/2)*
     (sampr - meanphiq)'inv(varphiq)*(sampr - meanphiq))*fc2^(1/2);

condrj = condrj + condrho;


endif;

endif;

i = i + 1;

endo;


/*
** Gibbs values
*/


fbetav[k,.] = bev[it,.];
fav[k,.] = av[it,.];
fphv[k,.] = phiv[it,.];
fs12v[k] = si12v[it];
fs11v[k] = si11v[it];
fs22v[k] = si22v[it];

if k/10==integ;
    print " k= " k;
    integ = integ + 1;
endif;


k = k + 1;
endo;

/*
** Choice of "burnout" period
*/


betav = fbetav[bur:repl,.];
adriftv = fav[bur:repl,.];
phv = fphv[bur:repl,.];
s12v = fs12v[bur:repl];
s11v = fs11v[bur:repl];
s22v = fs22v[bur:repl];

sampb = meanc(betav);
sampa = meanc(adriftv);
sampr = meanc(phv);
samps12 = meanc(s12v);
samps11 = meanc(s11v);
samps22 = meanc(s22v);


repl = repl - bur + 1;

densb = (1/repl)*condbf';
densp = (1/repl)*condppf';
densa = (1/repl)*cona;

i = 1;
do while i <= numphi;
    phi[i] = (lphi1) + (i-1)*widthp;
    if phi[i] < 1;
       densps[i] = densp[i];
    endif;
    i = i + 1;
endo;

gsprob = sumc(densps)*widthp;

pmean2 = counter/mycount;

print " Final no. of replications after burnout         = " repl;
print " Average proportion of accepted Metropolis draws = " pmean2;

et = hsec - ts;

/******************

xlabel("\204b");
ylabel("\201Marginal posterior for \204b");

xy(bv,densb);

xlabel("\201a");
ylabel("\201Marginal posterior for a");

xy(aval,densa);

xlabel("\204r\201]1[");
ylabel("\201Marginal posterior for \204r\201]1[");

xy(phi,densp);

*******************/


gmodep = phi[maxindc(densp)];
gmodeb = bv[maxindc(densb)];

print " ";
print "Gibbs output:";
print "Gibbs mode for rho1  = " gmodep;
print "Gibbs mode for beta  = " gmodeb;
print " ";


print " ";
print "Probability of stationarity  (Gibbs)    = " gsprob;
print " ";

print "Time (in minutes) for MCMC computations = " et/6000;
print " ";


/**
**  Evaluation of posterior odds under ho and h1 at
**  simulation mean values for the parameters
**/


/*
** Likelihood function
*/

sigmam = zeros(2,2);
sigmam[1,1] = samps11;
sigmam[1,2] = samps12;
sigmam[2,1] = samps12;
sigmam[2,2] = samps22;


invsig = inv(sigmam);

fys =  y - ylmatr1*sampr;
fxstar = x - xlmatr1*sampr;
finf = (x - xl) - sampa;

epss = (fys - fxstar*sampb)'(fys - fxstar*sampb);
epsf = (fys - fxstar*sampb)'finf;
finff = finf'finf;

smat = zeros(2,2);
smat[1,1] = epss;
smat[1,2] = epsf;
smat[2,1] = epsf;
smat[2,2] = finff;


tr = sumc(diag(invsig*smat));
like = ((2*pi)^(-ntime))*(det(sigmam))^(-ntime/2)*exp(-(1/2)*tr);


if ho == 1;
   lho = like;
else;
   lh1 = like;
endif;


/*
** Prior
*/


fc1 = (fys'fys)*finff - (fys'finf)^2;
fc2 = (fxstar'fxstar)*finff - (fxstar'finf)^2;
fc3 = (fxstar'fys)*finff - (fys'finf)*(fxstar'finf);
fc4 = fc1 - (fc3^2)/fc2;

prior = ((det(sigmam))^(-3/2))*fc2^(1/2);

if ho == 1;
   pho = prior;
else;
   ph1 = prior;
endif;


/*
** Posterior
*/

/*
** IW Conditional for sigma given beta, phi and a
**
*/


g1 = exp(lnfact((ntime/2)-1));
g2 = exp(lnfact(((ntime-1)/2)-1));
g1 = gamma(ntime/2);
g2 = gamma((ntime-1)/2);
invcons = (pi^(1/2))*g1*g2;


fcndsig1 = (inv(invcons))*((det(smat))^(ntime/2));

fcndsig2 =  fcndsig1*((det(sigmam))^(-(ntime+3)/2));

fcondsig =  fcndsig2*exp(-(1/2)*tr)*(2^(-ntime));


print " fcondsig = " fcondsig;

/*
** Numerically normalized Univariate conditional for beta given phi and a
**/

if ho == 1;
   fcondb = 1;
else;

t = 1;
do while t <= nplotb;
   bv[t] = lbeta + (t-1)*widthb;
   stdf = ntime - 1;
   bbar = fc3/fc2;
   conbtr[t] = (1+(fc2/fc4)*(bv[t] - bbar)^2)^(-(stdf+1)/2);
   t = t + 1;
endo;

etab = sumc(conbtr)*widthb;

   fcondb = (1/etab)*(1+(fc2/fc4)*(sampb - bbar)^2)^(-(stdf+1)/2);
endif;

print " fcondb = " fcondb;


/*
** More simulations in order to estimate: p(a given phi)
**
*/


   bur = 100;
   repl = 5000 + bur;
   it = 10;
   nmetrop = 1;
   seed = 223461.0;


f2betav = zeros(repl,1);
f2av = zeros(repl,1);
f2phv = zeros(repl,p11);
f2s12v = zeros(repl,1);
f2s11v = zeros(repl,1);
f2s22v = zeros(repl,1);

bev = zeros(it,1);
av = zeros(it,1);
phiv = zeros(it,p11);
si12v = zeros(it,1);
si11v = zeros(it,1);
si22v = zeros(it,1);

counterb = zeros(repl,it-1);

beta = zeros(nplotb,1);
expb = zeros(nplotb,1);
cob = zeros(nplotb,1);

condb = zeros(1,nplotb);
conda = zeros(nplota,1);
cona2 = 0;

etap = zeros(repl,1);
condpe = zeros(1,nplotp);


j = 1;
do while j<=nplotb;
   bv[j] = lbeta + (j-1)*widthb;
j = j + 1;
endo;



/* Starting values */

k = 1;
do while k <= repl;

   if k == 1;

if ho == 1;
   bev[1,.] = 1.0;
else;
   bev[1,.] = 0.9;
endif;

   phiv[1,.] = sampr';
   av[1] = 0.06;

   else;

phiv[1,.] = f2phv[k-1,.];
bev[1,.] = f2betav[k-1,.];
av[1] = f2av[k-1,.];

   endif;

ibn = 0;
stnbe = rndns(it,1,seed);
stnbern = rndns(200,1,seed);
rana = rndus(it,1,seed);


i = 2;
do while i <= it;

/*
** Generation of the elements of the sigma matrix
*/

   f = (x - xl) - av[i-1];

   ys = y - ylmatr1*phiv[i-1,.]';
   xstar = x - xlmatr1*phiv[i-1,.]';


   g = (ys - xstar*bev[i-1,.]');
   e1 = g;
   e2 = f;


   smatrix = {1.0 1.0,
              1.0 1.0};
   smatrix[1,1] = e1'e1;
   smatrix[1,2] = e1'e2;
   smatrix[2,1] = smatrix[1,2];
   smatrix[2,2] = e2'e2;
   sinv = invpd(smatrix);

   fn multn2(ntime,sig) = rndns(ntime,rows(sig),seed)*chol(sig);

   zvec  = multn2(ntime,sinv);

   zvec1 = zvec[.,1];
   zvec2 = zvec[.,2];

   zmatrix = {1.0 1.0,
              1.0 1.0};
   zmatrix[1,1] = sumc(zvec1.^2);
   zmatrix[1,2] = zvec1'zvec2;
   zmatrix[2,1] = zmatrix[1,2];
   zmatrix[2,2] = sumc(zvec2.^2);
   zinv = invpd(zmatrix);

   si11v[i] = zinv[1,1];
   si12v[i] = zinv[1,2];
   si22v[i] = zinv[2,2];


phiv[i,.] = sampr';


   ys = y - ylmatr1*phiv[i,.]';
   xstar = x - xlmatr1*phiv[i,.]';

   g = (ys - xstar*bev[i-1,.]');


/*
** Generation of beta
*/

 ystar = ys - (si12v[i]/si22v[i])*f;

if ho == 1;
   bev[i,.] = 1;
   goto nskipb1;
endif;


meanbe = inv(xstar'xstar)*(xstar'ystar);
varbe = (si11v[i] - (si12v[i]^2/si22v[i]))*inv(xstar'xstar);
bgen = chol(varbe)*stnbe[i,.]' + meanbe;


if bgen >= 1.0;
   rdobeta:
   print " beta greater than or equal to one" it repl;
   ibn = ibn + 1;
   bgen = chol(varbe)*stnber[ibn,.]' + meanbe;
endif;

   if bgen >= 1.0;
      goto rdobeta;
   endif;

if bgen <= 0.0;
   rdob:
   print " beta less than or equal to zero" it repl;
   ibn = ibn + 1;
   bgen = chol(varbe)*stnber[ibn,.]' + meanbe;
endif;

   if bgen <= 0.0;
      goto rdob;
   endif;

   if bgen >= 1.0;
      goto rdobeta;
   endif;

bev[i,.] = bgen';


nskipb1:

/*
** Generation of drift term a
*/

   g = (ys - xstar*bev[i,.]');

abar = meanc(x-xl - (si12v[i]/si11v[i])*g);
variana = (si22v[i] - (si12v[i]^2/si11v[i]))/ntime;

l = 1;
do while l <= nplota;
   ef = (x - xl) - aval[l];

   smatrix      = zeros(2,2);
   smatrix[1,1] = g'g;
   smatrix[1,2] = g'ef;
   smatrix[2,1] = smatrix[1,2];
   smatrix[2,2] = ef'ef;

   sigmatr  = zeros(2,2);
   sigmatr[1,1] = si11v[i];
   sigmatr[1,2] = si12v[i];
   sigmatr[2,1] = si12v[i];
   sigmatr[2,2] = si22v[i];

prior = sqrt((xstar'xstar)*(ef'ef) - (xstar'ef)^2);
expa = (-1/2)*((aval[l]-abar)^2)/variana;
conda[l] = exp(expa)*prior;

l = l + 1;
endo;

cumaden = cumsumc(conda)./sumc(conda);

diffa = cumaden - rana[i];
mina = minindc(abs(cumaden - rana[i]));

av[i] = aval[mina];


/***
****  Saving of conditional density for a at iteration it
****  after burn-in period `bur'. Evaluated at sampa (saved)
****
****/

if k >= bur;

if i == it;

etaa = sumc(conda)*wida;

ef2 = (x - xl) - sampa;
prior2 = sqrt((xstar'xstar)*(ef2'ef2) - (xstar'ef2)^2);
conda2 = (1/etaa)*exp((-1/2)*((sampa - abar)^2)/variana)*prior2;

cona2 = cona2 + conda2;

endif;

endif;

i = i + 1;

endo;

/*
** Gibbs values
*/


f2betav[k,.] = bev[it,.];
f2av[k,.] = av[it,.];
f2phv[k,.] = phiv[it,.];
f2s12v[k] = si12v[it];
f2s11v[k] = si11v[it];
f2s22v[k] = si22v[it];

k = k + 1;
endo;

repl = repl - bur + 1;


condaf = (1/repl)*cona2;

print " condaf = " condaf;

gmodep = phi[maxindc(densp)];
gmodeb = bv[maxindc(densb)];

/*
** p(phi)
*/


densrho = (1/repl)*condrj;

print " densrho = " densrho;

post = fcondsig*fcondb*condaf*densrho;

if ho == 1;
   postho = post;
else;
   posth1 = post;
endif;


ho = ho + 1;
endo;

output off;
output file = gaelm2.out reset;

/**
**  Computation of posterior odds
**/


      print " ";
      print "Posterior odds ratio for Model 1";
      print " ";


hoy = lho*pho/postho;

print " For Ho; lho pho postho hoy";
print lho pho postho hoy;
print " ";


h1y = lh1*ph1/posth1;

print " For H1; lh1 ph1 posth1 h1y";
print lh1 ph1 posth1 h1y;
print " ";


po1 = hoy/h1y;


lnhoy = ln(lho) + ln(pho) - ln(postho);

lnh1y = ln(lh1) + ln(ph1) - ln(posth1);


po2 = exp(lnhoy - lnh1y);

print " Posterior odds for Ho: beta1 = 1 versus H1: 0 < beta1 < 1";
print po1 po2;


output off;



