
/*
**  US deficit sustainability: a new approach based on
**                                   multiple endogenous breaks
**
**  PROGRAM 1
**
**  Program produces all results in the `Model 1' column in Table 1,
**
**  APART FROM the posterior odds ratio
**
**  Main aspects of program:
**
**     1) Triangular cointegration model assumed (Eqn (32) in paper)
**     2) Hybrid Gibbs/Metropolis-Hastings simulation method used,
**        along the lines of the algorithm described in Appendix A
**        in the paper, with all references to breaks ommitted
**     3) Lag length of upto 5 allowed for in code for AR(p) polynomial for
**        the cointegrating error (ut). (p=1 specified, based on a
**        preliminary model selection procedure)
**     4) Program written for the change in G (expenditure) being i.i.d.
**        with an intercept term (as specified by a preliminary
**        model selection procedure)
**
*/


library pgraph,maxlik;
#include maxlik.ext;
graphset;
maxset;
gausset;

_pnotify = 0;

fonts("simplex complex microb simgrma");


/**
**  Loading in deficit data
**/

/*  debt.dat
**
**  The data are quarterly starting in 1947(2) and ending in 1992(3)
**
**  The data are:
**
**          1    real tax revenues
**          2    real government expenditures, inclusive of interest paid on
**               debt
*/

load debt[182,8] = c:\gauss\sbreak\debt.dat;
reven = debt[.,1];
expen = debt[.,2];

      output file = gaelm1.out reset;
      print " ";
      print "Program produces all results in the `Model 1' column in Table 1";
      print "APART FROM the posterior odds ratio";
      print " ";
      yall = reven[1:182];
      xall = expen[1:182];
      n = 182;
      beg = 1947+1/4;
      period = 1/4;
      start = 6;
      ntime = n - start;
      time1n = seqa(beg+start*period,period,ntime);

      p11 = 1;  /* p in the paper */

   x   = (xall[start+1:n]);
   xl  = (xall[start:n-1]);
   xl2 = (xall[start-1:n-2]);
   xl3 = (xall[start-2:n-3]);
   xl4 = (xall[start-3:n-4]);
   xl5 = (xall[start-4:n-5]);

   y   = (yall[start+1:n]);
   yl  = (yall[start:n-1]);
   yl2 = (yall[start-1:n-2]);
   yl3 = (yall[start-2:n-3]);
   yl4 = (yall[start-3:n-4]);
   yl5 = (yall[start-4:n-5]);


  xlmatr = xl~(xl-xl2)~(xl2-xl3)~(xl3-xl4)~(xl4-xl5);
  xlmatr1 = xlmatr[.,1:p11];

  ylmatr = yl~(yl-yl2)~(yl2-yl3)~(yl3-yl4)~(yl4-yl5);
  ylmatr1 = ylmatr[.,1:p11];


      lalpha = -3.0;
      ualpha = 7.5;
      lbeta = -0.4;
      ubeta = 1.5;
      la = -0.1;
      ua = 0.2;
      lphi1 = 0.6501;
      uphi1 = 1.3;
      widthb = 0.01;
      wida = 0.005;
      widthp = 0.02;

      nplota = ((ua - la)/wida) + 1;
      numphi = (uphi1 - lphi1)/widthp + 1;
      nplotb = ((ubeta - lbeta)/widthb) + 1;

      widtha = (ualpha - lalpha)/nplotb;


ts = hsec;

/*
** Generation of values of a and phi (called rho in paper)
** from their respective conditional posteriors
** via the hybrid Gibbs/Metropolis algorithm.
*/

   bur = 100;
   repl = 5000 + bur;
   it = 10;
   nmetrop = 1;
   seed = 223460;

print " Initial No. of Gibbs values          = " repl;
print " No. of iterations per repl.          = " it;
print " No. of Metropolis iterations per it. = " nmetrop;

fav = zeros(repl,1);
av = zeros(it,1);

fphv = zeros(repl,p11);
phiv = zeros(it,p11);

fvarhpv = zeros(repl,1);
varhp = zeros(it,1);

aval = zeros(nplota,1);
conda = zeros(nplota,1);
cona = zeros(nplota,1);

phi = zeros(numphi,1);
condp = zeros(numphi,1);
conp = zeros(numphi,1);

densps = zeros(numphi,1);

alpha = seqa(lalpha,widtha,nplotb);
bv   = seqa(lbeta,widthb,nplotb);

condb = zeros(nplotb,1);
conb = zeros(nplotb,1);
condal = zeros(nplotb,1);
conal = zeros(nplotb,1);

ph = zeros(nmetrop+1,p11);
normp1 = zeros(numphi,1);
counter = 0;
mycount = 0;
integ = 1;


/* Starting values */

k = 1;
do while k <= repl;

   if k == 1;

phiv[1,.] = 0.9;
av[1,.] = 0.06;


   else;

phiv[1,.] = fphv[k-1,.];
av[1,.] = fav[k-1,.];
varhp[1] = fvarhpv[k-1];

   endif;

rana = rndus(it,1,seed);

i = 2;
do while i <= it;


/*
** Generation of phi via Metropolis-Hastings, based on normal candidate
** density
*/

f = (x - xl) - av[i-1];

c2 = zeros(2,2);
c3 = zeros(2,1);

proc pcondp(fi);
local yst,xst,onest,c1,c4,ic2,lnconp;

   yst = y - ylmatr1*fi;
   xst = x - xlmatr1*fi;
   onest = ones(ntime,1) - ones(ntime,1)*fi;

c1 = (yst'yst)*(f'f) - (yst'f)^2;

c2[1,1] = (onest'onest)*f'f   - (onest'f)^2;
c2[2,2] = (xst'xst)*f'f - (xst'f)^2;

c2[1,2] = (onest'xst)*f'f - (onest'f)*(xst'f);
c2[2,1] = c2[1,2];

ic2 = invpd(c2);

c3[1] = (yst'onest)*f'f  - (yst'f)*(onest'f);
c3[2] = (yst'xst)*f'f - (yst'f)*(xst'f);

c4 = c1 - c3'ic2*c3;

lnconp = ln(c4^(-(ntime-2)/2));

retp(lnconp);
endp;

proc pcondpm(fi,z);
local yst,xst,onest,c1,c4,ic2,lnconp;

   yst = y - ylmatr1*fi;
   xst = x - xlmatr1*fi;
   onest = ones(ntime,1) - ones(ntime,1)*fi;

c1 = (yst'yst)*(f'f) - (yst'f)^2;

c2[1,1] = (onest'onest)*f'f   - (onest'f)^2;
c2[2,2] = (xst'xst)*f'f - (xst'f)^2;

c2[1,2] = (onest'xst)*f'f - (onest'f)*(xst'f);
c2[2,1] = c2[1,2];

ic2 = invpd(c2);

c3[1] = (yst'onest)*f'f  - (yst'f)*(onest'f);
c3[2] = (yst'xst)*f'f - (yst'f)*(xst'f);

c4 = c1 - c3'ic2*c3;

lnconp = ln(c4^(-(ntime-2)/2));

retp(lnconp);
endp;

phstart = phiv[i-1,.]';
__output = 0;
_mlalgr = 6;
_mlcovp = 3;
{ pmle,fmax,g,cov,retcode } = maxlik(y~x~xlmatr1~ylmatr1~f,0,&pcondpm,phstart);

h = hessp(&pcondp,pmle);

if p11 == 1;
   if h < 0;
      varh = inv(-h);
   else;
      varh = varh;
   endif;
else;
   if det(h) < 0;
      varh = inv(-h);
   else;
      varh = varh;
   endif;
endif;

count = 0;
im = 2;
ime = 2;
ime2 = 2;
conphi = zeros(nmetrop+1,1);
normphi = zeros(nmetrop+1,1);
ph[im-1,.] = phiv[i-1,.];

stnphi = rndns(nmetrop+1,p11,seed);
stnphie = rndns(1000,p11,seed);
cphi1 = rndus(nmetrop+1,1,seed);

do until im == nmetrop + 2;

/*
** Generation of candidate value
** for phi and evaluation of the actual and candidate
** densities at it
*/

   pst = chol(varh)*stnphi[im,.]' + pmle;

   phidraw:

   pstt = zeros(p11,1);
   if p11 == 1;
      pstt[1] = pst[1];
   else;
      pstt[1] = pst[1] + pst[2];
      pstt[p11] = -pst[p11];
   endif;
   if p11 > 2;
      j = 2;
      do while j < p11;
         pstt[j] = -(pst[j] - pst[j+1]);
         j = j + 1;
      endo;
   endif;


/*
** Checking whether the implied AR process for u1t has at most one root <= 1.
*/

   proot = -rev(pstt)|1;
   yroot = polyroot(proot);
   absroot = abs(yroot);

   noroot = 0;
   if p11 > 1;
     j = 1;
     do while j <= p11;
        if absroot[j] <= 1;
           noroot = noroot + 1;
        endif;
        j = j + 1;
     endo;
   endif;

   if noroot > 1;
      redophi:
      ims = ims + 1;
      pst = chol(varh)*rndns(1,p11,seed)' + pmle;
      pstt = zeros(p11,1);
      if p11 == 1;
         pstt[1] = pst[1];
      else;
         pstt[1] = pst[1] + pst[2];
         pstt[p11] = -pst[p11];
      endif;
      if p11 > 2;
         j = 2;
         do while j < p11;
            pstt[j] = -(pst[j] - pst[j+1]);
            j = j + 1;
         endo;
      endif;
   endif;

   proot = -rev(pstt)|1;
   yroot = polyroot(proot);
   absroot = abs(yroot);

   noroot = 0;
   if p11 > 1;
   j = 1;
   do while j <= p11;
      if absroot[j] <= 1;
         noroot = noroot + 1;
      endif;
      j = j + 1;
   endo;
   endif;

   if noroot > 1;
      goto redophi;
    endif;


   yst = y - ylmatr1*pst;
   xst = x - xlmatr1*pst;
   onest = ones(ntime,1) - ones(ntime,1)*pst;

c1 = (yst'yst)*(f'f) - (yst'f)^2;

c2[1,1] = (onest'onest)*f'f   - (onest'f)^2;
c2[2,2] = (xst'xst)*f'f - (xst'f)^2;

c2[1,2] = (onest'xst)*f'f - (onest'f)*(xst'f);
c2[2,1] = c2[1,2];

ic2 = invpd(c2);

c3[1] = (yst'onest)*f'f  - (yst'f)*(onest'f);
c3[2] = (yst'xst)*f'f - (yst'f)*(xst'f);

c4 = c1 - c3'ic2*c3;

conphi1 = (c4^(-(ntime-2)/2))*(10^(100));

exph = (-1/2)*(pst-pmle)'*inv(varh)*(pst-pmle);
nc = (2*pi)^(-p11/2)*(det(varh))^(-1/2);
normphi1 = nc*exp(exph);


/*
** Evaluation of the actual and candidate densities at the previous value
*/

   yst = y - ylmatr1*ph[im-1,.]';
   xst = x - xlmatr1*ph[im-1,.]';
   onest = ones(ntime,1) - ones(ntime,1)*ph[im-1,.]';


c1 = (yst'yst)*(f'f) - (yst'f)^2;

c2[1,1] = (onest'onest)*f'f   - (onest'f)^2;
c2[2,2] = (xst'xst)*f'f - (xst'f)^2;

c2[1,2] = (onest'xst)*f'f - (onest'f)*(xst'f);
c2[2,1] = c2[1,2];

ic2 = invpd(c2);

c3[1] = (yst'onest)*f'f  - (yst'f)*(onest'f);
c3[2] = (yst'xst)*f'f - (yst'f)*(xst'f);

c4 = c1 - c3'ic2*c3;

conphi[im-1] = (c4^(-(ntime-2)/2))*(10^(100));

expph = (-1/2)*(ph[im-1,.]'-pmle)'*inv(varh)*(ph[im-1,.]'-pmle);
nc = (2*pi)^(-p11/2)*(det(varh))^(-1/2);
normphi[im-1] = nc*exp(expph);


if conphi[im-1] == 0;
   ratio = 1;
else;
   ratio = (conphi1/normphi1)*(normphi[im-1]/conphi[im-1]);
endif;

alph = ones(2,1);
alph[1] = ratio;
alphan = minc(alph);
if cphi1[im] <= alphan;
   ph[im,.] = pst';
   count = count + 1;
else;
   ph[im,.] = ph[im-1,.];
endif;

im = im + 1;
endo;

if k >= bur;
counter = counter + count/nmetrop;
mycount = mycount + 1;
endif;

phiv[i,.] = ph[im-1,.];


   yst = y - ylmatr1*phiv[i,.]';
   xst = x - xlmatr1*phiv[i,.]';
   onest = ones(ntime,1) - ones(ntime,1)*phiv[i,.]';

/*
** Generation of psi via Metropolis-Hastings, based on normal candidate
** density, would occur here in most general model. psi set to zero via
** preliminary model selection procedure
*/


/*
**  Generation of a (drift term for G) via Griddy Gibbs
*/

m = 1;
do while m <= nplota;
   aval[m] = la+ ((m-1)*wida);
   ef = (x - xl) - aval[m];

c1 = (yst'yst)*(ef'ef) - (yst'ef)^2;

c2[1,1] = (onest'onest)*ef'ef   - (onest'ef)^2;
c2[2,2] = (xst'xst)*ef'ef - (xst'ef)^2;

c2[1,2] = (onest'xst)*ef'ef - (onest'ef)*(xst'ef);
c2[2,1] = c2[1,2];

ic2 = invpd(c2);

c3[1] = (yst'onest)*ef'ef  - (yst'ef)*(onest'ef);
c3[2] = (yst'xst)*ef'ef - (yst'ef)*(xst'ef);

c4 = c1 - c3'ic2*c3;

   conda[m] = (c4^(-(ntime-2)/2))*(ef'ef)^(-1/2);
   m = m + 1;
endo;

cumaden = cumsumc(conda)./sumc(conda);


diffa = cumaden - rana[i];
mina = minindc(abs(cumaden - rana[i]));

av[i] = aval[mina];

f = (x - xl) - av[i];

/**
**  Specification of all conditional densities at it(th) iteration
**/

if k >= bur;


   if i == it;


c1 = (yst'yst)*(f'f) - (yst'f)^2;

c2[1,1] = (onest'onest)*f'f   - (onest'f)^2;
c2[2,2] = (xst'xst)*f'f - (xst'f)^2;

c2[1,2] = (onest'xst)*f'f - (onest'f)*(xst'f);
c2[2,1] = c2[1,2];

ic2 = invpd(c2);

c3[1] = (yst'onest)*f'f  - (yst'f)*(onest'f);
c3[2] = (yst'xst)*f'f - (yst'f)*(xst'f);

c4 = c1 - c3'ic2*c3;

bmean = ic2*c3;


/* a */

amean = bmean[1];

c11 = c2[1,1];
c12 = c2[1,2];
c21 = c12;

c22 = c2[2,2];

consa = c4^(-1/2)*det((c11 - c12*invpd(c22)*c21))^(1/2);
invara = c4^(-1)*(c11 - c12*invpd(c22)*c21);


/* b1 */

b1mean = bmean[2];

c11 = c2[2,2];
c12 = c2[1,2];
c21 = c12;

c22 = c2[1,1];

consb1 = c4^(-1/2)*det((c11 - c12*invpd(c22)*c21))^(1/2);
invarb1 = c4^(-1)*(c11 - c12*invpd(c22)*c21);

cons1 = gamma((ntime-1)/2)/(pi^(1/2)*gamma((ntime-2)/2));

l = 1;
do while l <= nplotb;

         condal[l] = cons1*consa*(1 + ((alpha[l] - amean)^2)
                           *invara)^(-(ntime-1)/2);
         condb[l] = cons1*consb1*(1 + ((bv[l] - b1mean)^2)
                           *invarb1)^(-(ntime-1)/2);
l = l + 1;
endo;

conal   = conal + condal;
conb   = conb   + condb;

/* phi */

t = 1;
do while t <= numphi;
   phi[t] = lphi1 + (t-1)*widthp;
   p = phi[t];

if p11 == 1;

   yst = y - p*yl;
   xst = x - p*xl;
   onest = ones(ntime,1) - p*ones(ntime,1);

else;

   yst = y - ylmatr1*(p|phiv[i,2:p11]');
   xst = x - xlmatr1*(p|phiv[i,2:p11]');
   onest = ones(ntime,1)
            - (ones(ntime,p11))~(zeros(ntime,p11-1))*(p|phiv[i,2:p11]');

endif;

c1 = (yst'yst)*(f'f) - (yst'f)^2;

c2[1,1] = (onest'onest)*f'f   - (onest'f)^2;
c2[2,2] = (xst'xst)*f'f - (xst'f)^2;

c2[1,2] = (onest'xst)*f'f - (onest'f)*(xst'f);
c2[2,1] = c2[1,2];

ic2 = invpd(c2);

c3[1] = (yst'onest)*f'f  - (yst'f)*(onest'f);
c3[2] = (yst'xst)*f'f - (yst'f)*(xst'f);

c4 = c1 - c3'ic2*c3;

   condp[t] = c4^(-(ntime-2)/2);

t = t + 1;
endo;

   etaa = sumc(conda)*wida;
   condaa = conda./etaa;
   cona = cona + condaa;

   etap = sumc(condp)*widthp;
   condpp = condp./etap;
   conp = conp + condpp;


endif;

endif;

i = i + 1;

endo;

/*
** Gibbs values
*/


fphv[k,.] = phiv[it,.];
fav[k,.] = av[it,.];
fvarhpv[k] = varhp[it];

if k/10==integ;
    print " k= " k;
    integ = integ + 1;
endif;

k = k + 1;
endo;

/*
** Choice of "burnout" period
*/


phv = fphv[bur:repl,.];
aav = fav[bur:repl,.];

repl = repl - bur + 1;


densa = (1/repl)*cona;
densa1 = (1/repl)*conal;
densb1 = (1/repl)*conb;
densp1 = (1/repl)*conp;


/**
**  Compute marginals for a and phi (of dimension one)
**  using numerical intergration to check against Gibbs estimates.
**/

phi = seqa(lphi1,widthp,numphi);
joint = zeros(nplota,numphi);

l = 1;
do while l <= nplota;
   f = x - xl - aval[l];
   m = 1;
   do while m <= numphi;

   yst = y - phi[m]*yl;
   xst = x - phi[m]*xl;
   onest = ones(ntime,1) - phi[m]*ones(ntime,1);

c1 = (yst'yst)*(f'f) - (yst'f)^2;

c2[1,1] = (onest'onest)*f'f   - (onest'f)^2;
c2[2,2] = (xst'xst)*f'f - (xst'f)^2;

c2[1,2] = (onest'xst)*f'f - (onest'f)*(xst'f);
c2[2,1] = c2[1,2];

ic2 = invpd(c2);

c3[1] = (yst'onest)*f'f  - (yst'f)*(onest'f);
c3[2] = (yst'xst)*f'f - (yst'f)*(xst'f);

c4 = c1 - c3'ic2*c3;

 joint[l,m] = c4^(-(ntime-2)/2);

m = m + 1;

endo;

l = l + 1;

endo;

etaalpha = sumc(joint)*wida;
etaphi = sumc(joint')*widthp;
etafull = sumc(etaalpha)*widthp;

margp = etaalpha./etafull;
marga = etaphi./etafull;


et = hsec - ts;

/*xy(alpha,densa1);
xy(bv,densb1);
xy(aval,densa~marga);
xy(phi,densp1~margp);*/


gmodea1 = alpha[maxindc(densa1)];
gmodeb1 = bv[maxindc(densb1)];
gmodea = aval[maxindc(densa)];
gmodep1 = phi[maxindc(densp1)];

print " ";
print " Gibbs mode for alpha   " gmodea1;
print " Gibbs mode for b1      " gmodeb1;
print " Gibbs mode for G drift " gmodea;
print " Gibbs mode for rho1    " gmodep1;
print " ";

i = 1;
do while i <= numphi;
    phi[i] = (lphi1) + (i-1)*widthp;
    if phi[i] < 1;
       densps[i] = densp1[i];
    endif;
    i = i + 1;
endo;

gsprob = sumc(densps)*widthp;

pmean2 = counter/mycount;

print " Final no. of replications after burnout               " repl;
print " ";
print " Average proportion of accepted Metropolis draws (rho) " pmean2;



print " ";
print " Probability of stationarity  (Gibbs) =                " gsprob;
print " ";

print " Time (in minutes) for MCMC computations =             " et/6000;
print " ";

output off;

