#include <oxstd.h>
#include <oxfloat.h>
#import <maximize>

class MLFA
{
	decl m_mY, m_iP, m_iQ;

	MLFA(const mY, const iP, const iQ);
	guess(const cN, const iP, const iQ);
	DFM(const vTheta, const cN, const iP, const iQ,
		const avBeta, const avPhi_f, const amPhi_u, const amSig_11, const amSig_22);
	SSR(const cN, const cN_1, const iP, const iQ,
		const vBeta, const vPhi_f, const mPhi_u, const dSig_11, const mSig_22,
		const amF, const amG, const amH_1, const amH_2, const amSig_vv);
	KF(const mY, const mF, const mG, const mH_1, const mH_2, const mSig_vv,
		const avLnl, const avIndex_u);
	loglikelihood(const vTheta, const adLnL, const avScore, const amHess);
	estimate(const mY, const iP, const iQ);
	index_u(const mY, const iP, const iQ, const vTheta);
	smoothing(const mY, const mF, const mG, const mH_1, const mH_2, const mSig_vv);
	index_s(const mY, const iP, const iQ, const vTheta);
}

MLFA::MLFA(const mY, const iP, const iQ)
{
	m_mY = mY;
	m_iP = iP;
	m_iQ = iQ;
}

MLFA::guess(const cN, const iP, const iQ)
{
	decl vbeta = ones(cN - 1, 1);
	decl vtheta = vbeta;
	if (iP > 0)
	{
		decl vphi_f = vec(zeros(1, iP));
		vtheta = vtheta | vphi_f;
	}
	if (iQ > 0)
	{
		decl vphi_u = vec(zeros(cN, iQ));
		vtheta = vtheta | vphi_u;
	}
	decl dsig_11 = .5;
	decl vsig_22 = .5 * ones(cN, 1);
	vtheta = vtheta | dsig_11 | vsig_22;

	return vtheta;
}

MLFA::DFM(const vTheta, const cN, const iP, const iQ,
	const avBeta, const avPhi_f, const amPhi_u, const amSig_11, const amSig_22)
{
	decl cbeta = cN - 1;
	decl cphi_f = iP;
	decl cphi_u = cN * iQ;
	decl cphi = cphi_f + cphi_u;
	decl ctheta = rows(vTheta);

	avBeta[0] = 1 | vTheta[0: cbeta - 1];
	avPhi_f[0] = 0;
	if (iP > 0)
	{
		avPhi_f[0] = vTheta[cbeta: cbeta + cphi_f - 1]';
	}
	amPhi_u[0] = 0;
	if (iQ > 0)
	{
		amPhi_u[0] = diag(vTheta[cbeta + cphi_f: cbeta + cphi_f + cN - 1]);
		if (iQ > 1)
		{
			decl i;
			for (i = 2; i <= iQ; ++i)
			{
				amPhi_u[0] = amPhi_u[0]
					~ diag(vTheta[cbeta + cphi_f + (i - 1) * cN: cbeta + cphi_f + i * cN - 1]);
			}
		}
	}
	amSig_11[0] = fabs(diag(vTheta[cbeta + cphi]));
	amSig_22[0] = fabs(diag(vTheta[cbeta + cphi + 1: ctheta - 1]));
}

MLFA::SSR(const cN, const cN_1, const iP, const iQ,
	const vBeta, const vPhi_f, const mPhi_u, const dSig_11, const mSig_22,
	const amF, const amG, const amH_1, const amH_2, const amSig_vv)
{
	decl cn_2 = cN - cN_1;
	decl cbeta = cN;
	decl cbeta_1 = cN_1;
	decl csta = 5 + 5 * cN;

	decl mf = zeros(csta, csta);
	mf[1: 4][0: 3] = unit(4);
	mf[5 + cN: 5 + 5 * cN - 1][5: 5 + 4 * cN - 1] = unit(4 * cN);
	if (iP > 0)
	{
		mf[0][0: iP - 1] = vPhi_f;
	}
	if (iQ > 0)
	{
		mf[5: 5 + cN - 1][5: 5 + iQ * cN - 1] = mPhi_u;
	}
	amF[0] = mf;

	decl mg = zeros(csta, 1 + cN);
	mg[0][0] = 1;
	mg[5: 5 + cN - 1][1: 1 + cN - 1] = unit(cN);
	amG[0] = mg;

	amH_1[0] = 0;
	if (cN_1 > 0)
	{
		decl vbeta1 = vBeta[0: cbeta_1 - 1];
		decl mh_1 = zeros(cN_1, csta);
		mh_1[][0] = (1 / 3) * vbeta1;
		mh_1[][1] = (2 / 3) * vbeta1;
		mh_1[][2] = vbeta1;
		mh_1[][3] = (2 / 3) * vbeta1;
		mh_1[][4] = (1 / 3) * vbeta1;
		mh_1[][5: 5 + cN_1 - 1] = (1 / 3) * unit(cN_1);
		mh_1[][5 + cN: 5 + cN + cN_1 - 1] = (2 / 3) * unit(cN_1);
		mh_1[][5 + 2 * cN: 5 + 2 * cN + cN_1 - 1] = unit(cN_1);
		mh_1[][5 + 3 * cN: 5 + 3 * cN + cN_1 - 1] = (2 / 3) * unit(cN_1);
		mh_1[][5 + 4 * cN: 5 + 4 * cN + cN_1 - 1] = (1 / 3) * unit(cN_1);
		amH_1[0] = mh_1;
	}

	decl vbeta2 = vBeta[cbeta_1: cbeta - 1];
	decl mh_2 = zeros(cn_2, csta);
	mh_2[][0] = vbeta2;
	mh_2[][5 + cN - cn_2: 5 + cN - 1] = unit(cn_2);
	amH_2[0] = mh_2;

	decl msig_vv = unit(1 + cN);
	msig_vv[0][0] = dSig_11;
	msig_vv[1: 1 + cN - 1][1: 1 + cN - 1] = mSig_22;
	amSig_vv[0] = msig_vv;
}

MLFA::KF(const mY, const mF, const mG, const mH_1, const mH_2, const mSig_vv,
	const avLnl, const avIndex_u)
{
	decl cn = rows(mY);
	decl cn_1 = rows(selectr(mY));
	decl cobs = columns(mY);
	decl csta = 5 + 5 * cn;

	decl vlnl = zeros(cobs, 1);
	decl vindex_u = zeros(cobs, 1);
	decl vs_u = zeros(csta, 1);
//	decl mp_u = shape(invert(unit(csta ^ 2) - mF ** mF) * vec(mG * mSig_vv * mG'), csta, csta);
	decl mp_u = zeros(csta, csta);  // approximate ML estimator
	decl t;
	for (t = 0; t < cobs; ++t)
	{
		// Prediction

		decl vs_p = mF * vs_u;
		decl mp_p = mF * mp_u * mF' + mG * mSig_vv * mG';

		// Log-likelihood
		
		decl vy = mY[][t];
		decl mh = mH_2;
		decl msig_ww = zeros(cn, cn);
		if (cn_1 > 0)
		{
			mh = mH_1 | mH_2;
			if (isnan(vy))
			{
				vy[0: cn_1 - 1] = zeros(cn_1, 1);
				mh = zeros(mH_1) | mH_2;
				msig_ww[0: cn_1 - 1][0: cn_1 - 1] = unit(cn_1);
			}
		}
		decl ve = vy - mh * vs_p;
		decl msig_ee = mh * mp_p * mh' + msig_ww;
		vlnl[t] = - (cn / 2) * log(2 * M_PI)
			- (1 / 2) * log(determinant(msig_ee))
			- (1 / 2) * ve' * invertsym(msig_ee) * ve;

		// Updating

		decl mgain = mp_p * mh' * invertsym(mh * mp_p * mh' + msig_ww);
		vs_u = vs_p + mgain * (vy - mh * vs_p);
		mp_u = mp_p - mgain * mh * mp_p;
		vindex_u[t] = vs_u[0];
	}
	avLnl[0] = vlnl;
	avIndex_u[0] = vindex_u;
}

MLFA::loglikelihood(const vTheta, const adLnL, const avScore, const amHess)
{
	decl my = m_mY;
	decl cn = rows(my);
	decl cn_1 = rows(selectr(my));
	decl ip = m_iP;
	decl iq = m_iQ;

	decl vbeta, vphi_f, mphi_u, dsig_11, msig_22;
	DFM(vTheta, cn, ip, iq,
		&vbeta, &vphi_f, &mphi_u, &dsig_11, &msig_22);

	decl mf, mg, mh_1, mh_2, msig_vv;
	SSR(cn, cn_1, ip, iq, vbeta, vphi_f, mphi_u, dsig_11, msig_22,
		&mf, &mg, &mh_1, &mh_2, &msig_vv);

	decl vlnl, vindex_u;
	KF(my, mf, mg, mh_1, mh_2, msig_vv,
		&vlnl, &vindex_u);
	adLnL[0] = meanc(vlnl);

	return 1;
}

MLFA::estimate(const mY, const iP, const iQ)
{
	decl cn = rows(mY);
	decl cobs = columns(mY);

	decl vtheta = guess(cn, iP, iQ);
	decl dfunc;
	MaxControl(-1, 1);
	MaxBFGS(loglikelihood, &vtheta, &dfunc, 0, 1);
//	decl mHess;
//	Num2Derivative(loglikelihood, vtheta, &mHess);
//	print(sqrt(diagonal(invertsym(-cobs * mHess)))');

	decl dlnL = cobs * dfunc;
	decl cpar = cn + iP + cn * iQ + cn;
	decl dAIC = (dlnL - cpar) / cobs;
	decl dBIC = (dlnL - cpar * log(cobs) / 2) / cobs;
	print(iP, iQ, dlnL, dAIC, dBIC);

	return vtheta;
}

MLFA::index_u(const mY, const iP, const iQ, const vTheta)
{
	decl cn = rows(mY);
	decl cn_1 = rows(selectr(mY));

	decl vbeta, vphi_f, mphi_u, dsig_11, msig_22;
	DFM(vTheta, cn, iP, iQ,
		&vbeta, &vphi_f, &mphi_u, &dsig_11, &msig_22);

	decl mf, mg, mh_1, mh_2, msig_vv;
	SSR(cn, cn_1, iP, iQ, vbeta, vphi_f, mphi_u, dsig_11, msig_22,
		&mf, &mg, &mh_1, &mh_2, &msig_vv);

	decl vlnl, vindex_u;
	KF(mY, mf, mg, mh_1, mh_2, msig_vv,
		&vlnl, &vindex_u);

	return vindex_u;
}

MLFA::smoothing(const mY, const mF, const mG, const mH_1, const mH_2, const mSig_vv)
{
	decl cn = rows(mY);
	decl cn_1 = rows(selectr(mY));
	decl cobs = columns(mY);
	decl csta = 5 + 5 * cn;

	decl vs_u = zeros(csta, 1);
	decl mp_u = zeros(csta, csta);
	decl ms_p = zeros(csta, cobs);
	decl mvechP_p = zeros(csta * (csta + 1) / 2, cobs);
	decl t;
	for (t = 0; t < cobs; ++t)
	{
		// Prediction

		decl vs_p = mF * vs_u;
		decl mp_p = mF * mp_u * mF' + mG * mSig_vv * mG';
		ms_p[][t] = vs_p;
		mvechP_p[][t] = vech(mp_p);

		// Updating

		decl vy = mY[][t];
		decl mh = mH_2;
		decl msig_ww = zeros(cn, cn);
		if (cn_1 > 0)
		{
			mh = mH_1 | mH_2;
			if (isnan(vy))
			{
				vy[0: cn_1 - 1] = zeros(cn_1, 1);
				mh = zeros(mH_1) | mH_2;
				msig_ww[0: cn_1 - 1][0: cn_1 - 1] = unit(cn_1);
			}
		}
		decl mgain = mp_p * mh' * invertsym(mh * mp_p * mh' + msig_ww);
		vs_u = vs_p + mgain * (vy - mh * vs_p);
		mp_u = mp_p - mgain * mh * mp_p;
	}

	// Smoothing

	decl ms_s = zeros(csta, cobs);
	decl vr = zeros(csta, 1);
	for (t = cobs - 1; t >= 0; --t)
	{
		decl vs_p = ms_p[][t];
		decl mp_p = unvech(mvechP_p[][t]);

		decl vy = mY[][t];
		decl mh = mH_2;
		decl msig_ww = zeros(cn, cn);
		if (cn_1 > 0)
		{
			mh = mH_1 | mH_2;
			if (isnan(vy))
			{
				vy[0: cn_1 - 1] = zeros(cn_1, 1);
				mh = zeros(mH_1) | mH_2;
				msig_ww[0: cn_1 - 1][0: cn_1 - 1] = unit(cn_1);
			}
		}
		decl mgain = mp_p * mh' * invertsym(mh * mp_p * mh' + msig_ww);
		vr = mh' * invertsym(mh * mp_p * mh' + msig_ww) * (vy - mh * vs_p)
			+ (unit(csta) - mh' * mgain') * mF' * vr;
		ms_s[][t] = vs_p + mp_p * vr;
	}

	return ms_s;
}

MLFA::index_s(const mY, const iP, const iQ, const vTheta)
{
	decl cn = rows(mY);
	decl cn_1 = rows(selectr(mY));

	decl vbeta, vphi_f, mphi_u, dsig_11, msig_22;
	DFM(vTheta, cn, iP, iQ,
		&vbeta, &vphi_f, &mphi_u, &dsig_11, &msig_22);

	decl mf, mg, mh_1, mh_2, msig_vv;
	SSR(cn, cn_1, iP, iQ, vbeta, vphi_f, mphi_u, dsig_11, msig_22,
		&mf, &mg, &mh_1, &mh_2, &msig_vv);

	decl ms_s = smoothing(mY, mf, mg, mh_1, mh_2, msig_vv);

	return ms_s[0][]';
}

main()
{
	decl time = timer();

	decl mY = loadmat("myprg_ox/00b/BCIQ1M4.mat")';
	decl iP = 1;
	decl iQ = 2;

	decl mlfaobj = new MLFA(mY, iP, iQ);
	decl vtheta = mlfaobj.estimate(mY, iP, iQ);
	decl vindex_u = mlfaobj.index_u(mY, iP, iQ, vtheta);
	decl vindex_s = mlfaobj.index_s(mY, iP, iQ, vtheta);
	savemat("c:/Program Files/Ox/myprg_ox/00b/temp.xls", vindex_u ~ vindex_s);
	delete mlfaobj;

	print(timespan(time, timer()));
}
