PROC GRUB(a,b);
/*
*****  Draw from Gamma distribution with a degrees of freedom and
*****  scale parameter b.
*/
LOCAL am1,sa;
LOCAL reject,exi,d,u,p,x,x1,x2,y,e;
reject   = 1;
IF (a<1);
    IF (b/=2);                              @ Use GRUB algorithm             @
        exi      = EXP(1);
        d        = (a + exi)/exi;
        DO WHILE (reject);
            u        = RNDU(1,1);           @ Draw uniform U                 @
            e        = RNDN(1,1);
            p        = d*u;
            IF (p<=1);
                x        = p^(1/a);
            ELSE;
                x        = -LN((d - p)/a);
                x        = (1 - a)*LN(x);
            ENDIF;
            reject   = (x>e);               @ Accept draw if X<=E            @
        ENDO;
    ELSE;                                   @ CHI2(2) distribution           @
        x        = SUMC(RNDN(2,1)^2)/2;
    ENDIF;
ELSEIF (a>1);
    @   a>1,  Ahrens algorithm from numerical recipes, page 206              @
    am1      = a - 1;
    sa       = SQRT(2*a - 1);
    DO WHILE (reject);
        draw:
        x1       = 2*RNDU(1,1) - 1;
        x2       = 2*RNDU(1,1) - 1;
        IF (x1*x1 + x2*x2 > 1);
            GOTO draw;
        ELSE;
            y        = x2/x1;
            x        = sa*y + am1;
            IF (x<=0);                   @ Negative values are rejected      @
                GOTO draw;
            ELSE;                        @ Reject on basis uniform density @
                e        = (1 + y*y)*EXP(am1*LN(x/am1) - sa*y);
                p        = RNDU(1,1);
                reject   = (p>e);
            ENDIF;
        ENDIF;
    ENDO;
ELSEIF (a==1);
    @ Exponential distribution @
    u        = RNDU(1,1);
    x        = -LN(1 - u);
ENDIF;
RETP(b*x);
ENDP;

