PROC GIBBSMIX(mu,sigma,y,mixodds);
/*
****    Procedure GIBBSMIX draws from the conditional distribution of
****    the latent variable Z in the mixture model
****
****         y(t) = X(z(t))    for   z(t) = 1,...,k
****
****    where X(i) is distributed normally with mean MU(i) and variance
****    SIGMA(i)^2. The input vector MIXODDS gives the prior odds that
****    Z=1 in favor of Z=i (i>1).
****
****   INPUTS:
****        mu       :  k-vector of means
****      sigma      :  k-vector of standard deviations
****        y        :  t-vector of data points
****      mixodds    :  (k-1) row vector of odds in favor of first element
****   
*/
LOCAL mu1,mu2,s1,s2,sratio,odds,p1,p,t,u,j,jcat,cumprob,z,lowprob;
s1       = sigma[1];
s2       = TRIMR(sigma,1,0)';                       @ Transpose to row vector @
sratio   = s2/s1;                                       @ Ratios of std dev's @
mu1      = mu[1];
mu2      = TRIMR(mu,1,0)';                          @ Transpose to row vector @
odds     = (mixodds.*sratio) .* PDFN( (y - mu1)/s1 ) ./ PDFN( (y - mu2)./s2 );
p1       = 1./(1 + SUMC(1./odds'));
p        = p1./odds;
@cumprob  = CUMSUMC((p1~p)')';@

t        = ROWS(y);
u        = RNDU(t,1);
j        = 0;
jcat     = ROWS(sigma);
DO WHILE j<jcat;
    j        = j + 1;
    IF j==1;
        lowprob = p1;
        z       = (u.<p1);
    ELSE;
        cumprob = lowprob + p[.,j-1];
        z       = z + j*(u.>=lowprob).*(u.<cumprob);
        lowprob = cumprob;
    ENDIF;
ENDO;
RETP(z);
ENDP;
