PROC (3) = GIBBSLIN(y,x,sigma2,b0,v0i);
/*
****      Procedure GIBBSLIN generates a draw from the conditional posterior
****      of the regression parameters of a linear model.
****  INPUTS:
****      y    :  dependent variable data
****      x    :  explanatory variable data
****    sigma2 :  variance of error term
****     b0    :  prior mean
****    v0i    :  prior precision (inverse of covariance matrix)
****
****  OUTPUT:
****     beta  :  draw from conditional posterior
****   betahat :  mean of conditional posterior
****  vbetahat :  Choleski factor of conditional covariance matrix
*/
LOCAL xx,xy,xxi,betahat,vbetahat,beta;
xx       = x'x/sigma2 + v0i;
xy       = x'y/sigma2 + v0i*b0;
xxi      = INVPD(xx);
betahat  = xxi*xy;
vbetahat = CHOL(xxi);
beta     = betahat + vbetahat'RNDN(ROWS(betahat),1);
RETP(beta,betahat,vbetahat);
ENDP;
