/*------------------------------------------*/
/* JAE - Data Archive - MS 9266 forthcoming */
/* James G. MacKinnon & Matthew D. Webb     */
/* Wild Bootstrap Inference for Wildy       */
/*    Different Cluster Sizes               */  
/*------------------------------------------*/

/*-----------------------------------------*/
/* This file replicates parts of Table 3.  */
/* Specifically, the aggregates estimates  */
/* in panel B.                             */
/*-----------------------------------------*/

/*-----------------------------------------*/
/*The data is an aggregate version of data */
/* from  table 6 - col 9                   */
/* in Angrist and Kugler (2008) ReStat.    */
/*-----------------------------------------*/

/*set path here if necessary*/
//	global SOURCE "./"
	global SOURCE "C:\wildly\"

	cd ${SOURCE}
	
	capture log close
	log using "${SOURCE}ak_col9_agg.txt", text replace


/*set bootstraps here*/
	global BS = 999
	
clear

/*open the dataset*/
	use "${SOURCE}AK_col9_agg.dta"
	
	gen ones = 1

set more off

/*erase (if necessary) variables used for the bootstrap */
	cap drop er_*
	cap drop ywild_*
	cap drop xbr_*
	cap drop ernew_*
	cap drop uni 
	cap drop pos
	cap drop Ts_*



/*matrix to store output*/
	matrix output = J(5,6,.)

/*run the regression */
	*global XVAR "ones dage* dsingle nhouse immig d1993 d1994 d1995 d1996 d1997 d1998 d1999 d2000 datlan dbolivar dsucre dcordoba dsant dboyaca  dcaldas drisaral dquindio dtolima dhuila  dantio  dcauca dnarino dvalle drural ru9597 ru9800 rugndmz tgndmz1"  
	*global VARS "rund9597 rund9800 urnd9597 urnd9800"

	*reg lmhours  ${XVAR} ${VARS},  nocons cluster(hetsedep)
	
	global XVAR " mage nhouse msingle immig d1993 d1994 d1995 d1996 d1997 d1998 d1999 d2000 dguajira dcesar datlan dbolivar dsucre dcordoba dnsant dsant dboyaca dcaldas drisaral dquindio dtolima dhuila dantio dcauca dnarino dvalle drural ru9597 ru9800 rugndmz tgndmz1"  
	global VARS "rund9597 rund9800 urnd9597 urnd9800"

	reg lmmhours ${XVAR} ${VARS} [pweight=chfactor],  cluster(hetsedep)

	
	/*save the f-tests*/
		test urnd9597=urnd9800=0 
		global mainf_urban = r(F)
		global t_5 = ${mainf_urban}
		
		test rund9597=rund9800=0 
		global mainf_rural = r(F)
		global t_6 = ${mainf_rural}
		
			



/*save the main coefficients*/
	local i = 0
	foreach v in $VARS {
		local i = `i' + 1
		local beta = _b[`v']
		disp "beta " `beta'
		local se = _se[`v']
		disp "se " `se'
		disp " i " `i'
		global t_`i' = `beta'/`se'
		
		local p_value = 2*min(ttail(31, ${t_`i'} ), 1 -  ttail(31,${t_`i'}))
		matrix output[1,`i'] = `beta'
		matrix output[2,`i'] = `se'
		matrix output[3,`i'] = ${t_`i'}
		matrix output[4,`i'] = `p_value'
	}


/*impose the null hypotheses - individual coefficients */

	qui reg lmmhours ${XVAR}  rund9800 urnd9597 urnd9800 [pweight=chfactor],   cluster(hetsedep)
	qui predict er_1, resid
	qui predict xbr_1, xb 

	qui reg lmmhours ${XVAR}  rund9597 urnd9597 urnd9800 [pweight=chfactor],   cluster(hetsedep)
	qui predict er_2, resid
	qui predict xbr_2, xb 
	
	qui reg lmmhours ${XVAR}  rund9597 rund9800 urnd9800 [pweight=chfactor],   cluster(hetsedep)
	qui predict er_3, resid
	qui predict xbr_3, xb 

	qui reg lmmhours ${XVAR}  rund9597 rund9800 urnd9597 [pweight=chfactor] ,   cluster(hetsedep)
	qui predict er_4, resid
	qui predict xbr_4, xb 
	
/*impose the null hypotheses - f-tests  */

	qui reg lmmhours ${XVAR}  rund9597 rund9800  [pweight=chfactor],   cluster(hetsedep)
	qui predict er_5, resid
	qui predict xbr_5, xb 

	qui reg lmmhours ${XVAR}   urnd9597 urnd9800  [pweight=chfactor],   cluster(hetsedep)
	qui predict er_6, resid
	qui predict xbr_6, xb 
	
/*bootstrap setup*/
	qui gen uni = . 
	qui gen ernew_1 = . 
	qui gen ernew_2 = .
	qui gen ernew_3 = . 
	qui gen ernew_4 = . 
	qui gen ernew_5 = . 
	qui gen ernew_6 = . 
	qui gen pos = . 
	qui gen ywild_1 = .
	qui gen ywild_2 = .
	qui gen ywild_3 = .
	qui gen ywild_4 = .
	qui gen ywild_5 = .
	qui gen ywild_6 = .

/* store bootstrap statistics */
	mata: bs_ts = J(${BS},6,.)
	
	forvalues b = 1/$BS {
		disp "b =  " `b'
			
		sort hetsedep
		qui by hetsedep: replace uni = uniform() 
			/*cluster level rademacher indicator*/
			qui by hetsedep: replace pos = uni[1]<.5  
	
		local i = 0
		
		/*loop over the four coefficients*/
		foreach v in $VARS {
			
			local i = `i' + 1
		
			/*transform residuals */
				qui replace ernew_`i' = (2*pos-1)*er_`i'
			
			/*generate the bootstrap sample*/
				qui replace ywild_`i' = xbr_`i' + ernew_`i' 
			
			/*run the regressions, and store the t-stats*/
			
			qui reg ywild_`i' ${XVAR} ${VARS} [pweight=chfactor],   cluster(hetsedep)
			
			local t_stat = (_b[`v'])/(_se[`v'])
			mata: bs_ts[`b',`i']= `t_stat'
			
		}/*end of vars loop*/ 
		
		/*loop over the f-tests*/
		forvalues i =5/6{
			
			/*transform residuals */
				qui replace ernew_`i' = (2*pos-1)*er_`i'
			
			/*generate the bootstrap sample*/
				qui replace ywild_`i' = xbr_`i' + ernew_`i' 
			
			/*run the regressions, and store the t-stats*/
				qui reg ywild_`i' ${XVAR} ${VARS} [pweight=chfactor],   cluster(hetsedep)
				
				if (`i'==5) {
					qui test urnd9597=urnd9800=0 
					local t_stat = r(F)
					}
				else {
					qui test rund9597=rund9800=0 
					local t_stat = r(F)
					}
				mata: bs_ts[`b',`i']= `t_stat'
				
		
		}/*end of i loop */
		
	} /*end of bootstrap loop */
	
	/*calculate the bootstrap p-values */
	
		cap drop ncount
		qui gen ncount =. 
	
		getmata (Ts_*)=bs_ts, force 
		
		forvalues i = 1/4 {
			sort Ts_`i' 
	
			qui replace ncount = _n 
			qui cap drop test
			qui gen test = (${t_`i'}>=Ts_`i')	
			qui summ ncount  if test ==1
			local myp = r(max) / ${BS}
			global bs_pval = 2 * min(`myp',(1-`myp')) 
		
			matrix output[5,`i'] = $bs_pval
			
		} /*end of i loop */
		
			
		forvalues i = 5/6{
		
			sort Ts_`i' 
			
			qui replace ncount = _n 
			qui cap drop test
			qui gen test = (${t_`i'}>=Ts_`i')	
			qui summ ncount  if test ==1
						
			/*ensures pval != . */
			global bs_pval = 1 - max(r(max) / ${BS}, 1/${BS})
			
			matrix output[5,`i'] = $bs_pval

		
		} /*end of i loop */

	/*store the f-stats in matrix*/	
		matrix output[3,5] = ${t_5}
		matrix output[3,6] = ${t_6}
		
	/*list the output matrix*/
		matrix list output
	
