%path = @runpath
cd %path


wfopen bbedata.csv ftype=ascii rectype=crlf skip=0 fieldtype=delimited delim=comma colhead=1 eoltype=pad badfield=NA @freq M 1959M01 @smpl @all

'Real output and income

series ipp =dlog(IPFPNSS)
series ipf = dlog(ipfinal)
series ipc = dlog(ipcongd)
series ipcd =dlog(ipdcongd)
series ipcn = dlog(ipncongd)
series ipe = dlog(ipbuseq)
'series ipi 
series ipm =dlog(ipmat)
series ipmd =dlog(ipdmat)
series ipmnd = dlog(ipnmat)
series ipmfg = dlog(ipmansics)
'series ipd =dlog(ipdman)
'series ipn =dlog(ipnman)
series ipmin = dlog(ipmine)
series iput = dlog(ipb51222s)
series ip = dlog(indpro)
series ipxmca = cumfns
series pmi = napm
series pmp=napmpi
series gmpyq = dlog(rpi)
series gmyxpq = dlog(w875rx1)


'employment and hours

series lhel = dlog(hwi)
series lhelx = log(hwiuratio)
series lhem = dlog(ce16ov)
series lhnag = dlog(clf16ov)
series lhur = unrate
series lhu680 = uempmean
series lhu5 = uemplt5
series lhu14 = uemp5to14
series lhu15 = uemp15ov
series lhu26 = uemp15t26
series lpnag=dlog(payems)
ceu0500000001.x13(save="d11", tf=log)  @x11
series lp = dlog(ceu0500000001_d11)
series lpgd = dlog(usgood)
series lpmi = dlog(ces1021000001) 
series lpcc=dlog(uscons)
series lpem=dlog(manemp)
series lped = dlog(dmanemp)
series lpen=dlog(ndmanemp)
series lpsp=dlog(srvprd)
series lptu=dlog(ustpu)
series lpt=dlog(uswtrade)
series lpfr=dlog(usfire)
series lps = dlog(usserv)
series lpgov=dlog(usgovt)
series lphrm=awhman
series lpmosa=awotman
series pmemp=napmei


'consumption
series gmcq = dlog(DPCERA3M086SBEA)
series gmcdq = dlog(ddurra3m086sbea)
series gmcnq = dlog(DNDGRA3M086SBEA)
series gmcsq = dlog(DSERRA3M086SBEA) 
'series gmcanq

' Housing starts and sales
series hsfr = log(houst)
series hsne=log(houstne)
series hsmw=log(houstmw)
series hssou = log(housts)
series hswst =log(houstw)
'series hsbr
'series hmob

'real inventories and orders 

series pmnv = napmii
series pmno = napmnoi
series pmdel = napmsdi

series mocmq =dlog(a0m008)
series msondq =dlog(a0m027)

'Stock prices
'series fsncom
series fspcom = dlog(s_p_500)
series fspin =dlog(s_p__indust)
'series fspcap
'series fsput
series fsdxp = s_p_div_yield
series fspxe = s_p_pe_ratio 


'Exchange rates

series exrsw=dlog(EXSZUSx)
series exrjan=dlog(EXJPUSx)
series exruk=dlog(EXUSUKx)
series exrcan=dlog(EXCAUSx)

'Interest rates

series fyff=FEDFUNDS
series fygm3=TB3MS
series fygm6=TB6MS
series fygt1=gs1
series fygt5=gs5
series fygt10=gs10  
series fyaaac=aaa
series fybaac=baa

series sfygm3=TB3SMFFM
series sfygm6=TB6SMFFM
series sfygt1=T1YFFM
series sfygt5=T5YFFM
series sfygt10=T10YFFM 
series sfyaaac=AAAFFM
series sfybaac=BAAFFM

'Money and credit

series fm1=dlog(m1sl)
series fm2=dlog(m2sl)
series fm3=dlog(m3sl)
series fm2dq=dlog(m2real)
series fmfba=dlog(ambsl)
series fmrra=dlog(TOTRESNS)
smpl 1959m1 2001:12
series fmrnba=dlog(NONBORRES)
smpl @all
series fclnq=dlog(busloans)
'series fclbmc
series ccinrv=dlog(nonrevsl)

'Price indixes

series pmcp=napmpri
series pwfsa=dlog(WPSFD49207)
series pwfcsa=dlog(WPSFD49502)
series pwimsa=dlog(WPSID61)
series pwcmsa=dlog(WPSID62)
series psm99q=dlog(a0m099)			'SW
series punew=dlog(CPIAUCSL)
series pu83=dlog(CPIAPPSL)
series pu84=dlog(CPITRNSL)
series pu85=dlog(CPIMEDSL)
series puc=dlog(CUSR0000SAC)
series pucd=dlog(CUSR0000SAD)
series pus=dlog(CUSR0000SAS)
series puxf=dlog(CPIULFSL)
series puxhs=dlog(CUSR0000SA0L2)
series puxm=dlog(CUSR0000SA0L5)

'Average hourly earnings
series lehcc = dlog(CES2000000008)
series lehm=dlog(CES3000000008)


' Miscellaneuos
series hhsntn = u0m093 

'standardize all variables for principal component analsyis

text vlabel
vlabel.append(file) vname1.txt
vlabel.svector slabel

for !j=1 to 110
	%temp = slabel(!j)
	%temp_ = %temp+"_"+@str(!j)
	series {%temp_}
	series {%temp_}= ({%temp} - @mean({%temp}))/@stdevp({%temp})
next

group xdata
for !i=1 to 110
	%temp_ = slabel(!i)+"_"+@str(!i)
	xdata.add {%temp_}
next
xdata.drop ip_13
xdata.drop fyff_68
xdata.drop punew_98

group xslow 
for !i=1 to 49
	%temp_ = slabel(!i)+"_"+@str(!i)
	xslow.add {%temp_}
next
xslow.drop ip_13
for !i=93 to 109
	%temp_ = slabel(!i)+"_"+@str(!i)
	xslow.add {%temp_}
next
xslow.drop punew_98

group xir 
xir.add fygm3_69 fygt5_72 fmfba_87 fm2_84 exrjan_65 pmcp_92 ipxmca_14 gmcq_46 gmcdq_47 gmcnq_48 lhur_23 pmemp_45 lehcc_108 hsfr_50 pmno_56 fsdxp_62 hhsntn_110

vector tcode =@fill(5, 5, 1, 1, 1, 5, 5, 5, 1, 1, 5, 5, 5, 1, 1, 5, 4, 1, 1, 1)

text yx_name 
yx_name.append(file) yxirlabel0.txt


smpl 1959m02 2001m08 

'favar(y=ip cpi ffr, k=1)
favar(factor=1,horizon=48,rep=1000,ci=0.9, save=1) 13 xdata xslow xir tcode yx_name @ ip_13 punew_98 fyff_68
close figure
matrix irfxmat2_ = @subextract(irfxmat2, 1,1, 48, 3)


'baseline favar(y=ffr, k=3)

group xdata1
for !i=1 to 110
	%temp_ = slabel(!i)+"_"+@str(!i)
	xdata1.add {%temp_}
next
xdata1.drop fyff_68

group xslow1 
for !i=1 to 49
	%temp_ = slabel(!i)+"_"+@str(!i)
	xslow1.add {%temp_}
next
for !i=93 to 109
	%temp_ = slabel(!i)+"_"+@str(!i)
	xslow1.add {%temp_}
next

group xir1 
xir1.add ip_13 punew_98 fygm3_69 fygt5_72 fmfba_87 fm2_84 exrjan_65 pmcp_92 ipxmca_14 gmcq_46 gmcdq_47 gmcnq_48 lhur_23 pmemp_45 lehcc_108 hsfr_50 pmno_56 fsdxp_62 hhsntn_110 

text yx_name1 
yx_name1.append(file) yxirlabel.txt
vector tcode1 =@fill(1, 5, 5, 1, 1, 5, 5, 5, 1, 1, 5, 5, 5, 1, 1, 5, 4, 1, 1, 1)


'baseline favar(y=ffr, k=3)
favar(factor=3,horizon=48,rep=1000,ci=0.9, save=1) 13 xdata1 xslow1 xir1 tcode1 yx_name1 @ fyff_68
close figure01
matrix irfxmat2_b = @hcat(@subextract(irfxmat201, 1,2, 48, 3), @subextract(irfxmat201, 1,1, 48, 1)) 


'baseline var
var var01.ls 1 13 ip_13 punew_98 fyff_68
do var01.impulse(48, smat=impulse3) ip_13 punew_98 fyff_68 @ fyff_68
do var01.impulse(48, a, smat=impulse3a) ip_13 punew_98 fyff_68 @ fyff_68
colplace(impulse3a, impulse3.@col(3), 3)
impulse3a.setcollabels ip cpi ffr
freeze(fig3a) impulse3a.line(m)
'show fig3a




matrix impulse = @vcat(impulse3a, irfxmat2_)
impulse = @vcat(impulse, irfxmat2_b)

vector impulsev
matrix impulse1
for !j = 1 to 3
	impulsev = impulse.@col(!j)
	impulse1 = @unvec(impulsev, 48)
	impulse1.setcollabels var(y =ffr cpi ip, k=0) favar(y=ip cpi ffr, k=1) baseline(y=ffr, k=3)
	freeze(fig{!j}) impulse1.line	
next
fig1.addtext(t) IP
fig2.addtext(t) CPI
fig3.addtext(t) FFR
 
freeze(fig4) fig3 fig1 fig2
fig4.align(3,1,1)
show fig4


