% The program for the paper by Helmut Luetkepohl and Aleksei Netsunajev 
%"Disentangling demand and supply shocks in the crude oil market: 
% How to check sign restrictions in structural VARs". 
% Function generates some visual results of the estimation

function[] = results(Estimation, spec, T, reply)


if reply == 1
    fid = fopen('results.txt','w');
else
    fid = 1;
end

if spec.BQrestrict == 1
    add_param = T(1,2)*(T(1,2) - 1)/2;
else
    add_param = 0;
end

free_param = numel(Estimation.StErr) - add_param;

fprintf(fid,'Number of free parameters is ');
fprintf(fid,'%d ', free_param);
fprintf(fid,'\n');

fprintf(fid,'LogL = ');
fprintf(fid,'%10.6f ', Estimation.logL);
fprintf(fid,'\n');

fprintf(fid,'AIC value is: ');
fprintf(fid,'%10.6f ', -2*Estimation.logL+2*free_param );
fprintf(fid,'\n');

fprintf(1,'SC value is: ');
fprintf(1,'%10.6f ', -2*Estimation.logL + log(T(1,1)-spec.lags) * free_param  );
fprintf(1,'\n');


    fprintf(fid,'\n');
    fprintf(fid,'Estimated  transition matrix P:\n');
    for i = 1:spec.s 
        fprintf(fid, '%10.6f', Estimation.P(i,:) );
        fprintf(fid,'\n');         
    end
    fprintf(fid,'\n');   

    fprintf(fid,'\n');
    fprintf(fid,'Estimated  standard errors for transition matrix P (last row taken as given):\n');
    P_err = reshape(Estimation.StErr(numel(Estimation.StErr) - spec.s*(spec.s-1)+1 : numel(Estimation.StErr) ), spec.s, spec.s-1 )';
    for i = 1:spec.s -1
        fprintf(fid, '%10.6f', P_err(i,:) );
        fprintf(fid,'\n');         
    end
    fprintf(fid,'\n');   
    
    fprintf(fid,'Estimated matrix B of decomposition:\n');
    for i = 1:T(1,2) 
        fprintf(fid, '%10.6f', Estimation.B(i,:) );
        fprintf(fid,'\n');         
    end
    fprintf(fid,'\n'); 

    cnt1 = 1;
    cnt2 = T(1,2);
    for i=1: T(1,2)
        C(1:T(1,2),i) = Estimation.StErr( cnt1 :  cnt2 ) ;
        cnt1 = cnt1 + T(1,2);
        cnt2 = cnt2 + T(1,2);        
    end    
    fprintf(fid,'\n');
    fprintf(fid,'Estimated standard errors for B: \n');
    
    for i = 1:T(1,2) 
        fprintf(fid, '%10.6f', C(i,:) );
        fprintf(fid,'\n');         
    end
    fprintf(fid,'\n');
    
    W = eye(T(1,2),T(1,2));
    for i =1:spec.lags
        W = W - get_coefficient( Estimation.Theta, T, i);
    end
    A = (W^-1 * Estimation.B);
    
%%  

    for l=2:spec.s
        fprintf(fid,'\n');
        fprintf(fid,'Estimated Lambda ');
        fprintf(fid,'%d \n', l);
        fprintf(fid, '%10.6f\n',diag(Estimation.Lambda(1+T(1,2)*(l-1):T(1,2)*l ,:)) );
    end

    cnt1 = T(1,2)^2 + 1;
    cnt2 = T(1,2)^2 + T(1,2);
    for i=1:spec.s-1
        fprintf(fid,'\n');
        fprintf(fid,'Estimated standard errors for Lambda ');
        fprintf(fid,'%d \n', i+1);     
        fprintf(fid,'%10.6f \n', Estimation.StErr( cnt1 : cnt2));
        cnt1 = cnt1 + T(1,2);
        cnt2 = cnt2 + T(1,2);
    end
    
    for l=1:spec.s
        fprintf(fid,'\n');
        fprintf(fid,'Estimated covariance matrix ');
        fprintf(fid,'%d \n', l);
        B = get_sigma(Estimation.Sigma, T, l);
        for i = 1:T(1,2) 
            fprintf(fid, '%10.6f', B(i,:) );
            fprintf(fid,'\n');         
        end
        fprintf(fid,'Determinant ');
        fprintf(fid, '%10.4f', det(B) ) ;
        fprintf(fid,'\n'); 
        fprintf(fid,'Eigenvalues \n');
        fprintf(fid, '%10.6f', (eig(B))' ) ; 
    end
    
    fprintf(fid,'\n');
    fprintf(fid,'Estimated constant term: \n');
    fprintf(fid,'%10.6f \n', Estimation.Theta(1:T(1,2)));
    fprintf(fid,'\n');

    fprintf(fid,'Estimated standard errors for constant term: \n');
    fprintf(fid,'%10.6f \n', Estimation.StErr( numel(Estimation.StErr)-numel(Estimation.Theta) - spec.s*(spec.s-1) + 1 : numel(Estimation.StErr)-numel(Estimation.Theta) - spec.s*(spec.s-1) + T(1,2)  ));
    fprintf(fid,'\n');
    
    for i=1:spec.lags
       fprintf(fid,'Estimated coefficient matrix, lag ');
       fprintf(fid,'%d \n', i);
       C =  get_coefficient(Estimation.Theta, T, i);
       D =  get_coefficient(Estimation.StErr(numel(Estimation.StErr)-numel(Estimation.Theta) -spec.s*(spec.s-1) + 1 : numel(Estimation.StErr)-spec.s*(spec.s-1)), T, i);
       for j = 1:T(1,2) 
            fprintf(fid, '%10.6f', C(j,:) );
            fprintf(fid,'\n');         
       end
       fprintf(fid,'\n');
       
       fprintf(fid,'Estimated standard errors: \n');
       for k = 1:T(1,2) 
            fprintf(fid, '%10.6f', D(k,:) );
            fprintf(fid,'\n');         
       end
       fprintf(fid,'\n');
    end

    figure1 = figure('Name','Estimated State Probabilities');
    axes1 = axes('Parent',figure1);
    ylim(axes1,[0 1.4]);
    box(axes1,'on');
    hold(axes1,'all');    

for k=1:spec.s
    subplot(spec.s,1,k), plot(Estimation.KsiT(:,k));
    title([ 'State ', int2str(k) ] );
    ylim(gca, [0 1.4]);
    set(gca,'XTickLabel',{'1973', '2007'} )    
end