% The program for the paper by Helmut Luetkepohl and Aleksei Netsunajev 
%"Disentangling demand and supply shocks in the crude oil market: 
% How to check sign restrictions in structural VARs". 
function[] = msvar(spec, y, LM, T)

fprintf(1,'\n');
fprintf(1,'This is MS-VAR estimation using EM algorithm and non-linear optimization to get structural covariance matrix decomposion\n');
fprintf(1,'\n');
fprintf(1,'The system has ');
fprintf(1,'%d ', spec.s);
fprintf(1,'states ');
fprintf(1,'%d ', T(1,2));
fprintf(1,'variables and ');
fprintf(1,'%d ', spec.lags);
fprintf(1,'lags\n');

%%
% DEFINITION OF VARIABLES FOR THE EM ALGORITHM
% Iter is a structure that holds the estmated parameters for user-specified number of iterations:
%P              Markov matrix
%Theta          Parameter vector
%B              B matrix of covariance matrix decomposition
%Lambda         Lambda matrix of covariance matrix decomposition
%LogValue       has number of iterations, value of the log likelikhood and
                        %relative change in the likelihood compared to the previous iteration
%Sigma            covariance matrices, stacked each under another
%KsiT               smoothed probabilities with timing 0,1,2...T-1
%T                    sum of smoothed probabilities, !!! don't mix with variable T
                        %which is not a part of the Estimation structure


% Estimation is a structure that holds the estmated parameters that correspond to maximum of log-likelihood:
%P              Markov matrix
%Theta          Parameter vector
%B              B matrix of covariance matrix decomposition
%Lambda         Lambda matrix of covariance matrix decomposition
%LogValue       has number of iterations, value of the log likelikhood and
                %relative change in the likelihood compared to the previous iteration
%Sigma          covariance matrices, stacked each under another
%KsiT           smoothed probabilities with timing 0,1,2...T-1
%T              sum of smoothed probabilities, !!! don't mix with variable
                %Tm which is not a part of the Estimation structure

%%
%Calculate the matrix Z of a constant and lagged observations (dimention
%T(1,1)*(1+var*lags))

Tolvalue = 0.000000001;                              % tolerance value for EM convergence
A1 = 0;                                             % auxiliary variables, counters
A2 = 0;
for i = 1:T(1,1)-spec.lags;

    Z(i,1) = 1;                                         % constant
    for j=1:spec.lags
        Z(i,(j-1)*T(1,2)+2 : j*T(1,2)+1 )= y(spec.lags+i-j,:);  % lagged observations 
    end
   
    A1 = A1 + kron( Z(i,:)' * Z(i,:), eye(T(1,2)));         
    A2 = A2 + kron(Z(i,:)', eye(T(1,2)))*y(i+spec.lags,:)'; 
end

%%
% Estimate model for given initial parameters, number of iterations is
% prespecified, estimate() is the estimation function, results are
% stored in the structure

%Form matrix of random numbers
for iteration = 1:spec.iterations
    RandNumbers(:,1+ T(1,2)*(iteration -1) :T(1,2)*iteration) = 1/100000*randn(T(1,2),T(1,2));
end

[Estimation.Theta, Estimation.Sigma, Estimation.KsiT, Estimation.P, Estimation.logL, Estimation.B, Estimation.Lambda, ~, Estimation.Eta, Estimation.Ksi] = estimate(A1, A2, T, y, Z, spec, Tolvalue, RandNumbers(:,1+ T(1,2)*(iteration -1) :T(1,2)*iteration), LM(iteration) );
%%
%Calculate standard errors
fprintf(1,'Calculating standard errors... \n');
[Estimation.StErr, Estimation.StErr_all, Estimation.Wald] = Param_Stderr(T, Estimation, spec, y, Z);

%%
%Show some results
if spec.sr == 1
    reply=0;
    results(Estimation, spec, T, reply);             %function prints results to the screen
end
%%
% Produce impulse responces & FEVDs
if  spec.IR == 1
    if spec.BQrestrict == 0
        U_stand(T, y, Z, spec, Estimation)                              % plot standardized residuals
                                                                                        % some needed changes in the ordering
        tmp = Estimation.B(:, 3);
        Estimation.B(:, 3) = Estimation.B(:, 1);
        Estimation.B(:, 1) = tmp;
        tmp1 = Estimation.Lambda(4,1);
        tmp2 = Estimation.Lambda(7,1);
        Estimation.Lambda(4,1) = Estimation.Lambda(6,3);
        Estimation.Lambda(7,1) = Estimation.Lambda(9,3);
        Estimation.Lambda(6,3) = tmp1;
        Estimation.Lambda(9,3) = tmp2; 
    end
    
    if Estimation.B(1,1)>0
        Estimation.B(:,1) = -1 * Estimation.B(:, 1);
    end
    h=60;                                                              % response horizon
    rep = 1000;                                                      % number of bootstrap replications
    birs_LOpt(spec, Estimation.Theta, Estimation.B, Estimation.KsiT, Estimation.Lambda, T, y, Z, h, rep);

    % FEVD for each state and all the variables
    
    fprintf(1,'FEVD printing (price_oil - shock 1, price_oil - shock 2, price_oil - shock 3. NB! For restricted model States 2&3 correspond to States1&2 of unrestricted model) \n');
    
    for s = 1:spec.s
       fprintf(1,'State ');
       fprintf(1,'%d \n', s);
        VD(:, :, s) = FEVD(spec, Estimation, T, h, s);
        VD(7:9,[6 12 24 36 48 60], s)
    end
end
