% The program for the paper by Helmut Luetkepohl and Aleksei Netsunajev 
%"Disentangling demand and supply shocks in the crude oil market: 
% How to check sign restrictions in structural VARs". 
% function retrieves VAR coefficients

function[C] = get_coefficient(Theta, T, Position)

cnt1 = (Position-1)*T(1,2)^2 + T(1,2) + 1;   
cnt2 = (Position)*T(1,2)^2 + T(1,2);

C = reshape(Theta(cnt1:cnt2), T(1,2), T(1,2) );