% The program for the paper by Helmut Luetkepohl and Aleksei Netsunajev 
%"Disentangling demand and supply shocks in the crude oil market: 
% How to check sign restrictions in structural VARs". 
% This function estimates the Impulse Responses and computes various
% bootstrap Confidence Intervals. 
function [Theta_SR, Theta_LR, Bootstrap, Bootstrap_LR ] = birs_LOpt(spec, Theta, B, KsiT, Lambda, T, y, Z, h, brep)


LM =spec.IR_sv;
%  --------------- To compute IRs with actual data: -----------------------
[A, Theta_SR, J, Theta_LR] = irs(spec, Theta, B,  T, h);
U = residuals2(T, y, Z, spec, Theta);
C = Theta(1:T(1,2))' ;   

%% The bootstrap loop

Bootstrap = zeros(brep, T(1,2) ^ 2 * (h+1));
for n=1:brep
    fprintf(1,'Bootstrap iteration ');
    fprintf(1,'%d \n', n);
    % Draw residuals at random with replacement:
 
    for l=1:T(1, 2)
         Ustar(:,l) = randsample( U(:,l), T(1,1)-spec.lags, true); % Random draw with replacement
    end

    % Set initial values:
    y_star = zeros(T(1,1), T(1,2) );
    y_star(1: spec.lags, :) = y(1:spec.lags, :); % Pre-sample values
    
    
    %% Fixed design wild bootstrap series 
    
    % Rademacher distribution:
    rade = 2*round(rand(T(1,1)-spec.lags, 1))-1;
    
    %  use the Rademacher distribution,
    for t=1:(T(1,1)-spec.lags)
        Ustar(t, :) = (Ustar(t, :)' * rade(t,:) )';
    end
          
    % Generate wild bootstraped series,
    for t=spec.lags+1 : T(1,1)
        for i=T(1,2):T(1,2):T(1,2)*spec.lags
            y_star(t, :)  = y_star(t, :) + (get_coefficient(Theta, T, i/T(1,2)) * y(t-i/T(1,2), :)')' ;
        end
        y_star(t, :) = y_star(t, :) + C + Ustar(t-spec.lags, :);
    end

    % Obtain parameters based on bootstrapped series    
    Y = y_star(spec.lags+1:end, :);
    A1 = 0;
    A2 = 0;
    for i = 1:T(1,1)-spec.lags;
        Z_star(i,1) = 1;                                         % constant
        for j=1:spec.lags
            Z_star(i,(j-1)*T(1,2)+2 : j*T(1,2)+1 )= y(spec.lags + i - j , :);  % lagged observations 
        end
        A1 = A1 + kron( Z_star(i,:)' * Z_star(i,:), eye(T(1,2)));         
        A2 = A2 + kron(Z_star(i,:)', eye(T(1,2)))*y_star(i+spec.lags,:)'; 
    end
    

    RND=1;
    val(1,1)=1;
    val(1,2)=1;

    Tm = sum(KsiT ) - KsiT(1,:);

   Ahat1_vec  =  (A1)^-1 * A2 ;
   U_opt =  residuals2(T, y_star, Z_star, spec, Ahat1_vec);
   B =  (1/(T(1,1)-spec.lags)*(U_opt'*U_opt))^0.5;

    for position = 1:spec.s
        Lambda(1 + T(1,2)*(position-1) : T(1,2) * position, :) = (LM^(position-1)) *eye(T(1,2));
    end

    for position = 1:spec.s
        Sigma(1 + T(1,2)*(position-1) : T(1,2) * position, : )= B * ...
                            Lambda(1 + T(1,2)*(position-1) : T(1,2) * position, :) * B' ;
    end
    L_full(:, 1) = reshape(Lambda,  T(1,2)^2*spec.s, 1 );


    while val(RND,2) > 0.0000000001
      
      [BL, val(RND+1,1), xi] = MinimizeB(KsiT, T, Tm, Lambda, B, spec, U_opt, Ahat1_vec, 1);

        % Store B and check 
        B = BL(:,1: T(1,2));
        
        % store percentage change
        val(RND+1,2) = abs( ( val(RND+1,1) - val(RND,1) ) / val(RND,1) );

        %Check signs of B
        if B(1,1) > 0
            B(:,1) = -1 * B(:,1);
        end
    
        if B(2, 2) < 0
            B(:,2) = -1 * B(:,2);
        end

         if B(3, 3) < 0
             B(:,3) = -1 * B(:,3);
         end

        % Write the covariance matrices from the decomposition of B and Lambda
       for position = 1:spec.s
          Sigma (1 + T(1,2)*(position-1) : T(1,2) * position, :) = B * ...
                Lambda(1 + T(1,2)*(position-1) : T(1,2) * position, :) * B';      
       end
        
        % Estimate parameter vector Theta (Ahat1_vec)
        T2=0;                                   %auxiliary counter matrices
        T3=0;                                   %auxiliary counter matrices
        for position = 1:spec.s
            T2 = T2 + kron( ( Z_star' * diag(KsiT(2:T(1,1)-spec.lags+1,position)) * Z_star ), get_sigma(Sigma, T, position)^-1) ;
            T3 = T3 + kron( Z_star' * diag(KsiT(2:T(1,1)-spec.lags+1,position)), get_sigma(Sigma, T, position)^-1);
        end
        
        Ahat1_vec = T2^-1 * T3 * reshape(Y', (T(1,1)-spec.lags) * T(1,2),1) ;
        U_opt = residuals2(T, y_star, Z_star, spec, Ahat1_vec);
        
        RND = RND + 1;
    end
    
    B_full(:, n) = reshape(B, T(1,2)^2, 1);
    L_full(:, n+1) = reshape(Lambda,  T(1,2)^2*spec.s, 1 );    
     
    [~, Theta1, ~, Theta1_LR] = irs(spec, Ahat1_vec, B,  T, h);

    % Store the bootstrapped IR values in matrix
    Bootstrap(n,:) = reshape(Theta1, 1, T(1,2)^2*(h+1) );
    Bootstrap_LR(n, :) = reshape(Theta1_LR, 1, T(1,2)^2*(h+1) ) ;
 
end

%% Compute Confidence Intervals, 68%
q = 0.84;
quantH = reshape(quantile(Bootstrap,q),T(1,2)^2,h+1);
quantL = reshape(quantile(Bootstrap,1-q),T(1,2)^2,h+1);
CIL2 = quantL;
CIH2 = quantH;

quantH_LR = reshape(quantile(Bootstrap_LR,q),T(1,2)^2,h+1);
quantL_LR = reshape(quantile(Bootstrap_LR,1-q),T(1,2)^2,h+1);
CIL2_LR = quantL_LR;
CIH2_LR = quantH_LR;


%% Plot of Impulse Responses with Confidence Intervals
% toc
% 

figure('Name','Impulse Responses','NumberTitle','off')
periods=0:h;
Vec = [1 4 7 2 5 8 3 6 9];
% plot the accumulated responses for the first variable
for p =1 : 3
                subplot(T(1,2),T(1,2), p);
                plot(periods, Theta_LR(Vec(p),:),'b',  'LineWidth', 1.5);
                hold on;
                plot(periods, CIH2_LR(Vec(p),:),'r--',  'LineWidth', 1.5);
                plot(periods, CIL2_LR(Vec(p),:),'r--' ,  'LineWidth', 1.5);
                plot(periods, zeros(1, h+1), ':' );
                hold off;
                xlim(gca, [0 h])   
end
% plot the responses for the 2&3 variable
for p = 4 : 9
                subplot(T(1,2),T(1,2), p);
                plot(periods, Theta_SR(Vec(p),:),'b',  'LineWidth', 1.5);
                hold on;
                plot(periods, CIH2(Vec(p),:),'r--',  'LineWidth', 1.5);
                plot(periods, CIL2(Vec(p),:),'r--' ,  'LineWidth', 1.5);
                plot(periods, zeros(1, h+1), ':' );
                hold off;
                xlim(gca, [0 h])   
end





