% The program for the paper by Helmut Luetkepohl and Aleksei Netsunajev 
%"Disentangling demand and supply shocks in the crude oil market: 
% How to check sign restrictions in structural VARs". 
% Function produces standardized residuals

function[] = U_stand(T, y, Z, spec, Estimation)

u = residuals2(T, y, Z, spec, Estimation.Theta);

for t=1:T(1,1)-spec.lags
    S = 0;
    for m=1:spec.s 
        S = S + Estimation.KsiT(t+1, m) * get_sigma(Estimation.Sigma, T, m);
    end
    Sigma_hat( (t-1)*T(1,2) + 1 : t*T(1,2), :) = S;
    U_st(t, :) = ( S^(-0.5) * u(t, :)' )' ;
   
end

figure('Name','Standardized residuals')
for r = 1:3
    subplot(1,3,r);
    plot(U_st(:, r) );
    %xlim(gca, [0 size(y, 1)+3]);
    title('U');
end