% The program for the paper by Helmut Luetkepohl and Aleksei Netsunajev 
%"Disentangling demand and supply shocks in the crude oil market: 
% How to check sign restrictions in structural VARs". 
%Function produces standard errors, returns - StErrors is the array of
%st.errors


function[StErrors, StErr_all, xi] = Param_Stderr(T, Estimation, spec, y, Z)
%% Choose the likelihood function
j=1;

if spec.s == 2
    param = [reshape(Estimation.B, T(1,2)^2,1)', diag(Estimation.Lambda(T(1,2)+1 : T(1,2)*2,:))', Estimation.Theta', reshape(Estimation.P(1:spec.s-1, :), numel(Estimation.P(1:spec.s-1, :)), 1 )'];
    Elements = numel(param);
    Elem_Theta = numel(Estimation.Theta);

elseif spec.s == 3
    param = [reshape(Estimation.B, T(1,2)^2,1)', diag(Estimation.Lambda(T(1,2)+1 : T(1,2)*2,:))', diag(Estimation.Lambda(T(1,2)*2+1:T(1,2)*3,:))', Estimation.Theta', reshape(Estimation.P(1:spec.s-1, :), numel(Estimation.P(1:spec.s-1, :)), 1 )'];
    Elements = numel(param);
    Elem_Theta = numel(Estimation.Theta);
 
elseif spec.s == 4
    param = [reshape(Estimation.B, T(1,2)^2,1)', diag(Estimation.Lambda(T(1,2)+1 : T(1,2)*2,:))', diag(Estimation.Lambda(T(1,2)*2+1:T(1,2)*3,:))', diag(Estimation.Lambda(T(1,2)*3+1:T(1,2)*4,:))', Estimation.Theta', reshape(Estimation.P(1:spec.s-1, :), numel(Estimation.P(1:spec.s-1, :)), 1 )' ];
    Elements = numel(param);
    Elem_Theta = numel(Estimation.Theta);

end
param = param';
myDelta=1e-4*abs(param)+0.00000001;

%%

xi=1;
s=zeros(T(1,1)-spec.lags,numel(param));

% calculate the initial likelihood function for each t.
for t=1:T(1,1)-spec.lags
    logLikVec1(t,1) = log( ( Estimation.P * Estimation.Ksi(t,:)' )' * Estimation.Eta(t,:)');
end

for i=1:numel(param)
    m=param;
    m(i)=param(i)+myDelta(i);
    
    B = reshape(m(1:T(1,2)^2, 1), T(1,2), T(1,2)) ;
    % Form matrix Sigma of state-dependent covariance matrices
    if spec.s == 2
        Sigma(1:T(1,2) , :) = B*B' ;
        Sigma(T(1,2)+1 : T(1,2)*2, :) = B * diag( m(T(1,2)^2 +1 : T(1,2)^2 + T(1,2), 1) ) * B' ;
    elseif spec.s == 3
        Sigma(1:T(1,2) , :) = B*B' ;
        Sigma(T(1,2)+1 : T(1,2)*2, :) = B * diag( m(T(1,2)^2 +1 : T(1,2)^2 + T(1,2), 1) ) * B' ;
        Sigma(2*T(1,2)+1 : T(1,2)*3, :) = B * diag( m(T(1,2)^2 + T(1,2) + 1 : T(1,2)^2 + 2*T(1,2), 1) ) * B' ;
    elseif spec.s == 4
        Sigma(1:T(1,2) , :) = B*B' ;
        Sigma(T(1,2)+1 : T(1,2)*2, :) = B * diag( m(T(1,2)^2 +1 : T(1,2)^2 + T(1,2), 1) ) * B' ;
        Sigma(2*T(1,2)+1 : T(1,2)*3, :) = B * diag( m(T(1,2)^2 + T(1,2) + 1 : T(1,2)^2 + 2*T(1,2), 1) ) * B' ;
        Sigma(3*T(1,2)+1 : T(1,2)*4, :) = B * diag( m(T(1,2)^2 + 2*T(1,2) + 1 : T(1,2)^2 + 3*T(1,2), 1) ) * B' ;
    end
    
	P = reshape(m( numel(m) - numel(Estimation.P(1:spec.s-1, :)) + 1 : numel(m)), spec.s-1 , spec.s);
	
    for k=1:spec.s-1
        for q=1:spec.s
            if P(k,q)>1
                P(k,q) = 0.999999;
            elseif P(k,q)<=0
                P(k,q) = 0.0000001;
            end
        end    
     end
    
    P_last = ones(1, spec.s);
	for k=1:spec.s-1
        P_last = P_last - P(k,:);
    end
	P(spec.s, :) = P_last;

    u = residuals2(T, y, Z, spec, m(Elements - Elem_Theta - numel(Estimation.P(1:spec.s-1, :)) + 1 : Elements - numel(Estimation.P(1:spec.s-1, :))) );
    Ksi2 = Estimation.Ksi;

    % update conditional density function Eta for the changes in parameter
    % values
    for j = 1: T(1,1)-spec.lags
        for position=1:spec.s
            Eta2(j,position) = (2*pi)^(-T(1,2)/2)*det(get_sigma(Sigma, T, position) )^-0.5 * exp(-0.5*u(j,:)...
                *get_sigma(Sigma, T, position)^-1*u(j,:)' );
        end
    end    

    % update state probabilities for the changes in parameter values
    for q=2:T(1,1)-spec.lags + 1
        Ksi2(q,1:spec.s) = ( Eta2(q-1,:)' .* (P*Ksi2(q-1,1:spec.s)') /...
            (spec.const'*(Eta2(q-1,:)'.*(P*Ksi2(q-1,1:spec.s)'))) )'; 
    end
    
    % calculate the approximated derivative for each t and each parameter
    for t=1:T(1,1)-spec.lags
        logLikVec2(t,i) = log( (P * Ksi2(t,:)' )' *  Eta2(t,:)');
        s(t,i)=(logLikVec2(t,i)-logLikVec1(t,1))/(myDelta(i));
    end
    
end

% form the outer product matrix as in Hamilton  eq 5.8.4
sum_s_Matrix=zeros(numel(param));
for idx=1:T(1,1)-spec.lags
    s_Matrix=s(idx,:)'*s(idx,:);
    sum_s_Matrix=sum_s_Matrix+s_Matrix;
end
OP_Matrix=sum_s_Matrix/T(1,1);
StErr_all(:, 2) = sqrt(diag(inv(OP_Matrix*T(1,1))));


%Produce results
% Using outer product matrix
StErrors = sqrt(diag(inv(OP_Matrix*T(1,1))));

