% The program for the paper by Helmut Luetkepohl and Aleksei Netsunajev 
%"Disentangling demand and supply shocks in the crude oil market: 
% How to check sign restrictions in structural VARs". 
% Fumction that minimizes the lihelihood function where cov. have structural decomposition B and Lambda


function[BL, val, xi] = MinimizeN(KsiT, T, Tm, Lambda, B, spec, u, Theta, ROUND)
%%
options = optimset('Algorithm', 'interior-point', 'Display', 'off', 'MaxFunEvals', 20000, ...
    'MaxIter', 20000, 'Hessian','bfgs', ...
'DerivativeCheck','on','Diagnostics','off','GradObj','off','LargeScale','off');
xi = 1;
% Form the matrix x of parameters to optimize wrt
x = B;
for position = 1:spec.s-1
    x(:,T(1,2)+position) = diag(Lambda(position*T(1,2)+1:T(1,2)*(position+1), :));
end

%lb is lower bound for constrained optimization, lbound returns the
%  bound for different number of states and variables
lb = lbound(T, spec);

% Restrictions for 3 variable case for Long-run or B matrix
% These are the restrictions imposed on the B matrix that ensure matrix Ksi (long run effects) 
% to be lower triangular (zeros above main diagonal)

% Restr
 restriction1 = [0 0 0 1 0 0 0 0 0];     
 restriction2 = [0 0 0 0 0 0 1 0 0]; 
 restriction3 = [0 0 0 0 0 0 0 1 0]; 

 %%
if spec.s == 2
%RESTRICTIONS FOR 3 VARIABLE CASE   
    ineq = @(x)[
     x(1,4) - x(2, 4)
     x(2,4) - x(3, 4)
    ];

    ceq = @(x) [
   %  Restrictions for B 
   restriction1 * reshape( x(1:T(1,2), 1:T(1,2)), T(1,2)^2 , 1)
   restriction2 * reshape( x(1:T(1,2), 1:T(1,2)), T(1,2)^2 , 1)
   restriction3 * reshape( x(1:T(1,2), 1:T(1,2)), T(1,2)^2 , 1) 
   ];
    
    if spec.BQrestrict == 1
        NonLinconstr = @(x)deal([] ,ceq(x));
    else
        NonLinconstr = @(x)deal( ineq(x), []);
    end
    
elseif spec.s == 3

   ineq = @(x)[
       ( x(1, 4) - x(2, 4) )
       ( x(2, 4) - x(3, 4) )
        ];
    
    ceq = @(x) [ 
%    Restrictions for B
  restriction1 * reshape( x(1:T(1,2), 1:T(1,2)), T(1,2)^2 , 1);
  restriction2 * reshape( x(1:T(1,2), 1:T(1,2)), T(1,2)^2 , 1);
  restriction3 * reshape( x(1:T(1,2), 1:T(1,2)), T(1,2)^2 , 1);
   ];
    
    if spec.BQrestrict == 1
        NonLinconstr = @(x)deal( [] ,ceq(x));
    else
        NonLinconstr = @(x)deal( ineq(x), []);
    end
 

elseif spec.s == 4
     ineq = @(x)[
      x(1,4) - x(2, 4)
      x(2,4) - x(3, 4)
        ];
    
    ceq = @(x) [
   %  Restrictions for B 
    restriction1 * reshape( x(1:T(1,2), 1:T(1,2)), T(1,2)^2 , 1)
    restriction2 * reshape( x(1:T(1,2), 1:T(1,2)), T(1,2)^2 , 1)
    restriction3 * reshape( x(1:T(1,2), 1:T(1,2)), T(1,2)^2 , 1) 
     ];
    
    if spec.BQrestrict == 1
        NonLinconstr = @(x)deal( [] ,ceq(x));
    else
        NonLinconstr =  @(x)deal( ineq(x), []);
    end
    
else
    'Number of states exceeds the one that is implemented (4) '
    return
end
%%
% Optimization part
[BL, val] = fmincon( @(x)LogLike(x, KsiT, Tm, spec, u, T), x , [], [] , [] , [] , lb , [] , NonLinconstr, options);
