% The program for the paper by Helmut Luetkepohl and Aleksei Netsunajev 
%"Disentangling demand and supply shocks in the crude oil market: 
% How to check sign restrictions in structural VARs". 
% Function that reestimates B in the bootstrap loop

function[BL, val, xi] = MinimizeB(KsiT, T, Tm, Lambda, B, spec, u, Theta, ROUND)
%%
options = optimset('Algorithm', 'interior-point', 'Display', 'off', 'MaxFunEvals', 20000, ...
    'MaxIter', 20000, 'Hessian','bfgs', ...
'DerivativeCheck','on','Diagnostics','off','GradObj','off','LargeScale','off');
xi = 1;
%'UseParallel', 'always'

% Form the matrix x of parameters to optimize wrt
x = B;
%lb is lower bound for constrained optimization, lbound returns the
%  bound for different number of states and variables
lb = lbound(T, spec);
Lb = lb(1:T(1,2), 1:T(1,2));
% Restrictions for 3 variable case for Long-run or B matrix
% These are the restrictions imposed on the B matrix that ensure matrix Ksi (long run effects) 
% to be lower triangular (zeros above main diagonal)
restriction1 = [0 0 0 1 0 0 0 0 0];     
restriction2 = [0 0 0 0 0 0 1 0 0]; 
restriction3 = [0 0 0 0 0 0 0 1 0]; 

%%
if spec.s == 2
%RESTRICTIONS FOR 3 VARIABLE CASE   
    W = eye(T(1,2),T(1,2));
    for w=1:spec.lags
        W = W - get_coefficient(Theta(:,ROUND), T, w);
    end

     ineq = @(x)[
    ];

    ceq = @(x) [
   %  Restrictions for B 
    restriction1 * reshape( x(1:T(1,2), 1:T(1,2)), T(1,2)^2 , 1)
    restriction2 * reshape( x(1:T(1,2), 1:T(1,2)), T(1,2)^2 , 1)
    restriction3 * reshape( x(1:T(1,2), 1:T(1,2)), T(1,2)^2 , 1) 
     ];
 
    if spec.BQrestrict == 1
        NonLinconstr = @(x)deal( [], ceq(x));
    else
        NonLinconstr = @(x)deal( ineq(x), []);
    end
    xi = 1;
    
elseif spec.s == 3
       
    %%

   ineq = @(x)[
    ];
    
    ceq = @(x) [ 
%    Restrictions for B
     restriction1 * reshape( x(1:T(1,2), 1:T(1,2)), T(1,2)^2 , 1);
     restriction2 * reshape( x(1:T(1,2), 1:T(1,2)), T(1,2)^2 , 1);
     restriction3 * reshape( x(1:T(1,2), 1:T(1,2)), T(1,2)^2 , 1);
    ];
    
    if spec.BQrestrict == 1
        NonLinconstr = @(x)deal( ineq(x) ,ceq(x));
    else
        NonLinconstr = @(x)deal( ineq(x), []);
    end
 
xi = 1;
elseif spec.s == 4
      
    ceq = @(x) [ 
   %  Restrictions for B 
    restriction1 * reshape( x(1:T(1,2), 1:T(1,2)), T(1,2)^2 , 1)
    restriction2 * reshape( x(1:T(1,2), 1:T(1,2)), T(1,2)^2 , 1)
    restriction3 * reshape( x(1:T(1,2), 1:T(1,2)), T(1,2)^2 , 1) 
     ];
    
    if spec.BQrestrict == 1
        NonLinconstr = @(x)deal( [] ,ceq(x));
    else
        NonLinconstr = [];
    end
    
else
    'Number of states exceeds the one that is implemented (4) '
    return
end
%%
% Optimization part
[BL, val] = fmincon( @(x)LogLikeB(x, Lambda, KsiT, Tm, spec, u, T), x , [], [] , [] , [] , Lb , [] , NonLinconstr, options);
