% The main program for the paper by Helmut Luetkepohl and Aleksei Netsunajev 
% "Disentangling demand and supply shocks in the crude oil market: 
% How to check sign restrictions in structural VARs". 

% read the data
y = xlsread('oil-shock-data.xls');                                              
T = size(y);

% This is the part for estimating unrestricted MS(3)-VAR(3) model
LM = 8;
spec.s = 3;
spec.lags = 3;
spec.iterations = numel(LM);
spec.const = ones(spec.s,1);
spec.IR = 1;
spec.IR_sv = 8;
spec.sr = 1;
spec.BQrestrict = 0;                    % identifying restrictions   
msvar(spec, y, LM, T);

% This is the part for estimating restricted  MS(3)-VAR(3) model
LM = 1.9;
spec.IR = 0;
spec.IR_sv = 0.351;
spec.sr = 1;
spec.BQrestrict = 1;                    % identifying restrictions   
msvar(spec, y, LM, T);

% This is the part for producing IRs and FEVDs for restricted
% MS(3)-VAR(3) model
LM = 0.1;
spec.IR = 1;
spec.IR_sv = 0.351;
spec.sr = 0;
spec.BQrestrict = 1;                    % identifying restrictions   
msvar(spec, y, LM, T);
