% The program for the paper by Helmut Luetkepohl and Aleksei Netsunajev 
%"Disentangling demand and supply shocks in the crude oil market: 
% How to check sign restrictions in structural VARs". 

function L = LogLikeB(x, Lambda, KsiT,  Tm, spec, u, T )
L = 0;

for position = 1:spec.s
    A(1 + T(1,2)*(position-1) : T(1,2) * position, :) = (repmat(KsiT(2:T(1,1) - spec.lags + 1, position),1, T(1,2) ) .* u )' * u;
end

L = L + (T(1,1)-spec.lags)*log( abs( det( x(:, 1: T(1,2)) ) ) ) + ...
0.5*trace( x(:, 1: T(1,2))'^-1 * x(:, 1:T(1,2))^-1 * get_sigma(A, T, 1));

for position = 2:spec.s
    L = L + Tm(1,position)/2 * log(  det(Lambda(1 + T(1,2)*(position-1) : T(1,2) * position, :) ) ) + ...
    0.5*trace( x(:,1: T(1,2))'^-1 *  Lambda(1 + T(1,2)*(position-1) : T(1,2) * position, :) ^-1 * x(:, 1: T(1,2))^-1 * get_sigma(A, T, position) );
end

L;