#include <oxstd.h>
#include <maximize.h>
#include <packages\SsfPack\SsfPack.h>
#include <oxfloat.h>
#include <oxdraw.h>
#include <ranmc.h>
#pragma link("maximize.oxo")
#pragma link("ranmc.oxo")

static decl mPhi, mOmega, mSigma, mY, mStsm, iStDim, iVar, bUni;
static decl s_limit, vAllP, s_vPskip;

FixStartSig (const rho)
{
	decl j, i, rhoSq = (1 - rho^2);
	for (i = 2*iVar; i < 3*iVar; ++i)
	{
		for (j = i; j < 3*iVar; ++j)
		{
			if (rhoSq > 1e-50)
			{
				mSigma[i][j] = mOmega[i][j]/rhoSq;
				mSigma[j][i] = mSigma[i][j];
				mSigma[i + iVar][j + iVar] = mSigma[i][j];
				mSigma[j + iVar][i + iVar] = mSigma[i][j];
			}
			else
			{
				if (i == j)
				{
					mSigma[i][j] = 1e10; // diffuse
				}
				else
				{
					mSigma[i][j] = 0; // uncorrelated in diffuse
				}
				println ("warning on prior for cycle: zero variance! ", rho);
				mSigma[j][i] = mSigma[i][j];
				mSigma[i + iVar][j + iVar] = mSigma[i][j];
				mSigma[j + iVar][i + iVar] = mSigma[i][j];
			}
		}
	}
//	println ("Prior for cycle: ", mSigma);
}

GetUniModel (const vP)
{
	decl i, big;

	big = maxc(vP);
	//print (vP);
	for (i=0; i<4; ++i)
	{
//		if (vP[i][0] - big < -11.51) // to prevent underflow
//		{
//		    mOmega[i][i] = exp (2 * (-11.51 + big));
//		}
//		else if (vP[i][0] < 150) // to prevent overflow
//		{
	        mOmega[i][i] = exp (2 * vP[i]);//transform vars
//		}
//		else
//		{
//		    mOmega[i][i] = exp (300);
//		}
	}
	mOmega[4][4] = mOmega[3][3]; // move meas var to last spot
	mOmega[3][3] = mOmega[2][2]; //parameter = var*(1-rho^2)!!!
}

// afgeleiden van diagonale elementen van omega
dervPdiag (const Gamma, const rijvP, const rownum, const dimOm)
{
	decl deriv;
	decl i, j, mdG = zeros(dimOm, dimOm);
	decl v = rijvP[0]; // = exp(2 * rijvP[0]); changed, now exp(2*param) sent to routine
	for (i = rownum - 1; i < dimOm; ++ i)
	{
		for (j = i; j < dimOm; ++j)
		{
			if (i == rownum - 1)
			{
				if (j == rownum - 1)
				{
					mdG[i][j] = 1;
				}
				else
				{
					mdG[i][j] = rijvP[j - rownum + 1];
				}
			}
			else
			{
				mdG[i][j] = rijvP[i - rownum + 1] * rijvP[j - rownum + 1];
			}
			if (i != j)
			{
				mdG[j][i] = mdG[i][j];
			}
		}
	}
//	print (mdG);
	mdG = 2 * v * mdG;
//	print (mdG);
	deriv = 0.5 * trace(Gamma * mdG);
	return deriv;
}

// afgeleiden van niet diagonale elementen van omega
dervPoffdiag (const Gamma, const rijvP, const rownum, const colnum, const dimOm)
{
	decl deriv;
	if (rownum > colnum)
	{
		print ("Improper location in covariance matrix!", "\n");
		deriv = 0;
		return deriv;
	}
	decl i, mdG = zeros(dimOm, dimOm);
	decl v = rijvP[0]; //changed, was = exp(2 * rijvP[0]); // transform diagonal parameter
	mdG[colnum - 1][rownum - 1] = v; // first term of d(omega)/d(param)
	mdG[rownum - 1][colnum - 1] = v;
	for (i = rownum; i < dimOm; ++ i)
	{
		if (i == colnum - 1)
		{
			mdG[i][colnum - 1] = 2 * rijvP[i - rownum + 1] * v; // diagonal element
		}
		else
		{
			mdG[colnum - 1][i] = v * rijvP[i - rownum + 1]; // off-diagonal element
			mdG[i][colnum - 1] = mdG[colnum - 1][i];
		}
	}
	deriv = 0.5 * trace(Gamma * mdG);  // derivative is equal to...
	return deriv;
}

Iznogoed (const m, const n) //kijken of covarianties kloppen
{
	decl i, j, idim, mTemp = mOmega[m:n][m:n];
	idim = rows(mTemp);
	for (i = 0; i < idim; ++i)
	{
		for (j = i + 1; j < idim; ++j)
		{
			if (sqr(mTemp[i][j]) > mTemp[i][i]*mTemp[j][j]) // correlatie mag niet groter dan 1 in abs waarde zijn
			{
//				print ("i ", i, "j ", j, "m ",  m, "\n");
				if (mTemp[i][j] < 0)
				{
					mTemp[i][j] = -sqrt(mTemp[i][i]*mTemp[j][j]);
				}
				else
				{
//					print (mTemp[i][j], ", ", mTemp[i][i], ", ", mTemp[j][j], "\n");
					mTemp[i][j] = sqrt(mTemp[i][i]*mTemp[j][j]);
				}
				mTemp[j][i] = mTemp[i][j];
			}
		}
	}
	mOmega[m:n][m:n] = mTemp;
}

blowupvP(const vPkort)
{
    decl i, j, n, vP, vPretn;
	
	if (s_vPskip[0] > 0)
	{
		vP = zeros(2 + iStDim*iVar*(iVar + 1)/2, 1);
//		println (vPkort);
//		println (vP');
		vP[] = vPkort[0:1];
		vP[2:iVar*iStDim + 1] = -exp(600); // should cause a zero load
		vP[iVar*iStDim + 2:] = 0; // zero off diagonal
//		print (vAllP);
		j = 0;
		n = 2;
		for (i = 2; i < 2 + iStDim*iVar*(iVar + 1)/2; ++i)
		{
			if (s_vPskip[j] != i)
			{
				vP[i] = vPkort[n];
				++n;
			}
			else
			{
				++j; // laat null in vP staan... ga door naar volgende restrictie
			}
		}
		if (n + j != 2 + iStDim*iVar*(iVar + 1)/2)
		{
			print ("parameter vector not properly blown up!", "\n");
		}
	}
	else // no reduced dimension
	{
		vP = vPkort; // nothing to skip, no restrictions
	}
	vPretn = vP;
	return vPretn;
}

GetMultiModel (const vPkort, const avPjump)
{
    decl i, j, k, m, n, l, var, rho, lambda, trcos, trsin, Mat, tempI, tempI2;
	decl vP;

	vP = blowupvP(vPkort);

//	print ("Dag", "\n", vAllP);
//	print ("verlaat", "\n", s_vPskip[0:min(5, rows(s_vPskip))-1][0]');
//	print ("Crit3: ", maxc(fabs((vP'-oldParm')./oldParm')'));
//	oldParm = vP;
	tempI = unit((iStDim) * iVar); // for with a cycle and measurement error
	tempI2 = tempI;
//	if (vP[0] < log(5) - log(995)) // this is no longer the correct transformation
//	{
//		rho = 0.995;
//	}
//	else
//	{
		rho = fabs(vP[0])/sqrt(sqr(vP[0]) + 1.0);
//	}
	lambda = M_2PI/(exp(vP[1]) + 2.0); //frequency
//	print (lambda, "\n");
    trcos = cos(lambda)*rho;
	trsin = sin(lambda)*rho;
//	print (trcos, ", ", trsin);
	Mat = unit(2);
	Mat[0][0:1] = trcos ~ trsin;
	Mat[1][0:1] = -trsin ~ trcos;
//	print (Mat);
	mPhi[2*iVar:4*iVar - 1][2*iVar:4*iVar - 1] = Mat ** unit(iVar);
//	print (format(600));
//	print (mPhi, "\n");
//	print (vP[][0]);
	
//	var = log(sumr(diagonal(mOmega))/((iStDim + 1)*iVar))/2; // log of average st. dev.
	
//	if (rho >= 0.995)
//	{
//		rho = log(1 - 0.995^2)/2;
//	}
//	else if (log(1 - rho^2) < -700)
//	{
//		rho = -350;
//	}
//	else
//	{
//		rho = log(1 - rho^2)/2;
//	}
//	format(600);
//	print ("cd ", mSigma);
//	print (mPhi);
//	print (mOmega);
//	decl io;
	decl lowerlimit = log(s_limit);
// fill in the variances along diagonal for trans eq.
    i = 2;
	k = 0;
	decl io = 0;
	for (l = 1; l < iStDim - 1; ++l) // diagonal for not cycle, measurement var's
	{
		var = maxc(vP[2 + iVar*(l - 1):iVar*l + 1]); // largest load factor of covariance (per block)
		for (j = 1; j <= iVar; ++j)
		{
		if (vP[i] - var < lowerlimit) // to prevent underflow
			{
			    tempI2[k][k] = 0.0;
//				print (vP[i], " i=", i, "\n");
//				print ("var=", var, "\n");
				avPjump[0][io][0] = i;
				++io;
			}
			else if (vP[i] < 170.0) // to prevent overflow
			{
		        tempI2[k][k] = exp (2 * vP[i]);//transform load
			}
			else
			{
			    tempI2[k][k] = exp (340);
			}
//			print (mOmega[k][k], " k= ", k, " 1 \n");  ??what is dit??
			i += 1;
			k += 1;
		}
	}
	var = maxc(vP[2 + iVar*2:iVar*3 + 1]); // largest load factor of covariance
	for (j = 1; j <= iVar; ++j) // for the cycle variances load
	{
		if ((vP[i] - var < lowerlimit) || (log(1.0 - sqr(rho)) <= lowerlimit))
		{
		    tempI2[k][k] = 0.0;
//			print (vP[i], " i=", i, "\n");
//			print ("var=", var, "\n");
			avPjump[0][io][0] = i;
			++io;
		}
		else if (vP[i] < 170)
		{
	        tempI2[k][k] = exp(2*vP[i]); //transform load
		}
		else
		{
			tempI2[k][k] = exp(340);
		}
//		if (log(1.0 - sqr(rho)) <= lowerlimit)
//		{
//			tempI2[k][k] = 0.0;
//		}
		i += 1;
		k += 1;
	}
// diagonal elements (variances) for measurements
//  print (diagonal(mOmega));
// overwrite second variance block from cycle load
	var = maxc(vP[2 + iVar*3:iVar*4 + 1]); // largest load factor of covariance	
	for (j = 1; j <= iVar; ++j)
	{
		if (vP[i] - var < lowerlimit) // to prevent underflow
		{
		    tempI2[k][k] = 0.0;
//			print (vP[i], " i=", i, "\n");
//			print ("var=", var, "\n");
			avPjump[0][io][0] = i;
			++io;
		}
		else if (vP[i] < 170) // to prevent overflow
		{
	        tempI2[k][k] = exp (2 * vP[i]);//transform vars load
		}
		else
		{
		    tempI2[k][k] = exp (340);
		}
//		print (mOmega[k][k], " k= ", k, " 2 \n"); ??waarvoor is dit??
		i += 1;
		k += 1;
	}
// now off diagonal elements (covariances)
	n = 0;
	for (j = 1; j <= iStDim; ++j) // number of covariance blocks - 1; overwrite second cycle
	{
		for (k = 1; k < iVar; ++k) // walk down the diagonal...
		{
			m = n + 1;
			for (l = 1; l <= iVar - k; ++l) // number covar's per block, also not work with seas
			{
				tempI[n][m] = vP[i];
				if (tempI2[n][n] == 0)
				{
					tempI[n][m] = 0.0;
//					print (avPjump[0][][]', io);
					avPjump[0][io][0] = i;
					++io;
				}
//				{
//					format ("%#15.7g");
//					print (vP[i]);
//				}
//				print (n, ", 3, ", m, ", ", i, ", ", vP[i], ", ", mOmega[n][m], "\n");
				i += 1;
				m += 1;
			}
			n += 1;
		}
		n += 1;
//		print (n, ", ", m, "\n"); 
	}

//	print (format(600));
//	print (mOmega);
//	print (i);
	decl rijvP = zeros(rows(tempI), iVar); // nodig voor afgeleiden
	j = iVar - 1;
	for (i = 0; i < rows(tempI); ++i)
	{
		if (j < 0)
		{
			j = iVar - 1;
		}
		rijvP[i][:j] = tempI[i][i:j + i];
		--j;
	}
	rijvP[][0] = diagonal(tempI2)';
//	print (diagonal(tempI2), "\n");
//	print (tempI);
	
	mOmega[:iVar * iStDim][:iVar * iStDim] = tempI' * tempI2 * tempI;

// now put measurement covar's where belong:
	mOmega[iVar * iStDim:][iVar * iStDim:]
		= mOmega[iVar * (iStDim - 1): iVar * iStDim - 1][iVar * (iStDim - 1): iVar * iStDim - 1];

// now copy cycle into second block:
	mOmega[iVar * (iStDim - 1): iVar * iStDim - 1][iVar * (iStDim - 1): iVar * iStDim - 1]
		= mOmega[iVar * (iStDim - 2): iVar * (iStDim - 1) - 1]
			[iVar * (iStDim - 2): iVar * (iStDim - 1) - 1];
//	format(600);
//	print (mOmega);
//	format(600);
//	print (mSigma);
//	print (mPhi);
//	print (diagonal(mOmega));
	Iznogoed (0, iVar - 1); //mOmega[0:4][0:4]);
//	print (mOmega[0:4][0:4]);
	Iznogoed (iVar, 2*iVar - 1); //mOmega[5:9][5:9]);
//	print (mOmega[5:9][5:9]);
	Iznogoed (2*iVar, 3*iVar - 1); //mOmega[10:14][10:14]);
//	print (mOmega[10:14][10:14]);
//	Iznogoed (mOmega[15:19][15:19]);
//	print (mOmega[15:19][15:19]);
	mOmega[3*iVar:4*iVar - 1][3*iVar:4*iVar - 1] = mOmega[2*iVar:3*iVar - 1][2*iVar:3*iVar - 1];
	Iznogoed (4*iVar, 5*iVar - 1); //mOmega[20:24][20:24]);
//	print (mOmega[20:24][20:24]);
//	print (mPhi);
//	if (avPjump[0][0] != 0)
//	{
//		println (avPjump[0][0:5]');
//		println (s_vPskip');
//		println (rows(vPkort));
//		if (avPjump[0][6] != 0)
//		{
//			println (avPjump[0][6:11]');
//		}
//	}
	FixStartSig (rho);
	return rijvP;
}


GetParam (const tempP, const avP)
{
    decl i, j, k, m, n, l, P, vPtemp = zeros(2 + iStDim*iVar*(iVar + 1)/2, 1);
	vPtemp[0:1] = avP[0][0:1][0];
// cut out extra cycle covar
	P = tempP;
// transform the variances along diagonal for trans eq.
    i = 2;
	k = 0;
	for (l = 1; l < iStDim - 1; ++l) // diagonal for not cycle, measurement var's
	{
		for (j = 1; j <= iVar; ++j)
		{
			if (P[k][k] > exp(-350))
			{
				vPtemp[i] = log(P[k][k]);
			}
			else
			{
				vPtemp[i] = -350;
			}
			i += 1;
			k += 1;
		}
	}
	for (j = 1; j <= iVar; ++j) // for the cycle variances load
	{
		if (P[k][k] > exp(-350))
		{
			vPtemp[i] = log(P[k][k]);
		}
		else
		{
			vPtemp[i] = -350;
		}
		i += 1;
		k += 1;
	}
// diagonal elements (variances) for measurements
	
	for (j = 1; j <= iVar; ++j)
	{
		if (P[k][k] > exp(-350))
		{
			vPtemp[i] = log(P[k][k]);
		}
		else
		{
			vPtemp[i] = -350;
		}
		i += 1;
		k += 1;
	}
// now off diagonal elements (covariances)
	n = 0;
	for (j = 1; j <= iStDim; ++j) // number of covariance blocks - 1; overwrite second cycle
	{
		for (k = 1; k < iVar; ++k) // walk down the diagonal...
		{
			m = n + 1;
			for (l = 1; l <= iVar - k; ++l) // number covar's per block, also not work with seas
			{
				if (P[n][n] > exp(-350))
				{
					vPtemp[i] = P[n][m];//sqr(P[n][n]); ?this is surely wrong?
				}
				else
				{
					vPtemp[i] = 0.0;
				}
				i += 1;
				m += 1;
			}
			n += 1;
		}
		n += 1;
//		print (n, ", ", m, "\n"); 
	}
	avP[0] = vPtemp;
}

RestLik(const vshortP, const apdLik, const apvSco, const apmHes)
{
	decl dfval, vnewP = vAllP;
	vnewP[0:1] = vshortP;
//	print (vnewP);
	decl junk, vJump;
	vJump = zeros(2 + iStDim*iVar*(iVar + 1)/2, 1);
	junk = GetMultiModel(vnewP, &vJump);
	decl dVar;
	dfval = SsfLik (apdLik, &dVar, mY, mPhi, mOmega, mSigma);
	if (dfval != 0)
	{
		apdLik[0] = apdLik[0]/(columns(mY));
	}
	else
	{
		apdLik[0] = -exp(700);
	}
	return dfval;
}

cutvP(const avP, const vPjump)
{
	decl j = 0;
	if (vPjump[0] != 0)
	{
		decl i, n = 1;
//		print ("Before: ", avP[0][][0]');
		decl vPtemp = blowupvP(avP[0]); // voor in het geval dat al eerder geknipt hebt
		for (i = 2; i < 2 + iStDim*iVar*(iVar + 1)/2; ++i) // rho en lambda mogen er niet uit
		{
			if (vPjump[j] != i)
			{
				++n;
				avP[0][n][0] = vPtemp[i];
			}
			else
			{
				++j;
			}
		}
		avP[0] = avP[0][0:n][0];
//		print ("vP cut: ", "\n", avP[0]);
//		print ("vAllP: ", "\n", vAllP);
	}
	else
	{
		print ("Niets te knippen uit parametervector!", "\n");
//		print (vPjump[0]);
	}
	return j; // return total number of restrictions
}

afgeleid (const rijvP, const mSco, const vP) // afgeleiden uitrekenen
{
	decl i, io, in, j, k, m, n, derivP = zeros(2 + iStDim*iVar*(iVar + 1)/2, 1);
	decl derivPretn;
	m = 0;
	n = iVar - 1;
	j = 1;
	k = 1;
	io = 0;
	in = 2;
	for (i = 2; i <= iVar * iStDim + 1; ++i)	//do diagonals first
	{
		if (i >= j * iVar + 2) // whether next block of covar or not
		{
			k = 1;
			m = j * iVar;
			++j;
			n = j * iVar - 1;
		}
//		print ("i=", i, " m=", m, " n=", n, "\n");
//		print (columns(mSco), rows(mSco), "\n");
//		print (mSco[m:n][m:n]);
//		print (rijvP[i - 2][]);
//		print ("k=", k, "\n");
//		if (s_vPskip[io] != i)
//		{
			derivP[in] = dervPdiag (mSco[m:n][m:n], rijvP[i - 2][], k, iVar);
			++in;
//		}
//		else
//		{
//			++io;
//		}
//		print (derivP[i], "\n");
		++k;
	}
	k = 0;
	decl rownum = 1;
	decl colnum = 2;
	m = 0;
	n = iVar - 1;
	j = 1;
	for (i = iVar * iStDim + 2; i < 2 + iStDim*iVar*(iVar + 1)/2; ++i) // offdiagonals
	{
//		print ("i=", i, " m=", m, " n=", n, " row=", rownum, " col=", colnum, "\n");
//		print (columns(mSco), rows(mSco), "\n");
//		print (mSco[m:n][m:n]);
//		print (rijvP[k][]);
//		print ("k=", k, "\n");
//		if (s_vPskip[io] != i)
//		{
			derivP[in] = dervPoffdiag (mSco[m:n][m:n], rijvP[k][], rownum, colnum, iVar);
			++in;
//		}
//		else
//		{
//			++io;
//		}
//		print (derivP[i], "\n");
		++colnum;
		if (colnum > iVar)
		{
			++rownum;
			++k;
			colnum = rownum + 1;
		}
		if (rownum >= iVar)
		{
			++k; // no off-diagonals
			rownum = 1;
			colnum = 2;
			m = j * iVar;
			++j;
			n = j * iVar - 1;
		}
	}
	vAllP = vP;
	decl vshortP = vP[0:1];
	decl vtempD = <0; 0>;
	derivP = derivP[0:in-1]/(columns(mY));
//	print (derivP', " what 1", "\n");
	Num1Derivative(RestLik, vshortP, &vtempD);
	derivP[0:1] = vtempD;
//	print (derivP', " if 2", "\n");
	decl oldskip = s_vPskip; // bewaar eerste waarde
	decl vPjump = s_vPskip; // gebruik huidige skip
	s_vPskip = 0*s_vPskip; // niets om op te blazen, ervanuit gegaan van 0 restrictie bij opbouw van derivP
//	n = rows(derivP);
//	if (vPjump[0] != 0)
//	{
//		println (derivP');
//	}
	j = cutvP(&derivP, vPjump); // snij restricties weg
//	derivP = derivP[0:n - j - 1];
	s_vPskip = oldskip; // zet waarde terug
	derivPretn = derivP;
//	print (derivP', "\n", rows(derivP), "\n");
	return derivPretn;
}

Likelihood (const vP, const apdLik, const apvSco, const apmHes)
{
    decl dVar, mSco, i, dfval, rijvP, vPjump;
//	print ("In: ", garbage, "\n");
	vPjump = zeros(iStDim*iVar*(iVar + 1)/2, 1);

	if (bUni)
	{
		GetUniModel(vP);
	}
	else
	{
		rijvP = GetMultiModel(vP, &vPjump);
//		print (mOmega[0:4][0:4]);
//		print (mOmega[5:9][5:9]);
//		print (mOmega[10:14][10:14]);
//		print (mOmega[15:19][15:19]);
//		print (mOmega[20:24][20:24]);
//		print (rijvP);
	}

	if (isarray(apvSco))
	{
//		print (mOmega);
	    dfval = SsfLikSco (apdLik, &dVar, &mSco, mY, mPhi, mOmega, mSigma);
//		print ("Variance: ", dVar, "\n", mSco[0:5][0:5]);
//		print (dfval, "\n");
		if (dfval > 0)
		{
//			print (mSco);
//			print (mSco[0:4][0:4]);
//			print (mSco[5:9][5:9]);
//			print (mSco[10:14][10:14]);
//			print (mSco[20:24][20:24]);
			mSco[2*iVar:3*iVar-1][2*iVar:3*iVar-1] = mSco[2*iVar:3*iVar-1][2*iVar:3*iVar-1]
			                                       + mSco[3*iVar:4*iVar-1][3*iVar:4*iVar-1]; // cycle is double
			mSco[3*iVar:4*iVar-1][3*iVar:4*iVar-1] = mSco[4*iVar:5*iVar-1][4*iVar:5*iVar-1]; // cycle is double
			apvSco[0] = afgeleid (rijvP, mSco, vP); // rekenen afgeleiden
//			println ("WHY? ");
//			println (apvSco[0]);
//			println ("derivatives: ", "\n", apvSco[0]);
//		print (pvSco[0], diagonal(mSco)', mOmega);
//		pvSco[0][0][0] = mOmega[0][0] * mSco[0][0];     //from transfomed
//		pvSco[0][1][0] = mOmega[1][1] * mSco[1][1];       //derivative to
//		pvSco[0][2][0] = mOmega[2][2] * mSco[2][2] + mOmega[3][3] * mSco[3][3];
//		pvSco[0][3][0] = mOmega[4][4] * mSco[4][4];
//		pvSco[0][3][0] = mOmega[3][3] * trace(mSco[3:13][3:13]);
//		pvSco[0][3][0] = mOmega[13][13] * mSco[13][13];  
		}
		else
		{
			apdLik[0] = -exp(700);
		}
		
//		print (pvSco[0], "HEY! Should not be here, derivatives not right!");		
	}	
	else
	{
//		println ("Numerical derivatives!");
	    dfval = SsfLik (apdLik, &dVar, mY, mPhi, mOmega, mSigma);
		if ((dVar < 0) || (isnan(apdLik[0])) || (isdotinf(apdLik[0])))	// if pred. var <0 or like not defined
		{ // this is missing from version with derivatives above
			apdLik[0] = -exp(700);
			print (mOmega[0:4][0:4]);
			print (mOmega[5:9][5:9]);
			print (mOmega[10:14][10:14]);
			print (mOmega[20:24][20:24]);
			print ("trouble", "\n");
		}
//		print (apdLik[0]);
//		if(rows(vP) > 55)
//		{
//			print (vP[55:][0]');
//		}
	}
	
//	print (dVar);
//	format(600);
//	print (mOmega);
//	print ("Out: ", garbage, ", ", apdLik[0], "\n");
//	print ("Crit1: ", fabs((garbage - apdLik[0])/garbage), "\n");
//	garbage = apdLik[0];
	apdLik[0] = apdLik[0]/(columns(mY)); // is dit wel goed?
	return dfval;
}

GenCholeski(const P, const lim)
{
	decl Pdim, i, j, k, var, C;
	Pdim = rows(P);
	C = zeros(Pdim, Pdim);
//	print (C, ", ", Pdim, ", ", P);
	
	if (Pdim != columns(P))
	{
		println ("Input matrix not square!");
		return 0;
	}

	var = sqrt(maxc(diagonal(P)')); // maximum diagonal element
//	print (var);

	k = 0;
	i = 0;
	while (k == 0) // find first non-zero row
	{
//		print (P[i][i]);
		C[i][i] = sqrt(P[i][i]); // diagonal element (root of)
		if (C[i][i]/var >= lim)
		{
			for (j = i + 1; j < Pdim; ++j)
			{
				C[i][j] = P[i][j]/P[i][i]; // off diagonal elements 
			}
			++k;
//			print (k);
		}
		++i; // next row
	}

	k = i; // begin first row after first non-zero row
	for (i = k; i < Pdim; ++i)
	{
		C[i][i] = P[i][i];
		for (j = 1; j <= i; ++j)
		{
			C[i][i] = C[i][i] - sqr(C[i - j][i]*C[i - j][i - j]);
		}
		if (C[i][i] > 0.0)
		{
			C[i][i] = sqrt(C[i][i]); // diagonal element (root of)
		}
		else
		{
			C[i][i] = 0.0;
		}
		if (C[i][i]/var >= lim) // if non zero diagonal element find off diag's
		{
			for (j = i + 1; j < Pdim; ++j)
			{
				C[i][j] = P[i][j];
				for (k = 1; k <= i; ++k)
				{
					C[i][j] = C[i][j] - sqr(C[i - k][i - k])*C[i - k][j]*
							C[i - k][i];
				}
				 C[i][j] = C[i][j]/sqr(C[i][i]); // off diagonal element
			}
		}
	}
	decl temp2 = sqr(C);
//	println (temp2);
	temp2 = diagonalize(temp2);
//	println (temp2);
	decl temp1 = C;
	temp1 = upper(temp1);
//	println (temp1);
	temp1 = setdiagonal(temp1, ones(Pdim, Pdim));
//	println (temp1);
	
	
	
	if (temp1'*temp2*temp1 != P)
	{
		println ((temp1'*temp2*temp1 != P));
		println (C);
		println (temp1'*temp2*temp1);
		println (P);
	}
	return C;
}

emalg(const iter, const avP)
{
	decl mSco, mest2, P, limit, check, step, moldOmega, doldLik, dVar, dLik;
	P = mOmega;
	step = columns(mY);
	check = SsfLikSco(&dLik, &dVar, &mSco, mY, mPhi, mOmega, mSigma);
	if (check == 0)
	{
		print ("problem with KF in EM", "\n");
		return check;
	}
	mSco = mSco/step;
	doldLik = dLik;
	moldOmega = mOmega;
	decl i, mNewOm = mOmega;
	decl rho = fabs(avP[0][0])/sqrt(sqr(avP[0][0]) + 1.0);
	print (s_limit, dLik/(columns(mY)));
	for (i=1; i<=iter; ++i)
	{
		mNewOm = mOmega + mOmega*mSco*mOmega;
		mOmega[0:iVar-1][0:iVar-1] = mNewOm[0:iVar-1][0:iVar-1];
		mOmega[iVar:2*iVar-1][iVar:2*iVar-1] = mNewOm[iVar:2*iVar-1][iVar:2*iVar-1];
		mOmega[2*iVar:3*iVar-1][2*iVar:3*iVar-1] = (mNewOm[2*iVar:3*iVar-1][2*iVar:3*iVar-1] + mNewOm[3*iVar:4*iVar-1][3*iVar:4*iVar-1])/2;
		mOmega[3*iVar:4*iVar-1][3*iVar:4*iVar-1] = mOmega[2*iVar:3*iVar-1][2*iVar:3*iVar-1];
		mOmega[4*iVar:5*iVar-1][4*iVar:5*iVar-1] = mNewOm[4*iVar:5*iVar-1][4*iVar:5*iVar-1];		
		print (mOmega[0:iVar-1][0:iVar-1]);
		print (mOmega[iVar:2*iVar-1][iVar:2*iVar-1]);
		print (mOmega[2*iVar:3*iVar-1][2*iVar:3*iVar-1]);
//		print (mOmega[15:19][15:19]);
		print (mOmega[4*iVar:5*iVar-1][4*iVar:5*iVar-1]);
		FixStartSig (rho);
		check = SsfLikSco(&dLik, &dVar, &mSco, mY, mPhi, mOmega, mSigma);
		print (dLik/(columns(mY)), ", ", dVar, ", ", check, "\n");
//		check = SsfLik(&dLogLik, &dVar, mY, mPhi, mOmega, mSigma);
//		print (dLogLik, ", ", dVar, ", ", check, "\n");
//		check = SsfLikConc(&dLogLik, &dVar, mY, mPhi, mOmega, mSigma);
//		print (dLogLik, ", ", dVar, ", ", check, "\n");		
		if ((dVar <= 0) || (dLik <= doldLik) || (check != 1))
		{
			mOmega = moldOmega;
			FixStartSig (rho);
			print ("variantie: ", dVar, " KF check: ", check, "\n");
			dLik = doldLik;
			step = step*2.0;
			check = SsfLikSco(&dLik, &dVar, &mSco, mY, mPhi, mOmega, mSigma);
			mSco = mSco/step;
		}
		else
		{
			mSco = mSco/step;
//			step = step*0.99;
//			print (step, "\n");
//			if (step < 100)
//			{
//				step = 100;
//			}
		}
//		mOmega = mOmega + mOmega*mSco*mOmega;
		moldOmega = mOmega;
		doldLik = dLik;
		check = SsfMomentEst(ST_SMO, &mest2, mY, mPhi, mOmega, mSigma);
//    DrawTMatrix(0, mest2[0:4][], {"level"}, 1970, 1, 4);
		DrawTMatrix(0, mest2[iVar:2*iVar-1][], {"drift"}, 1970, 1, 4);
		DrawTMatrix(1, mest2[2*iVar:3*iVar-1][], {"cycle"}, 1970, 1, 4);
		ShowDrawWindow();
	}
	P[0:iVar-1][0:iVar-1] = GenCholeski(mOmega[0:iVar-1][0:iVar-1], s_limit);
//	if (P[0:4][0:4]'*P[0:4][0:4] != mOmega[0:4][0:4]) //this should NOT work!
//	{
//		println("warning!");
//	}
	P[iVar:2*iVar-1][iVar:2*iVar-1] = GenCholeski(mOmega[iVar:2*iVar-1][iVar:2*iVar-1], s_limit);
	P[2*iVar:3*iVar-1][2*iVar:3*iVar-1] = GenCholeski(mOmega[2*iVar:3*iVar-1][2*iVar:3*iVar-1], s_limit);
	P[3*iVar:4*iVar-1][3*iVar:4*iVar-1] = GenCholeski(mOmega[4*iVar:5*iVar-1][4*iVar:5*iVar-1], s_limit);
	check = SsfLik(&dLik, &dVar, mY, mPhi, mOmega, mSigma);
	print (dLik/(columns(mY)), " hello");
//	decl vPtemp = vAllP;
	if (check != 0)
	{
		GetParam(P, avP);
	}
	else
	{
		dLik = check;
	}
	return dLik;
}

CutHess(const aHess, const iter, const oldLik, const dLik, const vPjump) // remove row & col of Hessian where new restriction
{
	decl i, j, temp = aHess[0];
//	println ("In Hess: ", aHess[0]);
//	println ("Skip: ", s_vPskip');

	j = 0;
	for (i = 0; i < iStDim*iVar*(iVar + 1)/2; ++i)
	{
//		println ("jump: ", vPjump[i]);
		if (vPjump[i] == 0)
		{
			break; // no restrictions any more
		}
		else
		{
//			println ("Test: ", vPjump[i] != s_vPskip);
			if (vPjump[i] != s_vPskip) // check if restriction is new
			{
//				println (vPjump[i] - j);
				temp = dropc(temp, vPjump[i]-j);
				temp = dropr(temp, vPjump[i]-j);
//				print  ("tussen: ", temp);
				++j;
			}
			else
			{
				++j;
			}
		}
	}
	println ("change per iter: ", (dLik - oldLik)/iter);
	if ((dLik - oldLik)/iter < 0.001) // dichtbij genoeg om Hessian te houden
	{
		aHess[0] = temp;
	}
	else // anders gebruik nieuwe E matrix...
	{
		aHess[0] = unit(rows(temp));
	}
//	println ("Out Hess: ", aHess[0], temp);
}

checkskip(const pvSco, const vPjump, const avP) // routine to reduce vP dimension
{
	decl i, logica, pvDer;
	logica = (vPjump[0] != 0);
//	print (vPjump');
	i = 0;
	if (vPjump[0] == 0) // no restrictions
	{
		print ("Parameter vector dimension not reduced.", "\n");
	}
	else
	{
//		println ("Enter: ", pvSco');
		pvDer = blowupvP(pvSco); // get blown up derivative vector
//		println ("Exit: ", pvDer);
		for (i = 0; i < iStDim*iVar*(iVar + 1)/2; ++i)
		{
//			print (vPjump[i], "\n");
			if (vPjump[i] != 0) // zijn er nog restricties?
			{
//				print ((s_vPskip .!= vPjump[i]) == TRUE, "\n");
				if ((s_vPskip != vPjump[i]) == TRUE) // restrictie nog niet ingevoerd?
				{
					logica = (pvDer[vPjump[i]] == 0.0); // restrictie klopt?
//					print ("Deriv = 0 ", logica, "\n");
					if (logica == FALSE)
					{
						print ("Error!. Cannot reduce parameter dimension!", "\n");
//						println (vPjump[i], "a ", pvDer[vPjump[i]], "b ", i);
						break; // nieuwe restrictie onbetrouwbaar, stop

					}
				}
			}
			else
			{
				break; // no more restrictions
			}
		}
	}
	i = 0;
	if (logica)
	{
		i = cutvP(avP, vPjump);
		s_vPskip = vPjump; // restricties lijken ok te zijn, voer ze in.
//		print (s_vPskip');
	}
	return i;
}

outputCov (const m, const n) // print stuk van Omega met correlatiecoef. in boven driehoek
{
	decl i, j, idim, mTemp = mOmega[m:n][m:n];
	idim = rows(mTemp);
	for (i = 0; i < idim; ++i)
	{
		for (j = i + 1; j < idim; ++j)
		{
			mTemp[i][j] = mTemp[j][i]/sqrt(mTemp[i][i]*mTemp[j][j]);
		}
	}
	println ("stuk Omega van: ", m, " tot: ", n, "\n", mTemp);
}

main()
{
    decl mhes, ir, dLik, dVar, mD, mS, i, mSc, iter, irep, vP, vPUni, mp2, mYulti, rho;

	// Get data:
	mY = loadmat ("f:\proefschrift\data\international\DFrSpItNl ox70.xls")';
//	iNumObs = columns(mY);                       // number of observations
	print (mY', "\n");
	mY = mY[0:1][] | mY[3][] | mY[2][] | mY[4][];
	// specify model:
	s_vPskip = <0>; // elements of parameter vector to be skipped (none at start)
	s_limit = sqrt(1.0e-6);
	bUni = 0;
	iStDim = 4; // input the dimension of the state
	mStsm = <CMP_IRREG,       1e-2,   0, 0;
         	 CMP_LEVEL,       0.77,   0, 0;
           	 CMP_SLOPE,       0.026,  0, 0;				 
			 CMP_CYC_0,       0.1,   12, 0.9>;

	mStsm[3][2] = M_2PI/20.0;
	rho = 0.92;
    GetSsfStsm (mStsm, &mPhi, &mOmega, &mSigma);

	if (iStDim != columns(mPhi))
	{
		print ("Dimension of the state vector misspecified!", "\n");
	}

//	mSigma[0][0] = 460;
//	format(600);
//	print (mSigma);	
//	print (mOmega);
	iVar = rows(mY);	
//	print (mJ_Phi);//, mJ_Omega, mJ_Delta, mDelta);

    // T|z matrix
	mPhi   = mPhi ** unit(iVar);
	mOmega = mOmega ** unit(iVar);
	mSigma = mSigma[:iStDim - 1][:iStDim - 1] ** unit(iVar) | 0;
//	format(600);
//	print ("cd ", mSigma);
//	print (mPhi);
//	print (mOmega);

	vP = zeros(2 + iStDim*iVar*(iVar + 1)/2, 1); // determine number of model parameters
//	vAllP = vP;
//	print (vP);
	vP[][0] = //log(2/(0. + 1) - 1); //correl of 0. for each correl...
//	print ("hello", vP);
	vP[0][0] = 2.7;//6503; //sqrt(sqr(rho)/(1 - sqr(rho))); //cycle dampening factor (transformed)
	vP[1][0] = 2.5;//3752;//log(22 - 2); //cycle frequency (transformed)
	vP[2:iVar + 1][0] = 0;//-1.5;//= vPUni[0][0]; // trend variance transformed
	vP[2 + iVar:2 + 2*iVar - 1][0] = 0;//-1.270237;//= vPUni[1][0]; // drift trans var
	vP[2 + 2*iVar: 2 + 3*iVar - 1][0] = 0;//-1.5; // cycle trans var
	vP[2 + 3*iVar:][0] = 0;//-1.424908; //= vPUni[2][0]; // measure trans var
//	for (iter = 1; iter <= rows(vP) - 2; ++iter)
//	{
//		vP[iter + 1][0] = iter/100;
//	}
//	print (vP, "\n");
	if (1 == 1)
	{		  /*
		vP = <2.7365;
		  2.4709;
		-0.48903;
		 -12;//-1.6042;
		 -12;//-1.5185;
		 -12;//-5.0310;
		 -12;//-5.0797;
		 -2.2031;
		 -3.3619;
		 -12;//-8.6353;
		 -2.4816;
		 -12;//-8.2528;
		 -1.4283;
		 -2.1395;
		 -2.5748;
		 -12;//-5.3416;
		 -12;//-5.5298;
		-0.68801;
		 -1.7149;
		 -1.8288;
		 -12;//-5.9045;
		 -1.7981;
		0.040156;
		-0.14004;
		-0.21961;
		 0.80341;
		-0.92855;
		-0.17057;
		-0.83767;
		-0.84766;
		-0.31185;
		0.031899;
		  1.2793;
		  1.0674;
		  1.4119;
		 0.65329;
		 0.13553;
		  3.3826;
		  1.6507;
		-0.32394;
		 -1.4265;
		 0.13114;
		 0.68370;
		  1.6803;
		 0.68814;
		 0.73728;
		  1.2689;
		-0.49473;
		  1.0203;
		-0.21629;
		  1.3441;
		-0.34481;
		 0.23708;
		-0.016565;
		 0.10623;
		-0.44657;
		-0.046633;
		-0.19451;
		  2.1080;
		 -1.2547;
		 -1.7540;
		-0.46093>;
			*/
		vP = <2.4797;
		  2.7208;
		-0.47165;
		-12;
		-12;
		-12;
		-12;
		 -2.3024;
		 -3.4870;
		 -12;
		 -2.4392;
		 -12;
		 -1.2656;
		 -1.5138;
		 -1.9841;
		 -12;
		 -12;
		-0.70190;
		 -1.6041;
		 -1.7420;
		 -12;
		 -1.0625;
		 0.11745;
		-0.16824;
		-0.12492;
		 0.74900;
		 0;
		 0;
		 0;
		 0;
		 0;
		 0;
		  1.2679;
		  1.0802;
		  1.3090;
		 0.70962;
		 0.14396;
		  4.0842;
		  2.0767;
		  0;
		  0;
		 0.16951;
		 0.53368;
		  1.7899;
		 0.58253;
		 0.86268;
		 0.54313;
		0.074798;
		0.0063874;
		 -1.2352;
		  1.3401;
		  0;
		 0.22433;
		-0.042252;
		0.060657;
		-0.48784;
		-0.23134;
		-0.14050;
		  1.3961;
		 -1.3221;
		 -1.4443;
		 0>;
	}

		  
//	print (vP);
	decl pvSco, vPjump = zeros(rows(vP) - 2, 1);
	pvSco = vP; // set correct vector length
	GetMultiModel (vP, &vPjump);
	Likelihood (vP, &dLik, &pvSco, 0);	
	decl id = checkskip (pvSco, vPjump, &vP); // check if parameter vector dim can be smaller & do it.
	pvSco = vP; // set correct vector length
//	vP = vP[0:1 + iStDim*iVar*(iVar + 1)/2 - id];
	println ("Dimension of vP: ", rows(vP));
	println ("After: ", vP');
//	s_vPskip = vPjump;
//	cutvP(&vP);

	println (dLik);

//	decl P;
//	P = choleski(mOmega);
//	print (P);
//	vp[13][0] = -5;
//	print (vP);
	dLik = emalg(2, &vP);

	s_vPskip = 0*s_vPskip;
	GetMultiModel (vP, &vPjump);
	pvSco = vP; // set correct vector length
	Likelihood (vP, &dLik, &pvSco, 0);	
	id = checkskip (pvSco, vPjump, &vP); // check if parameter vector dim can be smaller & do it.
	println ("Dimension of vP: ", rows(vP));
	println ("After: ", vP');
//	vP = vP[0:1 + iStDim*iVar*(iVar + 1)/2 - id];
//	print (vPtemp);
//	vAllP = vPtemp;
//	cutvP(&vP);
//	GetMultiModel(vP, &vPjump);
//	s_vPskip = vPjump;
//	print (vPjump');
//	cutvP(&vP);
	pvSco = vP; // set correct vector length
	Likelihood (vP, &dLik, &pvSco, 0);
	println (dLik, " Goodbye");
//	MaxControl (10, 1);
//	ir = MaxBFGS (Likelihood, &vP, &dLik, 0, 1);


//	print (P);
//	GetParam(P, &vP);
//	GetMultiModel(vP);
//	MaxControl (5, 1, 1);
//	MaxControlEps (1e-3, 1e-2);
//	ir = MaxBFGS (Likelihood, &vP, &dLik, 0, 0);
//	GetMultiModel(vP, &vPjump);
//	s_vPskip = vPjump;
//	cutvP(&vP);

	//MLE
//	Likelihood (vP, &dLik, 0, 0);
//	print (dLik);
//	MaxControlEps (1e-5, 1e-4);
	decl lastit = 25;
	decl factor = 2;
	decl Hess = unit(rows(vP));
	decl oldHess = Hess;
	decl oldLik = dLik;
	decl icount = 0;
	decl yesDer = 1; //use analytical derivatives
	for (i = 1; i <= 20; ++i)
	{
		println ("Afgerond naar nul bij: ", s_limit);
		MaxControl (lastit, 1, 0);
		println ("Am I here?");
		ir = MaxBFGS (Likelihood, &vP, &dLik, &Hess, yesDer);
		if (ir == 0)
		{
			break;
		}
		else // nog geen max gevonden, kijk op dim vP kleiner kan...
		{
			yesDer = 1; // stop using analytical derivatives...
			Hess = Hess*0;
			GetMultiModel (vP, &vPjump);
			Likelihood (vP, &dLik, &pvSco, 0);
			oldHess = Hess;
			CutHess(&Hess, lastit, oldLik, dLik, vPjump);
//			println ("is this good? ", Hess);
			id = checkskip (pvSco, vPjump, &vP); // check if parameter vector dim can be smaller & do it.
			println ("Vector smaller? ", id);
			if (id <= 0) // parameter reduction failed
			{
				if ((dLik - oldLik)/lastit < 0.0005)
				{
					Hess = oldHess; // use original Hessian without restrictions
				}
				else
				{
					Hess = unit(rows(vP));
				}
			}
			if ((dLik - oldLik)/lastit < 1e-5)
			{
				++icount;
				if (icount > 5) // trouble with convergence... try I
				{
					Hess = unit(rows(vP));
					icount = 0;
				}
				if (lastit > 40) // for first time here, need larger factor
				{
					factor = 1.5;
				}
				lastit = 40; // use small number to find restrictions
				s_limit = s_limit*factor; // near max reduce limit
				if (s_limit < 1e-5)
				{
					s_limit = 1e-5; // limit mag niet te klein worden
				}
			}
			else // not yet near max, do not reduce limit yet
			{
				lastit = lastit*factor; // use more iterations
			}
			factor = sqrt(factor);
			oldLik = dLik;
//			println ("vP: ", rows(vP), "Hess: ", rows(Hess));
			println ("restricties: ", s_vPskip);
			pvSco = vP; // set correct vector length (not really needed I do not believe...)
//			vP = vP[0:1 + iStDim*iVar*(iVar + 1)/2 - id];
		}
	}
//	print ("it returns a value of: ", ir, "\n");

    print ("\n", MaxConvergenceMsg(ir), " using analytical derivatives",
	       "\nFunction value = ", dLik, "; parameters: ", vP);

	print (format(600));
    print ("Omega ", "\n");
	outputCov(0, iVar-1); // prints out Omega with correlation in upper triangle
	outputCov(iVar, 2*iVar-1);
	outputCov(2*iVar, 3*iVar-1);
//		print (mOmega[15:19][15:19]);
	outputCov(4*iVar, 5*iVar-1);	
/*
    print ("Omega ", "\n");
	print (mOmega[0:iVar-1][0:iVar-1]);
	print (mOmega[iVar:2*iVar-1][iVar:2*iVar-1]);
	print (mOmega[2*iVar:3*iVar-1][2*iVar:3*iVar-1]);
//		print (mOmega[15:19][15:19]);
	print (mOmega[4*iVar:5*iVar-1][4*iVar:5*iVar-1]);
	print ("mPhi ", "\n", mPhi);
	print ("mSigma ", "\n", mSigma); */
	println ("Locaties van restricties: ", "\n", s_vPskip);
//    mD = SsfCondDens (ST_SMO, mY, mPhi, mOmega, mSigma);
//	mS = mY - <0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0> * mD;	
//	i = 0;
//	for (i = 0; i < columns(mY); ++i)
//	{
//    	print ("\n", mD[2][i], ",", mD[4][i], ",",  mD[6][i], ",",
//		             mD[8][i], ",",  mD[10][i], ",", 
//		             mD[12][i]);
//	}
	decl mest2, check;
	check = SsfMomentEst(ST_SMO, &mest2, mY, mPhi, mOmega, mSigma);
//    DrawTMatrix(0, mest2[0:4][], {"level"}, 1970, 1, 4);
	DrawTMatrix(0, mest2[iVar:2*iVar-1][], {"drift D", "drift Fr", "drift Sp",
		"drift It", "drift Nl"}, 1970, 1, 4);
	DrawTMatrix(1, mest2[2*iVar:3*iVar-1][], {"cycle D", "cycle Fr", "cycle Sp",
		"cycle It", "cycle Nl"}, 1970, 1, 4);
//	ShowDrawWindow();
	savemat("SM UCs isn.in7", mest2[:3*iVar-1][]');
/*
	decl covar, invcov;
	check = Num2Derivative(Likelihood, vP, &covar);
	if (!check)
	{
		println("Covar() failed in numerical second derivatives");
		return zeros(vP);
	}
	invcov = invertgen(-covar, 30);
	println ("standard errors:", "\n", vP ~ sqrt(diagonal(invcov)/columns(mY))' ~
										diag(1 ./sqrt(diagonal(invcov)/columns(mY)))
										* vP);

*/
//	println (mest2[][0]);
	decl mKF;
//	println("size mphi", rows(mPhi), " ", columns(mPhi));
	mKF = KalmanFil(mY, mPhi, mOmega, mSigma);

	decl holdDiag, F = zeros(5,5);
	decl v, vv=<>, qSum = zeros(125, 1);
	decl lnDiag = zeros(125, 1);
//	println (qSum);
	for (i = 2; i < columns(mY); ++i)
	{
//		println ("mKF: ", mKF[][i]);
		F = 0*F;
		F[0][0] = mKF[25][i];
//				println (F);
		F[0:1][1] = mKF[46:47][i];
//				println (F);
		F[0:2][2] = mKF[68:70][i];
//				println (F);
		F[0:3][3] = mKF[91:94][i];
//				println (F);
		F[0:4][4] = mKF[115:119][i];
//				println (F);
		holdDiag = diagonal(F);
//				println (F);
		F = setdiagonal(F, 0);
//				println (F);
		F = F + F';
//				println (F);
		F = setdiagonal(F, holdDiag);
		println ("F: ", F[0][0]);
		v = mKF[0:4][i];
//		println ("v: ", v);
		qSum[i][0] = v'*F*v;
		lnDiag[i] = i/124;
		if (i > 0)
		{
			qSum[i][0] += qSum[i-1][0]*124*5;//i*5;
			qSum[i] = qSum[i]/(124*5);//(5*(i + 1));
			println (i/124);
		}
		F = 0*F;
		F = setdiagonal(F, sqrt(holdDiag));
		vv ~= F*v;
//		println (F);
	}
	savemat("resid isn.in7", vv');
	savemat("forecast error isn.in7", mKF[0:4][]');
//	println (qSum);
	DrawTMatrix(2, (qSum[2:] ~ lnDiag[2:])', {"Cusum Residual Squared"}, 1970.5, 1, 4);
	savemat("qsum isn.in7", qSum[2:] ~ lnDiag[2:]);	
		ShowDrawWindow();
}



