#include <oxstd.h>
#include <maximize.h>
#include <packages\SsfPack\SsfPack.h>
#include <oxfloat.h>
#include <oxdraw.h>
#include <ranmc.h>
#pragma link("maximize.oxo")
#pragma link("ranmc.oxo")

static decl mPhi, mOmega, mSigma, mY, mStsm, iStDim, iVar, bUni, mDelta;
static decl s_limit, vAllP, s_vPskip, mX, mJ_Phi, mJ_Omega, mJ_Delta;

FixStartSig (const rho)
{
	decl j, i, rhoSq = (1 - rho^2);
	for (i = 2*iVar; i < 3*iVar; ++i)
	{
		for (j = i; j < 3*iVar; ++j)
		{
			if (rhoSq > 1e-50)
			{
				mSigma[i][j] = mOmega[i][j]/rhoSq;
				mSigma[j][i] = mSigma[i][j];
				mSigma[i + iVar][j + iVar] = mSigma[i][j];
				mSigma[j + iVar][i + iVar] = mSigma[i][j];
			}
			else
			{
				if (i == j)
				{
					mSigma[i][j] = 1e10; // diffuse
				}
				else
				{
					mSigma[i][j] = 0; // uncorrelated in diffuse
				}
				println ("warning on prior for cycle: zero variance! ", rho);
				mSigma[j][i] = mSigma[i][j];
				mSigma[i + iVar][j + iVar] = mSigma[i][j];
				mSigma[j + iVar][i + iVar] = mSigma[i][j];
			}
		}
	}
//	println ("Prior for cycle: ", mSigma);
}

GetUniModel (const vP)
{
	decl i, big;

	big = maxc(vP);
	//print (vP);
	for (i=0; i<4; ++i)
	{
//		if (vP[i][0] - big < -11.51) // to prevent underflow
//		{
//		    mOmega[i][i] = exp (2 * (-11.51 + big));
//		}
//		else if (vP[i][0] < 150) // to prevent overflow
//		{
	        mOmega[i][i] = exp (2 * vP[i]);//transform vars
//		}
//		else
//		{
//		    mOmega[i][i] = exp (300);
//		}
	}
	mOmega[4][4] = mOmega[3][3]; // move meas var to last spot
	mOmega[3][3] = mOmega[2][2]; //parameter = var*(1-rho^2)!!!
}

// afgeleiden van diagonale elementen van omega
dervPdiag (const Gamma, const rijvP, const rownum, const dimOm)
{
	decl deriv;
	decl i, j, mdG = zeros(dimOm, dimOm);
	decl v = rijvP[0]; // = exp(2 * rijvP[0]); changed, now exp(2*param) sent to routine
	for (i = rownum - 1; i < dimOm; ++ i)
	{
		for (j = i; j < dimOm; ++j)
		{
			if (i == rownum - 1)
			{
				if (j == rownum - 1)
				{
					mdG[i][j] = 1;
				}
				else
				{
					mdG[i][j] = rijvP[j - rownum + 1];
				}
			}
			else
			{
				mdG[i][j] = rijvP[i - rownum + 1] * rijvP[j - rownum + 1];
			}
			if (i != j)
			{
				mdG[j][i] = mdG[i][j];
			}
		}
	}
//	print (mdG);
	mdG = 2 * v * mdG;
//	print (mdG);
	deriv = 0.5 * trace(Gamma * mdG);
	return deriv;
}

// afgeleiden van niet diagonale elementen van omega
dervPoffdiag (const Gamma, const rijvP, const rownum, const colnum, const dimOm)
{
	decl deriv;
	if (rownum > colnum)
	{
		print ("Improper location in covariance matrix!", "\n");
		deriv = 0;
		return deriv;
	}
	decl i, mdG = zeros(dimOm, dimOm);
	decl v = rijvP[0]; //changed, was = exp(2 * rijvP[0]); // transform diagonal parameter
	mdG[colnum - 1][rownum - 1] = v; // first term of d(omega)/d(param)
	mdG[rownum - 1][colnum - 1] = v;
	for (i = rownum; i < dimOm; ++ i)
	{
		if (i == colnum - 1)
		{
			mdG[i][colnum - 1] = 2 * rijvP[i - rownum + 1] * v; // diagonal element
		}
		else
		{
			mdG[colnum - 1][i] = v * rijvP[i - rownum + 1]; // off-diagonal element
			mdG[i][colnum - 1] = mdG[colnum - 1][i];
		}
	}
	deriv = 0.5 * trace(Gamma * mdG);  // derivative is equal to...
	return deriv;
}

Iznogoed (const m, const n) //kijken of covarianties kloppen
{
	decl i, j, idim, mTemp = mOmega[m:n][m:n];
	idim = rows(mTemp);
	for (i = 0; i < idim; ++i)
	{
		for (j = i + 1; j < idim; ++j)
		{
			if (sqr(mTemp[i][j]) > mTemp[i][i]*mTemp[j][j]) // correlatie mag niet groter dan 1 in abs waarde zijn
			{
//				print ("i ", i, "j ", j, "m ",  m, "\n");
				if (mTemp[i][j] < 0)
				{
					mTemp[i][j] = -sqrt(mTemp[i][i]*mTemp[j][j]);
				}
				else
				{
//					print (mTemp[i][j], ", ", mTemp[i][i], ", ", mTemp[j][j], "\n");
					mTemp[i][j] = sqrt(mTemp[i][i]*mTemp[j][j]);
				}
				mTemp[j][i] = mTemp[i][j];
			}
		}
	}
	mOmega[m:n][m:n] = mTemp;
}

blowupvP(const vPkort)
{
    decl i, j, n, vP, vPretn;
	
	if (s_vPskip[0] > 0)
	{
		vP = zeros(2 + iStDim*iVar*(iVar + 1)/2, 1);
//		println (vPkort);
//		println (vP');
		vP[] = vPkort[0:1];
		vP[2:iVar*iStDim + 1] = -exp(600); // should cause a zero load
		vP[iVar*iStDim + 2:] = 0; // zero off diagonal
//		print (vAllP);
		j = 0;
		n = 2;
		for (i = 2; i < 2 + iStDim*iVar*(iVar + 1)/2; ++i)
		{
			if (s_vPskip[j] != i)
			{
				vP[i] = vPkort[n];
				++n;
			}
			else
			{
				++j; // laat null in vP staan... ga door naar volgende restrictie
			}
		}
		if (n + j != 2 + iStDim*iVar*(iVar + 1)/2)
		{
			print ("parameter vector not properly blown up!", "\n");
		}
	}
	else // no reduced dimension
	{
		vP = vPkort; // nothing to skip, no restrictions
	}
	vPretn = vP;
	return vPretn;
}

logitWegt (const wegt, const rho)
{
	if (rho > 600.0)
	{
		return wegt;
	}
	else if (rho < -600.0)
	{
		return 0.0;
	}
	else
	{
		decl ans;
		ans = wegt/(1 + exp(-rho));
		if (ans == M_NAN)
		{
			println ("logit problems: ", ans);
		}
		return ans;
	}
}

GetMultiModel (const vPkort, const avPjump)
{
    decl i, j, k, m, n, l, var, rho, lambda, trcos, trsin, Mat, tempI, tempI2;
	decl vP;

//	println ("SHORT: ", vPkort);
	vP = blowupvP(vPkort[:rows(vPkort) - 8][0]);
//	println ("BLOW: ", vP);
	vP = vP | vPkort[rows(vPkort) - 7:][0];
//	println ("ADD: ", vP);
// set D measurement error variance to 1 and store actual value
	decl dmeas = exp(2.0*vP[17]);
	vP[17] = 0.0;
//	restrictie:
//	vP[22] = 0.0;
//	println ("Result: ", vP);

//	print ("Dag", "\n", vAllP);
//	print ("verlaat", "\n", s_vPskip[0:min(5, rows(s_vPskip))-1][0]');
//	print ("Crit3: ", maxc(fabs((vP'-oldParm')./oldParm')'));
//	oldParm = vP;
	tempI = unit((iStDim) * iVar); // for with a cycle and measurement error
	tempI2 = tempI;
//	if (vP[0] < log(5) - log(995)) // this is no longer the correct transformation
//	{
//		rho = 0.995;
//	}
//	else
//	{
		rho = fabs(vP[0])/sqrt(sqr(vP[0]) + 1.0);
//	}
	lambda = M_2PI/(exp(vP[1]) + 2.0); //frequency
//	print (lambda, "\n");
    trcos = cos(lambda)*rho;
	trsin = sin(lambda)*rho;
//	print (trcos, ", ", trsin);
	Mat = unit(2);
	Mat[0][0:1] = trcos ~ trsin;
	Mat[1][0:1] = -trsin ~ trcos;
//	print (Mat);
	mPhi[2*iVar:4*iVar - 1][2*iVar:4*iVar - 1] = Mat ** unit(iVar);
//	print (format(600));
//	print (mPhi, "\n");
//	print (vP[][0]);
	
//	var = log(sumr(diagonal(mOmega))/((iStDim + 1)*iVar))/2; // log of average st. dev.
	
//	if (rho >= 0.995)
//	{
//		rho = log(1 - 0.995^2)/2;
//	}
//	else if (log(1 - rho^2) < -700)
//	{
//		rho = -350;
//	}
//	else
//	{
//		rho = log(1 - rho^2)/2;
//	}
//	format(600);
//	print ("cd ", mSigma);
//	print (mPhi);
//	print (mOmega);
//	decl io;
	decl lowerlimit = log(s_limit);
// fill in the variances along diagonal for trans eq.
    i = 2;
	k = 0;
	decl io = 0;
	for (l = 1; l < iStDim - 1; ++l) // diagonal for not cycle, measurement var's
	{
		var = maxc(vP[2 + iVar*(l - 1):iVar*l + 1]); // largest load factor of covariance (per block)
		for (j = 1; j <= iVar; ++j)
		{
		if (vP[i] - var < lowerlimit) // to prevent underflow
			{
			    tempI2[k][k] = 0.0;
//				print (vP[i], " i=", i, "\n");
//				print ("var=", var, "\n");
				avPjump[0][io][0] = i;
				++io;
			}
			else if (vP[i] < 170.0) // to prevent overflow
			{
		        tempI2[k][k] = exp (2 * vP[i]);//transform load
			}
			else
			{
			    tempI2[k][k] = exp (340);
			}
//			print (mOmega[k][k], " k= ", k, " 1 \n");  ??what is dit??
			i += 1;
			k += 1;
		}
	}
	var = maxc(vP[2 + iVar*2:iVar*3 + 1]); // largest load factor of covariance
	for (j = 1; j <= iVar; ++j) // for the cycle variances load
	{
		if ((vP[i] - var < lowerlimit) || (log(1.0 - sqr(rho)) <= lowerlimit))
		{
		    tempI2[k][k] = 0.0;
//			print (vP[i], " i=", i, "\n");
//			print ("var=", var, "\n");
			avPjump[0][io][0] = i;
			++io;
		}
		else if (vP[i] < 170)
		{
	        tempI2[k][k] = exp(2*vP[i]); //transform load
		}
		else
		{
			tempI2[k][k] = exp(340);
		}
//		if (log(1.0 - sqr(rho)) <= lowerlimit)
//		{
//			tempI2[k][k] = 0.0;
//		}
		i += 1;
		k += 1;
	}
// diagonal elements (variances) for measurements
//  print (diagonal(mOmega));
// overwrite second variance block from cycle load
	var = maxc(vP[2 + iVar*3:iVar*4 + 1]); // largest load factor of covariance	
	for (j = 1; j <= iVar; ++j)
	{
		if (vP[i] - var < lowerlimit) // to prevent underflow
		{
		    tempI2[k][k] = 0.0;
//			print (vP[i], " i=", i, "\n");
//			print ("var=", var, "\n");
			avPjump[0][io][0] = i;
			++io;
		}
		else if (vP[i] < 170) // to prevent overflow
		{
	        tempI2[k][k] = exp (2 * vP[i]);//transform vars load
		}
		else
		{
		    tempI2[k][k] = exp (340);
		}
//		print (mOmega[k][k], " k= ", k, " 2 \n"); ??waarvoor is dit??
		i += 1;
		k += 1;
	}
// now off diagonal elements (covariances)
	n = 0;
	for (j = 1; j <= iStDim; ++j) // number of covariance blocks - 1; overwrite second cycle
	{
		for (k = 1; k < iVar; ++k) // walk down the diagonal...
		{
			m = n + 1;
			for (l = 1; l <= iVar - k; ++l) // number covar's per block, also not work with seas
			{
				tempI[n][m] = vP[i];
				if (tempI2[n][n] == 0)
				{
					tempI[n][m] = 0.0;
//					print (avPjump[0][][]', io);
					avPjump[0][io][0] = i;
					++io;
				}
//				{
//					format ("%#15.7g");
//					print (vP[i]);
//				}
//				print (n, ", 3, ", m, ", ", i, ", ", vP[i], ", ", mOmega[n][m], "\n");
				i += 1;
				m += 1;
			}
			n += 1;
		}
		n += 1;
//		print (n, ", ", m, "\n"); 
	}

//	print (format(600));
//	print (mOmega);
//	print (i);
	decl rijvP = zeros(rows(tempI), iVar); // nodig voor afgeleiden
	j = iVar - 1;
	for (i = 0; i < rows(tempI); ++i)
	{
		if (j < 0)
		{
			j = iVar - 1;
		}
		rijvP[i][:j] = tempI[i][i:j + i];
		--j;
	}
	rijvP[][0] = diagonal(tempI2)';
//	print (diagonal(tempI2), "\n");
//	print (tempI);
	
	mOmega[:iVar * iStDim][:iVar * iStDim] = tempI' * tempI2 * tempI;

// now put measurement covar's where belong:
	mOmega[iVar * iStDim:][iVar * iStDim:]
		= mOmega[iVar * (iStDim - 1): iVar * iStDim - 1][iVar * (iStDim - 1): iVar * iStDim - 1];

// now copy cycle into second block:
	mOmega[iVar * (iStDim - 1): iVar * iStDim - 1][iVar * (iStDim - 1): iVar * iStDim - 1]
		= mOmega[iVar * (iStDim - 2): iVar * (iStDim - 1) - 1]
			[iVar * (iStDim - 2): iVar * (iStDim - 1) - 1];
//	format(600);
//	print (mOmega);
//	format(600);
//	print (mSigma);
//	print (mPhi);
//	print (diagonal(mOmega));
	Iznogoed (0, iVar - 1); //mOmega[0:4][0:4]);
//	print (mOmega[0:4][0:4]);
	Iznogoed (iVar, 2*iVar - 1); //mOmega[5:9][5:9]);
//	print (mOmega[5:9][5:9]);
	Iznogoed (2*iVar, 3*iVar - 1); //mOmega[10:14][10:14]);
//	print (mOmega[10:14][10:14]);
//	Iznogoed (mOmega[15:19][15:19]);
//	print (mOmega[15:19][15:19]);
	mOmega[3*iVar:4*iVar - 1][3*iVar:4*iVar - 1] = mOmega[2*iVar:3*iVar - 1][2*iVar:3*iVar - 1];
	Iznogoed (4*iVar, 5*iVar - 1); //mOmega[20:24][20:24]);
//	print (mOmega[20:24][20:24]);
//	print (mPhi);
//	if (avPjump[0][0] != 0)
//	{
//		println (avPjump[0][0:5]');
//		println (s_vPskip');
//		println (rows(vPkort));
//		if (avPjump[0][6] != 0)
//		{
//			println (avPjump[0][6:11]');
//		}
//	}
	decl oldwegt = tempI2[8][8];	// laat een drift gewicht naar 0 gaan...
	decl oldwegtc = tempI2[12][12]; // laat een cyclus gewicht naar 0 gaan...
	decl concenLvar = exp(2.0*vP[rows(vP) - 1][0]); // part of concentrated var with logit
	decl concenvar;
	m =  vP[rows(vP) - 2][0]; //Dit zorgt ervoor dat logit een gewicht van 1 geeft bij i=0:
	rho = m*vP[rows(vP) - 5][0];
	concenvar = 1;
	decl korFak = (1 - logitWegt(concenvar, rho))*concenLvar; // hoe dicht bij 1 begint de logitfunctie? Correctiefactor!
//	println (mOmega[5:9][5:9]);
	for (i = 0; i < columns(mY); ++i)
	{
		j = i + vP[rows(vP) - 4][0];
		n = i + vP[rows(vP) - 3][0];
		m = i + vP[rows(vP) - 2][0];
		rho = j*vP[rows(vP) - 7][0];
//		println ("j= ", j, ", vP= ", vP[rows(vP) - 1][0], ", logit: ", rho);
		tempI2[8][8] = logitWegt(oldwegt, rho);
		rho = n*vP[rows(vP) - 6][0];
		tempI2[12][12] = logitWegt(oldwegtc, rho);//2*oldwegtc * rho/(1.0 + rho);
//		println (tempI2[7][7]);
		rho = m*vP[rows(vP) - 5][0];
		concenvar = dmeas + logitWegt(concenLvar, rho) + korFak;
// trend:
		mX[0:4][i] = mOmega[0:4][0] * concenvar;
		mX[5:8][i] = mOmega[1:4][1] * concenvar;
		mX[9:11][i] = mOmega[2:4][2] * concenvar;
		mX[12:13][i] = mOmega[3:4][3] * concenvar;
		mX[14][i] = mOmega[4][4] * concenvar;
//
		Mat = tempI[iVar:2*iVar - 1][iVar:2*iVar - 1]'
			  * tempI2[iVar:2*iVar - 1][iVar:2*iVar - 1]
			  * tempI[iVar:2*iVar - 1][iVar:2*iVar - 1];
//
		mOmega[iVar:2*iVar - 1][iVar:2*iVar - 1] = Mat;
		Iznogoed (iVar, 2*iVar - 1); //mOmega[5:9][5:9]);
// drift:
		mX[15:19][i] = mOmega[5:9][5] * concenvar;
		mX[20:23][i] = mOmega[6:9][6] * concenvar;
		mX[24:26][i] = mOmega[7:9][7] * concenvar;
		mX[27:28][i] = mOmega[8:9][8] * concenvar;
		mX[29][i] = mOmega[9][9] * concenvar;
		
//		println ("What?");
//
		Mat = tempI[2*iVar:3*iVar - 1][2*iVar:3*iVar - 1]'
			  * tempI2[2*iVar:3*iVar - 1][2*iVar:3*iVar - 1]
			  * tempI[2*iVar:3*iVar - 1][2*iVar:3*iVar - 1];
//
		mOmega[2*iVar:3*iVar - 1][2*iVar:3*iVar - 1] = Mat;
		Iznogoed (2*iVar, 3*iVar - 1); //mOmega[10:14][10:14]);
//cycle:
		mX[30:34][i] = mOmega[10:14][10] * concenvar;
		mX[35:38][i] = mOmega[11:14][11] * concenvar;
		mX[39:41][i] = mOmega[12:14][12] * concenvar;
		mX[42:43][i] = mOmega[13:14][13] * concenvar;
		mX[44][i] = mOmega[14][14] * concenvar;

// measure:
		mX[45:49][i] = mOmega[20:24][20] * concenvar;
		mX[50:53][i] = mOmega[21:24][21] * concenvar;
		mX[54:56][i] = mOmega[22:24][22] * concenvar;
		mX[57:58][i] = mOmega[23:24][23] * concenvar;
		mX[59][i] = mOmega[24][24] * concenvar;
		
//		println ("What?");
//		println (mX[][i]');
	}
//	println (mX');
	rho = fabs(vP[0])/sqrt(sqr(vP[0]) + 1.0);
	FixStartSig (rho);
	return rijvP;
}


GetParam (const tempP, const avP)
{
    decl i, j, k, m, n, l, P, vPtemp = zeros(2 + iStDim*iVar*(iVar + 1)/2, 1);
	vPtemp[0:1] = avP[0][0:1][0];
// cut out extra cycle covar
	P = tempP;
// transform the variances along diagonal for trans eq.
    i = 2;
	k = 0;
	for (l = 1; l < iStDim - 1; ++l) // diagonal for not cycle, measurement var's
	{
		for (j = 1; j <= iVar; ++j)
		{
			if (P[k][k] > exp(-350))
			{
				vPtemp[i] = log(P[k][k]);
			}
			else
			{
				vPtemp[i] = -350;
			}
			i += 1;
			k += 1;
		}
	}
	for (j = 1; j <= iVar; ++j) // for the cycle variances load
	{
		if (P[k][k] > exp(-350))
		{
			vPtemp[i] = log(P[k][k]);
		}
		else
		{
			vPtemp[i] = -350;
		}
		i += 1;
		k += 1;
	}
// diagonal elements (variances) for measurements
	
	for (j = 1; j <= iVar; ++j)
	{
		if (P[k][k] > exp(-350))
		{
			vPtemp[i] = log(P[k][k]);
		}
		else
		{
			vPtemp[i] = -350;
		}
		i += 1;
		k += 1;
	}
// now off diagonal elements (covariances)
	n = 0;
	for (j = 1; j <= iStDim; ++j) // number of covariance blocks - 1; overwrite second cycle
	{
		for (k = 1; k < iVar; ++k) // walk down the diagonal...
		{
			m = n + 1;
			for (l = 1; l <= iVar - k; ++l) // number covar's per block, also not work with seas
			{
				if (P[n][n] > exp(-350))
				{
					vPtemp[i] = P[n][m];//sqr(P[n][n]); ?Is dit niet fout?
				}
				else
				{
					vPtemp[i] = 0.0;
				}
				i += 1;
				m += 1;
			}
			n += 1;
		}
		n += 1;
//		print (n, ", ", m, "\n"); 
	}
	avP[0][0:8][0] = vPtemp[0:8][0];
	avP[0][12:rows(avP[0]) - 2][0] = vPtemp[12:][0];
}

RestLik(const vshortP, const apdLik, const apvSco, const apmHes)
{
	decl dfval, vnewP = vAllP;
	println ("Dit mag je nooit zien in dit programma! FOUT!");
	vnewP[0:1] = vshortP[0:1];
	decl tempvParm = blowupvP(vnewP[:rows(vnewP) - 5][0]);
	tempvParm[9:11] = vshortP[2:4];
	tempvParm[14:16] = vshortP[5:7];
	tempvParm[39:41] = vshortP[8:10];
	tempvParm[49:51] = vshortP[11:13];
	tempvParm = tempvParm | vshortP[14:17];
//	print (vnewP);
	decl junk, vJump;
	vJump = zeros(2 + iStDim*iVar*(iVar + 1)/2, 1);
	decl olds_skips = s_vPskip;
	s_vPskip = 0*s_vPskip;
	junk = GetMultiModel(tempvParm, &vJump);
	s_vPskip = olds_skips;
	decl dVar;
	dfval = SsfLik (apdLik, &dVar, mY, mPhi, mOmega, mSigma, mDelta,
					mJ_Phi, mJ_Omega, mJ_Delta, mX);
	if (dfval != 0)
	{
		apdLik[0] = apdLik[0]/(columns(mY));
	}
	else
	{
		apdLik[0] = -exp(700);
	}
	return dfval;
}

cutvP(const avP, const vPjump)
{
	decl j = 0;
	if (vPjump[0] != 0)
	{
		decl i, n = 1;
//		print ("Before: ", avP[0][][0]');
		decl vPtemp = blowupvP(avP[0]); // voor in het geval dat al eerder geknipt hebt
		for (i = 2; i < 2 + iStDim*iVar*(iVar + 1)/2; ++i) // rho en lambda mogen er niet uit
		{
			if (vPjump[j] != i)
			{
				++n;
				avP[0][n][0] = vPtemp[i];
			}
			else
			{
				++j;
			}
		}
		avP[0] = avP[0][0:n][0] | avP[0][rows(avP[0][][]) - 7:][0];
//		print ("vP cut: ", "\n", avP[0]);
//		print ("vAllP: ", "\n", vAllP);
	}
	else
	{
		print ("Niets te knippen uit parametervector!", "\n");
//		print (vPjump[0]);
	}
	return j; // return total number of restrictions
}

afgeleid (const rijvP, const mSco, const vP) // afgeleiden uitrekenen
{
	decl i, io, in, j, k, m, n, derivP = zeros(6 + iStDim*iVar*(iVar + 1)/2, 1);
	decl derivPretn;
	println ("FOUT! HIER mag je nooit zijn in dit programma!");
	m = 0;
	n = iVar - 1;
	j = 1;
	k = 1;
	io = 0;
	in = 2;
	for (i = 2; i <= iVar * iStDim + 1; ++i)	//do diagonals first
	{
		if (i >= j * iVar + 2) // whether next block of covar or not
		{
			k = 1;
			m = j * iVar;
			++j;
			n = j * iVar - 1;
		}
//		print ("i=", i, " m=", m, " n=", n, "\n");
//		print (columns(mSco), rows(mSco), "\n");
//		print (mSco[m:n][m:n]);
//		print (rijvP[i - 2][]);
//		print ("k=", k, "\n");
//		if (s_vPskip[io] != i)
//		{
			derivP[in] = dervPdiag (mSco[m:n][m:n], rijvP[i - 2][], k, iVar);
			++in;
//		}
//		else
//		{
//			++io;
//		}
//		print (derivP[i], "\n");
		++k;
	}
	k = 0;
	decl rownum = 1;
	decl colnum = 2;
	m = 0;
	n = iVar - 1;
	j = 1;
	for (i = iVar * iStDim + 2; i < 2 + iStDim*iVar*(iVar + 1)/2; ++i) // offdiagonals
	{
//		print ("i=", i, " m=", m, " n=", n, " row=", rownum, " col=", colnum, "\n");
//		print (columns(mSco), rows(mSco), "\n");
//		print (mSco[m:n][m:n]);
//		print (rijvP[k][]);
//		print ("k=", k, "\n");
//		if (s_vPskip[io] != i)
//		{
			derivP[in] = dervPoffdiag (mSco[m:n][m:n], rijvP[k][], rownum, colnum, iVar);
			++in;
//		}
//		else
//		{
//			++io;
//		}
//		print (derivP[i], "\n");
		++colnum;
		if (colnum > iVar)
		{
			++rownum;
			++k;
			colnum = rownum + 1;
		}
		if (rownum >= iVar)
		{
			++k; // no off-diagonals
			rownum = 1;
			colnum = 2;
			m = j * iVar;
			++j;
			n = j * iVar - 1;
		}
	}
	vAllP = vP;
	decl vshortP = vP[0:17];
	decl tempvParm = blowupvP(vP);
	vshortP[2:17][0] = tempvParm[9:11][0] | tempvParm[14:16][0]
	                 | tempvParm[39:41][0] | tempvParm[49:51][0]
					 | vP[rows(vP) - 4:][0];
	decl vtempD = 0*vshortP;
	derivP = derivP/(columns(mY));
//	print (derivP', " what 1", "\n");
	Num1Derivative(RestLik, vshortP, &vtempD);
	derivP[0:1] = vtempD[0:1];
	derivP[9:11] = vtempD[2:4];
	derivP[14:15] = vtempD[5:7];
	derivP[39:41] = vtempD[8:10];
	derivP[49:51] = vtempD[11:13];
//	println ("rows derivP: ", rows(derivP));
	derivP[rows(derivP) - 4:] = vtempD[14:];
//	print (derivP', " if 2", "\n");
	decl oldskip = s_vPskip; // bewaar eerste waarde
	decl vPjump = s_vPskip; // gebruik huidige skip
	s_vPskip = 0*s_vPskip; // niets om op te blazen, ervanuit gegaan van 0 restrictie bij opbouw van derivP
//	n = rows(derivP);
//	if (vPjump[0] != 0)
//	{
//		println (derivP');
//	}
	j = cutvP(&derivP, vPjump); // snij restricties weg
//	derivP = derivP[0:n - j - 1];
	s_vPskip = oldskip; // zet waarde terug
	derivPretn = derivP;
//	print (derivP', "\n", rows(derivP), "\n");
	return derivPretn;
}

Likelihood (const vP, const apdLik, const apvSco, const apmHes)
{
    decl dVar, mSco, i, dfval, rijvP, vPjump;
//	print ("In: ", garbage, "\n");
	vPjump = zeros(iStDim*iVar*(iVar + 1)/2, 1);

	if (bUni)
	{
		GetUniModel(vP);
	}
	else
	{
		rijvP = GetMultiModel(vP, &vPjump);
//		print (mOmega[0:4][0:4]);
//		print (mOmega[5:9][5:9]);
//		print (mOmega[10:14][10:14]);
//		print (mOmega[15:19][15:19]);
//		print (mOmega[20:24][20:24]);
//		print (rijvP);
	}

	if (isarray(apvSco))
	{
//		print (mOmega);
		println ("Hier moet je niet zijn. Een FOUT dus...!");
	    dfval = SsfLikSco (apdLik, &dVar, &mSco, mY, mPhi, mOmega, mSigma, mDelta,
						   mJ_Phi, mJ_Omega, mJ_Delta, mX);
//		print ("Variance: ", dVar, "\n", mSco[0:5][0:5]);
//		print (dfval, "\n");
		if (dfval > 0)
		{
//			print (mSco);
//			print (mSco[0:4][0:4]);
//			print (mSco[5:9][5:9]);
//			print (mSco[10:14][10:14]);
//			print (mSco[20:24][20:24]);
			mSco[2*iVar:3*iVar-1][2*iVar:3*iVar-1] = mSco[2*iVar:3*iVar-1][2*iVar:3*iVar-1]
			                                       + mSco[3*iVar:4*iVar-1][3*iVar:4*iVar-1]; // cycle is double
			mSco[3*iVar:4*iVar-1][3*iVar:4*iVar-1] = mSco[4*iVar:5*iVar-1][4*iVar:5*iVar-1]; // cycle is double
			apvSco[0] = afgeleid (rijvP, mSco, vP); // rekenen afgeleiden
//			println ("WHY? ");
//			println (apvSco[0]);
//			println ("derivatives: ", "\n", apvSco[0]);
//		print (pvSco[0], diagonal(mSco)', mOmega);
//		pvSco[0][0][0] = mOmega[0][0] * mSco[0][0];     //from transfomed
//		pvSco[0][1][0] = mOmega[1][1] * mSco[1][1];       //derivative to
//		pvSco[0][2][0] = mOmega[2][2] * mSco[2][2] + mOmega[3][3] * mSco[3][3];
//		pvSco[0][3][0] = mOmega[4][4] * mSco[4][4];
//		pvSco[0][3][0] = mOmega[3][3] * trace(mSco[3:13][3:13]);
//		pvSco[0][3][0] = mOmega[13][13] * mSco[13][13];  
		}
		else
		{
			apdLik[0] = -exp(700);
		}
		
//		print (pvSco[0], "HEY! Should not be here, derivatives not right!");		
	}	
	else
	{
//		println ("Numerical derivatives!");
	    dfval = SsfLik (apdLik, &dVar, mY, mPhi, mOmega, mSigma, mDelta,
						mJ_Phi, mJ_Omega, mJ_Delta, mX);
		if ((dVar < 0) || (isnan(apdLik[0])) || (isdotinf(apdLik[0])))	// if pred. var <0 or like not defined
		{ // this is missing from version with derivatives above
			apdLik[0] = -exp(700);
			print (mOmega[0:4][0:4]);
			print (mOmega[5:9][5:9]);
			print (mOmega[10:14][10:14]);
			print (mOmega[20:24][20:24]);
			print ("trouble", "\n");
		}
//		print (apdLik[0]);
//		if(rows(vP) > 55)
//		{
//			print (vP[55:][0]');
//		}
	}
	
//	print (dVar);
//	format(600);
//	print (mOmega);
//	print ("Out: ", garbage, ", ", apdLik[0], "\n");
//	print ("Crit1: ", fabs((garbage - apdLik[0])/garbage), "\n");
//	garbage = apdLik[0];
	apdLik[0] = apdLik[0]/(columns(mY)); // is dit wel goed?
	return dfval;
}

GenCholeski(const P, const lim)
{
	decl Pdim, i, j, k, var, C;
	Pdim = rows(P);
	C = zeros(Pdim, Pdim);
//	print (C, ", ", Pdim, ", ", P);
	
	if (Pdim != columns(P))
	{
		println ("Input matrix not square!");
		return 0;
	}

	var = sqrt(maxc(diagonal(P)')); // maximum diagonal element
//	print (var);

	k = 0;
	i = 0;
	while (k == 0) // find first non-zero row
	{
//		print (P[i][i]);
		C[i][i] = sqrt(P[i][i]); // diagonal element (root of)
		if (C[i][i]/var >= lim)
		{
			for (j = i + 1; j < Pdim; ++j)
			{
				C[i][j] = P[i][j]/P[i][i]; // off diagonal elements 
			}
			++k;
//			print (k);
		}
		++i; // next row
	}

	k = i; // begin first row after first non-zero row
	for (i = k; i < Pdim; ++i)
	{
		C[i][i] = P[i][i];
		for (j = 1; j <= i; ++j)
		{
			C[i][i] = C[i][i] - sqr(C[i - j][i]*C[i - j][i - j]);
		}
		if (C[i][i] > 0.0)
		{
			C[i][i] = sqrt(C[i][i]); // diagonal element (root of)
		}
		else
		{
			C[i][i] = 0.0;
		}
		if (C[i][i]/var >= lim) // if non zero diagonal element find off diag's
		{
			for (j = i + 1; j < Pdim; ++j)
			{
				C[i][j] = P[i][j];
				for (k = 1; k <= i; ++k)
				{
					C[i][j] = C[i][j] - sqr(C[i - k][i - k])*C[i - k][j]*
							C[i - k][i];
				}
				 C[i][j] = C[i][j]/sqr(C[i][i]); // off diagonal element
			}
		}
	}
	decl temp2 = sqr(C);
//	println (temp2);
	temp2 = diagonalize(temp2);
//	println (temp2);
	decl temp1 = C;
	temp1 = upper(temp1);
//	println (temp1);
	temp1 = setdiagonal(temp1, ones(Pdim, Pdim));
//	println (temp1);
	
	
	
	if (temp1'*temp2*temp1 != P)
	{
		println ((temp1'*temp2*temp1 != P));
		println (C);
		println (temp1'*temp2*temp1);
		println (P);
	}
	return C;
}

emalg(const iter, const avP)
{
	decl mSco, mest2, P, limit, check, step, moldOmega, doldLik, dVar, dLik;
	P = mOmega;
	println ("Check dim vP: ", rows(avP[0]));
	step = columns(mY);
	check = SsfLikSco(&dLik, &dVar, &mSco, mY, mPhi, mOmega, mSigma, mDelta,
					  mJ_Phi, mJ_Omega, mJ_Delta, mX);
	if (check == 0)
	{
		print ("problem with KF in EM", "\n");
		return check;
	}
	mSco = mSco/step;
	doldLik = dLik;
	moldOmega = mOmega;
	decl i, mNewOm = mOmega;
	decl rho = fabs(avP[0][0])/sqrt(sqr(avP[0][0]) + 1.0);
	print (s_limit, dLik/(columns(mY)));
	for (i=1; i<=iter; ++i)
	{
		mNewOm = mOmega + mOmega*mSco*mOmega;
		mOmega[0:iVar-1][0:iVar-1] = mNewOm[0:iVar-1][0:iVar-1];
//		mOmega[iVar:2*iVar-1][iVar:2*iVar-1] = mNewOm[iVar:2*iVar-1][iVar:2*iVar-1];
		mOmega[2*iVar:3*iVar-1][2*iVar:3*iVar-1] = (mNewOm[2*iVar:3*iVar-1][2*iVar:3*iVar-1] + mNewOm[3*iVar:4*iVar-1][3*iVar:4*iVar-1])/2;
		mOmega[3*iVar:4*iVar-1][3*iVar:4*iVar-1] = mOmega[2*iVar:3*iVar-1][2*iVar:3*iVar-1];
		mOmega[4*iVar:5*iVar-1][4*iVar:5*iVar-1] = mNewOm[4*iVar:5*iVar-1][4*iVar:5*iVar-1];		
		print (mOmega[0:iVar-1][0:iVar-1]);
		print (mOmega[iVar:2*iVar-1][iVar:2*iVar-1]);
		print (mOmega[2*iVar:3*iVar-1][2*iVar:3*iVar-1]);
//		print (mOmega[15:19][15:19]);
		print (mOmega[4*iVar:5*iVar-1][4*iVar:5*iVar-1]);
		FixStartSig (rho);
		check = SsfLikSco(&dLik, &dVar, &mSco, mY, mPhi, mOmega, mSigma, mDelta,
						  mJ_Phi, mJ_Omega, mJ_Delta, mX);
		print (dLik/(columns(mY)), ", ", dVar, ", ", check, "\n");
//		check = SsfLik(&dLogLik, &dVar, mY, mPhi, mOmega, mSigma);
//		print (dLogLik, ", ", dVar, ", ", check, "\n");
//		check = SsfLikConc(&dLogLik, &dVar, mY, mPhi, mOmega, mSigma);
//		print (dLogLik, ", ", dVar, ", ", check, "\n");		
		if ((dVar <= 0) || (dLik <= doldLik) || (check != 1))
		{
			mOmega = moldOmega;
			FixStartSig (rho);
			print ("variantie: ", dVar, " KF check: ", check, "\n");
			dLik = doldLik;
			step = step*2.0;
			check = SsfLikSco(&dLik, &dVar, &mSco, mY, mPhi, mOmega, mSigma, mDelta,
							  mJ_Phi, mJ_Omega, mJ_Delta, mX);
			mSco = mSco/step;
		}
		else
		{
			mSco = mSco/step;
//			step = step*0.99;
//			print (step, "\n");
//			if (step < 100)
//			{
//				step = 100;
//			}
		}
//		mOmega = mOmega + mOmega*mSco*mOmega;
		moldOmega = mOmega;
		doldLik = dLik;
		check = SsfMomentEst(ST_SMO, &mest2, mY, mPhi, mOmega, mSigma, mDelta,
							 mJ_Phi, mJ_Omega, mJ_Delta, mX);
//    DrawTMatrix(0, mest2[0:4][], {"level"}, 1970, 1, 4);
		DrawTMatrix(0, mest2[iVar:2*iVar-1][], {"drift"}, 1970, 1, 4);
		DrawTMatrix(1, mest2[2*iVar:3*iVar-1][], {"cycle"}, 1970, 1, 4);
		ShowDrawWindow();
	}
	P[0:iVar-1][0:iVar-1] = GenCholeski(mOmega[0:iVar-1][0:iVar-1], s_limit);
//	if (P[0:4][0:4]'*P[0:4][0:4] != mOmega[0:4][0:4]) //this should NOT work!
//	{
//		println("warning!");
//	}
	P[iVar:2*iVar-1][iVar:2*iVar-1] = GenCholeski(mOmega[iVar:2*iVar-1][iVar:2*iVar-1], s_limit);
	P[2*iVar:3*iVar-1][2*iVar:3*iVar-1] = GenCholeski(mOmega[2*iVar:3*iVar-1][2*iVar:3*iVar-1], s_limit);
	P[3*iVar:4*iVar-1][3*iVar:4*iVar-1] = GenCholeski(mOmega[4*iVar:5*iVar-1][4*iVar:5*iVar-1], s_limit);
	check = SsfLik(&dLik, &dVar, mY, mPhi, mOmega, mSigma, mDelta,
				   mJ_Phi, mJ_Omega, mJ_Delta, mX);
	print (dLik/(columns(mY)), " hello");
//	decl vPtemp = vAllP;
	if (check != 0)
	{
		GetParam(P, avP);
	}
	else
	{
		dLik = check;
	}
	return dLik;
}

CutHess(const aHess, const iter, const oldLik, const dLik, const vPjump) // remove row & col of Hessian where new restriction
{
	decl i, j, temp = aHess[0];
//	println ("In Hess: ", aHess[0]);
//	println ("Skip: ", s_vPskip');

	j = 0;
	for (i = 0; i < iStDim*iVar*(iVar + 1)/2; ++i)
	{
//		println ("jump: ", vPjump[i]);
		if (vPjump[i] == 0)
		{
			break; // no restrictions any more
		}
		else
		{
//			println ("Test: ", vPjump[i] != s_vPskip);
			if (vPjump[i] != s_vPskip) // check if restriction is new
			{
//				println (vPjump[i] - j);
				temp = dropc(temp, vPjump[i]-j);
				temp = dropr(temp, vPjump[i]-j);
//				print  ("tussen: ", temp);
				++j;
			}
			else
			{
				++j;
			}
		}
	}
	println ("change per iter: ", (dLik - oldLik)/iter);
	if ((dLik - oldLik)/iter < 0.001) // dichtbij genoeg om Hessian te houden
	{
		aHess[0] = temp;
	}
	else // anders gebruik nieuwe E matrix...
	{
		aHess[0] = unit(rows(temp));
	}
//	println ("Out Hess: ", aHess[0], temp);
}

checkskip(const pvSco, const vPjump, const avP) // routine to reduce vP dimension
{
	decl i, logica, pvDer;
	logica = (vPjump[0] != 0);
//	print (vPjump');
	i = 0;
	if (vPjump[0] == 0) // no restrictions
	{
		print ("Parameter vector dimension not reduced.", "\n");
	}
	else
	{
//		println ("Enter: ", pvSco');
		pvDer = blowupvP(pvSco); // get blown up derivative vector
//		println ("Exit: ", pvDer);
		for (i = 0; i < iStDim*iVar*(iVar + 1)/2; ++i)
		{
//			print (vPjump[i], "\n");
			if (vPjump[i] != 0) // zijn er nog restricties?
			{
//				print ((s_vPskip .!= vPjump[i]) == TRUE, "\n");
				if ((s_vPskip != vPjump[i]) == TRUE) // restrictie nog niet ingevoerd?
				{
					logica = (pvDer[vPjump[i]] == 0.0); // restrictie klopt?
//					print ("Deriv = 0 ", logica, "\n");
					if (logica == FALSE)
					{
						print ("Error!. Cannot reduce parameter dimension!", "\n");
//						println (vPjump[i], "a ", pvDer[vPjump[i]], "b ", i);
						break; // nieuwe restrictie onbetrouwbaar, stop

					}
				}
			}
			else
			{
				break; // no more restrictions
			}
		}
	}
	i = 0;
	if (logica)
	{
		i = cutvP(avP, vPjump);
		s_vPskip = vPjump; // restricties lijken ok te zijn, voer ze in.
//		print (s_vPskip');
	}
	return i;
}

outputCov (const m, const n) // print stuk van Omega met correlatiecoef. in boven driehoek
{
	decl i, j, idim, mTemp = mOmega[m:n][m:n];
	idim = rows(mTemp);
	for (i = 0; i < idim; ++i)
	{
		for (j = i + 1; j < idim; ++j)
		{
			mTemp[i][j] = mTemp[j][i]/sqrt(mTemp[i][i]*mTemp[j][j]);
		}
	}
	println ("stuk Omega van: ", m, " tot: ", n, "\n", mTemp);
}

main()
{
    decl mhes, ir, dLik, dVar, mD, mS, i, mSc, iter, irep, vP, vPUni, mp2, mYulti, rho;

	// Get data:
	mY = loadmat ("F:\proefschrift\DATA\International\DFrSpItNl ox70.xls")';
//	iNumObs = columns(mY);                       // number of observations
	print (mY', "\n");
	mY = mY[0:1][] | mY[3][] | mY[2][] | mY[4][];
	mX = zeros(60, columns(mY));//mY | mY[0][];
//	mX = mX | mX;
	// specify model:
	s_vPskip = <0>; // elements of parameter vector to be skipped (none at start)
	s_limit = sqrt(1.0e-8);
	bUni = 0;
	iStDim = 4; // input the dimension of the state
	mStsm = <CMP_IRREG,       1e-2,   0, 0;
         	 CMP_LEVEL,       0.77,   0, 0;
           	 CMP_SLOPE,       0.026,  0, 0;				 
			 CMP_CYC_0,       0.1,   12, 0.9>;

	mStsm[3][2] = M_2PI/20.0;
	rho = 0.92;
    GetSsfStsm (mStsm, &mPhi, &mOmega, &mSigma);

	if (iStDim != columns(mPhi))
	{
		print ("Dimension of the state vector misspecified!", "\n");
	}

//	mSigma[0][0] = 460;
//	format(600);
//	print (mSigma);	
//	print (mOmega);
	iVar = rows(mY);
//	print (mJ_Phi);//, mJ_Omega, mJ_Delta, mDelta);

    // T|z matrix
	mPhi   = mPhi ** unit(iVar);
	mOmega = mOmega ** unit(iVar);
	mSigma = mSigma[:iStDim - 1][:iStDim - 1] ** unit(iVar) | 0;
	mDelta = <0>;
	mJ_Phi = <0>;
	mJ_Omega = 0*mOmega;
	mJ_Omega -= 1;
	
	mJ_Omega[0:4][0:4] = <0, 1, 2, 3, 4;
						  1, 5, 6, 7, 8;
						  2, 6, 9, 10, 11;
						  3, 7, 10, 12, 13;
						  4, 8, 11, 13, 14>;
						  
	mJ_Omega[5:9][5:9] = <15, 16, 17, 18, 19;
						  16, 20, 21, 22, 23;
						  17, 21, 24, 25, 26;
						  18, 22, 25, 27, 28; 
						  19, 23, 26, 28, 29>;

	mJ_Omega[10:14][10:14] = <30, 31, 32, 33, 34;
							  31, 35, 36, 37, 38;
							  32, 36, 39, 40, 41;
							  33, 37, 40, 42, 43;
							  34, 38, 41, 43, 44>;

	mJ_Omega[15:19][15:19] = <30, 31, 32, 33, 34;
							  31, 35, 36, 37, 38;
							  32, 36, 39, 40, 41;
							  33, 37, 40, 42, 43;
							  34, 38, 41, 43, 44>;

	mJ_Omega[20:24][20:24] = <45, 46, 47, 48, 49;
							  46, 50, 51, 52, 53;
							  47, 51, 54, 55, 56;
							  48, 52, 55, 57, 58; 
							  49, 53, 56, 58, 59>;

	mJ_Delta = <0>;
//	println (mJ_Omega);
//	format(600);
//	print ("cd ", mSigma);
//	print (mPhi);
//	print (mOmega);

	vP = zeros(9 + iStDim*iVar*(iVar + 1)/2, 1); // determine number of model parameters
	vP -= 0.3;
//	vAllP = vP;
//	print (vP);
	vP[:2 + iStDim*iVar*(iVar + 1)/2][0] = 0.0;//log(2/(0. + 1) - 1); //correl of 0. for each correl...
//	print ("hello", vP);
	vP[0][0] = sqrt(sqr(rho)/(1 - sqr(rho))); //cycle dampening factor (transformed)
	vP[1][0] = log(22 - 2); //cycle frequency (transformed)
	vP[2:iVar + 1][0] = 0;//-1.5;//= vPUni[0][0]; // trend variance transformed
	vP[2 + iVar:2 + 2*iVar - 1][0] = -2;//-1.270237;//= vPUni[1][0]; // drift trans var
	vP[2 + 2*iVar: 2 + 3*iVar - 1][0] = 0;//-1.5; // cycle trans var
	vP[2 + 3*iVar:2 + 4*iVar - 1][0] = 0;//-1.424908; //= vPUni[2][0]; // measure trans var
//	for (iter = 1; iter <= rows(vP) - 2; ++iter)
//	{
//		vP[iter + 1][0] = iter/100;
//	}
//	print (vP, "\n");
	if (1 == 1)
	{	  
/*		vP = <2.0226;
		  2.8512;
		0.059073;
		-12;
		-12;
		-12;
		-12;
		 -1.7755;
		 -2.1025;
		 -1.0698;
		 -12;
		 -12;
		-0.21289;
		 -2.3276;
		 -1.7344;
		 -12;
		 -12;
		 -9.0969;
		-0.99566;
		-0.78493;
		-12;
		0;//-0.49928;
		0;//-0.21611;
		 0.15367;
		-0.40925;
		 0.64161;
		 0;
		 0;
		 0;
		 0;
		 0;
		 0;
		  1.5654;
		  2.0516;
		  1.1680;
		 0.92890;
		  1.4745;
		 0.39313;
		  1.0895;
		-0.15461;
		 0.35502;
		 0;
		 0.68279;
		 0.39548;
		 0.81292;
		 0.28935;
		 -4.5172;
		 -5.8148;
		 0.19417;
		 -4.6214;
		 -6.3263;
		 0;
		 0.20003;
		-0.081254;
		0.031449;
		-0.31815;
		-0.019958;
		-0.46170;
		  1.9246;
		-0.98565;
		 0.15935;
		 0;
		 -7.9677;
		-0.16919;
		-0.065178;
		 -48.285;
		 -52.673;
		 -102.49;
		-0.59694>; 
		-0.31275;
		-0.21265;
		-0.054885;
		 -45.852;
		 -54.270;
		 -100.77;
		-0.56081>;

	vP = <2.0867;
		  2.7540;
		0.085284;
		-12;
		-12;
		-12;
		-12;
		 -1.7557;
		 -2.3898;
		 -12;
		-0.90772;
		-12;
		-0.42717;
		-0.85354;
		-0.32338;
		-12;
		-12;
		 -12.000;
		-0.95176;
		-0.79652;
		 -12;//-4.9893;
		-0.33403;
		0.075888;
		-0.42121;
		-0.021098;
		 0.51318;
		 0;
		 0;
		 0;
		 0;
		 0;
		 0;
		  1.4781;
		  1.0314;
		  1.9057;
		 0.93530;
		 0.13639;
		  1.3896;
		  1.3304;
		  0;
		  0;
		 0.26933;
		 0.48332;
		  1.1963;
		 0.76515;
		 0.31709;
		 0.49259;
		-0.17441;
		-0.31349;
		-0.27669;
		  1.5245;
		  0;
		 0.17823;
		0.052095;
		-0.062201;
		-0.23740;
		-0.27221;
		-0.16245;
		  1.3663;
		 -1.0413;
		-0.45751;
		-0.072316;
		-0.29394;
		-0.20963;
		-0.054620;
		 -45.171;
		 -54.142;
		 -100.36;
		-0.53941>;
		
	vP = <2.0874;
		  2.7603;
		  0.17359;
		 -12;
		 -12;
		 -12;
		 -12;
		 -1.7162;
		 -2.2990;
		-12;//-0.97937;
		 0.606752658;//-12;
		-12;
		-0.50611;
		-0.93346;
		 0.733492776;//-1.6099;
		 -12;
		 -12;
		 -12.000;
		-0.93844;
		0.630917721;//-0.74836;
		0.560886047;//-12;
		0.724500829;//-0.34023;
		0.055561;
		-0.34553;
		0.019941;
		 0.50756;
		 0;
		 0;
		 0;
		 0;
		 0;
		 0;
		  1.4447;
		  1.0062;
		  1.8747;
		 0.93978;
		 0.30612;
		  1.4119;
		  1.1751;
		 0;//-0.12827;
		 0;//0.38625;
		 0.386250471;//0;
		 0.62211;
		  1.3924;
		 0.82589;
		 0.26189;
		 0.15713;
		-0.40176;
		-0.31298;
		 -0.274567222;//-3.6421;
		 1.572663993;//-5.7278;
		 0;
		 0.18273;
		0.054021;
		-0.066256;
		-0.25739;
		-0.27950;
		-0.14653;
		  1.4115;
		-1.012474755;//-0.98107;
		 -0.434167355;//0.41119;
		 0.42204523;//0;
		-0.31275;
		-0.21265;
		-0.054885;
		 -45.852;
		 -54.270;
		 -100.77;
		-0.56081>; */

		vP = <2.0867;
		  2.7540;
		0.085284;
		-12;
		-12;
		-12;
		-12;
		 -1.7557;
		 -2.3898;
		 -12;
		-0.90772;
		-12;
		-0.42717;
		-0.85354;
		-0.32338;
		-12;
		-12;
		 -6;//-12.000;
		-0.95176;
		-0.79652;
		 -12;//-4.9893;
		-0.33403;
		0.075888;
		-0.42121;
		-0.021098;
		 0.51318;
		 0;
		 0;
		 0;
		 0;
		 0;
		 0;
		  1.4781;
		  1.0314;
		  1.9057;
		 0.93530;
		 0.13639;
		  1.3896;
		  1.3304;
		  0;
		  0;
		 0.26933;
		 0.48332;
		  1.1963;
		 0.76515;
		 0.31709;
		 0.49259;
		-0.17441;
		-0.31349;
		-0.27669;
		  1.5245;
		  0;
		 0.17823;
		0.052095;
		-0.062201;
		-0.23740;
		-0.27221;
		-0.16245;
		  1.3663;
		 -1.0413;
		-0.45751;
		-0.072316;
		-0.29394;
		-0.20963;
		-0.054620;
		 -45.171;
		 -54.142;
		 -100.36;
		-0.53941>;
	}

		  
//	print (vP);
	decl pvSco, vPjump = zeros(rows(vP) - 7, 1);
	pvSco = vP*0; // set correct vector length
	GetMultiModel (vP, &vPjump);
	println ("after model: ", vP);
	Likelihood (vP, &dLik, 0,0);//&pvSco, 0);
	println (vPjump, pvSco);
	decl id = checkskip (pvSco, vPjump, &vP); // check if parameter vector dim can be smaller & do it.
	pvSco = vP; // set correct vector length
//	vP = vP[0:1 + iStDim*iVar*(iVar + 1)/2 - id];
	println ("Dimension of vP: ", rows(vP));
	println ("After: ", vP');
//	s_vPskip = vPjump;
//	cutvP(&vP);

	println (dLik);

//	decl P;
//	P = choleski(mOmega);
//	print (P);
//	vp[13][0] = -5;
//	print (vP);
//	dLik = emalg(1, &vP);

//	s_vPskip = 0*s_vPskip;
	GetMultiModel (vP, &vPjump);
	pvSco = vP; // set correct vector length
	Likelihood (vP, &dLik, 0,0);//&pvSco, 0);	
	id = checkskip (pvSco, vPjump, &vP); // check if parameter vector dim can be smaller & do it.
	println ("Dimension of vP: ", rows(vP));
	println ("After: ", vP');
//	vP = vP[0:1 + iStDim*iVar*(iVar + 1)/2 - id];
//	print (vPtemp);
//	vAllP = vPtemp;
//	cutvP(&vP);
//	GetMultiModel(vP, &vPjump);
//	s_vPskip = vPjump;
//	print (vPjump');
//	cutvP(&vP);
	pvSco = vP; // set correct vector length
	Likelihood (vP, &dLik, 0,0);//&pvSco, 0);
	println (dLik, " Goodbye");
//	MaxControl (10, 1);
//	ir = MaxBFGS (Likelihood, &vP, &dLik, 0, 1);


//	print (P);
//	GetParam(P, &vP);
//	GetMultiModel(vP);
//	MaxControl (5, 1, 1);
//	MaxControlEps (1e-3, 1e-2);
//	ir = MaxBFGS (Likelihood, &vP, &dLik, 0, 0);
//	GetMultiModel(vP, &vPjump);
//	s_vPskip = vPjump;
//	cutvP(&vP);

	//MLE
//	Likelihood (vP, &dLik, 0, 0);
//	print (dLik);
	MaxControlEps (5e-4, 5e-3);
	decl lastit = 50; // was 25!!
	decl factor = 2;
	decl Hess = unit(rows(vP));
	decl oldHess = Hess;
	decl oldLik = dLik;
	decl icount = 0;
	for (i = 1; i <= 20; ++i)
	{
		println ("Afgerond naar nul bij: ", s_limit);
		MaxControl (lastit, 1, 0);
		println ("Am I here?");
		ir = MaxBFGS (Likelihood, &vP, &dLik, &Hess, 1);
		if (ir == 0)
		{
			break;
		}
		else // nog geen max gevonden, kijk op dim vP kleiner kan...
		{
			GetMultiModel (vP, &vPjump);
			Likelihood (vP, &dLik, 0, 0);// &pvSco, 0);
			oldHess = Hess;
			CutHess(&Hess, lastit, oldLik, dLik, vPjump);
//			println ("is this good? ", Hess);
			id = checkskip (pvSco, vPjump, &vP); // check if parameter vector dim can be smaller & do it.
			println ("Vector smaller? ", id);
			if (id <= 0) // parameter reduction failed
			{
				if ((dLik - oldLik)/lastit < 0.0005)
				{
					Hess = oldHess; // use original Hessian without restrictions
				}
				else
				{
					Hess = unit(rows(vP));
				}
			}
			if ((dLik - oldLik)/lastit < 1e-5)
			{
				++icount;
				if (icount > 5) // trouble with convergence... try I
				{
					Hess = unit(rows(vP));
					icount = 0;
				}
				if (lastit > 40) // for first time here, need larger factor
				{
					factor = 1.5;
				}//below was 40!
				lastit = 1000; // use small number to find restrictions
				s_limit = s_limit*factor; // near max reduce limit
				if (s_limit < 1e-5)
				{
					s_limit = 1e-5; // limit mag niet te klein worden
				}
			}
			else // not yet near max, do not reduce limit yet
			{
				lastit = lastit*factor; // use more iterations
			}
			factor = sqrt(factor);
			oldLik = dLik;
//			println ("vP: ", rows(vP), "Hess: ", rows(Hess));
			println ("restricties: ", s_vPskip);
			pvSco = vP; // set correct vector length (not really needed I do not believe...)
//			vP = vP[0:1 + iStDim*iVar*(iVar + 1)/2 - id];
		}
	}
//	print ("it returns a value of: ", ir, "\n");

    print ("\n", MaxConvergenceMsg(ir), " using analytical derivatives",
	       "\nFunction value = ", dLik, "; parameters: ", vP);

	print (format(600));
    print ("Omega ", "\n");
	outputCov(0, iVar-1); // prints out Omega with correlation in upper triangle
	outputCov(iVar, 2*iVar-1);
	outputCov(2*iVar, 3*iVar-1);
//		print (mOmega[15:19][15:19]);
	outputCov(4*iVar, 5*iVar-1);
	print ("mPhi ", "\n", mPhi);
	print ("mSigma ", "\n", mSigma);
	println ("Locaties van restricties: ", "\n", s_vPskip');
//    mD = SsfCondDens (ST_SMO, mY, mPhi, mOmega, mSigma);
//	mS = mY - <0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0> * mD;	
//	i = 0;
//	for (i = 0; i < columns(mY); ++i)
//	{
//    	print ("\n", mD[2][i], ",", mD[4][i], ",",  mD[6][i], ",",
//		             mD[8][i], ",",  mD[10][i], ",", 
//		             mD[12][i]);
//	}
	decl mest2, check;
	check = SsfMomentEst(ST_SMO, &mest2, mY, mPhi, mOmega, mSigma, mDelta,
						 mJ_Phi, mJ_Omega, mJ_Delta, mX);
//    DrawTMatrix(0, mest2[0:4][], {"level"}, 1970, 1, 4);
	DrawTMatrix(0, mest2[iVar:2*iVar-1][], {"drift D", "drift Fr", "drift Sp",
		"drift It", "drift Nl"}, 1970, 1, 4);
	DrawTMatrix(1, mest2[2*iVar:3*iVar-1][], {"cycle D", "cycle Fr", "cycle Sp",
		"cycle It", "cycle Nl"}, 1970, 1, 4);
//	ShowDrawWindow();
	savemat("SM UCs logit3 isn.in7", mest2[:3*iVar-1][]');
	decl A = unit(5);
	decl C = unit(5);
	decl B = unit(5);
	A[1:4][0] = vP[13:16];
	println ("A = ", A);
	B[1:4][0] = vP[17:20];
	B[2:4][1] = vP[21:23];
	B[4:4][3] = vP[24];
	println ("B = ", B);
	C[1:4][0] = vP[25:28];
	C[2:4][1] = vP[29:31];
	C[3:4][2] = vP[32:33];
	println ("C = ", C);
	decl AInv = invert(A);
	println ("A inverse = ", AInv);
	decl BInv = invert(B);
	println ("B inverse = ", BInv);
	decl CInv = invert(C);
	println ("C inverse = ", CInv);
	decl StStar = mest2[:3*iVar-1][];
	StStar[2*iVar:3*iVar-1][] = CInv * mest2[2*iVar:3*iVar-1][];
	StStar[iVar:2*iVar-1][] = BInv * mest2[iVar:2*iVar-1][];
	check = SsfMomentEst(DS_SMO, &mest2, mY, mPhi, mOmega, mSigma, mDelta,
						 mJ_Phi, mJ_Omega, mJ_Delta, mX);
	StStar[:iVar-1][] = AInv * mest2[:iVar-1][];
	savemat("SM UCStar logit3 isn.in7", StStar');
//
	format (200);
	format ("%#15.7g");
	println ("mX: ", mX[][]');
//	println ("mX2: ", mX[5:9][]');
//	println ("mX3: ", mX[10:14][]');
//	println ("mX4: ", mX[15:19][]');
//	println ("vP: ", vP);

/*	decl covar, invcov;
	check = Num2Derivative(Likelihood, vP, &covar);
	if (!check)
	{
		println("Covar() failed in numerical second derivatives");
		return zeros(vP);
	}
	invcov = invertgen(-covar, 30);
	println ("standard errors:", "\n", vP ~ sqrt(diagonal(invcov)/columns(mY))' ~
										diag(1 ./sqrt(diagonal(invcov)/columns(mY)))
										* vP);

*/
//	println (mest2[][0]);
	decl mKF;
//	println("size mphi", rows(mPhi), " ", columns(mPhi));
	mKF = KalmanFil(mY, mPhi, mOmega, mSigma, mDelta,
						 mJ_Phi, mJ_Omega, mJ_Delta, mX);

	decl holdDiag, F = zeros(5,5);
	decl v, vv=<>, qSum = zeros(125, 1);
	decl lnDiag = zeros(125, 1);
//	println (qSum);
	for (i = 2; i < columns(mY); ++i)
	{
//		println ("mKF: ", mKF[][i]);
		F = 0*F;
		F[0][0] = mKF[25][i];
//				println (F);
		F[0:1][1] = mKF[46:47][i];
//				println (F);
		F[0:2][2] = mKF[68:70][i];
//				println (F);
		F[0:3][3] = mKF[91:94][i];
//				println (F);
		F[0:4][4] = mKF[115:119][i];
//				println (F);
		holdDiag = diagonal(F);
//				println (F);
		F = setdiagonal(F, 0);
//				println (F);
		F = F + F';
//				println (F);
		F = setdiagonal(F, holdDiag);
//		println ("F: ", F[0][0]);
		v = mKF[0:4][i];
//		println ("v: ", v);
		qSum[i][0] = v'*F*v;
		lnDiag[i] = i/124;
		if (i > 0)
		{
			qSum[i][0] += qSum[i-1][0]*124*5;//i*5;
			qSum[i] = qSum[i]/(124*5);//(5*(i + 1));
			println (i/124);
		}
		F = 0*F;
		F = setdiagonal(F, sqrt(holdDiag));
		vv ~= F*v;
//		println (F);
	}
	savemat("resid final isn.in7", vv');
	savemat("forecast error isn logit.in7", mKF[0:4][]');
	savemat("Covariance isn logit.in7", mX');
//	println (qSum);
	DrawTMatrix(2, (qSum[2:] ~ lnDiag[2:])', {"Cusum Residual Squared"}, 1970.5, 1, 4);
	savemat("qsum final isn.in7", qSum[2:] ~ lnDiag[2:]);
		ShowDrawWindow();
}





