%% ML_SmokingGun_ReplicationFile1 - Reproduces Table 1 & 2
%
% Replication File for the paper 
% Monetary Policy and the Housing Market: A Structural Factor Analysis
% by Matteo Luciani (matteo.luciani@ulb.ac.be)
% ECARES Working Paper 2012-035 
% To appear on the Journal of Applied Econometrics
%

clear all; close all; clc
ML_graph_options                                                            % Default Graphs Options
TR=1;                                                                       % Data transformation
out=1;                                                                      % Elimination of Outliers
[db, label,cd] = ML_SmokingGun_Data(TR,out);                                % Upload Data
[T N]=size(db); t0=1963+.25*TR; tt=t0:0.25:t0+(T-1)*0.25;                   % useful objects
tb=find(tt==1982.5); te=find(tt==2008); tg=find(tt==2002.25);               % Extremes to truncate the sample
db(1:tb,:)=[];   [T N]=size(db); tt=tt(tb)+.25:0.25:tt(tb)+T*0.25;          % I consider only the second half of the sample
y = ML_Standardize(db);                                                     % Standardize Data


%% Table I. Testing for the Number of Factors %%
rmax=20; M = floor(sqrt(T)*0.75); nbck = round(N/10); cmax = 2;             % Setting parameters to compute criteria
[PR IC]=ML_nfactorsBN(y,rmax);                                              % Bai&Ng (2002) Criteria for Static Factors
tS=T./(1:T); S=ML_argmin(abs(tS-48),2):ML_argmin(abs(tS-8),2);
kmax = 20;  nbck = round(N/3); cmax = 1; npace=1;                           % setting parameters for criteria estimation
TableOnatski=ML_ndynfactors_Onatski(y',S,10);                               % Onatski (2009)
xx=ML_nfactorsGDFM(y,M);                                                    % Eigenvalues of the Spectral Density Matrix
Table1=[xx(1:10) diag(TableOnatski(2:end,2:end)) PR(1:10,1) IC(1:10,1)];

%% Table II. Percentage of Variance Explained by the first q Common Shocks %%
idvar=[68 69 70 72 7 108 1 31 41 43 36 75 82 35 55 56];                     % Variables of Interest
for qq=1:6; disp(qq);
    [F, L] = ML_SmokingGun_efactorsML(db,qq,r,1,100,3);                     % ML Estimation of the DFM
    share=var((F*L'))';                                                     % Share of variance accounted for by the common component       
    Table2(:,qq) =[mean(share); share(idvar)];
end







