%% ML_SmokingGun_Data - Uploads and transforms US quarterly Data
%
% [Data, codeData] = ML_SmokingGun_Data(trans,out)
%   trans = 0 - No transformation except logarithms
%   trans = 1 - Light transformation
%   trans = 2 - Heavy transformation
%   out   = 1 - Remove outliers
%

% Original version by Mario Forni, 
% modified by Matteo Luciani (matteo.luciani@.ulb.ac.be)

function [Data, label, cd] = ML_SmokingGun_Data(trans,out)

load SmokingGun_Data2;                                                      % Upload the Database
Label=LabelVariables;                                                       % Upload label
X=DB(56:end,:); n=size(X,2);                                                % Select Observations starting from 1963:1
if trans==2; apt=3; else apt=2; end; Tsc = DB(apt,:);                       % Select the Type of Transformation


%% Selecting and Transforming Varables %%

% Selecting %
sel=DB(1,:); 
jj=find(sel==1);
x=X(:,jj); 
tsc=Tsc(:,jj); 
label=Label(jj,:); 
[T,N]=size(x);

% Transforming %
if trans==0; bb=1; 
    for ii=1:N; 
        if tsc(:,ii)==2; tsc(:,ii)=1;
        elseif (tsc(:,ii)==3)||(tsc(:,ii)==4)||(tsc(:,ii)==6)||(tsc(:,ii)==7); tsc(:,ii)=5; 
        end; 
    end
elseif trans==1; bb=2; 
elseif trans==2; bb=3; 
end

data=zeros(size(x(bb:end,:)));
cd=zeros(N,1);
for i=1:N;
    if      tsc(i)==1;  data(:,i)=x(bb:T,i);                                                cd(i)=0;
    elseif  tsc(i)==2;  data(:,i)=ML_diff(x(bb-1:T,i));                                     cd(i)=1;
    elseif  tsc(i)==3;  data(:,i)=ML_diff(100*log(x(bb-1:T,i)));                            cd(i)=1;
    elseif  tsc(i)==4;  data(:,i)=ML_diff(ML_diff(100*log(x(bb-2:T,i))));                   cd(i)=2;
    elseif  tsc(i)==5;  data(:,i)=100*log(x(bb:T,i));                                       cd(i)=0;
    elseif  tsc(i)==6;  
        disp(bb-1)
        data(:,i)=100*(x(bb:T,i)-x(bb-1:T-1,i))./x(bb-1:T-1,i);             cd(i)=1;
    elseif  tsc(i)==7;  data(:,i)=ML_diff(100*(x(bb-1:T,i)-x(bb-2:T-1,i))./x(bb-2:T-1,i));  cd(i)=2;
    end;
end
 
if out==1;
    Data = removeoutliers(data);
else
    Data=data;
end


%% Remove Outliers (By Mario Forni) %%
            
function cleaneddata = removeoutliers(data)
kk=0;
for i = 1:size(data,2);
    iqr_data = iqr(data(:,i));                      % Interquantile Range
    amd_tdata = abs(data(:,i) - median(data(:,i))); % Distance from Median Value
    a  = find(amd_tdata >= 6*iqr_data);             % Identify Outliers    
    if ~isempty(a)
        for j = 1:length(a);
            kk=kk+1; out(kk,:)=[i a(j)];
            if a(j)>1; data(a(j),i) = median(data(max(1,a(j)-5):a(j)-1,i));
            else         data(a(j),i) =  median(data(2:6, i)); end
        end        
    end
end
fprintf('Number of Detected Outliers'); disp(kk)
cleaneddata = data;
 

%% Labelling variables %%
function label=LabelVariables
label=['  INDPRO   ';'  IPBUSEQ  ';'  IPCONGD  ';' IPDCONGD  ';'  IPDMAN   ';'  IPDMAT   ';'  IPFINAL  ';
'   IPMAN   ';'   IPMAT   ';'  IPMINE   ';' IPNCONGD  ';'  IPNMAN   ';'  IPNMAT   ';'  IPUTIL   ';
'  MCUMFN   ';' CPIAUCSL  ';' CPIENGSL  ';' CPILEGSL  ';' CPILFESL  ';' CPIUFDSL  ';' CPIULFSL  ';
'  PPICEM   ';'  PPICRM   ';'  PPIENG   ';'  PPIFCG   ';'  PPIFGS   ';'  PPIIDC   ';'  PPIIEG   ';
'  PPIIFF   ';'  PPICPE   ';'  PPIACO   ';'  PPIITM   ';'   AMBSL   ';' ADJRESSL  ';'  CURRSL   ';
'   M1SL    ';'   M2SL    ';'   M3SL    ';' BUSLOANS  ';' CONSUMER  ';'  LOANINV  ';'   LOANS   ';
'  OTHSEC   ';'  REALLN   ';'  TOTALSL  ';'   GDPC1   ';'  FINSLC1  ';'  GPDIC1   ';'  SLCEC1   ';
'  PRFIC1   ';'  PNFIC1   ';'  NRIPDC1  ';'  IMPGSC1  ';'  FGCEC1   ';'   GCEC1   ';'   FPIC1   ';
'  EXPGSC1  ';'   CBIC1   ';' PCNDGC96  ';' SLINVC96  ';' PCESVC96  ';' PCDGCC96  ';'  PCECC96  ';
'  DGIC96   ';'  NDGIC96  ';'  DPIC96   ';'  PCECTPI  ';' GPDICTPI  ';'  GDPDEF   ';'  GDPCTPI  ';
'  GNPDEF   ';'  GNPCTPI  ';'  HOUSTMW  ';'  HOUSTNE  ';'  HOUSTS   ';'  HOUSTW   ';'   HSN1F   ';
'  PERMIT   ';'    hp     ';'  ULCNFB   ';' COMPRNFB  ';'  COMPNFB  ';'  HOANBS   ';'  OPHNFB   ';
'  ULCMFG   ';'  COMPRMS  ';'  COMPMS   ';'   HOAMS   ';'  OPHMFG   ';'   ULCBS   ';'  RCPHBS   ';
'  HCOMPBS  ';'   HOABS   ';'  OPHPBS   ';'  MPRIME   ';' FEDFUNDS  ';'    AAA    ';'    BAA    ';
'   TB3MS   ';'   TB6MS   ';'    GS1    ';'    GS2    ';'    GS3    ';'    GS5    ';'    GS7    ';
'   GS10    ';'  spread1  ';'  spread2  ';'  spread3  ';'  spread5  ';'  spread7  ';'  spread10 ';
'  EXCAUS   ';'  EXJPUS   ';'  EXUSUK   ';'  CIVPART  ';'  EMRATIO  ';'  CLF16OV  ';'  CE16OV   ';
'  UNRATE   ';'  UEMPLT5  ';' UEMP5TO14 ';' UEMP15T26 ';' UEMP27OV  ';' UEMPMEAN  ';' UNEMPLOY  ';
'  PAYEMS   ';'  MANEMP   ';'  DMANEMP  ';' NDMANEMP  ';'  SRVPRD   ';'  USCONS   ';'   USEHS   ';
'  USFIRE   ';'  USGOOD   ';'  USGOVT   ';'  USINFO   ';'   USLAH   ';'  USMINE   ';'   USPBS   ';
'  USPRIV   ';'  USSERV   ';'   USTPU   ';'  USTRADE  ';' USWTRADE  ';' OILPRICE  ';'    PMI    ';
'  ORDERS   ';'PRODUCTION ';'EMPLOYMENT ';'DELIVERIES ';'INVENTORIES';'    DJI    ';'   GSPC    ';
'   IXIC    ';' BOGAMBSL  ';'CUSR0000SAC';' BOGNONBR  ';'  IPDBNS   '];
