#delim ;
cap program drop marginal_simulations_dist10percent;
program define marginal_simulations_dist10percent, eclass;

	capture erase "simulated.dta";
	capture erase "actual.dta";

	gen _kmsmp = kmsmp;
	
	replace kmsmp = kmsmp *0.9;

	liv_mx learnhr00 $X,
		   select(dschool = kmsmp INT_* $X)
		   grid(0 1 100)
		   support(0.05,0.95)
		   method(parametric) // np
		   kernel(gaussian)
		   bwidth(0.2)
		   shift(0.00001)
		   nograph
		   simfile(simulated.dta)
		   ;
	
	replace kmsmp = _kmsmp;
	drop _kmsmp;
		   
	liv_mx learnhr00 $X,
		   select(dschool = kmsmp INT_* $X)
		   grid(0 1 100)
		   support(0.05,0.95)
		   method(parametric) // np
		   kernel(gaussian)
		   bwidth(0.2)
		   shift(0)
		   nograph
		   simfile(actual.dta)
		   ;
	preserve;
		use actual, clear;
		merge 1:1 id v_grid using simulated;
		sum mte_clone_act if (switch_act != switch_sim);
		ereturn scalar margret = r(mean);
		gen diff = switch_act - switch_sim;
		tab diff;
	restore;
end;
