*! version Dec12, M.Lokshin
*! with Stata plugin
program locpoly1, rclass sortpreserve
	version 8

	syntax varlist(min=2 max=2 numeric)	///
		[if] [in] [,			///
		noGraph				///
		noScatter			///
    GENerate(string)                ///
    SLope(string)                   ///
    AT(varname)                     ///
		N(integer 50)			///
		Degree(integer 0)		///
		Width(real 0.0)			///
		BIweight			///
		COSine				///
		EPanechnikov			///
		GAUssian			///
		PARzen				///
		RECtangle			///
		TRIangle			///
		ADOonly				///
		*				/// graph opts
	]

	local kernel `biweight' `cosine' `epanechnikov' `gaussian' `parzen' `rectangle' `triangle'

  local k : word count `kernel'
	if `k' > 1 {
		di as err "only one kernel may be specified"
		exit 198
	}

  if (`k' == 0) local kernel epanechnikov

	tokenize `generate'
	local k : word count `generate'
	if `k' {
		if `k' == 1 {
			if missing("`at'") {
                                di as err "at() must be specified for generate() to work with one variable"
				error 198
			}
			confirm new var `1'
			local yname `"`1'"'
			local xname `"`at'"'
			local nsave 1
		}
		else {
			if `k' != 2 {
                                di as err "generate(): two new variables required"
				error 198
			}
			confirm new var `1'
			confirm new var `2'
			local xname `"`1'"'
			local yname `"`2'"'
			local nsave 2
		}
	}

	marksample touse

	tokenize `varlist'
	local y `1'
	local x `2'

	local bw = `width'
	if `bw' <= 0.0 {
		qui sum `x' if `touse', detail
		local bw = min( r(sd), (r(p75)-r(p25))/1.349 )
                if (`bw' <= 0.0)  local bw = r(sd)
		local bw = 0.9*`bw'/(r(N)^.20)
	}

  tempvar xgrid yhat fd
	qui gen double `xgrid' = .
  qui gen double `yhat'  = .
  qui gen double `fd'    = .

	if !missing("`at'") {
		qui count if `at' < .
		local n = r(N)
		qui replace `xgrid' = `at'
		tempvar obssrt
		gen `obssrt' = _n
		sort `xgrid' `obssrt'
	}

	else {
    if (`n' <= 1) local n = 50

    if `n' > _N {
			local n = _N
			noi di in gr "(n() set to " `n' ")"
		}
    qui summ `x' if `touse', meanonly
    tempname delta
    scalar `delta' = (r(max)-r(min))/(`n'-1)
    qui replace `xgrid' = r(min)+(_n-1)*`delta' in 1/`n'
	}


  if missing("`adoonly'") {
		capture plugin call _lpwork `y' `x' `xgrid' `yhat' ///
						if `touse',  `n' `bw' `degree' `kernel'
	
		if _rc==199 {
			di as err "plugin not loaded or not available:  " _c
			di as err "using the " as inp "adoonly " as err "option"
	    Lpwork `y' `x' if `touse', xgrid(`xgrid') yhat(`yhat') fd(`fd') ///
              n(`n') h(`bw') p(`degree') k(`kernel')
		}
	}
	else {
  	Lpwork `y' `x' if `touse', xgrid(`xgrid') yhat(`yhat') fd(`fd') ///
            n(`n') h(`bw') p(`degree') k(`kernel')
  }
  qui count if `yhat' < .
  local ngrid = r(N)

	ret local kernel `"`kernel'"'
	ret scalar width = `bw'
	ret scalar ngrid = `ngrid'
	ret scalar degree = `degree'

  tempname LIV                                            // create matrix for LIV
  mkmat `xgrid' `yhat' `fd', matrix(`LIV') nomissing
  matrix colname `LIV' = coord nfl nfl_slop

  return matrix LIV =`LIV'

	if `"`nsave'"' != "" {
    label variable `yhat'  `"locpoly smooth: `y'"'
    label variable `fd'    `"locpoly smooth: FD `y'"'
		rename `yhat' `yname'
    if (!missing("`slope'")) rename `fd' `slope'
		if `nsave' == 2 {
			rename `xgrid' `xname'
			label var `xname' `"locpoly smoothing grid"'
		}
	}

end

capture program _lpwork, plugin using("locpoly.plugin")

program Lpwork
	syntax varlist(min=2 max=2 numeric)	///
		[if],  				///
		xgrid(varname) 			///
		yhat(varname)			///
    fd(varname)                     ///
    n(integer)                      ///
		[ p(integer 0)			///
		h(real 0.0)			///
		k(string) ]

		tokenize `varlist'
		local y `1'
		local x `2'

    marksample touse

    mata: kkk("`y'","`x'","`xgrid'","`yhat'","`fd'",`n',"`touse'",`p',`h',"`k'")

end

mata:

void function kkk(string scalar y,
                  string scalar x,
                  string scalar xgrid,
                  string scalar yhat,
                  string scalar fd,
                  real   scalar n,
                  string scalar touse,
                  | real scalar p, real scalar h, string scalar k)
{
	
mx      =st_data(.,x,touse)
my      =st_data(.,y,touse)
mxgrid  =st_data(.,xgrid,touse)

//m      = minmax(mx)
//delta  = (m[1,2]-m[1,1])/(n-1)
//mxgrid = (0::(n-1)):*delta:+m[1, 1]

xs=J(rows(mx),1,1),J(rows(mx),p,.)

yyhat=J(rows(mx),1,.)
ffd  =J(rows(mx),1,.)

for (i=1;i<=n;i++) {
   arg  = (mx:-mxgrid[i]):/h
   karg = mm_kern(k,arg)
   for (j=1;j<=p;j++) {
      xs[.,j+1]=(arg:*h):^j
   }
   coeff=(invsym(quadcross(xs,karg,xs))*quadcross(xs,karg,my))
   yyhat[i,1]=coeff[1,1]
   ffd  [i,1]=coeff[2,1]
}
//mxgrid=mxgrid\J(rows(mx)-rows(mxgrid),1,.)
st_store(.,(xgrid,yhat,fd),touse,(mxgrid,yyhat,ffd))

}
end

