program define bw_sensitivity;

	use "$data\nithins_data.dta", clear;
	
	local X age age2 r_protest r_cathol r_other elem_f jsec_f edumiss_f elem_m jsec_m edumiss_m rural kmsd  prov_*;

	global N_itterations = 0;
	
	matrix TAB = J(100,4,.);
	matrix colnames TAB = bw att ate atu;
	local counter = 0;

	forvalues bw=0.1(0.02)0.3{;
			qui liv_mx learnhr00 `X',
		       select(dschool = kmsmp INT_* `X')
		       grid(0 1 100)
		       support(0,1)
		       method(np)
		       kernel(gaussian)
		       bwidth(`bw')
		       shift(0)
		       bsfile(bsout.txt)
			   	 nograph
			   ;
			 local ++counter;
			 noi disp `bw';
			 
			 matrix _T = e(b);
			 matrix TAB[`counter',1] = `bw';
			 matrix TAB[`counter',2] = e(mte_att);
			 matrix TAB[`counter',3] = e(mte_ate);
			 matrix TAB[`counter',4] = e(mte_atu);			   
	 };

	 matrix list TAB;
end;
