#delim ;

program define _dgp_mc;
	quietly {;
		args iter;
		
		drop _all;
		set obs 2000;
		
		gen e1 = invnorm(uniform());
		gen e2 = invnorm(uniform());
		gen e3 = invnorm(uniform());
		
		gen x1 = -2 + 2*invnorm(uniform());
		gen x2 =  2 + 2*invnorm(uniform());
		gen z1 = -1 + 3*invnorm(uniform());
		gen z2 =  1 + 3*invnorm(uniform());
		
		gen U1 = e1*0.012 + 0.01*e2;
		gen U0 = e1*-0.05 + 0.02*e3;
		gen V  = e1*-1;
		
		gen I = 0.2+0.3*z1+0.1*z2-V;
		
		gen byte d = (I>0);
		
		gen y1 = 0.04 + 0.2 + 0.8*x1 + 0.4*x2 + U1;
		gen y0 = 0.02       + 0.5*x1 + 0.1*x2 + U0;
		
		gen     y = y1 if d == 1;
		replace y = y0 if d == 0;
		
		 // treatment effects
		 generate TT = (0.04+0.2+0.8*x1+0.4*x2) - (0.02 + 0.5*x1 + 0.1*x2);
		 
		 sum TT if d == 1, meanonly; local att = r(mean);
		 sum TT if d == 0, meanonly; local atu = r(mean);
		 sum TT 				 , meanonly; local ate = r(mean);
		 
		display "ATT = ", `att', " ATU = ",`atu', "ATE = ", `ate';
		
		keep y d x1 x2 z1 z2 U1 U0 V;
		compress;
		
		noi save dgp_heckman_`iter', replace;
	};
end;

