#delim ;

/* Estimate non-linear function of Pscore */
/* Generate polinomial of a degree DP		 */

program define _PolyMte;
				syntax, y_reg(varname numeric) 
								x_reg(varlist numeric) 
								ps(varname numeric) 
								drv_grid(name) 
								v_grid(name) 
								x_b(name)
								id(name)
								ngrid(int)
								[ DPolinomials(int 3) 
								  SUpport(numlist min=2 max=2 >=0 <=1)								  
								]        
				;
				
        if (missing("`dpolinomials'")) local dpolinomials = 3;  // correct later for polinomials

        forvalues i = 1/`dpolinomials' {;
        	tempvar ps_`i';
          qui generate double `ps_`i'' = `ps'^`i';
          local ps_polinomials `ps_polinomials' `ps_`i'';
        }; // end forvalues
        
        foreach x of varlist `x_reg' {; // Create interactions of x's and pscore
          generate double `x'__ps = `x'*`ps';
          local ps_interactions `ps_interactions' `x'__ps;
        }; // end foreach
        
        // Second stage regression MAIN; note that ps_* also includes ps_x1 and ps_x2
        // Equation 6 on page 3 in Manual

        if (!missing("`support'"))
           qui regress `y_reg' `x_reg' `ps_interactions' `ps_polinomials' if (inrange(`ps',`lb',`ub'));
        else
           qui regress `y_reg' `x_reg' `ps_interactions' `ps_polinomials';

        /*******************************************************************/
        local indep_vars: colnames e(b) ;

        local interactions_start = 1;
        foreach var of local indep_vars {;
            if (strpos("`var'","__ps")>0) continue, break;
            local interactions_start = `interactions_start' + 1;
        }; // end foreach

        generate double `x_b' = 0;
        forvalues i = 1/`=`interactions_start'-1' {;
        	local varname: word `i' of `indep_vars';    // read variable name from the list of coefficients
          capture display _b[`varname'__ps];          // check if coefficient on interaction exists
          if (_rc == 0) qui replace `x_b' = `x_b'+`varname'*_b[`varname'__ps];
        }; // end foreach
        /*******************************************************************/

        if (missing("`ngrid'")) local ngrid = 100;             
             
        _Clone `ngrid' `id' `v_grid';                          // creates ngrid clones for each observation, creates vars

        qui generate double `drv_grid' = _b[`ps_1'];
        
        forvalues i = 2/`dpolinomials' {;
        	qui replace `drv_grid' = `drv_grid' + `i'*_b[`ps_`i'']*(`v_grid'^(`i'-1));
        }; // end forvalues        
        
end; // endif method poly
