#delim ;
program define _ParametricMte;
		syntax, y_reg(varname numeric) 
						x_reg(varlist numeric) 
						y_prob(varname numeric) 
						x_prob(varlist numeric) 
						ngrid(int)
						drv_grid(name) 
						v_grid(name) 
						x_b(name)
						id(name)
						;
	
	  qui movestay `y_reg' `x_reg', select(`y_prob' = `x_prob') iter(50);

    tempvar xb1 xb0;
	  qui predict `xb1', xb1;
	  qui predict `xb0', xb0;

    qui generate double `x_b' = `xb1'-`xb0'; 

	  local rho0 = tanh(_b["r0:_cons"]);
	  local rho1 = tanh(_b["r1:_cons"]);
	  
	  local sigma0 = e(sigma0);	  
	  local sigma1 = e(sigma1);

	 	if (`rho0'>0 | `rho1' <0) local flag = 1;
		else                      local flag = 0;

    _Clone `ngrid' `id' `v_grid';                           // creates ngrid clones for each observation, creates vars

		qui generate double `drv_grid' = (`sigma0'*`rho0'-`sigma1'*`rho1')*invnorm(`v_grid'); // note movestay returns rho1 with the opposite sign than it should be
end;	// program ParametricMte
