#delim ;
program define _NpMteBwSelect_GridTest;
		syntax, y_reg(varname numeric) 
						x_reg(varlist numeric) 
						ps(varname numeric)			
						ngrid(int)					
						drv_grid(name) 				
						v_grid(name) 
						kernel(string)
						x_b(name)
						id(name)
						bwidth(real)
						grid(numlist min=3 max=3)					
						;

	  foreach x of varlist `x_reg' {; // Create interactions of x's and pscore
	  		generate double `x'__ps = `x'*`ps';
	      local ps_interactions `ps_interactions' `x'__ps;
	  }; // end foreach

		tempvar number;
		generate `number' = _n;
		
		local n_obs = _N;
		matrix RESULTS = J(100,2,.);
		matrix TAB = J(`n_obs',1,.);
		local big_count = 1;

		forvalues bwidth = 0(0.05)1 {;
				
				forvalues count = 1/`n_obs' {;
		
			    qui	plreg_rob `y_reg' `x_reg' `ps_interactions' if `number' != `count',
			        		     	nlf(`ps') 
			            		  degree(2)
			              		`kernel'
			              		gen(`blank')
			              		slope(`fd')
			              		width(`bwidth')                                 // band width
			              		bs_grid(`grid')
			              		adoonly                                         // this is non-optional, always specify adoonly
			              ;
			
					tempvar y_hat resid;
					qui predict `y_hat' 										 if `number' == `count';
					qui generate `resid' = `y_reg' - `y_hat' if `number' == `count';
					sum `resid', meanonly;
					matrix TAB[`count',1] = r(mean);
					*disp in yellow `count';
					drop `y_hat' `resid';
				}; 
				svmat TAB; 
				qui sum 	TAB1;
				drop TAB1; 

				matrix RESULTS[`big_count',1] = `bwidth';
				matrix RESULTS[`big_count',2] = r(sd);

				disp in yellow `big_count';

				local big_count = `big_count' + 1;			
		};
end;