#delim ;
program define _NpMte;
		syntax, y_reg(varname numeric) 
						x_reg(varlist numeric) 
						ps(varname numeric)			
						ngrid(int)					
						drv_grid(name) 				
						v_grid(name) 
						kernel(string)
						x_b(name)
						id(name)
						bwidth(real)
						grid(numlist min=3 max=3)					
						;

    tempname blank fd; // blank is not used, this is approximation of nonlinear function, we need derivative of it

	  foreach x of varlist `x_reg' {; // Create interactions of x's and pscore
	  		generate double `x'__ps = `x'*`ps';
	      local ps_interactions `ps_interactions' `x'__ps;
	  }; // end foreach

    plreg_rob `y_reg' `x_reg' `ps_interactions',
             	nlf(`ps') 
              degree(2)
              `kernel'
              gen(`blank')
              slope(`fd')
              width(`bwidth')                                 // band width
              bs_grid(`grid')
              adoonly                                         // this is non-optional, always specify adoonly
              ;

		/********** USE LINEAR PART OF PLREG *******************************/

    local indep_vars: colnames e(b) ;

    local interactions_start = 1;
    foreach var of local indep_vars {;  // create interactions
    	if (strpos("`var'","__ps")>0) continue, break;
      local interactions_start = `interactions_start' + 1;
    }; // end foreach

    qui generate double `x_b' = 0;
    forvalues i = 1/`=`interactions_start'-1' {;
    	local varname: word `i' of `indep_vars';    // read variable name from the list of coefficients
      capture display _b[`varname'__ps];          // check if coefficient on interaction exists
      if (_rc == 0) qui replace `x_b' = `x_b'+`varname'*_b[`varname'__ps];
    }; // end foreach

    /*******************************************************************/
    tempname LIV;
    matrix `LIV' = e(LIV);

    tempvar m_id;                       									// id - identifier for original observation

    preserve;
    	svmat `LIV'; keep `LIV'1 `LIV'3;                    // save matrix to file
      rename `LIV'1 `v_grid'; rename `LIV'3 `drv_grid';
      qui generate int `m_id' = _n;
      qui keep `m_id' `v_grid' `drv_grid';
      qui keep if !missing(`v_grid');
      sort `m_id'; qui compress;
      tempfile grid;
      qui save `grid', replace;
    restore;
           
    qui generate int `id'   = _n;
          
    qui keep `id' `x_b' `ps';                                  // keep just variables we need

    qui expand `ngrid';

    qui bys `id': generate `m_id' = sum(1); 										// generates counters by id (1,2,3...)
    sort `m_id';
    qui merge m:1 `m_id' using `grid', nogenerate;                                  
end;