#delim ;
program define _MarginalSimulationsMPRTE_Dist10, eclass;

	syntax varlist [if] [in], method(string) effect(string);

  marksample touse;
  
	capture erase "simulated.dta";
	capture erase "actual.dta";

	gen _kmsmp = kmsmp;
	
	if (upper("`effect'") == "MPRTE") {;
		replace kmsmp = kmsmp *0.9;
		local shift = 0.001;
	};
	else local shift = -0.06;

	liv_mx learnhr00 `varlist' if `touse',
		   select(dschool = kmsmp INT_* `varlist')
		   grid(0 1 100)
		   support(0.05,0.95)
		   method("`method'") 
		   kernel(gaussian)
		   bwidth(0.2)
		   shift(`shift')
		   nograph
		   simfile(simulated)
		   ;
	
	replace kmsmp = _kmsmp;
	drop _kmsmp;
		   
	liv_mx learnhr00 `varlist' if `touse',
		   select(dschool = kmsmp INT_* `varlist')
		   grid(0 1 100)
		   support(0.05,0.95)
		   method("`method'") 
		   kernel(gaussian)
		   bwidth(0.2)
		   shift(0)
		   nograph
		   simfile(actual)
		   ;
	preserve;
		use actual, clear;
		merge 1:1 id v_grid using simulated;
		sum mte_clone_act if (switch_act != switch_sim);
		ereturn scalar margret = r(mean);
		gen diff = switch_act - switch_sim;
		tab diff;
	restore;
end;
