/*************************************************/
/*   8/01/2013 7:06PM                           */
/*************************************************/
#delim;
mata mata clear;
set more off; program drop _all; discard; file close _all; 

//need to have moremata installed on the computer

capture program drop liv_mx_BW_Select;
program define liv_mx_BW_Select, eclass;

        syntax  varlist(min=2) [pweight iweight fweight]
                [if] [in], SELect(string) [
                DPolinomials(numlist min=1 max=1 int >0)  // degree of polinomials
                grid(numlist min=3 max=3)                 // specify low bound upper bound and number of grid points
                ngrid(numlist min=1 max=1 int >1)
                PScore(string)
                BWidth(numlist min=1 max=1 >0)            // bandwidth for NP estimator
                method(string)                            // method NP or POLY
                Kernel(string)                            // type of kernel
                SUpport(numlist min=2 max=2 >=0 <=1)      // support is only for POLY, NP is always on support
                bsfile(string)                            // txt file to save GRID matrix for bootstrap
								shift(numlist min=1 max=1)								// parameter for simulations
								simfile(string)														// file for simulations
                noGraph *];

        local coll `s(collinear)';

        timer clear 1;  timer on 1;

        // read vector of parameters

        gettoken y_reg1 x_reg1 :  varlist;
        unab x_reg1 : `x_reg1';

        tokenize "`select'", parse("=");         // define vars for regression equation
        if ("`2'"!="=") {;
                tokenize "`select'";
                local y_prob `1';
                macro shift;
                local x_prob `*';
        };
        else {;
                local y_prob `1';
                local x_prob `3';
        };
        unab x_prob : `x_prob';

				// reads number of grid points from grid option
				local ngrid: word 3 of `grid';

        // Drop observations with missing values

        marksample touse;
        markout `touse' `y_reg1' `x_reg1' `y_prob' `x_prob' `cluster', strok;

        if ("`weight'" == "pweight" | "`cluster'" != "") local robust robust;
        if ~missing("`cluster'") local clopt cluster(`cluster');
        if ~missing("`weight'")  local weight "[`weight'`exp']";

        if (!missing("`support'")) {;
           tokenize `support';
           local lb = `1'; mac shift; local ub = `*';
        };
        
        local method = upper("`method'");
        if (!inlist("`method'","POLY","NP","PARAMETRIC")) local method POLY;

		   	if (missing("`bwidth'")) local bwidth = 0.1;

    		if (!inlist("`kernel'","epanechnikov","biweight","cosine","gaussian","parzen","rectangle","triangle")) 
    				local kernel gaussian ;

        // conditional collinearity
        _rmdcoll `y_reg1' `x_reg1' if `touse', `coll';
        local result "`r(varlist)'";
        local colls1: list x_reg1 - result;
        if ~missing("`colls1'") {;
                noisily display as text "note: `colls1' dropped from the main equation due to collinearity";
                local x_reg1 `result';
        };

        _rmdcoll `y_prob' `x_prob' if `touse', `coll';
        	local result "`r(varlist)'";
          local colls: list x_prob - result;
          noisily display _newline;
          if ~missing("`colls'") noisily display as text "note: `colls' dropped from the selection equation due to collinearity";
          local x_prob `result';              
                
        /*******************************************************************/
        /***************** Actual Estimation *******************************/
        /*******************************************************************/

        qui tempfile original_data; 
        qui save `original_data', replace;  // Save original data file to add pscore at the end

        qui keep if (`touse');

				if missing("`ngrid'") local ngrid = 100;
        //probit `y_prob' `x_prob'; estimates store eprobit;    // Probit on selection dummy
        qui logit `y_prob' `x_prob'; estimates store eprobit;      	// Probit on selection dummy

        tempvar ps xb;

				qui predict double `xb', xb;

				if missing("`shift'") local shift = 0;
		
				qui replace `xb' = `xb' + `shift' ;
		
				qui generate double `ps' = exp(`xb')/(1+exp(`xb'));			// Propensity score with shift in intercept


        /*******************************************************************/
		
		 		_DisplayMethodInfo, method("`method'") kernel("`kernel'") bwidth("`bwidth'") ngrid("`ngrid'") dp("`dpolinomials'");

        /*******************************************************************/
        
			  tempvar drv_grid v_grid id x_b;  // derivative of a control function wrt ps	

        /***************** LIV ROBINSON ************************************/

        if ("`method'" == "NP") {;
        	
        	_NpMteBwSelect, // _NpMte
									y_reg(`y_reg1')    			// <=
									x_reg(`x_reg1')    			// <=
									ps(`ps') 								// <= propensity score								
									ngrid(`ngrid')          // <=						
									drv_grid(`drv_grid')   	// =>
									v_grid(`v_grid')			  // =>								
									kernel(`kernel')        // <=				
									x_b(`x_b')             	// =>
									id(`id')                // =>
									bwidth(`bwidth')        // <=
									grid(`grid')            // <=
						;					 
        }; // endif method NP


end; // end program LIV_mx

/*******************************************************************/
/*******************************************************************/


