/*************************************************/
/*   8/01/2013 7:06PM                           */
/*************************************************/
#delim;
mata mata clear;
set more off; discard; /* file close _all; */

 //need to have moremata installed on the computer

capture program drop liv_mx;
program define liv_mx, eclass;

        syntax  varlist(min=2) [pweight iweight fweight]
                [if] [in], SELect(string) [
                DPolinomials(numlist min=1 max=1 int >0)  // degree of polinomials
                grid(numlist min=3 max=3)                 // specify low bound upper bound and number of grid points
                ngrid(numlist min=1 max=1 int >1)
                PScore(string)
                BWidth(numlist min=1 max=1 >0)            // bandwidth for NP estimator
                method(string)                            // method NP or POLY
                Kernel(string)                            // type of kernel
                SUpport(numlist min=2 max=2 >=0 <=1)      // support is only for POLY, NP is always on support
                bsfile(string)                            // txt file to save GRID matrix for bootstrap
								shift(numlist min=1 max=1)								// parameter for simulations
								simfile(string)														// file for simulations
                noGraph *];

        local coll `s(collinear)';

        timer clear 1;  timer on 1;

        // read vector of parameters

        gettoken y_reg1 x_reg1 :  varlist;
        unab x_reg1 : `x_reg1';

        tokenize "`select'", parse("=");         // define vars for regression equation
        if ("`2'"!="=") {;
                tokenize "`select'";
                local y_prob `1';
                macro shift;
                local x_prob `*';
        };
        else {;
                local y_prob `1';
                local x_prob `3';
        };
        unab x_prob : `x_prob';

				// reads number of grid points from grid option
				local ngrid: word 3 of `grid';

        // Drop observations with missing values

        marksample touse;
        markout `touse' `y_reg1' `x_reg1' `y_prob' `x_prob' `cluster', strok;

        if ("`weight'" == "pweight" | "`cluster'" != "") local robust robust;
        if ~missing("`cluster'") local clopt cluster(`cluster');
        if ~missing("`weight'")  local weight "[`weight'`exp']";

        if (!missing("`support'")) {;
           tokenize `support';
           local lb = `1'; mac shift; local ub = `*';
        };
        
        local method = upper("`method'");
        if (!inlist("`method'","POLY","NP","PARAMETRIC")) local method POLY;

		   	if (missing("`bwidth'")) local bwidth = 0.1;

    		if (!inlist("`kernel'","epanechnikov","biweight","cosine","gaussian","parzen","rectangle","triangle")) 
    				local kernel gaussian ;

        // conditional collinearity
        _rmdcoll `y_reg1' `x_reg1' if `touse', `coll';
        local result "`r(varlist)'";
        local colls1: list x_reg1 - result;
        if ~missing("`colls1'") {;
                noisily display as text "note: `colls1' dropped from the main equation due to collinearity";
                local x_reg1 `result';
        };

        _rmdcoll `y_prob' `x_prob' if `touse', `coll';
        	local result "`r(varlist)'";
          local colls: list x_prob - result;
          noisily display _newline;
          if ~missing("`colls'") noisily display as text "note: `colls' dropped from the selection equation due to collinearity";
          local x_prob `result';              
                
        /*******************************************************************/
        /***************** Actual Estimation *******************************/
        /*******************************************************************/

        qui tempfile original_data; 
        qui save `original_data', replace;  // Save original data file to add pscore at the end

        qui keep if (`touse');

				if missing("`ngrid'") local ngrid = 100;
        //probit `y_prob' `x_prob'; estimates store eprobit;    // Probit on selection dummy
        qui logit `y_prob' `x_prob'; estimates store eprobit;      	// Probit on selection dummy

        tempvar ps xb;

				qui predict double `xb', xb;

				if missing("`shift'") local shift = 0;
		
				qui replace `xb' = `xb' + `shift' ;
		
				qui generate double `ps' = exp(`xb')/(1+exp(`xb'));			// Propensity score with shift in intercept


        /*******************************************************************/
		
		 		_DisplayMethodInfo, method("`method'") kernel("`kernel'") bwidth("`bwidth'") ngrid("`ngrid'") dp("`dpolinomials'");

        /*******************************************************************/
        
			  tempvar drv_grid v_grid id x_b;  // derivative of a control function wrt ps	

        /***************** LIV ROBINSON ************************************/

        if ("`method'" == "NP") {;
        	
        	_NpMte,
									y_reg(`y_reg1')    			// <=
									x_reg(`x_reg1')    			// <=
									ps(`ps') 								// <= propensity score								
									ngrid(`ngrid')          // <=						
									drv_grid(`drv_grid')   	// =>
									v_grid(`v_grid')			  // =>								
									kernel(`kernel')        // <=				
									x_b(`x_b')             	// =>
									id(`id')                // =>
									bwidth(`bwidth')        // <=
									grid(`grid')            // <=
						;					 
        }; // endif method NP

        /***************** LIV POLINOMIAL **********************************/
	
        if ("`method'" == "POLY" ) {;

        	_PolyMte,
									y_reg(`y_reg1')    			// <=
									x_reg(`x_reg1')    			// <=
									ps(`ps') 								// <= propensity score
									ngrid(`ngrid')          //
									drv_grid(`drv_grid')   	// =>
									v_grid(`v_grid')			  // =>
									x_b(`x_b')             	// =>
									id(`id')                // =>
						;
				};
				/**************** PARAMETRIC ****************************************/

				if ("`method'" == "PARAMETRIC") {;
					_ParametricMte, 
									y_reg(`y_reg1')    			// <=
									x_reg(`x_reg1')    			// <=
									y_prob(`y_prob')   			// <= 
									x_prob(`x_prob')    		// <=
									ngrid(`ngrid')          //
									drv_grid(`drv_grid')   	// =>
									v_grid(`v_grid')			  // =>
									x_b(`x_b')	            // =>
									id(`id')                // =>
									;
				
				}; // enfif method parametric
				/*******************************************************************/
estimates store emte;

	tempvar switch mte_clone;
	qui generate byte `switch' = `v_grid'<`ps';      // indicated on treated or untreated groups within clones of each original observation
	qui generate `mte_clone' = `x_b' + `drv_grid';

  if (missing("`support'")){;
  	local lb = c(mindouble);
  	local ub = c(maxdouble);
  }; // end if

  summarize `mte_clone' if                   (inrange(`v_grid',`lb',`ub')), mean; local mte_tot  =r(mean);
  summarize `mte_clone' if (`switch' == 1) & (inrange(`v_grid',`lb',`ub')), mean; local mte_treat=r(mean);
  summarize `mte_clone' if (`switch' == 0) & (inrange(`v_grid',`lb',`ub')), mean; local mte_contr=r(mean);
  summarize `x_b'       if (`switch' == 1) & (inrange(`v_grid',`lb',`ub')), mean; local xb_treat  = r(mean);
	summarize `drv_grid'  if (`switch' == 1) & (inrange(`v_grid',`lb',`ub')), mean; local drv_treat = r(mean);
	
  tempname GRID mte_bs;
	summarize `x_b', meanonly; 
	qui generate double `mte_bs' = r(mean) + `drv_grid' if (`id' == 1); // mte at the sample mean on x_b, this is constant over all id
    
	sort `v_grid';

	if ("`method'" == "PARAMETRIC") {; // select for parametric
		mkmat `v_grid' `mte_bs' `smtexv' `umtexv' `lmtexv' if (`id' == 1), matrix(`GRID');
    matrix colname `GRID' = ps_grid v /*se u_bound l_bound */;
		matrix TOGRAPH = `GRID'; //for graphing in excel
	};
	else {;
		mkmat `v_grid' `mte_bs'                            if (`id' == 1), matrix(`GRID'); 
   	matrix colname `GRID' = ps_grid v;
	};  

	if (missing("`graph'")) {; 
			// note that the MTE graph is drawn at the sample mean of x_b

			_GraphMte,	method("`method'") 
									mte_bs("`mte_bs'")
								    id("`id'")
							  	v_grid("`v_grid'")
								    lb("`lb'")
								    ub("`ub'")
						   		options("`options'")
						   ;
		
  }; // end if

	// THIS PART if for doing simulations of policies : distance + 10%
	if (!missing("`simfile'")) {;
			_Simulate , 
					simfile(`simfile') shift(`shift') id(`id') v_grid(`v_grid') switch(`switch') mte_clone(`mte_clone');
	}; // end if
		
	// *************************************************
 	use `original_data', clear;

 	if (!missing("`pscore'")) {;
      estimates restore eprobit;
      predict `pscore' if (`touse'); 
      label variable `pscore' "Liv: Propensity score";
 	};

	// bootstrapping

 	if (!missing(`"`bsfile'"')) {;
 			_WriteBootStrap "`bsfile'" "`GRID'" `mte_tot' `mte_treat' `mte_contr' `flag';
 	};
	else {;
			display in yellow "ATE : " `mte_tot' _col(20) "ATT : " `mte_treat' _col(40) "ATU : " `mte_contr';
	};


/**************** MC_SIMULATIONS ***************************/
 
/*	estimates restore emte;
	mat T = e(b);
	local x1 		 = T[1,1];
	local x2 		 = T[1,2];
	local x1ps   = T[1,3];
	local x2ps   = T[1,4];
	estimates restore eprobit;
	mat T = e(b); 
	local xz1 	 = T[1,1];
	local xz2 	 = T[1,2];
	local z1  	 = T[1,3];
	local z2  	 = T[1,4];
	local z_cons = T[1,5];
	local str_out $N_ITER, `x1', `x2', `x1ps', `x2ps', `xz1', `xz2', `z1', `z2', `z_cons';
	
	local grid_line;
	matrix GRID_OUT = `GRID'; 
	
	forvalues i = 1/100 {;
			local grid_line `grid_line', `=GRID_OUT[`i',2]';	
	};
	set trace on; 
	file write output   "`str_out', `mte_tot', `mte_treat', `mte_contr' `grid_line'" _n;
 */
/**********************************************************/

	qui timer off 1;
	qui timer list 1;

	display as result "Time per iteration: " r(t1);

  /***************** RETURNS *****************************************/

	qui count if (`touse'); local N=r(N);
	ereturn post, esample(`touse');  // post clears everything
					  
	ereturn scalar N       = `N';
  ereturn scalar mte_ate = `mte_tot';
  ereturn scalar mte_att = `mte_treat';
  ereturn scalar mte_atu = `mte_contr';

	ereturn scalar xb_att  = `xb_treat';
	ereturn scalar drv_att = `drv_treat';

  ereturn matrix GRID = `GRID';
  
end; // end program LIV_mx

/*******************************************************************/
/*******************************************************************/


