#delim ;
file close _all;
program drop _all;
global data "INSERT";
cd "$data";

program define table7;

	qui use "$data\data.dta", clear;
	
	local X age age2 r_protest r_cathol r_other elem_f jsec_f edumiss_f elem_m jsec_m edumiss_m rural kmsd  prov_*;
	
	local method "np";
	local method "parametric";

	global N_itterations = 0;

	* test run of a single iteration of LIV, results in bsout.txt;
    liv_mx learnhr00 `X',
       select(dschool = kmsmp INT_* `X')
       grid(0 1 100)
       support(0,1)
       method(`method')
       kernel(gaussian)
       bwidth(0.27)
       bsfile(bsout.txt)
       shift(0)
	   	 nograph
	   ;

	********************************************************;
 
	capture erase bsout_all.txt;
	
	local bs_string reps(250) dots seed(12345678) noheader nolegend;

	display in green _newline "Method: " in yellow "`method'", in green " Total Sample";
		
	bootstrap att	=	e(mte_att) 
						ate	=	e(mte_ate) 
						atu = e(mte_atu), saving(bs_result_250_all, replace) `bs_string':
	
						liv_mx learnhr00 `X',
						       select(dschool = kmsmp INT_* `X')
						       grid(0 1 100)
						       support(0,1)
						       method(`method')
						       kernel(gaussian)
						       bwidth(0.27)
						       bsfile(bsout_all.txt)
							   	 shift(0)
						       nograph;
	
	_output_att ATT;

	bootstrap margret=e(margret), 
						 saving(bs_result_margret, replace) cluster(commid00) `bs_string':
						_MarginalSimulationsMPRTE_Dist10 `X', method(`method') effect("MPRTE");	
		
	_output_att MPRTE;			       

	bootstrap margret=e(margret), 
						 saving(bs_result_margret, replace) cluster(commid00) `bs_string':
						_MarginalSimulationsMPRTE_Dist10 `X', method(`method') effect("PRTE");	
		
	_output_att PRTE;			       

	
end; 
	

program define _output_att;
		
		args effect;

		matrix MEANS = e(b);
		matrix CI    = e(ci_normal);
		
		matrix MEANS = MEANS/7.74;
		matrix CI    = CI/7.74;

		if (upper("`effect'") == "MPRTE") {;		
			display in green "MPRTE"	 , in yellow %4.3f MEANS[1,1];
			display in green "MPRTE_ci", in yellow "(" %4.3f CI[1,1] "," , %4.3f CI[2,1] ")";
		};

		if (upper("`effect'") == "PRTE") {;		
			display in green "PRTE"	 , in yellow %4.3f MEANS[1,1];
			display in green "PRTE_ci", in yellow "(" %4.3f CI[1,1] "," , %4.3f CI[2,1] ")";
		};
		
		if (upper("`effect'") == "ATT") {;
		
			display in green "att"	 , in yellow %4.3f MEANS[1,1];
			display in green "att_ci", in yellow "(" %4.3f CI[1,1] "," , %4.3f CI[2,1] ")";

			display in green "ate"	 , in yellow %4.3f MEANS[1,2];
			display in green "ate_ci", in yellow "(" %4.3f CI[1,2] "," , %4.3f CI[2,2] ")";
			
			display in green "atu"	 , in yellow %4.3f MEANS[1,3];
			display in green "atu_ci", in yellow "(" %4.3f CI[1,3] "," , %4.3f CI[2,3] ")";
		};

end;

table7;


