#delim;
clear;
set mem 200m;
set more off;
cap log close;

global c_data "I:/Schooling\created_data";
global results "I:/Schooling\programs\ols_iv\results";
global progdir "I:/Schooling\programs\data_work";
global ifls97 "I:\Schooling\alldata\hh1997"; 
global ifls93 "I:\Schooling\alldata\hh1993"; 
global ifls00 "I:\Schooling\alldata\hh2000"; 

** migration variables;
** MIGRATION VARIABLES ARE NOT YET PUBLIC FOR 1997 IFLS; 
//I have not been able to ascertain if 2000 IFLS contains information on type of residence at age 12 for all respondents or only for new respondents. For time being using migration variables from IFLS 2000. 

use $ifls00/b3a_mg1.dta, clear;
// where did respondent live at age 12

tab mg04; 
tab mg08;

replace mg08 = mg04 if mg04a == 1; 
replace mg08 =. if mg08 >5; 
rename mg08 location12; 

gen vill_12 = (location12 ==1);
gen town_12 = (location12== 3);
gen city_12 = (location12==5); 
for var *_12: replace X = . if location12 ==.;  

rename mg19b moved12; 

recode moved12 9=. 3 = 0; 
recode moved12 . = 1 if inrange(mg20c, 1,17); 
recode moved12 . =0 if mg20c ==0; 

keep pidlink location12 moved12 *_12; 
sort pidlink;
save $c_data\migration.dta, replace; 


