#delim; 
clear; 
set mem 200m; 
set more off; 

local com_data "C:\Users\wb245036\Dropbox\Schooling\data"; 
global sar "`com_data'"; 
global bk1 "`com_data'"; 
global bk2 "`com_data'"; 
global c_data "C:\Users\wb245036\Dropbox\Schooling\created_data";  

** VARIABLES ARE FROM SERVICE AVAILABILITY ROSTER OF COMMUNITY FACILITY QUESTIONNAIRE 2000
** Geographic variables; 
/* 
use $bk1/bk1, clear; 
codebook lk05 lk01 lk02 lk03; //type of areas and province district and subdistrict codes (see bk1)
keep  commid00 lk05 lk01 lk02 lk03; 
tempfile area; 
sort commid00; 
save `area', replace; 
*/

use $sar/sar, clear; //service availability 
tab facility; // there are several facilities in each community
keep if x15x == 3; //drop duplicates


** UPPER SECONDARY SCHOOL; 
** THE ORIGINAL IV WHICH IS DISTANCE TO SCHOOL WITHOUT CONDITIONING ON AGE OF SCHOOL

** IN KILOMETERS; 
keep if facility == "SMP";
*bys commid00: egen kmsmp = min(km2kd); //THIS IS THE ORIGINAL IV
**JAE REVISION: CREATE SCHOOL AGE;
gen schoolage = 2000-calyropn if cayropnx == 3; 
replace schoolage = calyropn if cayropnx == 1;
drop if km2kd > 500;
keep commid00 km2kd schoolage; 
bys commid00: gen schoolid = _n; 
reshape wide km2kd schoolage, i(commid00) j(schoolid);
save $c_data/dist_age, replace;

/*
** IN MINUTES; 
keep if facility == "SMP";
*bys commid00: egen kmsmp = min(km2kd); //THIS IS THE ORIGINAL IV
**JAE REVISION: CREATE SCHOOL AGE;
gen schoolage = 2000-calyropn if cayropnx == 3; 
replace schoolage = calyropn if cayropnx == 1;
drop if min2kd == 999;
keep commid00 min2kd schoolage; 
bys commid00: gen schoolid = _n; 
reshape wide min2kd schoolage, i(commid00) j(schoolid);
save $c_data/dist_age, replace;
*/

use C:\Users\wb245036\Dropbox\Schooling\created_data\ind.dta, clear; 
drop operates_sd cayropnx_sd min2kd schoolage_sd operates_smp cayropnx_smp schoolage_smp; 
sort commid00; 
merge commid00 using $c_data/dist_age; 
tab _merge; 
keep if _merge ==3;
save $c_data/ind_jaerr2, replace; 

/*
sort commid00;
tempfile min2smp; 
save `min2smp',replace; 
restore;

use `area', clear; 
sort commid00; 
merge commid00 using `min2sd'; tab _merge; keep if _merge == 3; drop _merge; 
sort commid00; 
merge commid00 using `min2smp'; tab _merge; keep if _merge == 3;  drop _merge; 

recode lk05 1=0 2=1; 
rename lk05 rural; 
rename lk01 province; 

keep commid00 min2kd schoolage;
sort commid00; 
save $c_data/com_fac_jae, replace; 
*/
