#delim; 
clear; 
set mem 200m; 
set more off; 

local com_data "I:\Schooling/com_data"; 
global sar "`com_data'/sar"; 
global bk1 "`com_data'/bk1"; 
global bk2 "`com_data'/bk2"; 
global c_data "I:\Schooling\created_data";  

** VARIABLES ARE FROM SERVICE AVAILABILITY ROSTER OF COMMUNITY FACILITY QUESTIONNAIRE 2000
** Geographic variables; 
 
use $bk1/bk1, clear; 
codebook lk05 lk01 lk02 lk03; //type of areas and province district and subdistrict codes (see bk1)
keep  commid00 lk05 lk01 lk02 lk03; 
tempfile area; 
sort commid00; 
save `area', replace; 

use $sar/sar, clear; //service availability 
tab facility; // there are several facilities in each community
keep if x15x == 3; //drop duplicates

preserve; 
keep if facility == "pusk"; //primary school
*keep only nearest school measured in travelling time; 
bys commid00: egen min2sd = min(min2kd); 
bys commid00: egen kmsd = min(km2kd); 
keep if min2sd == min2kd;
drop if min2sd ==. & kmsd ==.; 
duplicates drop commid00, force; // there are 312 communities in total and 16 are missing
duplicates report commid00; 

/* add year when school was opened and a discreet var if information is available*/

replace cayropnx = 9 if operates == 3; /* missing info on school age*/
replace calyropn = 1900+calyropn if cayropnx == 3; 
gen schoolage_sd = 2000 - calyropn; 
rename operates operates_sd; 
rename cayropnx cayropnx_sd; 

keep commid00 min2sd kmsd min2kdm cayropnx_sd schoolage_sd operates_sd ; 
sort commid00;
tempfile min2sd; 
save `min2sd',replace; 
restore;

preserve; 
keep if facility == "SMP";
*keep only nearest school measured in travelling time; 
bys commid00: egen min2smp = min(min2kd); 
bys commid00: egen kmsmp = min(km2kd);
keep if min2smp == min2kd; 
drop if min2smp ==. & kmsmp ==.; 
duplicates drop commid00, force; // there are 312 communities in total and 16 are missing
duplicates report commid00; 
/* add year when school was opened and a discreet var if information is available*/
replace cayropnx = 9 if operates == 3; /* missing info on school age*/
replace calyropn = 1900+calyropn if cayropnx == 3; 
gen schoolage_smp = 2000 - calyropn; 
rename operates operates_smp; 
rename cayropnx cayropnx_smp; 

keep commid00 min2smp kmsmp min2kdm cayropnx_smp schoolage_smp operates_smp; 
sort commid00;
tempfile min2smp; 
save `min2smp',replace; 
restore;

use `area', clear; 
sort commid00; 
merge commid00 using `min2sd'; tab _merge;  drop _merge; 
sort commid00; 
merge commid00 using `min2smp'; tab _merge;  drop _merge; 

recode lk05 1=0 2=1; 
rename lk05 rural; 
rename lk01 province; 

sort commid00; 
save $c_data/com_fac, replace; 
