%Plot simulation results
nr=3;
nc=3;
show_horz=20;
time=0:1:show_horz-1;

%skip initial period
if skip_ini_period==1
    tt=2:show_horz+1;
else
    tt=1:show_horz;
end

%First 12 Variables plotted as they appear in the var statement
%nonlinear model
oo_endo_simul_base_nonlin=oo_endo_simul_base(1:12,1:end);

%linear model - retrieve levels
oo_endo_simul_base_lin_orig=oo_endo_simul_base(13:24,1:end);
oo_endo_simul_base_lin=oo_endo_simul_base_lin_orig*NaN;
oo_endo_simul_base_lin(1,:)=oo_endo_simul_base_lin_orig(1,1:end); %output gap
oo_endo_simul_base_lin(2,:)=(1+oo_endo_simul_base_lin_orig(2,1:end))*M_.params(loc(M_.param_names(:,:),'piV_SS')); %inflation
oo_endo_simul_base_lin(3,:)=(1+oo_endo_simul_base_lin_orig(3,1:end))*M_.params(loc(M_.param_names(:,:),'RV_SS')); %nom. interest rate
oo_endo_simul_base_lin(4,:)=(1+oo_endo_simul_base_lin_orig(4,1:end))*M_.params(loc(M_.param_names(:,:),'rrV_SS')); %real interest rate
oo_endo_simul_base_lin(5,:)=(1+oo_endo_simul_base_lin_orig(5,1:end))*M_.params(loc(M_.param_names(:,:),'rrV_SS')); %potential real interest rate
oo_endo_simul_base_lin(6,:)=(1+oo_endo_simul_base_lin_orig(6,1:end))*M_.params(loc(M_.param_names(:,:),'yV_SS')); %real GDP
oo_endo_simul_base_lin(7,:)=(1+oo_endo_simul_base_lin_orig(7,1:end))*M_.params(loc(M_.param_names(:,:),'pstarV_SS')); %inverse price dispersion
oo_endo_simul_base_lin(8,:)=oo_endo_simul_base_lin_orig(8,1:end)+M_.params(loc(M_.param_names(:,:),'bGV_SS')); %gov. debt
oo_endo_simul_base_lin(9,:)=oo_endo_simul_base_lin_orig(9,1:end)+M_.params(loc(M_.param_names(:,:),'tauV_SS')); %lump-sum taxes
oo_endo_simul_base_lin(10,:)=oo_endo_simul_base_lin_orig(10,1:end)+M_.params(loc(M_.param_names(:,:),'tauNV_SS')); %labor income taxes
oo_endo_simul_base_lin(11,:)=(1+oo_endo_simul_base_lin_orig(11,1:end))*M_.params(loc(M_.param_names(:,:),'gV_SS')); %gov. cons.
oo_endo_simul_base_lin(12,:)=oo_endo_simul_base_lin_orig(12,1:end)+M_.params(loc(M_.param_names(:,:),'nuV_SS')); %cons. demand shock



varnames={
    'Output Gap';
    'Inflation (APR)';
    'Nominal Interest Rate (APR)';
    'Real Interest Rate (APR)';
    'Potential Real Interest Rate (APR)';
    'Real GDP';
    'Price Dispersion';
    'Gov. Debt (% of S-S Output)';         
    'Lump-sum Taxes (% of SS Output)';
    'Labor Income Taxes';
    'Shock: Gov. Consumption (%)';
    'Cons. Demand Shock';
    };

vartype=[3 2 2 2 2 1 1 5 6 3 1 4]; %1=percent dev. from ss; 2=APR; 3=percent; 4=level; 5=percent of annual output; 6=percent of output


figure;

index=1:1:size(varnames,1);
index=[1 2 3 4 5 7 6 8 12];
hh=0;

for kkk=index
    hh=hh+1;
    subplot(nr,nc,hh)
    
    if vartype(1,kkk)==1
        plot(time, (log(oo_endo_simul_base_nonlin(kkk,tt))-log(oo_steady_state_base(kkk)))*100 ,'r--','LineWidth',2,'MarkerSize',4); hold on
        plot(time, (log(oo_endo_simul_base_lin(kkk,tt))-log(oo_steady_state_base(kkk)))*100 ,'b-','LineWidth',2,'MarkerSize',5); hold on
        plot(time, time*0,'k:','LineWidth',2,'MarkerSize',4); hold on
    elseif vartype(1,kkk)==2
        plot(time, (oo_endo_simul_base_nonlin(kkk,tt)-1)*400 ,'r--','LineWidth',2,'MarkerSize',4); hold on
        plot(time, (oo_endo_simul_base_lin(kkk,tt)-1)*400 ,'b-','LineWidth',2,'MarkerSize',5); hold on
    elseif vartype(1,kkk)==3
        plot(time, (oo_endo_simul_base_nonlin(kkk,tt))*100 ,'r--','LineWidth',2,'MarkerSize',4); hold on
        plot(time, (oo_endo_simul_base_lin(kkk,tt))*100 ,'b-','LineWidth',2,'MarkerSize',5); hold on
        %plot(time, (ones(1,show_horz).*oo_steady_state_base(kkk))*100,'k:','LineWidth',2,'MarkerSize',4); hold on
   elseif vartype(1,kkk)==4
        plot(time, (oo_endo_simul_base_nonlin(kkk,tt)) ,'r--','LineWidth',2,'MarkerSize',4); hold on
        plot(time, (oo_endo_simul_base_lin(kkk,tt)) ,'b-','LineWidth',2,'MarkerSize',5); hold on
        %plot(time, (ones(1,show_horz).*oo_steady_state_base(kkk)),'k:','LineWidth',2,'MarkerSize',4); hold on
   elseif vartype(1,kkk)==5
        yssA=M_.params(loc(M_.param_names(:,:),'yV_SS'))*4;
        plot(time, (oo_endo_simul_base_nonlin(kkk,tt))/yssA*100 ,'r--','LineWidth',2,'MarkerSize',4); hold on
        plot(time, (oo_endo_simul_base_lin(kkk,tt))/yssA*100 ,'b-','LineWidth',2,'MarkerSize',5); hold on
        %plot(time, (ones(1,show_horz).*oo_steady_state_base(kkk))/yssA*100,'k:','LineWidth',2,'MarkerSize',4); hold on
   elseif vartype(1,kkk)==6
        yssA=M_.params(loc(M_.param_names(:,:),'yV_SS'));
        plot(time, (oo_endo_simul_base_nonlin(kkk,tt))/yssA*100 ,'r--','LineWidth',2,'MarkerSize',4); hold on
        plot(time, (oo_endo_simul_base_lin(kkk,tt))/yssA*100 ,'b-','LineWidth',2,'MarkerSize',5); hold on
        %plot(time, (ones(1,show_horz).*oo_steady_state_base(kkk))/yssA*100,'k:','LineWidth',2,'MarkerSize',4); hold on
   end
    title(varnames(kkk,:),'Fontsize',10);
    set(gca,'Fontsize',10);
    
    axis tight
    if hh>6
        xlabel('Quarters','Fontsize',10);
    end
    if hh<9
        ylabel('Percent','Fontsize',10);
    else
       ylabel('Level','Fontsize',10); 
    end
end
suptitle(figtitle);
 
legend1 =legend(legstring);
        set(legend1,'Orientation','horizontal',...
            'Position',[0.171517101838298 0.901022628824886 0.686676427525622 0.0368098159509202],'FontSize',8,'Interpreter','tex');
%orient landscape
%print('-dpdf',['figure1']);



