function [p p_pibar p_thetap p_xip p_psie p_pitilde p_gampi p_gamx p_alfa p_betta p_sigma ...
          p_chi p_nu p_gy p_tauC p_bGy p_tauy p_phiT p_phiN p_rhoG p_rhonu p_rhodelta p_sigG_nonlin p_signu_nonlin ...
          p_sigdelta p_gAtZLBonly p_sigG_lin p_signu_lin] =params

      
p.pibar=1.005;  %steady state gross inflation rate
p.thetap=0.1;   %net price markup in steady state
p.xip=0.667;     %Calvo sticky prices parameter
p.psie=-12.2;      %Kimball aggregator parameter 
p.pitilde=p.pibar;%Indexation to ss inflation
if abs(p.pitilde-p.pibar)>0,error('pitilde needs to equal pibar for now!'); end

p.gampi=1.5;   %Taylor rule coef. on inflation
p.gamx=0.125;  %Taylor rule coef. on output gap

p.alfa=0.3;    %capital share in production
p.betta=0.995; %discount factor of households
p.sigma=1;     %inverse intertemporal elasticity of substitution

                %code needs fixing for sigma different from 1
             
p.chi=1/0.4;   %inverse Frisch elasticity of labor supply
p.nu=0.01;     %steady state of cons. demand shock

p.gy=0.2;      %gov. consumption to output ratio in steady state
p.tauC=0;      %steady state cons. tax
p.bGy=2.4;     %steady state debt to GDP ratio
p.tauy=0;      %steady state transfer to GDP ratio

p.phiT=1*(1/p.betta-1)*2; %fiscal rule for lump-sum taxes: coef. on debt
p.phiN=0*(1/p.betta-1)*2; %fiscal rule for labor taxes: coef. on debt

p.rhodelta=0.95;%AR(1) discount factor shock

p.sigdelta=0.005;%Std. discount factor shock
p.gAtZLBonly=0;%if=0, gov. spending follows AR(1); if=1 gov. spending positive at ZLB only



%%%%%%%%%%%%%%%%%%%%%%%%%
%AR(1) gov. cons shock
%%%%%%%%%%%%%%%%%%%%%%%%%
p.rhoG=0.95;     
%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%
%Std.gov. cons shock
%%%%%%%%%%%%%%%%%%%%%%%%%
p.sigG_nonlin=0.01; 
p.sigG_lin=0.01;     
%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%
%AR(1) cons. demand shock
%%%%%%%%%%%%%%%%%%%%%%%%%  
p.rhonu=0.95;   
%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%
%Std.cons. demand shock
%%%%%%%%%%%%%%%%%%%%%%%%%
p.signu_nonlin=0.042;
p.signu_lin=0.02275;  
%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%
 






p_pibar=p.pibar;
p_thetap=p.thetap;
p_xip=p.xip;
p_psie=p.psie;
p_pitilde=p.pitilde; 
p_gampi=p.gampi;
p_gamx=p.gamx;
p_alfa=p.alfa;
p_betta=p.betta;
p_sigma=p.sigma;
p_chi=p.chi;
p_nu=p.nu;
p_gy=p.gy;
p_tauC=p.tauC;
p_bGy=p.bGy;
p_tauy=p.tauy;
p_phiT=p.phiT;
p_phiN=p.phiN;
p_rhoG=p.rhoG;
p_rhonu=p.rhonu;
p_rhodelta=p.rhodelta;
p_sigG_nonlin=p.sigG_nonlin;
p_signu_nonlin=p.signu_nonlin;
p_sigG_lin=p.sigG_lin;
p_signu_lin=p.signu_lin;
p_sigdelta=p.sigdelta;
p_gAtZLBonly=p.gAtZLBonly;



  
  
