function [residual, g1, g2, g3] = model_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations.
%                                          Dynare may prepend or append auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g3        [M_.endo_nbr by (M_.endo_nbr)^3] double   Third derivatives matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 63, 1);

%
% Model equations
%

T18 = (-1)/params(5);
T19 = (y(25)-params(4)*y(12))^T18;
T49 = params(8)^params(9);
T50 = y(7)^(-1)*T49;
T52 = y(26)^(1-params(9));
T71 = y(31)^((1+params(40))*(1+params(7))/params(7));
T77 = params(41)/y(2);
T81 = T77^((1+params(40))*(-(1+params(7)))/params(7));
T82 = y(37)*params(1)*params(10)*T81;
T90 = (-(1+params(40)+params(7)*params(40)))/params(7);
T91 = T77^T90;
T92 = y(37)*params(1)*params(10)*T91;
T106 = (1+params(7))*(1+params(40))/params(7);
T108 = y(33)^(1+T106);
T127 = (1+params(40))*(-(1+params(7)))/params(7);
T156 = T49*(1-params(9))*y(26)^(-params(9));
T164 = params(12)*(y(2)/params(11))^params(13);
T166 = y(6)/y(41);
T168 = T166^params(14);
T194 = y(8)/params(15)-params(18)/params(15);
T207 = (y(38)-params(4)*y(12))^T18;
T215 = y(39)^params(6);
T246 = y(42)/params(15)-params(18)/params(15);
T309 = (y(47)-y(24))/(params(5)*(1-params(29)));
T343 = (1-params(10))*(1-params(1)*params(10))/params(10)/(1-(1+params(7))*params(40));
T361 = params(12)/params(11);
T362 = params(18)*T361;
T394 = (y(50)-y(24))/(params(5)*(1-params(29)));
lhs =y(58);
rhs =params(2);
residual(1)= lhs-rhs;
lhs =y(44);
rhs =T19/(1+y(58));
residual(2)= lhs-rhs;
lhs =y(26)^params(6);
rhs =y(44)*(1-y(10))*y(27);
residual(3)= lhs-rhs;
lhs =y(44);
rhs =y(44)*params(1)*y(37)*y(3)/y(2);
residual(4)= lhs-rhs;
lhs =y(25)+y(11);
rhs =y(6);
residual(5)= lhs-rhs;
lhs =y(6);
rhs =T50*T52;
residual(6)= lhs-rhs;
lhs =y(28);
rhs =y(6)*y(44)*(1+params(7))*(1+params(40))/(1+params(40)+params(7)*params(40))*y(29)*T71+y(28)*T82;
residual(7)= lhs-rhs;
lhs =y(30);
rhs =T71*y(44)*y(6)+y(30)*T92;
residual(8)= lhs-rhs;
lhs =y(32);
rhs =y(44)*y(6)*params(7)*params(40)/(1+params(40)+params(7)*params(40))+y(32)*y(37)*params(1)*params(10)*T77;
residual(9)= lhs-rhs;
lhs =y(28);
rhs =y(30)*y(33)-y(32)*T108;
residual(10)= lhs-rhs;
lhs =y(31);
rhs =1+params(40)-params(40)*y(35);
residual(11)= lhs-rhs;
lhs =y(31);
rhs =y(36);
residual(12)= lhs-rhs;
lhs =y(7);
rhs =1/(1+params(40))*(y(31)/y(34))^T106+params(40)/(1+params(40));
residual(13)= lhs-rhs;
lhs =y(34)^T127;
rhs =(1-params(10))*y(33)^T127+params(10)*(T77*y(34))^T127;
residual(14)= lhs-rhs;
lhs =y(35);
rhs =y(33)*(1-params(10))+y(35)*params(10)*params(41)/y(2);
residual(15)= lhs-rhs;
lhs =y(36)^T90;
rhs =(1-params(10))*y(33)^T90+params(10)*(T77*y(36))^T90;
residual(16)= lhs-rhs;
lhs =y(29);
rhs =y(27)*y(61)/T156;
residual(17)= lhs-rhs;
lhs =y(3);
rhs =T164*T168*exp(y(60));
residual(18)= lhs-rhs;
lhs =y(8);
rhs =y(11)+y(8)*y(3)/y(2)-y(58)*y(25)-y(26)*y(10)*y(27)-y(9);
residual(19)= lhs-rhs;
lhs =y(9)/params(15);
rhs =params(16)/params(15)+params(17)*T194;
residual(20)= lhs-rhs;
lhs =y(10)/params(15);
rhs =params(3)/params(15)+T194*params(37);
residual(21)= lhs-rhs;
lhs =T207/(1+y(58));
rhs =T207*params(1)*y(37)*y(5)/(1+y(58));
residual(22)= lhs-rhs;
lhs =T215/T207;
rhs =(1-y(45))/(1+y(58))*y(40);
residual(23)= lhs-rhs;
lhs =y(40);
rhs =T49*(1-params(9))/(1+params(7))*y(39)^(-params(9));
residual(24)= lhs-rhs;
lhs =y(11)+y(38);
rhs =y(41);
residual(25)= lhs-rhs;
lhs =y(41);
rhs =T49*y(39)^(1-params(9));
residual(26)= lhs-rhs;
lhs =y(42);
rhs =y(11)+y(5)*y(42)-y(58)*y(38)-y(39)*y(45)*y(40)-y(43);
residual(27)= lhs-rhs;
lhs =y(43)/params(15);
rhs =params(16)/params(15)+params(17)*T246;
residual(28)= lhs-rhs;
lhs =y(45)/params(15);
rhs =params(3)/params(15)+params(37)*T246;
residual(29)= lhs-rhs;
lhs =y(1);
rhs =log(T166);
residual(30)= lhs-rhs;
lhs =y(4);
rhs =y(3)/y(2);
residual(31)= lhs-rhs;
lhs =y(11)-params(22);
rhs =(y(11)-params(22))*params(19)+x(2);
residual(32)= lhs-rhs;
lhs =y(12)-params(23);
rhs =(y(12)-params(23))*params(20)+x(1);
residual(33)= lhs-rhs;
lhs =y(37)-(y(37));
rhs =params(20)*(y(37)-(y(37)))+x(3);
residual(34)= lhs-rhs;
lhs =y(61)-(y(61));
rhs =params(20)*(y(61)-(y(61)))+x(4);
residual(35)= lhs-rhs;
lhs =y(60)-(y(60));
rhs =(y(60)-(y(60)))*0.7+x(5);
residual(36)= lhs-rhs;
lhs =y(62)-(y(62));
rhs =params(20)*(y(62)-(y(62)))+x(6);
residual(37)= lhs-rhs;
residual(38) = y(59);
lhs =params(6)*y(46)+T309;
rhs =y(48)-y(22)/(1-params(3))-y(59)/(1+params(2));
residual(39)= lhs-rhs;
lhs =0;
rhs =T309+y(57)+y(15)-y(14)-T309;
residual(40)= lhs-rhs;
lhs =params(4)*y(47)+params(22)*y(23);
rhs =params(15)*y(18);
residual(41)= lhs-rhs;
lhs =y(18);
rhs =(1-params(9))*y(46);
residual(42)= lhs-rhs;
lhs =y(14);
rhs =params(1)*y(14)+T343*y(49);
residual(43)= lhs-rhs;
lhs =y(49);
rhs =y(48)+y(63)+params(9)*y(46);
residual(44)= lhs-rhs;
lhs =y(15);
rhs =y(60)+params(13)*y(14)+params(14)*(y(18)-y(52));
residual(45)= lhs-rhs;
lhs =y(20);
rhs =params(22)*y(23)+T362*(y(15)-y(14))+y(20)*T361-y(47)*params(2)*params(4)-params(4)*y(59)-y(22)*params(30)*params(31)-params(31)*params(3)*params(30)*(y(46)+y(48))-y(21);
residual(46)= lhs-rhs;
lhs =y(21);
rhs =params(17)*y(20);
residual(47)= lhs-rhs;
lhs =y(22);
rhs =params(37)*y(20);
residual(48)= lhs-rhs;
lhs =0;
rhs =T394+y(57)+y(17)-T394;
residual(49)= lhs-rhs;
lhs =T394+params(6)*y(55);
rhs =y(51)-y(56)/(1-params(3))-y(59)/(1+params(2));
residual(50)= lhs-rhs;
lhs =y(51);
rhs =(-params(9))*y(55);
residual(51)= lhs-rhs;
lhs =params(22)*y(23)+params(4)*y(50);
rhs =params(15)*y(52);
residual(52)= lhs-rhs;
lhs =y(52);
rhs =(1-params(9))*y(55);
residual(53)= lhs-rhs;
lhs =y(53);
rhs =params(22)*y(23)+T362*y(17)+T361*y(53)-params(2)*params(4)*y(50)-params(4)*y(59)-params(30)*params(31)*y(56)-params(31)*params(3)*params(30)*(y(55)+y(51))-y(54);
residual(54)= lhs-rhs;
lhs =y(54);
rhs =params(17)*y(53);
residual(55)= lhs-rhs;
lhs =y(56);
rhs =params(37)*y(53);
residual(56)= lhs-rhs;
lhs =y(13);
rhs =y(18)-y(52);
residual(57)= lhs-rhs;
lhs =y(16);
rhs =y(15)-y(14);
residual(58)= lhs-rhs;
lhs =y(23);
rhs =(y(11)-params(22))/params(22);
residual(59)= lhs-rhs;
lhs =y(24);
rhs =x(1)+params(20)*y(24);
residual(60)= lhs-rhs;
lhs =y(19);
rhs =params(10)*y(19);
residual(61)= lhs-rhs;
lhs =y(57);
rhs =(y(37)-(y(37)))/(y(37));
residual(62)= lhs-rhs;
lhs =y(63);
rhs =(y(61)-(y(61)))/(y(61));
residual(63)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(63, 63);

  %
  % Jacobian matrix
  %

T457 = (-params(41))/(y(2)*y(2));
T472 = getPowerDeriv(T77*y(34),T127,1);
T481 = getPowerDeriv(T77*y(36),T90,1);
T516 = getPowerDeriv(T166,params(14),1);
T528 = 1/params(15);
T542 = getPowerDeriv(y(25)-params(4)*y(12),T18,1);
T546 = getPowerDeriv(y(38)-params(4)*y(12),T18,1);
T547 = (-params(4))*T546;
T596 = getPowerDeriv(y(31),(1+params(40))*(1+params(7))/params(7),1);
T602 = getPowerDeriv(y(31)/y(34),T106,1);
  g1(1,58)=1;
  g1(2,12)=(-((-params(4))*T542/(1+y(58))));
  g1(2,25)=(-(T542/(1+y(58))));
  g1(2,44)=1;
  g1(2,58)=(-((-T19)/((1+y(58))*(1+y(58)))));
  g1(3,10)=(-(y(27)*(-y(44))));
  g1(3,26)=getPowerDeriv(y(26),params(6),1);
  g1(3,27)=(-(y(44)*(1-y(10))));
  g1(3,44)=(-((1-y(10))*y(27)));
  g1(4,2)=(-(y(44)*(-(params(1)*y(37)*y(3)))/(y(2)*y(2))));
  g1(4,3)=(-(y(44)*params(1)*y(37)/y(2)));
  g1(4,37)=(-(y(44)*params(1)*y(3)/y(2)));
  g1(4,44)=1-params(1)*y(37)*y(3)/y(2);
  g1(5,6)=(-1);
  g1(5,11)=1;
  g1(5,25)=1;
  g1(6,6)=1;
  g1(6,7)=(-(T52*T49*getPowerDeriv(y(7),(-1),1)));
  g1(6,26)=(-(T50*getPowerDeriv(y(26),1-params(9),1)));
  g1(7,2)=(-(y(28)*y(37)*params(1)*params(10)*T457*getPowerDeriv(T77,(1+params(40))*(-(1+params(7)))/params(7),1)));
  g1(7,6)=(-(T71*y(44)*(1+params(7))*(1+params(40))/(1+params(40)+params(7)*params(40))*y(29)));
  g1(7,28)=1-T82;
  g1(7,29)=(-(y(6)*y(44)*(1+params(7))*(1+params(40))/(1+params(40)+params(7)*params(40))*T71));
  g1(7,31)=(-(y(6)*y(44)*(1+params(7))*(1+params(40))/(1+params(40)+params(7)*params(40))*y(29)*T596));
  g1(7,37)=(-(y(28)*params(1)*params(10)*T81));
  g1(7,44)=(-(T71*y(29)*y(6)*(1+params(7))*(1+params(40))/(1+params(40)+params(7)*params(40))));
  g1(8,2)=(-(y(30)*y(37)*params(1)*params(10)*T457*getPowerDeriv(T77,T90,1)));
  g1(8,6)=(-(y(44)*T71));
  g1(8,30)=1-T92;
  g1(8,31)=(-(y(44)*y(6)*T596));
  g1(8,37)=(-(y(30)*params(1)*params(10)*T91));
  g1(8,44)=(-(y(6)*T71));
  g1(9,2)=(-(y(32)*y(37)*params(1)*params(10)*T457));
  g1(9,6)=(-(y(44)*params(7)*params(40)/(1+params(40)+params(7)*params(40))));
  g1(9,32)=1-y(37)*params(1)*params(10)*T77;
  g1(9,37)=(-(y(32)*params(1)*params(10)*T77));
  g1(9,44)=(-(y(6)*params(7)*params(40)/(1+params(40)+params(7)*params(40))));
  g1(10,28)=1;
  g1(10,30)=(-y(33));
  g1(10,32)=T108;
  g1(10,33)=(-(y(30)-y(32)*getPowerDeriv(y(33),1+T106,1)));
  g1(11,31)=1;
  g1(11,35)=params(40);
  g1(12,31)=1;
  g1(12,36)=(-1);
  g1(13,7)=1;
  g1(13,31)=(-(1/(1+params(40))*1/y(34)*T602));
  g1(13,34)=(-(1/(1+params(40))*T602*(-y(31))/(y(34)*y(34))));
  g1(14,2)=(-(params(10)*y(34)*T457*T472));
  g1(14,33)=(-((1-params(10))*getPowerDeriv(y(33),T127,1)));
  g1(14,34)=getPowerDeriv(y(34),T127,1)-params(10)*T77*T472;
  g1(15,2)=(-(y(35)*(-(params(10)*params(41)))/(y(2)*y(2))));
  g1(15,33)=(-(1-params(10)));
  g1(15,35)=1-params(10)*params(41)/y(2);
  g1(16,2)=(-(params(10)*y(36)*T457*T481));
  g1(16,33)=(-((1-params(10))*getPowerDeriv(y(33),T90,1)));
  g1(16,36)=getPowerDeriv(y(36),T90,1)-params(10)*T77*T481;
  g1(17,26)=(-((-(y(27)*y(61)*T49*(1-params(9))*getPowerDeriv(y(26),(-params(9)),1)))/(T156*T156)));
  g1(17,27)=(-(y(61)/T156));
  g1(17,29)=1;
  g1(17,61)=(-(y(27)/T156));
  g1(18,2)=(-(exp(y(60))*T168*params(12)*1/params(11)*getPowerDeriv(y(2)/params(11),params(13),1)));
  g1(18,3)=1;
  g1(18,6)=(-(exp(y(60))*T164*1/y(41)*T516));
  g1(18,41)=(-(exp(y(60))*T164*T516*(-y(6))/(y(41)*y(41))));
  g1(18,60)=(-(T164*T168*exp(y(60))));
  g1(19,2)=(-(y(8)*(-y(3))/(y(2)*y(2))));
  g1(19,3)=(-(y(8)*1/y(2)));
  g1(19,8)=1-y(3)/y(2);
  g1(19,9)=1;
  g1(19,10)=y(26)*y(27);
  g1(19,11)=(-1);
  g1(19,25)=y(58);
  g1(19,26)=y(10)*y(27);
  g1(19,27)=y(26)*y(10);
  g1(19,58)=y(25);
  g1(20,8)=(-(params(17)*T528));
  g1(20,9)=T528;
  g1(21,8)=(-(params(37)*T528));
  g1(21,10)=T528;
  g1(22,5)=(-(params(1)*y(37)*T207/(1+y(58))));
  g1(22,12)=T547/(1+y(58))-params(1)*y(37)*y(5)*T547/(1+y(58));
  g1(22,37)=(-(T207*params(1)*y(5)/(1+y(58))));
  g1(22,38)=T546/(1+y(58))-params(1)*y(37)*y(5)*T546/(1+y(58));
  g1(22,58)=(-T207)/((1+y(58))*(1+y(58)))-(-(T207*params(1)*y(37)*y(5)))/((1+y(58))*(1+y(58)));
  g1(23,12)=(-(T215*T547))/(T207*T207);
  g1(23,38)=(-(T215*T546))/(T207*T207);
  g1(23,39)=getPowerDeriv(y(39),params(6),1)/T207;
  g1(23,40)=(-((1-y(45))/(1+y(58))));
  g1(23,45)=(-(y(40)*(-1)/(1+y(58))));
  g1(23,58)=(-(y(40)*(-(1-y(45)))/((1+y(58))*(1+y(58)))));
  g1(24,39)=(-(T49*(1-params(9))/(1+params(7))*getPowerDeriv(y(39),(-params(9)),1)));
  g1(24,40)=1;
  g1(25,11)=1;
  g1(25,38)=1;
  g1(25,41)=(-1);
  g1(26,39)=(-(T49*getPowerDeriv(y(39),1-params(9),1)));
  g1(26,41)=1;
  g1(27,5)=(-y(42));
  g1(27,11)=(-1);
  g1(27,38)=y(58);
  g1(27,39)=y(45)*y(40);
  g1(27,40)=y(39)*y(45);
  g1(27,42)=1-y(5);
  g1(27,43)=1;
  g1(27,45)=y(39)*y(40);
  g1(27,58)=y(38);
  g1(28,42)=(-(params(17)*T528));
  g1(28,43)=T528;
  g1(29,42)=(-(params(37)*T528));
  g1(29,45)=T528;
  g1(30,1)=1;
  g1(30,6)=(-(1/y(41)/T166));
  g1(30,41)=(-((-y(6))/(y(41)*y(41))/T166));
  g1(31,2)=(-((-y(3))/(y(2)*y(2))));
  g1(31,3)=(-(1/y(2)));
  g1(31,4)=1;
  g1(32,11)=1-params(19);
  g1(33,12)=1-params(20);
  g1(38,59)=1;
  g1(39,22)=1/(1-params(3));
  g1(39,24)=(-1)/(params(5)*(1-params(29)));
  g1(39,46)=params(6);
  g1(39,47)=1/(params(5)*(1-params(29)));
  g1(39,48)=(-1);
  g1(39,59)=1/(1+params(2));
  g1(40,14)=1;
  g1(40,15)=(-1);
  g1(40,57)=(-1);
  g1(41,18)=(-params(15));
  g1(41,23)=params(22);
  g1(41,47)=params(4);
  g1(42,18)=1;
  g1(42,46)=(-(1-params(9)));
  g1(43,14)=1-params(1);
  g1(43,49)=(-T343);
  g1(44,46)=(-params(9));
  g1(44,48)=(-1);
  g1(44,49)=1;
  g1(44,63)=(-1);
  g1(45,14)=(-params(13));
  g1(45,15)=1;
  g1(45,18)=(-params(14));
  g1(45,52)=params(14);
  g1(45,60)=(-1);
  g1(46,14)=T362;
  g1(46,15)=(-T362);
  g1(46,20)=1-T361;
  g1(46,21)=1;
  g1(46,22)=params(30)*params(31);
  g1(46,23)=(-params(22));
  g1(46,46)=params(31)*params(3)*params(30);
  g1(46,47)=params(2)*params(4);
  g1(46,48)=params(31)*params(3)*params(30);
  g1(46,59)=params(4);
  g1(47,20)=(-params(17));
  g1(47,21)=1;
  g1(48,20)=(-params(37));
  g1(48,22)=1;
  g1(49,17)=(-1);
  g1(49,57)=(-1);
  g1(50,24)=(-1)/(params(5)*(1-params(29)));
  g1(50,50)=1/(params(5)*(1-params(29)));
  g1(50,51)=(-1);
  g1(50,55)=params(6);
  g1(50,56)=1/(1-params(3));
  g1(50,59)=1/(1+params(2));
  g1(51,51)=1;
  g1(51,55)=params(9);
  g1(52,23)=params(22);
  g1(52,50)=params(4);
  g1(52,52)=(-params(15));
  g1(53,52)=1;
  g1(53,55)=(-(1-params(9)));
  g1(54,17)=(-T362);
  g1(54,23)=(-params(22));
  g1(54,50)=params(2)*params(4);
  g1(54,51)=params(31)*params(3)*params(30);
  g1(54,53)=1-T361;
  g1(54,54)=1;
  g1(54,55)=params(31)*params(3)*params(30);
  g1(54,56)=params(30)*params(31);
  g1(54,59)=params(4);
  g1(55,53)=(-params(17));
  g1(55,54)=1;
  g1(56,53)=(-params(37));
  g1(56,56)=1;
  g1(57,13)=1;
  g1(57,18)=(-1);
  g1(57,52)=1;
  g1(58,14)=1;
  g1(58,15)=(-1);
  g1(58,16)=1;
  g1(59,11)=(-(1/params(22)));
  g1(59,23)=1;
  g1(60,24)=1-params(20);
  g1(61,19)=1-params(10);
  g1(62,37)=(-((-(y(37)-(y(37))))/((y(37))*(y(37)))));
  g1(62,57)=1;
  g1(63,61)=(-((-(y(61)-(y(61))))/((y(61))*(y(61)))));
  g1(63,63)=1;
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],63,3969);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],63,250047);
end
end
end
end
