function [residual, g1, g2, g3] = model_dynamic(y, x, params, steady_state, it_)
%
% Status : Computes dynamic model for Dynare
%
% Inputs :
%   y         [#dynamic variables by 1] double    vector of endogenous variables in the order stored
%                                                 in M_.lead_lag_incidence; see the Manual
%   x         [nperiods by M_.exo_nbr] double     matrix of exogenous variables (in declaration order)
%                                                 for all simulation periods
%   steady_state  [M_.endo_nbr by 1] double       vector of steady state values
%   params    [M_.param_nbr by 1] double          vector of parameter values in declaration order
%   it_       scalar double                       time period for exogenous variables for which to evaluate the model
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the dynamic model equations in order of 
%                                          declaration of the equations.
%                                          Dynare may prepend auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by #dynamic variables] double    Jacobian matrix of the dynamic model equations;
%                                                           rows: equations in order of declaration
%                                                           columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g2        [M_.endo_nbr by (#dynamic variables)^2] double   Hessian matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g3        [M_.endo_nbr by (#dynamic variables)^3] double   Third order derivative matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

%
% Model equations
%

residual = zeros(63, 1);
T18 = (-1)/params(5);
T19 = (y(44)-params(4)*y(31))^T18;
T50 = params(8)^params(9);
T51 = y(26)^(-1)*T50;
T53 = y(45)^(1-params(9));
T64 = (1+params(7))*(1+params(40))/(1+params(40)+params(7)*params(40));
T65 = y(63)*T64;
T71 = (1+params(40))*(1+params(7))/params(7);
T72 = y(50)^T71;
T78 = params(41)/y(83);
T81 = (1+params(40))*(-(1+params(7)))/params(7);
T82 = T78^T81;
T83 = y(56)*params(1)*params(10)*T82;
T92 = (-(1+params(40)+params(7)*params(40)))/params(7);
T93 = T78^T92;
T94 = y(56)*params(1)*params(10)*T93;
T100 = params(7)*params(40)/(1+params(40)+params(7)*params(40));
T110 = (1+params(7))*(1+params(40))/params(7);
T112 = y(52)^(1+T110);
T122 = 1/(1+params(40));
T131 = (1+params(40))*(-(1+params(7)))/params(7);
T137 = params(41)/y(21);
T165 = T50*(1-params(9))*y(45)^(-params(9));
T173 = params(12)*(y(21)/params(11))^params(13);
T175 = y(25)/y(60);
T177 = T175^params(14);
T205 = y(3)/params(15)-params(18)/params(15);
T218 = (y(57)-params(4)*y(31))^T18;
T226 = (y(90)-params(4)*y(84))^T18;
T233 = y(58)^params(6);
T242 = T50*(1-params(9))/(1+params(7));
T266 = y(15)/params(15)-params(18)/params(15);
T385 = (1-params(10))*(1-params(1)*params(10))/params(10)/(1-(1+params(7))*params(40));
T403 = params(12)/params(11);
T404 = params(18)*T403;
lhs =y(77);
rhs =params(2);
residual(1)= lhs-rhs;
lhs =y(63);
rhs =T19/(1+y(77));
residual(2)= lhs-rhs;
lhs =y(45)^params(6);
rhs =y(63)*(1-y(29))*y(46);
residual(3)= lhs-rhs;
lhs =y(63);
rhs =params(1)*y(56)*y(22)/y(83)*y(91);
residual(4)= lhs-rhs;
lhs =y(44)+y(30);
rhs =y(25);
residual(5)= lhs-rhs;
lhs =y(25);
rhs =T51*T53;
residual(6)= lhs-rhs;
lhs =y(47);
rhs =y(25)*T65*y(48)*T72+T83*y(87);
residual(7)= lhs-rhs;
lhs =y(49);
rhs =T72*y(63)*y(25)+T94*y(88);
residual(8)= lhs-rhs;
lhs =y(51);
rhs =y(63)*y(25)*T100+y(56)*params(1)*params(10)*T78*y(89);
residual(9)= lhs-rhs;
lhs =y(47);
rhs =y(49)*y(52)-y(51)*T112;
residual(10)= lhs-rhs;
lhs =y(50);
rhs =1+params(40)-params(40)*y(54);
residual(11)= lhs-rhs;
lhs =y(50);
rhs =y(55);
residual(12)= lhs-rhs;
lhs =y(26);
rhs =T122*(y(50)/y(53))^T110+params(40)/(1+params(40));
residual(13)= lhs-rhs;
lhs =y(53)^T131;
rhs =(1-params(10))*y(52)^T131+params(10)*(T137*y(11))^T131;
residual(14)= lhs-rhs;
lhs =y(54);
rhs =y(52)*(1-params(10))+params(10)*params(41)/y(21)*y(12);
residual(15)= lhs-rhs;
lhs =y(55)^T92;
rhs =(1-params(10))*y(52)^T92+params(10)*(T137*y(13))^T92;
residual(16)= lhs-rhs;
lhs =y(48);
rhs =y(46)*y(80)/T165;
residual(17)= lhs-rhs;
lhs =y(22);
rhs =T173*T177*exp(y(79));
residual(18)= lhs-rhs;
lhs =y(27);
rhs =y(30)+y(1)/y(21)*y(3)-y(77)*y(44)-y(45)*y(29)*y(46)-y(28);
residual(19)= lhs-rhs;
lhs =y(28)/params(15);
rhs =params(16)/params(15)+params(17)*T205;
residual(20)= lhs-rhs;
lhs =y(29)/params(15);
rhs =params(3)/params(15)+T205*params(37);
residual(21)= lhs-rhs;
lhs =T218/(1+y(77));
rhs =params(1)*y(56)*y(24)*T226/(1+y(94));
residual(22)= lhs-rhs;
lhs =T233/T218;
rhs =(1-y(64))/(1+y(77))*y(59);
residual(23)= lhs-rhs;
lhs =y(59);
rhs =T242*y(58)^(-params(9));
residual(24)= lhs-rhs;
lhs =y(30)+y(57);
rhs =y(60);
residual(25)= lhs-rhs;
lhs =y(60);
rhs =T50*y(58)^(1-params(9));
residual(26)= lhs-rhs;
lhs =y(61);
rhs =y(30)+y(2)*y(15)-y(77)*y(57)-y(58)*y(64)*y(59)-y(62);
residual(27)= lhs-rhs;
lhs =y(62)/params(15);
rhs =params(16)/params(15)+params(17)*T266;
residual(28)= lhs-rhs;
lhs =y(64)/params(15);
rhs =params(3)/params(15)+params(37)*T266;
residual(29)= lhs-rhs;
lhs =y(20);
rhs =log(T175);
residual(30)= lhs-rhs;
lhs =y(23);
rhs =y(22)/y(83);
residual(31)= lhs-rhs;
lhs =y(30)-params(22);
rhs =params(19)*(y(4)-params(22))+x(it_, 2);
residual(32)= lhs-rhs;
lhs =y(31)-params(23);
rhs =params(20)*(y(5)-params(23))+x(it_, 1);
residual(33)= lhs-rhs;
lhs =y(56)-(steady_state(37));
rhs =params(20)*(y(14)-(steady_state(37)))+x(it_, 3);
residual(34)= lhs-rhs;
lhs =y(80)-(steady_state(61));
rhs =params(20)*(y(18)-(steady_state(61)))+x(it_, 4);
residual(35)= lhs-rhs;
lhs =y(79)-(steady_state(60));
rhs =0.7*(y(17)-(steady_state(60)))+x(it_, 5);
residual(36)= lhs-rhs;
lhs =y(81)-(steady_state(62));
rhs =params(20)*(y(19)-(steady_state(62)))+x(it_, 6);
residual(37)= lhs-rhs;
residual(38) = y(78);
lhs =params(6)*y(65)+(y(66)-y(43))/(params(5)*(1-params(29)));
rhs =y(67)-y(41)/(1-params(3))-y(78)/(1+params(2));
residual(39)= lhs-rhs;
lhs =0;
rhs =(y(66)-y(43))/(params(5)*(1-params(29)))+y(76)+y(34)-y(85)-(y(92)-y(86))/(params(5)*(1-params(29)))-(y(95)-y(78))/(1+params(2));
residual(40)= lhs-rhs;
lhs =params(4)*y(66)+params(22)*y(42);
rhs =params(15)*y(37);
residual(41)= lhs-rhs;
lhs =y(37);
rhs =(1-params(9))*y(65);
residual(42)= lhs-rhs;
lhs =y(33);
rhs =params(1)*y(85)+T385*y(68);
residual(43)= lhs-rhs;
lhs =y(68);
rhs =y(67)+y(82)+params(9)*y(65);
residual(44)= lhs-rhs;
lhs =y(34);
rhs =y(79)+params(13)*y(33)+params(14)*(y(37)-y(71));
residual(45)= lhs-rhs;
lhs =y(39);
rhs =params(22)*y(42)+T404*(y(6)-y(33))+T403*y(9)-y(66)*params(2)*params(4)-params(4)*y(78)-y(41)*params(30)*params(31)-params(31)*params(3)*params(30)*(y(65)+y(67))-y(40);
residual(46)= lhs-rhs;
lhs =y(40);
rhs =params(17)*y(9);
residual(47)= lhs-rhs;
lhs =y(41);
rhs =params(37)*y(9);
residual(48)= lhs-rhs;
lhs =0;
rhs =y(76)+y(36)-(y(93)-y(86))/(params(5)*(1-params(29)))+(y(69)-y(43))/(params(5)*(1-params(29)))-(y(95)-y(78))/(1+params(2));
residual(49)= lhs-rhs;
lhs =(y(69)-y(43))/(params(5)*(1-params(29)))+params(6)*y(74);
rhs =y(70)-y(75)/(1-params(3))-y(78)/(1+params(2));
residual(50)= lhs-rhs;
lhs =y(70);
rhs =(-params(9))*y(74);
residual(51)= lhs-rhs;
lhs =params(22)*y(42)+params(4)*y(69);
rhs =params(15)*y(71);
residual(52)= lhs-rhs;
lhs =y(71);
rhs =(1-params(9))*y(74);
residual(53)= lhs-rhs;
lhs =y(72);
rhs =params(22)*y(42)+T404*y(7)+T403*y(16)-params(2)*params(4)*y(69)-params(4)*y(78)-params(30)*params(31)*y(75)-params(31)*params(3)*params(30)*(y(74)+y(70))-y(73);
residual(54)= lhs-rhs;
lhs =y(73);
rhs =params(17)*y(16);
residual(55)= lhs-rhs;
lhs =y(75);
rhs =params(37)*y(16);
residual(56)= lhs-rhs;
lhs =y(32);
rhs =y(37)-y(71);
residual(57)= lhs-rhs;
lhs =y(35);
rhs =y(34)-y(85);
residual(58)= lhs-rhs;
lhs =y(42);
rhs =(y(30)-params(22))/params(22);
residual(59)= lhs-rhs;
lhs =y(43);
rhs =x(it_, 1)+params(20)*y(10);
residual(60)= lhs-rhs;
lhs =y(38);
rhs =params(10)*y(8);
residual(61)= lhs-rhs;
lhs =y(76);
rhs =(y(56)-(steady_state(37)))/(steady_state(37));
residual(62)= lhs-rhs;
lhs =y(82);
rhs =(y(80)-(steady_state(61)))/(steady_state(61));
residual(63)= lhs-rhs;
if nargout >= 2,
  g1 = zeros(63, 101);

  %
  % Jacobian matrix
  %

T506 = (-params(41))/(y(21)*y(21));
T507 = y(11)*T506;
T508 = getPowerDeriv(T137*y(11),T131,1);
T516 = y(13)*T506;
T517 = getPowerDeriv(T137*y(13),T92,1);
T524 = params(12)*1/params(11)*getPowerDeriv(y(21)/params(11),params(13),1);
T537 = (-params(41))/(y(83)*y(83));
T538 = getPowerDeriv(T78,T81,1);
T543 = getPowerDeriv(T78,T92,1);
T573 = 1/y(60);
T574 = getPowerDeriv(T175,params(14),1);
T582 = T50*getPowerDeriv(y(26),(-1),1);
T586 = 1/params(15);
T601 = getPowerDeriv(y(44)-params(4)*y(31),T18,1);
T605 = getPowerDeriv(y(57)-params(4)*y(31),T18,1);
T612 = getPowerDeriv(y(90)-params(4)*y(84),T18,1);
T630 = (-1)/(params(5)*(1-params(29)));
T636 = getPowerDeriv(y(45),1-params(9),1);
T640 = T50*(1-params(9))*getPowerDeriv(y(45),(-params(9)),1);
T642 = (-(y(46)*y(80)*T640));
T657 = getPowerDeriv(y(50),T71,1);
T663 = getPowerDeriv(y(50)/y(53),T110,1);
T669 = getPowerDeriv(y(52),1+T110,1);
T685 = (-y(50))/(y(53)*y(53));
T722 = getPowerDeriv(y(58),params(6),1);
T736 = (-y(25))/(y(60)*y(60));
T761 = 1/(params(5)*(1-params(29)));
T781 = 1/(1+params(2));
  g1(1,77)=1;
  g1(2,31)=(-((-params(4))*T601/(1+y(77))));
  g1(2,44)=(-(T601/(1+y(77))));
  g1(2,63)=1;
  g1(2,77)=(-((-T19)/((1+y(77))*(1+y(77)))));
  g1(3,29)=(-(y(46)*(-y(63))));
  g1(3,45)=getPowerDeriv(y(45),params(6),1);
  g1(3,46)=(-(y(63)*(1-y(29))));
  g1(3,63)=(-((1-y(29))*y(46)));
  g1(4,83)=(-(y(91)*(-(params(1)*y(56)*y(22)))/(y(83)*y(83))));
  g1(4,22)=(-(y(91)*params(1)*y(56)/y(83)));
  g1(4,56)=(-(y(91)*params(1)*y(22)/y(83)));
  g1(4,63)=1;
  g1(4,91)=(-(params(1)*y(56)*y(22)/y(83)));
  g1(5,25)=(-1);
  g1(5,30)=1;
  g1(5,44)=1;
  g1(6,25)=1;
  g1(6,26)=(-(T53*T582));
  g1(6,45)=(-(T51*T636));
  g1(7,83)=(-(y(87)*y(56)*params(1)*params(10)*T537*T538));
  g1(7,25)=(-(T72*T65*y(48)));
  g1(7,47)=1;
  g1(7,87)=(-T83);
  g1(7,48)=(-(y(25)*T65*T72));
  g1(7,50)=(-(y(25)*T65*y(48)*T657));
  g1(7,56)=(-(y(87)*params(1)*params(10)*T82));
  g1(7,63)=(-(T72*y(48)*y(25)*T64));
  g1(8,83)=(-(y(88)*y(56)*params(1)*params(10)*T537*T543));
  g1(8,25)=(-(y(63)*T72));
  g1(8,49)=1;
  g1(8,88)=(-T94);
  g1(8,50)=(-(y(63)*y(25)*T657));
  g1(8,56)=(-(y(88)*params(1)*params(10)*T93));
  g1(8,63)=(-(y(25)*T72));
  g1(9,83)=(-(y(89)*y(56)*params(1)*params(10)*T537));
  g1(9,25)=(-(y(63)*T100));
  g1(9,51)=1;
  g1(9,89)=(-(y(56)*params(1)*params(10)*T78));
  g1(9,56)=(-(y(89)*params(1)*params(10)*T78));
  g1(9,63)=(-(y(25)*T100));
  g1(10,47)=1;
  g1(10,49)=(-y(52));
  g1(10,51)=T112;
  g1(10,52)=(-(y(49)-y(51)*T669));
  g1(11,50)=1;
  g1(11,54)=params(40);
  g1(12,50)=1;
  g1(12,55)=(-1);
  g1(13,26)=1;
  g1(13,50)=(-(T122*1/y(53)*T663));
  g1(13,53)=(-(T122*T663*T685));
  g1(14,21)=(-(params(10)*T507*T508));
  g1(14,52)=(-((1-params(10))*getPowerDeriv(y(52),T131,1)));
  g1(14,11)=(-(params(10)*T137*T508));
  g1(14,53)=getPowerDeriv(y(53),T131,1);
  g1(15,21)=(-(y(12)*(-(params(10)*params(41)))/(y(21)*y(21))));
  g1(15,52)=(-(1-params(10)));
  g1(15,12)=(-(params(10)*params(41)/y(21)));
  g1(15,54)=1;
  g1(16,21)=(-(params(10)*T516*T517));
  g1(16,52)=(-((1-params(10))*getPowerDeriv(y(52),T92,1)));
  g1(16,13)=(-(params(10)*T137*T517));
  g1(16,55)=getPowerDeriv(y(55),T92,1);
  g1(17,45)=(-(T642/(T165*T165)));
  g1(17,46)=(-(y(80)/T165));
  g1(17,48)=1;
  g1(17,80)=(-(y(46)/T165));
  g1(18,21)=(-(exp(y(79))*T177*T524));
  g1(18,22)=1;
  g1(18,25)=(-(exp(y(79))*T173*T573*T574));
  g1(18,60)=(-(exp(y(79))*T173*T574*T736));
  g1(18,79)=(-(T173*T177*exp(y(79))));
  g1(19,21)=(-(y(3)*(-y(1))/(y(21)*y(21))));
  g1(19,1)=(-(y(3)*1/y(21)));
  g1(19,3)=(-(y(1)/y(21)));
  g1(19,27)=1;
  g1(19,28)=1;
  g1(19,29)=y(45)*y(46);
  g1(19,30)=(-1);
  g1(19,44)=y(77);
  g1(19,45)=y(29)*y(46);
  g1(19,46)=y(45)*y(29);
  g1(19,77)=y(44);
  g1(20,3)=(-(params(17)*T586));
  g1(20,28)=T586;
  g1(21,3)=(-(params(37)*T586));
  g1(21,29)=T586;
  g1(22,24)=(-(params(1)*y(56)*T226/(1+y(94))));
  g1(22,31)=(-params(4))*T605/(1+y(77));
  g1(22,84)=(-(params(1)*y(56)*y(24)*(-params(4))*T612/(1+y(94))));
  g1(22,56)=(-(T226*params(1)*y(24)/(1+y(94))));
  g1(22,57)=T605/(1+y(77));
  g1(22,90)=(-(params(1)*y(56)*y(24)*T612/(1+y(94))));
  g1(22,77)=(-T218)/((1+y(77))*(1+y(77)));
  g1(22,94)=(-((-(params(1)*y(56)*y(24)*T226))/((1+y(94))*(1+y(94)))));
  g1(23,31)=(-(T233*(-params(4))*T605))/(T218*T218);
  g1(23,57)=(-(T233*T605))/(T218*T218);
  g1(23,58)=T722/T218;
  g1(23,59)=(-((1-y(64))/(1+y(77))));
  g1(23,64)=(-(y(59)*(-1)/(1+y(77))));
  g1(23,77)=(-(y(59)*(-(1-y(64)))/((1+y(77))*(1+y(77)))));
  g1(24,58)=(-(T242*getPowerDeriv(y(58),(-params(9)),1)));
  g1(24,59)=1;
  g1(25,30)=1;
  g1(25,57)=1;
  g1(25,60)=(-1);
  g1(26,58)=(-(T50*getPowerDeriv(y(58),1-params(9),1)));
  g1(26,60)=1;
  g1(27,2)=(-y(15));
  g1(27,30)=(-1);
  g1(27,57)=y(77);
  g1(27,58)=y(64)*y(59);
  g1(27,59)=y(58)*y(64);
  g1(27,15)=(-y(2));
  g1(27,61)=1;
  g1(27,62)=1;
  g1(27,64)=y(58)*y(59);
  g1(27,77)=y(57);
  g1(28,15)=(-(params(17)*T586));
  g1(28,62)=T586;
  g1(29,15)=(-(params(37)*T586));
  g1(29,64)=T586;
  g1(30,20)=1;
  g1(30,25)=(-(T573/T175));
  g1(30,60)=(-(T736/T175));
  g1(31,83)=(-((-y(22))/(y(83)*y(83))));
  g1(31,22)=(-(1/y(83)));
  g1(31,23)=1;
  g1(32,4)=(-params(19));
  g1(32,30)=1;
  g1(32,97)=(-1);
  g1(33,5)=(-params(20));
  g1(33,31)=1;
  g1(33,96)=(-1);
  g1(34,14)=(-params(20));
  g1(34,56)=1;
  g1(34,98)=(-1);
  g1(35,18)=(-params(20));
  g1(35,80)=1;
  g1(35,99)=(-1);
  g1(36,17)=(-0.7);
  g1(36,79)=1;
  g1(36,100)=(-1);
  g1(37,19)=(-params(20));
  g1(37,81)=1;
  g1(37,101)=(-1);
  g1(38,78)=1;
  g1(39,41)=1/(1-params(3));
  g1(39,43)=T630;
  g1(39,65)=params(6);
  g1(39,66)=T761;
  g1(39,67)=(-1);
  g1(39,78)=T781;
  g1(40,85)=1;
  g1(40,34)=(-1);
  g1(40,43)=(-T630);
  g1(40,86)=T630;
  g1(40,66)=(-T761);
  g1(40,92)=T761;
  g1(40,76)=(-1);
  g1(40,78)=(-1)/(1+params(2));
  g1(40,95)=T781;
  g1(41,37)=(-params(15));
  g1(41,42)=params(22);
  g1(41,66)=params(4);
  g1(42,37)=1;
  g1(42,65)=(-(1-params(9)));
  g1(43,33)=1;
  g1(43,85)=(-params(1));
  g1(43,68)=(-T385);
  g1(44,65)=(-params(9));
  g1(44,67)=(-1);
  g1(44,68)=1;
  g1(44,82)=(-1);
  g1(45,33)=(-params(13));
  g1(45,34)=1;
  g1(45,37)=(-params(14));
  g1(45,71)=params(14);
  g1(45,79)=(-1);
  g1(46,33)=T404;
  g1(46,6)=(-T404);
  g1(46,9)=(-T403);
  g1(46,39)=1;
  g1(46,40)=1;
  g1(46,41)=params(30)*params(31);
  g1(46,42)=(-params(22));
  g1(46,65)=params(31)*params(3)*params(30);
  g1(46,66)=params(2)*params(4);
  g1(46,67)=params(31)*params(3)*params(30);
  g1(46,78)=params(4);
  g1(47,9)=(-params(17));
  g1(47,40)=1;
  g1(48,9)=(-params(37));
  g1(48,41)=1;
  g1(49,36)=(-1);
  g1(49,43)=(-T630);
  g1(49,86)=T630;
  g1(49,69)=(-T761);
  g1(49,93)=T761;
  g1(49,76)=(-1);
  g1(49,78)=(-1)/(1+params(2));
  g1(49,95)=T781;
  g1(50,43)=T630;
  g1(50,69)=T761;
  g1(50,70)=(-1);
  g1(50,74)=params(6);
  g1(50,75)=1/(1-params(3));
  g1(50,78)=T781;
  g1(51,70)=1;
  g1(51,74)=params(9);
  g1(52,42)=params(22);
  g1(52,69)=params(4);
  g1(52,71)=(-params(15));
  g1(53,71)=1;
  g1(53,74)=(-(1-params(9)));
  g1(54,7)=(-T404);
  g1(54,42)=(-params(22));
  g1(54,69)=params(2)*params(4);
  g1(54,70)=params(31)*params(3)*params(30);
  g1(54,16)=(-T403);
  g1(54,72)=1;
  g1(54,73)=1;
  g1(54,74)=params(31)*params(3)*params(30);
  g1(54,75)=params(30)*params(31);
  g1(54,78)=params(4);
  g1(55,16)=(-params(17));
  g1(55,73)=1;
  g1(56,16)=(-params(37));
  g1(56,75)=1;
  g1(57,32)=1;
  g1(57,37)=(-1);
  g1(57,71)=1;
  g1(58,85)=1;
  g1(58,34)=(-1);
  g1(58,35)=1;
  g1(59,30)=(-(1/params(22)));
  g1(59,42)=1;
  g1(60,10)=(-params(20));
  g1(60,43)=1;
  g1(60,96)=(-1);
  g1(61,8)=(-params(10));
  g1(61,38)=1;
  g1(62,56)=(-(1/(steady_state(37))));
  g1(62,76)=1;
  g1(63,80)=(-(1/(steady_state(61))));
  g1(63,82)=1;

if nargout >= 3,
  %
  % Hessian matrix
  %

  v2 = zeros(205,3);
T791 = getPowerDeriv(y(44)-params(4)*y(31),T18,2);
T792 = (-params(4))*T791;
T847 = (-((-params(41))*(y(83)+y(83))))/(y(83)*y(83)*y(83)*y(83));
T863 = getPowerDeriv(y(50),T71,2);
T910 = getPowerDeriv(y(50)/y(53),T110,2);
T911 = 1/y(53)*T910;
T938 = getPowerDeriv(T137*y(11),T131,2);
T939 = T507*T938;
T965 = getPowerDeriv(T137*y(13),T92,2);
T966 = T516*T965;
T1017 = getPowerDeriv(T175,params(14),2);
T1018 = T573*T1017;
T1055 = getPowerDeriv(y(57)-params(4)*y(31),T18,2);
T1056 = (-params(4))*T1055;
T1062 = getPowerDeriv(y(90)-params(4)*y(84),T18,2);
T1063 = (-params(4))*T1062;
  v2(1,1)=2;
  v2(1,2)=3061;
  v2(1,3)=(-((-params(4))*T792/(1+y(77))));
  v2(2,1)=2;
  v2(2,2)=4374;
  v2(2,3)=(-(T792/(1+y(77))));
  v2(3,1)=2;
  v2(3,2)=3074;
  v2(3,3)=  v2(2,3);
  v2(4,1)=2;
  v2(4,2)=4387;
  v2(4,3)=(-(T791/(1+y(77))));
  v2(5,1)=2;
  v2(5,2)=7707;
  v2(5,3)=(-((-((-params(4))*T601))/((1+y(77))*(1+y(77)))));
  v2(6,1)=2;
  v2(6,2)=3107;
  v2(6,3)=  v2(5,3);
  v2(7,1)=2;
  v2(7,2)=7720;
  v2(7,3)=(-((-T601)/((1+y(77))*(1+y(77)))));
  v2(8,1)=2;
  v2(8,2)=4420;
  v2(8,3)=  v2(7,3);
  v2(9,1)=2;
  v2(9,2)=7753;
  v2(9,3)=(-((-((-T19)*(1+y(77)+1+y(77))))/((1+y(77))*(1+y(77))*(1+y(77))*(1+y(77)))));
  v2(10,1)=3;
  v2(10,2)=4489;
  v2(10,3)=getPowerDeriv(y(45),params(6),2);
  v2(11,1)=3;
  v2(11,2)=4574;
  v2(11,3)=y(63);
  v2(12,1)=3;
  v2(12,2)=2874;
  v2(12,3)=  v2(11,3);
  v2(13,1)=3;
  v2(13,2)=6291;
  v2(13,3)=y(46);
  v2(14,1)=3;
  v2(14,2)=2891;
  v2(14,3)=  v2(13,3);
  v2(15,1)=3;
  v2(15,2)=6308;
  v2(15,3)=(-(1-y(29)));
  v2(16,1)=3;
  v2(16,2)=4608;
  v2(16,3)=  v2(15,3);
  v2(17,1)=4;
  v2(17,2)=8365;
  v2(17,3)=(-(y(91)*(-((-(params(1)*y(56)*y(22)))*(y(83)+y(83))))/(y(83)*y(83)*y(83)*y(83))));
  v2(18,1)=4;
  v2(18,2)=2204;
  v2(18,3)=(-(y(91)*(-(params(1)*y(56)))/(y(83)*y(83))));
  v2(19,1)=4;
  v2(19,2)=8304;
  v2(19,3)=  v2(18,3);
  v2(20,1)=4;
  v2(20,2)=5638;
  v2(20,3)=(-(y(91)*(-(params(1)*y(22)))/(y(83)*y(83))));
  v2(21,1)=4;
  v2(21,2)=8338;
  v2(21,3)=  v2(20,3);
  v2(22,1)=4;
  v2(22,2)=5577;
  v2(22,3)=(-(y(91)*params(1)/y(83)));
  v2(23,1)=4;
  v2(23,2)=2177;
  v2(23,3)=  v2(22,3);
  v2(24,1)=4;
  v2(24,2)=9173;
  v2(24,3)=(-((-(params(1)*y(56)*y(22)))/(y(83)*y(83))));
  v2(25,1)=4;
  v2(25,2)=8373;
  v2(25,3)=  v2(24,3);
  v2(26,1)=4;
  v2(26,2)=9112;
  v2(26,3)=(-(params(1)*y(56)/y(83)));
  v2(27,1)=4;
  v2(27,2)=2212;
  v2(27,3)=  v2(26,3);
  v2(28,1)=4;
  v2(28,2)=9146;
  v2(28,3)=(-(params(1)*y(22)/y(83)));
  v2(29,1)=4;
  v2(29,2)=5646;
  v2(29,3)=  v2(28,3);
  v2(30,1)=6;
  v2(30,2)=2551;
  v2(30,3)=(-(T53*T50*getPowerDeriv(y(26),(-1),2)));
  v2(31,1)=6;
  v2(31,2)=4470;
  v2(31,3)=(-(T582*T636));
  v2(32,1)=6;
  v2(32,2)=2570;
  v2(32,3)=  v2(31,3);
  v2(33,1)=6;
  v2(33,2)=4489;
  v2(33,3)=(-(T51*getPowerDeriv(y(45),1-params(9),2)));
  v2(34,1)=7;
  v2(34,2)=8365;
  v2(34,3)=(-(y(87)*y(56)*params(1)*params(10)*(T538*T847+T537*T537*getPowerDeriv(T78,T81,2))));
  v2(35,1)=7;
  v2(35,2)=8769;
  v2(35,3)=(-(y(56)*params(1)*params(10)*T537*T538));
  v2(36,1)=7;
  v2(36,2)=8369;
  v2(36,3)=  v2(35,3);
  v2(37,1)=7;
  v2(37,2)=4772;
  v2(37,3)=(-(T65*T72));
  v2(38,1)=7;
  v2(38,2)=2472;
  v2(38,3)=  v2(37,3);
  v2(39,1)=7;
  v2(39,2)=4974;
  v2(39,3)=(-(T65*y(48)*T657));
  v2(40,1)=7;
  v2(40,2)=2474;
  v2(40,3)=  v2(39,3);
  v2(41,1)=7;
  v2(41,2)=4997;
  v2(41,3)=(-(y(25)*T65*T657));
  v2(42,1)=7;
  v2(42,2)=4797;
  v2(42,3)=  v2(41,3);
  v2(43,1)=7;
  v2(43,2)=4999;
  v2(43,3)=(-(y(25)*T65*y(48)*T863));
  v2(44,1)=7;
  v2(44,2)=5638;
  v2(44,3)=(-(y(87)*params(1)*params(10)*T537*T538));
  v2(45,1)=7;
  v2(45,2)=8338;
  v2(45,3)=  v2(44,3);
  v2(46,1)=7;
  v2(46,2)=5642;
  v2(46,3)=(-(params(1)*params(10)*T82));
  v2(47,1)=7;
  v2(47,2)=8742;
  v2(47,3)=  v2(46,3);
  v2(48,1)=7;
  v2(48,2)=6287;
  v2(48,3)=(-(T72*T64*y(48)));
  v2(49,1)=7;
  v2(49,2)=2487;
  v2(49,3)=  v2(48,3);
  v2(50,1)=7;
  v2(50,2)=6310;
  v2(50,3)=(-(T72*y(25)*T64));
  v2(51,1)=7;
  v2(51,2)=4810;
  v2(51,3)=  v2(50,3);
  v2(52,1)=7;
  v2(52,2)=6312;
  v2(52,3)=(-(T657*y(48)*y(25)*T64));
  v2(53,1)=7;
  v2(53,2)=5012;
  v2(53,3)=  v2(52,3);
  v2(54,1)=8;
  v2(54,2)=8365;
  v2(54,3)=(-(y(88)*y(56)*params(1)*params(10)*(T543*T847+T537*T537*getPowerDeriv(T78,T92,2))));
  v2(55,1)=8;
  v2(55,2)=8870;
  v2(55,3)=(-(y(56)*params(1)*params(10)*T537*T543));
  v2(56,1)=8;
  v2(56,2)=8370;
  v2(56,3)=  v2(55,3);
  v2(57,1)=8;
  v2(57,2)=4974;
  v2(57,3)=(-(y(63)*T657));
  v2(58,1)=8;
  v2(58,2)=2474;
  v2(58,3)=  v2(57,3);
  v2(59,1)=8;
  v2(59,2)=4999;
  v2(59,3)=(-(y(63)*y(25)*T863));
  v2(60,1)=8;
  v2(60,2)=5638;
  v2(60,3)=(-(y(88)*params(1)*params(10)*T537*T543));
  v2(61,1)=8;
  v2(61,2)=8338;
  v2(61,3)=  v2(60,3);
  v2(62,1)=8;
  v2(62,2)=5643;
  v2(62,3)=(-(params(1)*params(10)*T93));
  v2(63,1)=8;
  v2(63,2)=8843;
  v2(63,3)=  v2(62,3);
  v2(64,1)=8;
  v2(64,2)=6287;
  v2(64,3)=(-T72);
  v2(65,1)=8;
  v2(65,2)=2487;
  v2(65,3)=  v2(64,3);
  v2(66,1)=8;
  v2(66,2)=6312;
  v2(66,3)=(-(y(25)*T657));
  v2(67,1)=8;
  v2(67,2)=5012;
  v2(67,3)=  v2(66,3);
  v2(68,1)=9;
  v2(68,2)=8365;
  v2(68,3)=(-(y(89)*y(56)*params(1)*params(10)*T847));
  v2(69,1)=9;
  v2(69,2)=8971;
  v2(69,3)=(-(y(56)*params(1)*params(10)*T537));
  v2(70,1)=9;
  v2(70,2)=8371;
  v2(70,3)=  v2(69,3);
  v2(71,1)=9;
  v2(71,2)=5638;
  v2(71,3)=(-(y(89)*params(1)*params(10)*T537));
  v2(72,1)=9;
  v2(72,2)=8338;
  v2(72,3)=  v2(71,3);
  v2(73,1)=9;
  v2(73,2)=5644;
  v2(73,3)=(-(params(1)*params(10)*T78));
  v2(74,1)=9;
  v2(74,2)=8944;
  v2(74,3)=  v2(73,3);
  v2(75,1)=9;
  v2(75,2)=6287;
  v2(75,3)=(-T100);
  v2(76,1)=9;
  v2(76,2)=2487;
  v2(76,3)=  v2(75,3);
  v2(77,1)=10;
  v2(77,2)=5200;
  v2(77,3)=(-1);
  v2(78,1)=10;
  v2(78,2)=4900;
  v2(78,3)=  v2(77,3);
  v2(79,1)=10;
  v2(79,2)=5202;
  v2(79,3)=T669;
  v2(80,1)=10;
  v2(80,2)=5102;
  v2(80,3)=  v2(79,3);
  v2(81,1)=10;
  v2(81,2)=5203;
  v2(81,3)=y(51)*getPowerDeriv(y(52),1+T110,2);
  v2(82,1)=13;
  v2(82,2)=4999;
  v2(82,3)=(-(T122*1/y(53)*T911));
  v2(83,1)=13;
  v2(83,2)=5302;
  v2(83,3)=(-(T122*(T685*T911+T663*(-1)/(y(53)*y(53)))));
  v2(84,1)=13;
  v2(84,2)=5002;
  v2(84,3)=  v2(83,3);
  v2(85,1)=13;
  v2(85,2)=5305;
  v2(85,3)=(-(T122*(T685*T685*T910+T663*(-((-y(50))*(y(53)+y(53))))/(y(53)*y(53)*y(53)*y(53)))));
  v2(86,1)=14;
  v2(86,2)=2041;
  v2(86,3)=(-(params(10)*(T508*y(11)*(-((-params(41))*(y(21)+y(21))))/(y(21)*y(21)*y(21)*y(21))+T507*T939)));
  v2(87,1)=14;
  v2(87,2)=5203;
  v2(87,3)=(-((1-params(10))*getPowerDeriv(y(52),T131,2)));
  v2(88,1)=14;
  v2(88,2)=1031;
  v2(88,3)=(-(params(10)*(T506*T508+T137*T939)));
  v2(89,1)=14;
  v2(89,2)=2031;
  v2(89,3)=  v2(88,3);
  v2(90,1)=14;
  v2(90,2)=1021;
  v2(90,3)=(-(params(10)*T137*T137*T938));
  v2(91,1)=14;
  v2(91,2)=5305;
  v2(91,3)=getPowerDeriv(y(53),T131,2);
  v2(92,1)=15;
  v2(92,2)=2041;
  v2(92,3)=(-(y(12)*(-((-(params(10)*params(41)))*(y(21)+y(21))))/(y(21)*y(21)*y(21)*y(21))));
  v2(93,1)=15;
  v2(93,2)=1132;
  v2(93,3)=(-((-(params(10)*params(41)))/(y(21)*y(21))));
  v2(94,1)=15;
  v2(94,2)=2032;
  v2(94,3)=  v2(93,3);
  v2(95,1)=16;
  v2(95,2)=2041;
  v2(95,3)=(-(params(10)*(T517*y(13)*(-((-params(41))*(y(21)+y(21))))/(y(21)*y(21)*y(21)*y(21))+T516*T966)));
  v2(96,1)=16;
  v2(96,2)=5203;
  v2(96,3)=(-((1-params(10))*getPowerDeriv(y(52),T92,2)));
  v2(97,1)=16;
  v2(97,2)=1233;
  v2(97,3)=(-(params(10)*(T506*T517+T137*T966)));
  v2(98,1)=16;
  v2(98,2)=2033;
  v2(98,3)=  v2(97,3);
  v2(99,1)=16;
  v2(99,2)=1225;
  v2(99,3)=(-(params(10)*T137*T137*T965));
  v2(100,1)=16;
  v2(100,2)=5509;
  v2(100,3)=getPowerDeriv(y(55),T92,2);
  v2(101,1)=17;
  v2(101,2)=4489;
  v2(101,3)=(-((T165*T165*(-(y(46)*y(80)*T50*(1-params(9))*getPowerDeriv(y(45),(-params(9)),2)))-T642*(T165*T640+T165*T640))/(T165*T165*T165*T165)));
  v2(102,1)=17;
  v2(102,2)=4590;
  v2(102,3)=(-((-(y(80)*T640))/(T165*T165)));
  v2(103,1)=17;
  v2(103,2)=4490;
  v2(103,3)=  v2(102,3);
  v2(104,1)=17;
  v2(104,2)=8024;
  v2(104,3)=(-((-(y(46)*T640))/(T165*T165)));
  v2(105,1)=17;
  v2(105,2)=4524;
  v2(105,3)=  v2(104,3);
  v2(106,1)=17;
  v2(106,2)=8025;
  v2(106,3)=(-(1/T165));
  v2(107,1)=17;
  v2(107,2)=4625;
  v2(107,3)=  v2(106,3);
  v2(108,1)=18;
  v2(108,2)=2041;
  v2(108,3)=(-(exp(y(79))*T177*params(12)*1/params(11)*1/params(11)*getPowerDeriv(y(21)/params(11),params(13),2)));
  v2(109,1)=18;
  v2(109,2)=2445;
  v2(109,3)=(-(exp(y(79))*T524*T573*T574));
  v2(110,1)=18;
  v2(110,2)=2045;
  v2(110,3)=  v2(109,3);
  v2(111,1)=18;
  v2(111,2)=2449;
  v2(111,3)=(-(exp(y(79))*T173*T573*T1018));
  v2(112,1)=18;
  v2(112,2)=5980;
  v2(112,3)=(-(exp(y(79))*T524*T574*T736));
  v2(113,1)=18;
  v2(113,2)=2080;
  v2(113,3)=  v2(112,3);
  v2(114,1)=18;
  v2(114,2)=5984;
  v2(114,3)=(-(exp(y(79))*T173*(T736*T1018+T574*(-1)/(y(60)*y(60)))));
  v2(115,1)=18;
  v2(115,2)=2484;
  v2(115,3)=  v2(114,3);
  v2(116,1)=18;
  v2(116,2)=6019;
  v2(116,3)=(-(exp(y(79))*T173*(T736*T736*T1017+T574*(-((-y(25))*(y(60)+y(60))))/(y(60)*y(60)*y(60)*y(60)))));
  v2(117,1)=18;
  v2(117,2)=7899;
  v2(117,3)=(-(exp(y(79))*T177*T524));
  v2(118,1)=18;
  v2(118,2)=2099;
  v2(118,3)=  v2(117,3);
  v2(119,1)=18;
  v2(119,2)=7903;
  v2(119,3)=(-(exp(y(79))*T173*T573*T574));
  v2(120,1)=18;
  v2(120,2)=2503;
  v2(120,3)=  v2(119,3);
  v2(121,1)=18;
  v2(121,2)=7938;
  v2(121,3)=(-(exp(y(79))*T173*T574*T736));
  v2(122,1)=18;
  v2(122,2)=6038;
  v2(122,3)=  v2(121,3);
  v2(123,1)=18;
  v2(123,2)=7957;
  v2(123,3)=(-(T173*T177*exp(y(79))));
  v2(124,1)=19;
  v2(124,2)=2041;
  v2(124,3)=(-(y(3)*(-((-y(1))*(y(21)+y(21))))/(y(21)*y(21)*y(21)*y(21))));
  v2(125,1)=19;
  v2(125,2)=21;
  v2(125,3)=(-(y(3)*(-1)/(y(21)*y(21))));
  v2(126,1)=19;
  v2(126,2)=2021;
  v2(126,3)=  v2(125,3);
  v2(127,1)=19;
  v2(127,2)=223;
  v2(127,3)=(-((-y(1))/(y(21)*y(21))));
  v2(128,1)=19;
  v2(128,2)=2023;
  v2(128,3)=  v2(127,3);
  v2(129,1)=19;
  v2(129,2)=203;
  v2(129,3)=(-(1/y(21)));
  v2(130,1)=19;
  v2(130,2)=3;
  v2(130,3)=  v2(129,3);
  v2(131,1)=19;
  v2(131,2)=4473;
  v2(131,3)=y(46);
  v2(132,1)=19;
  v2(132,2)=2873;
  v2(132,3)=  v2(131,3);
  v2(133,1)=19;
  v2(133,2)=4574;
  v2(133,3)=y(45);
  v2(134,1)=19;
  v2(134,2)=2874;
  v2(134,3)=  v2(133,3);
  v2(135,1)=19;
  v2(135,2)=4590;
  v2(135,3)=y(29);
  v2(136,1)=19;
  v2(136,2)=4490;
  v2(136,3)=  v2(135,3);
  v2(137,1)=19;
  v2(137,2)=7720;
  v2(137,3)=1;
  v2(138,1)=19;
  v2(138,2)=4420;
  v2(138,3)=  v2(137,3);
  v2(139,1)=22;
  v2(139,2)=3061;
  v2(139,3)=(-params(4))*T1056/(1+y(77));
  v2(140,1)=22;
  v2(140,2)=8407;
  v2(140,3)=(-(params(1)*y(56)*(-params(4))*T612/(1+y(94))));
  v2(141,1)=22;
  v2(141,2)=2407;
  v2(141,3)=  v2(140,3);
  v2(142,1)=22;
  v2(142,2)=8467;
  v2(142,3)=(-(params(1)*y(56)*y(24)*(-params(4))*T1063/(1+y(94))));
  v2(143,1)=22;
  v2(143,2)=5579;
  v2(143,3)=(-(params(1)*T226/(1+y(94))));
  v2(144,1)=22;
  v2(144,2)=2379;
  v2(144,3)=  v2(143,3);
  v2(145,1)=22;
  v2(145,2)=5639;
  v2(145,3)=(-((-params(4))*T612*params(1)*y(24)/(1+y(94))));
  v2(146,1)=22;
  v2(146,2)=8439;
  v2(146,3)=  v2(145,3);
  v2(147,1)=22;
  v2(147,2)=5687;
  v2(147,3)=T1056/(1+y(77));
  v2(148,1)=22;
  v2(148,2)=3087;
  v2(148,3)=  v2(147,3);
  v2(149,1)=22;
  v2(149,2)=5713;
  v2(149,3)=T1055/(1+y(77));
  v2(150,1)=22;
  v2(150,2)=9013;
  v2(150,3)=(-(params(1)*y(56)*T612/(1+y(94))));
  v2(151,1)=22;
  v2(151,2)=2413;
  v2(151,3)=  v2(150,3);
  v2(152,1)=22;
  v2(152,2)=9073;
  v2(152,3)=(-(params(1)*y(56)*y(24)*T1063/(1+y(94))));
  v2(153,1)=22;
  v2(153,2)=8473;
  v2(153,3)=  v2(152,3);
  v2(154,1)=22;
  v2(154,2)=9045;
  v2(154,3)=(-(T612*params(1)*y(24)/(1+y(94))));
  v2(155,1)=22;
  v2(155,2)=5645;
  v2(155,3)=  v2(154,3);
  v2(156,1)=22;
  v2(156,2)=9079;
  v2(156,3)=(-(params(1)*y(56)*y(24)*T1062/(1+y(94))));
  v2(157,1)=22;
  v2(157,2)=7707;
  v2(157,3)=(-((-params(4))*T605))/((1+y(77))*(1+y(77)));
  v2(158,1)=22;
  v2(158,2)=3107;
  v2(158,3)=  v2(157,3);
  v2(159,1)=22;
  v2(159,2)=7733;
  v2(159,3)=(-T605)/((1+y(77))*(1+y(77)));
  v2(160,1)=22;
  v2(160,2)=5733;
  v2(160,3)=  v2(159,3);
  v2(161,1)=22;
  v2(161,2)=7753;
  v2(161,3)=(-((-T218)*(1+y(77)+1+y(77))))/((1+y(77))*(1+y(77))*(1+y(77))*(1+y(77)));
  v2(162,1)=22;
  v2(162,2)=9417;
  v2(162,3)=(-((-(params(1)*y(56)*T226))/((1+y(94))*(1+y(94)))));
  v2(163,1)=22;
  v2(163,2)=2417;
  v2(163,3)=  v2(162,3);
  v2(164,1)=22;
  v2(164,2)=9477;
  v2(164,3)=(-((-(params(1)*y(56)*y(24)*(-params(4))*T612))/((1+y(94))*(1+y(94)))));
  v2(165,1)=22;
  v2(165,2)=8477;
  v2(165,3)=  v2(164,3);
  v2(166,1)=22;
  v2(166,2)=9449;
  v2(166,3)=(-((-(T226*params(1)*y(24)))/((1+y(94))*(1+y(94)))));
  v2(167,1)=22;
  v2(167,2)=5649;
  v2(167,3)=  v2(166,3);
  v2(168,1)=22;
  v2(168,2)=9483;
  v2(168,3)=(-((-(params(1)*y(56)*y(24)*T612))/((1+y(94))*(1+y(94)))));
  v2(169,1)=22;
  v2(169,2)=9083;
  v2(169,3)=  v2(168,3);
  v2(170,1)=22;
  v2(170,2)=9487;
  v2(170,3)=(-((-((-(params(1)*y(56)*y(24)*T226))*(1+y(94)+1+y(94))))/((1+y(94))*(1+y(94))*(1+y(94))*(1+y(94)))));
  v2(171,1)=23;
  v2(171,2)=3061;
  v2(171,3)=(T218*T218*(-(T233*(-params(4))*T1056))-(-(T233*(-params(4))*T605))*(T218*(-params(4))*T605+T218*(-params(4))*T605))/(T218*T218*T218*T218);
  v2(172,1)=23;
  v2(172,2)=5687;
  v2(172,3)=(T218*T218*(-(T233*T1056))-(-(T233*T605))*(T218*(-params(4))*T605+T218*(-params(4))*T605))/(T218*T218*T218*T218);
  v2(173,1)=23;
  v2(173,2)=3087;
  v2(173,3)=  v2(172,3);
  v2(174,1)=23;
  v2(174,2)=5713;
  v2(174,3)=(T218*T218*(-(T233*T1055))-(-(T233*T605))*(T218*T605+T218*T605))/(T218*T218*T218*T218);
  v2(175,1)=23;
  v2(175,2)=5788;
  v2(175,3)=(-((-params(4))*T605*T722))/(T218*T218);
  v2(176,1)=23;
  v2(176,2)=3088;
  v2(176,3)=  v2(175,3);
  v2(177,1)=23;
  v2(177,2)=5814;
  v2(177,3)=(-(T605*T722))/(T218*T218);
  v2(178,1)=23;
  v2(178,2)=5714;
  v2(178,3)=  v2(177,3);
  v2(179,1)=23;
  v2(179,2)=5815;
  v2(179,3)=getPowerDeriv(y(58),params(6),2)/T218;
  v2(180,1)=23;
  v2(180,2)=6422;
  v2(180,3)=(-((-1)/(1+y(77))));
  v2(181,1)=23;
  v2(181,2)=5922;
  v2(181,3)=  v2(180,3);
  v2(182,1)=23;
  v2(182,2)=7735;
  v2(182,3)=(-((-(1-y(64)))/((1+y(77))*(1+y(77)))));
  v2(183,1)=23;
  v2(183,2)=5935;
  v2(183,3)=  v2(182,3);
  v2(184,1)=23;
  v2(184,2)=7740;
  v2(184,3)=(-(y(59)*1/((1+y(77))*(1+y(77)))));
  v2(185,1)=23;
  v2(185,2)=6440;
  v2(185,3)=  v2(184,3);
  v2(186,1)=23;
  v2(186,2)=7753;
  v2(186,3)=(-(y(59)*(-((-(1-y(64)))*(1+y(77)+1+y(77))))/((1+y(77))*(1+y(77))*(1+y(77))*(1+y(77)))));
  v2(187,1)=24;
  v2(187,2)=5815;
  v2(187,3)=(-(T242*getPowerDeriv(y(58),(-params(9)),2)));
  v2(188,1)=26;
  v2(188,2)=5815;
  v2(188,3)=(-(T50*getPowerDeriv(y(58),1-params(9),2)));
  v2(189,1)=27;
  v2(189,2)=5916;
  v2(189,3)=y(64);
  v2(190,1)=27;
  v2(190,2)=5816;
  v2(190,3)=  v2(189,3);
  v2(191,1)=27;
  v2(191,2)=1416;
  v2(191,3)=(-1);
  v2(192,1)=27;
  v2(192,2)=116;
  v2(192,3)=  v2(191,3);
  v2(193,1)=27;
  v2(193,2)=6421;
  v2(193,3)=y(59);
  v2(194,1)=27;
  v2(194,2)=5821;
  v2(194,3)=  v2(193,3);
  v2(195,1)=27;
  v2(195,2)=6422;
  v2(195,3)=y(58);
  v2(196,1)=27;
  v2(196,2)=5922;
  v2(196,3)=  v2(195,3);
  v2(197,1)=27;
  v2(197,2)=7733;
  v2(197,3)=1;
  v2(198,1)=27;
  v2(198,2)=5733;
  v2(198,3)=  v2(197,3);
  v2(199,1)=30;
  v2(199,2)=2449;
  v2(199,3)=(-((-(T573*T573))/(T175*T175)));
  v2(200,1)=30;
  v2(200,2)=5984;
  v2(200,3)=(-((T175*(-1)/(y(60)*y(60))-T573*T736)/(T175*T175)));
  v2(201,1)=30;
  v2(201,2)=2484;
  v2(201,3)=  v2(200,3);
  v2(202,1)=30;
  v2(202,2)=6019;
  v2(202,3)=(-((T175*(-((-y(25))*(y(60)+y(60))))/(y(60)*y(60)*y(60)*y(60))-T736*T736)/(T175*T175)));
  v2(203,1)=31;
  v2(203,2)=8365;
  v2(203,3)=(-((-((-y(22))*(y(83)+y(83))))/(y(83)*y(83)*y(83)*y(83))));
  v2(204,1)=31;
  v2(204,2)=2204;
  v2(204,3)=(-((-1)/(y(83)*y(83))));
  v2(205,1)=31;
  v2(205,2)=8304;
  v2(205,3)=  v2(204,3);
  g2 = sparse(v2(:,1),v2(:,2),v2(:,3),63,10201);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],63,1030301);
end
end
end
end
