//CGG New Keynesian model with fully non-linear vs. linear equilibrium equations
//Consumption demand or discount factor shocks take economy to ZLB; Fiscal multiplier analysis
//Kimball (1995) aggregator to match slope of PC and micro-evidence of price stickiness together

%addpath('Dynare424');

//Dynare version: 4.4.3
//Mathias Trabandt, mathias.trabandt@gmail.com, November 2016


//MT changes since March 2013:
//1. Taylor rule coefficients set to 1.5 and 0.125
//2. Make labor income taxes a true dynamic variable (in actual and pot econ.)
//3. Put in a new fiscal rule for labor income taxes (parameter phiN)
//4. Renamed equation numbering due to new variables
//5. Plot more variables (Debt, Lump-sum taxes, dist. labor tax)
//6. Deleted all code after figure 2 in mod file
//7. Changed ordering of variables in Dynare var statement!
//8. Made lots of changes to plot_results.m file (variable creation, plotting etc)
//9. Per new switch, allow government spending shock only when ZLB is binding (gAtZLBonly)
//10.Re-specified the Taylor rule in logs rather than in levels (to get rid of the SS expressions in the linear case)

//MT changes since April 2013:
//11.Kimball (1995) aggregator introduced
//12.Discount factor shock added
//13.More variables in var statement due to 11 and 12.
//14.Fixed error in steady state computations
//15.General (non-) indexation scheme available in non-linear model. Yet not available 
//in linearized model and steady state. I.e. stick to indexation for the time being! 

 
// Endogenous variables 
var 
xV piV RV rrV rrVpot yV pstarV bGV tauV tauNV gV nuV                                                //these 12 variables are plotted
xVBREVE piVHAT RVHAT rrVHAT rrVpotHAT yVHAT pstarVHAT bGVBREVE tauVBREVE tauNVBREVE gVHAT nuVBREVE  //these 12 variables are plotted
cV nV wV sV mcV fV varthetaV aV ptildeV delta1V delta2V delta3V deltaV  //13
cVpot nVpot wVpot yVpot bGVpot tauVpot lamV tauNVpot nVHAT //
cVHAT wVHAT mcVHAT cVpotHAT wVpotHAT yVpotHAT bGVpotBREVE 
tauVpotBREVE nVpotHAT tauNVpotBREVE deltaVHAT
tauCV tauCVBREVE RVshk mcVshk zVshk mcVshkHAT zVshkHAT
;  
 
// Shocks 
varexo nuV_eps gV_eps deltaV_eps mcV_eps RV_eps  zV_eps;  
 
// Parameters 
parameters betta tauC tauN cV_SS sigma chi thetap k alfa xip piV_SS
RV_SS gampi gamx yV_SS tauV_SS phiT bGV_SS rhoG rhonu sigG 
gV_SS nuV_SS signu pibar bGy gy tauy nu wV_SS nV_SS rrV_SS pstarV_SS
sV_SS fV_SS mcV_SS phiN tauNV_SS gAtZLBonly psie pitilde rhodelta sigdelta deltaV_SS
p_sigG_lin p_signu_lin; 
 

//Initialize parameters
[p, p_pibar, p_thetap, p_xip, p_psie, p_pitilde, p_gampi, p_gamx, p_alfa, p_betta, p_sigma,...
          p_chi, p_nu, p_gy, p_tauC, p_bGy, p_tauy, p_phiT, p_phiN, p_rhoG, p_rhonu, p_rhodelta, p_sigG_nonlin, p_signu_nonlin,...
          p_sigdelta, p_gAtZLBonly, p_sigG_lin, p_signu_lin]=params;

pibar=p_pibar;
thetap=p_thetap;
xip=p_xip;
psie=p_psie;
pitilde=p_pitilde; 
gampi=p_gampi;
gamx=p_gamx;
alfa=p_alfa;
betta=p_betta;
sigma=p_sigma;
chi=p_chi;
nu=p_nu;
gy=p_gy;
tauC=p_tauC;
bGy=p_bGy;
tauy=p_tauy;
phiT=p_phiT;
phiN=p_phiN;
rhoG=p_rhoG;
rhonu=p_rhonu;
rhodelta=p_rhodelta;
sigG_nonlin=p_sigG_nonlin;
signu_nonlin=p_signu_nonlin;
sigG_lin=p_sigG_lin;
signu_lin=p_signu_lin;
sigdelta=p_sigdelta;
gAtZLBonly=p_gAtZLBonly;



//endogenous steady states are calculated in _steadystate.m file  
model;
///////////////////////////////////////////////////////
//non-linear economy                                 //
///////////////////////////////////////////////////////
//set some fiscal instruments to their steady states
tauCV=tauC;

//n1 marg. utility
lamV=(cV-cV_SS*nuV)^(-1/sigma)/(1+tauCV);  
  
//n2 leisure-labor tradeoff 
nV^chi =(1-tauNV)*lamV*wV; 
 
//n3 euler equation
lamV=betta*deltaV*RV/piV(+1)*lamV(+1); 

//n4 resource constraint
cV+gV=yV;

//n5 production
yV=zVshk*pstarV^(-1)*k^alfa*nV^(1-alfa); 
 
//n6 non-lin. pricing 1 
sV=(1+thetap)*(1+psie)/(1+psie+thetap*psie)*lamV*yV*mcV*varthetaV^((1+thetap)/thetap*(1+psie))+xip*betta*deltaV*(pitilde/piV(+1))^(-(1+thetap)/thetap*(1+psie))*sV(+1);  

//n7 non-lin. pricing 2 
fV=lamV*yV*varthetaV^((1+thetap)/thetap*(1+psie))+xip*betta*deltaV*(pitilde/piV(+1))^(-(1+psie+psie*thetap)/thetap)*fV(+1); 

//n8 non-lin. pricing 3
aV=psie*thetap/(1+psie+psie*thetap)*yV*lamV+xip*betta*deltaV*(pitilde/piV(+1))*aV(+1);

//n9 non-lin. pricing 4
sV=fV*ptildeV-aV*ptildeV^(1+(1+psie)*(1+thetap)/thetap);

//n10 zero profit condition
varthetaV=1+psie-psie*delta2V;

//n11 aggregate price index
varthetaV=delta3V;

//n12 overall price dispersion index 
pstarV=1/(1+psie)*(varthetaV/delta1V)^((1+thetap)*(1+psie)/thetap)+psie/(1+psie);

//n13 dispersion index 
delta1V^(-(1+thetap)*(1+psie)/thetap)=(1-xip)*ptildeV^(-(1+thetap)*(1+psie)/thetap)+xip*(pitilde/piV*delta1V(-1))^(-(1+thetap)*(1+psie)/thetap); 

//n14 dispersion index 
delta2V=(1-xip)*ptildeV+xip*pitilde/piV*delta2V(-1); 

//n15 dispersion index 
delta3V^(-(1+psie+psie*thetap)/thetap)=(1-xip)*ptildeV^(-(1+psie+psie*thetap)/thetap)+xip*(pitilde/piV*delta3V(-1))^(-(1+psie+psie*thetap)/thetap); 

//n16 marginal cost
mcV=1/zVshk*mcVshk*wV/( (1-alfa)*k^alfa*nV^(-alfa) ); 

//n17 Taylor rule
%RV=max(1,RV_SS*(piV/piV_SS)^gampi*(yV/yVpot)^gamx);
RV=RV_SS*(piV/piV_SS)^gampi*(yV/yVpot)^gamx*exp(RVshk);

//n18 gov. budget
bGV=RV(-1)/piV*bGV(-1)+gV-tauCV*cV-tauNV*wV*nV-tauV;

//n19 fiscal rule for lump-sum taxes
tauV/yV_SS=tauV_SS/yV_SS+phiT*(bGV(-1)/yV_SS-bGV_SS/yV_SS);

//n20 fiscal rule for distortionary labor income taxes
tauNV/yV_SS=tauN/yV_SS+phiN*(bGV(-1)/yV_SS-bGV_SS/yV_SS);
 
//n21 flex-price: euler equation 
(cVpot-cV_SS*nuV)^(-1/sigma)/(1+tauCV)=betta*deltaV*rrVpot*(cVpot(+1)-cV_SS*nuV(+1))^(-1/sigma)/(1+tauCV(+1)); 

//n22 flex-price: leisure-labor tradeoff 
nVpot^chi/(cVpot-cV_SS*nuV)^(-1/sigma) =(1-tauNVpot)/(1+tauCV)*wVpot; 

//n23 flex-price: wage
wVpot=zVshk*(1-alfa)/(1+thetap)*k^alfa*nVpot^(-alfa);

//n24 flex-price: resource constraint
cVpot+gV=yVpot;

//n25 flex-price: production
yVpot=zVshk*k^alfa*nVpot^(1-alfa); 

//n26 flex-price: gov. budget
bGVpot=rrVpot(-1)*bGVpot(-1)+gV-tauCV*cVpot-tauNVpot*wVpot*nVpot-tauVpot;

//n27 flex-price: fiscal rule for lump-sum taxes
tauVpot/yV_SS=tauV_SS/yV_SS+phiT*(bGVpot(-1)/yV_SS-bGV_SS/yV_SS);

//n28 flex-price: fiscal rule for distortionary labor income taxes
tauNVpot/yV_SS=tauN/yV_SS+phiN*(bGVpot(-1)/yV_SS-bGV_SS/yV_SS);

//n29 (extra equation, not listed in manuscript) output gap
xV=log(yV/yVpot);

//n30 (extra equation, not listed in manuscript) real rate
rrV=RV/piV(+1);

//n31 (extra equation, not listed in manuscript) gov. consumption shock
(gV-gV_SS)=rhoG*(gV(-1)-gV_SS)+gV_eps;

//n32 (extra equation, not listed in manuscript)  consumption demand shock
(nuV-nuV_SS)=rhonu*(nuV(-1)-nuV_SS)+nuV_eps;

//n32 (extra equation, not listed in manuscript)  discount factor shock
deltaV-STEADY_STATE(deltaV)=rhonu*(deltaV(-1)-STEADY_STATE(deltaV))+deltaV_eps;

//cost push shock (inefficient shock to marginal cost)
(mcVshk-STEADY_STATE(mcVshk))=rhonu*(mcVshk(-1)-STEADY_STATE(mcVshk))+mcV_eps; 

//shock to Taylor rule
(RVshk-STEADY_STATE(RVshk))=0.7*(RVshk(-1)-STEADY_STATE(RVshk))+RV_eps;
 
//stationary neutral technology shock
(zVshk-STEADY_STATE(zVshk))=rhonu*(zVshk(-1)-STEADY_STATE(zVshk))+zV_eps;


///////////////////////////////////////////////////////
///linear economy                                    //
///////////////////////////////////////////////////////
//set some fiscal shocks not needed to zero
tauCVBREVE=0;

//l1 labor-leisure tradeoff
chi*nVHAT+(cVHAT-nuVBREVE)/(sigma*(1-nu))=wVHAT-tauNVBREVE/(1-tauN)-tauCVBREVE/(1+tauC);

//l2 euler equation
0=deltaVHAT+RVHAT-piVHAT(+1)-(cVHAT(+1)-nuVBREVE(+1))/(sigma*(1-nu))+(cVHAT-nuVBREVE)/(sigma*(1-nu))-(tauCVBREVE(+1)-tauCVBREVE)/(1+tauC);

//l3 resource constraint
cV_SS*cVHAT+gV_SS*gVHAT=yV_SS*yVHAT;

//l4 production
yVHAT=zVshkHAT+(1-alfa)*nVHAT;

//l5 Phillips curve
piVHAT=betta*piVHAT(+1)+(1-xip)*(1-xip*betta)/xip/(1-(1+thetap)*psie)*mcVHAT;

//l6 marginal cost
mcVHAT=mcVshkHAT+wVHAT+alfa*nVHAT-zVshkHAT;

//l7 Taylor rule
%RVHAT=max( (1-RV_SS)/RV_SS,gampi*piVHAT+gamx*(yVHAT-yVpotHAT));
RVHAT=gampi*piVHAT+gamx*(yVHAT-yVpotHAT)+RVshk;

//l8 gov. budget
bGVBREVE=RV_SS/piV_SS*bGV_SS*(RVHAT(-1)-piVHAT)+RV_SS/piV_SS*bGVBREVE(-1)
        +gV_SS*gVHAT-tauC*cV_SS*cVHAT-cV_SS*tauCVBREVE-wV_SS*nV_SS*tauNVBREVE
        -tauN*wV_SS*nV_SS*(wVHAT+nVHAT)-tauVBREVE;

//l9 fiscal rule for lump-sum taxes
tauVBREVE=phiT*bGVBREVE(-1);

//l10 fiscal rule for distortionary labor income taxes
tauNVBREVE=phiN*bGVBREVE(-1);

//l11 flex-price, euler equation
0=deltaVHAT+rrVpotHAT-(cVpotHAT(+1)-nuVBREVE(+1))/(sigma*(1-nu))+(cVpotHAT-nuVBREVE)/(sigma*(1-nu))-(tauCVBREVE(+1)-tauCVBREVE)/(1+tauC);

//l12 flex-price, labor/leisure tradeoff
chi*nVpotHAT+(cVpotHAT-nuVBREVE)/(sigma*(1-nu))=wVpotHAT-tauNVpotBREVE/(1-tauN)-tauCVBREVE/(1+tauC);

//l13 flex-price, real wage
wVpotHAT=-alfa*nVpotHAT+zVshkHAT;

//l4 flex-price, resource constraint
cV_SS*cVpotHAT+gV_SS*gVHAT=yV_SS*yVpotHAT;

//l5 flex-price, production
yVpotHAT=zVshkHAT+(1-alfa)*nVpotHAT;

//l6 flex-price, gov. budget
bGVpotBREVE=RV_SS/piV_SS*bGV_SS*rrVpotHAT(-1)+RV_SS/piV_SS*bGVpotBREVE(-1)
        +gV_SS*gVHAT-tauC*cV_SS*cVpotHAT-cV_SS*tauCVBREVE-wV_SS*nV_SS*tauNVpotBREVE
        -tauN*wV_SS*nV_SS*(wVpotHAT+nVpotHAT)-tauVpotBREVE;

//l7 flex-price, fiscal rule for lump-sum taxes
tauVpotBREVE=phiT*bGVpotBREVE(-1);

//l8 flex-price, fiscal rule for distortionary labor income taxes
tauNVpotBREVE=phiN*bGVpotBREVE(-1);

//l19 (extra equation, not listed in manuscript)  output gap
xVBREVE=yVHAT-yVpotHAT;

//l20 (extra equation, not listed in manuscript) real rate
rrVHAT=RVHAT-piVHAT(+1);

//l21 (extra equation, not listed in manuscript) gov. consumption shock
gVHAT=(gV-gV_SS)/gV_SS; 

//l22 (extra equation, not listed in manuscript) consumption demand shock
nuVBREVE=rhonu*nuVBREVE(-1)+nuV_eps;

//l23 (extra equation, not listed in manuscript) price dispersion
pstarVHAT=xip*pstarVHAT(-1);

//l24 (extra equation, not listed in manuscript)  discount factor shock
deltaVHAT=(deltaV-STEADY_STATE(deltaV))/STEADY_STATE(deltaV);

//Markup shock
mcVshkHAT=(mcVshk-STEADY_STATE(mcVshk))/STEADY_STATE(mcVshk); 

//Technology shock
zVshkHAT=(zVshk-STEADY_STATE(zVshk))/STEADY_STATE(zVshk);
end; 
 
