function [ys,check] = model_steadystate(ys,junk)


global M_


%read parameter values from M_.params and assign to parameters names.
num_para=size(M_.params,1);
for idxxx=1:1:num_para
    define_string=[M_.param_names(idxxx,:),'=',sprintf('%20.20g',M_.params(idxxx))];
    evalc(define_string);
end


%endogenous steady states
R=pibar/betta;
tauN=( (1+thetap)/(1-alfa) )*( (R/pibar-1)*bGy+gy-tauC*(1-gy)-tauy);
mc=1/(1+thetap);
kn=( (1-betta)/(alfa*betta)*(1+thetap))^(1/(alfa-1));
w=mc*(1-alfa)*(kn)^alfa;
yn=kn^alfa;
cy=1-gy;
cn=cy*yn;
n=((1-tauN)/(1+tauC)*w/(cn*(1-nu))^(1/sigma))^(1/(1/sigma+chi));
k=kn*n;
y=k^alfa*n^(1-alfa);
g=gy*y;
c=y-g;
lam=(c-c*nu)^(-1/sigma)/(1+tauC);
bG=bGy*y;
rr=R/pibar;
tau=tauy*y; 


s=lam*y/(1-xip*betta)*(1+psie)/(1+psie+psie*thetap);
f=lam*y/(1-xip*betta);
a=f*psie*thetap/(1+psie+psie*thetap);
vartheta=1;
ptilde=1;
delta1=1;
delta2=1;
delta3=1;


%steady states in dynare naming convention for ys vector
xV=0;
pstarV=1; 
deltaV=1;

lamV=lam;
cV=c;
nV=n; 
wV=w; 
RV=R;
piV=pibar;
yV=y; 
sV=s;
mcV=mc;
fV=f; 
bGV=bG; 
tauV=tau; 
gV=g; 
nuV=nu;
cVpot=cV; 
rrVpot=rr; 
nVpot=n; 
wVpot=w; 
yVpot=y; 
bGVpot=bG; 
tauVpot=tau;
rrV=rr;
tauNV=tauN;
tauNVpot=tauN; 
varthetaV=vartheta; 
aV=a; 
ptildeV=ptilde; 
delta2V=delta2; 
delta1V=delta1; 
delta3V=delta3;
tauCV=tauC;


xVBREVE=0; 
nVHAT=0; 
cVHAT=0; 
nuVBREVE=0; 
wVHAT=0; 
RVHAT=0; 
piVHAT=0; 
gVHAT=0; 
yVHAT=0; 
mcVHAT=0; 
bGVBREVE=0; 
tauVBREVE=0;
tauNVBREVE=0;
tauNVpotBREVE=0;
rrVpotHAT=0; 
cVpotHAT=0;
wVpotHAT=0; 
nVpotHAT=0; 
yVpotHAT=0; 
bGVpotBREVE=0; 
tauVpotBREVE=0; 
rrVHAT=0;
pstarVHAT=0;
deltaVHAT=0;
tauCVBREVE=0;


%variables needed for M_
cV_SS=c; 
piV_SS=pibar;
RV_SS=R; 
yV_SS=y; 
tauV_SS=tau; 
bGV_SS=bG; 
gV_SS=g; 
nuV_SS=nu;  
wV_SS=w;
nV_SS=n;
rrV_SS=R/pibar;
pstarV_SS=1;
tauNV_SS=tauN;

sV_SS=s; 
fV_SS=s; 
mcV_SS=mc;
deltaV_SS = deltaV;

RVshk=0;
mcVshk=1;
zVshk=1;
mcVshkHAT=0;
zVshkHAT=0;

 

%put steady states into ys vector
ys=NaN*ones(M_.orig_endo_nbr,1);
for idyyy=1:1:M_.orig_endo_nbr, %number of endogenous variables
    define_string=['ys(',num2str(idyyy), ') =',M_.endo_names(idyyy,:)];
    evalc(define_string);
end

% saving s.s. values that are used as params in static file
num_para=size(M_.params,1);
for idxxx=1:1:num_para
    define_string=['M_.params(idxxx)=',M_.param_names(idxxx,:),';'];
    evalc(define_string);
end 


%Dynare steady state indicator (0 good, 1 bad)
check=0;

