function [residual, g1, g2, g3] = det_simul_dynamic(y, x, params, steady_state, it_)
%
% Status : Computes dynamic model for Dynare
%
% Inputs :
%   y         [#dynamic variables by 1] double    vector of endogenous variables in the order stored
%                                                 in M_.lead_lag_incidence; see the Manual
%   x         [nperiods by M_.exo_nbr] double     matrix of exogenous variables (in declaration order)
%                                                 for all simulation periods
%   steady_state  [M_.endo_nbr by 1] double       vector of steady state values
%   params    [M_.param_nbr by 1] double          vector of parameter values in declaration order
%   it_       scalar double                       time period for exogenous variables for which to evaluate the model
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the dynamic model equations in order of 
%                                          declaration of the equations.
%                                          Dynare may prepend auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by #dynamic variables] double    Jacobian matrix of the dynamic model equations;
%                                                           rows: equations in order of declaration
%                                                           columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g2        [M_.endo_nbr by (#dynamic variables)^2] double   Hessian matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g3        [M_.endo_nbr by (#dynamic variables)^3] double   Third order derivative matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

%
% Model equations
%

residual = zeros(64, 1);
T18 = (-1)/params(5);
T19 = (y(44)-params(4)*y(31))^T18;
T48 = y(26)^(-1);
T52 = params(8)^params(9);
T53 = y(81)*T48*T52;
T55 = y(45)^(1-params(9));
T74 = y(50)^((1+params(40))*(1+params(7))/params(7));
T80 = params(41)/y(84);
T84 = T80^((1+params(40))*(-(1+params(7)))/params(7));
T85 = y(56)*params(1)*params(10)*T84;
T94 = (-(1+params(40)+params(7)*params(40)))/params(7);
T95 = T80^T94;
T96 = y(56)*params(1)*params(10)*T95;
T112 = (1+params(7))*(1+params(40))/params(7);
T114 = y(52)^(1+T112);
T133 = (1+params(40))*(-(1+params(7)))/params(7);
T139 = params(41)/y(21);
T169 = T52*(1-params(9))*y(45)^(-params(9));
T177 = params(12)*(y(21)/params(11))^params(13);
T179 = y(25)/y(60);
T181 = T179^params(14);
T209 = y(3)/params(15)-params(18)/params(15);
T222 = (y(57)-params(4)*y(31))^T18;
T230 = (y(91)-params(4)*y(85))^T18;
T237 = y(58)^params(6);
T248 = y(58)^(-params(9));
T254 = y(58)^(1-params(9));
T272 = y(15)/params(15)-params(18)/params(15);
T392 = (1-params(10))*(1-params(1)*params(10))/params(10)/(1-(1+params(7))*params(40));
T411 = params(12)/params(11);
T412 = params(18)*T411;
lhs =y(77);
rhs =params(2);
residual(1)= lhs-rhs;
lhs =y(63);
rhs =T19/(1+y(77));
residual(2)= lhs-rhs;
lhs =y(45)^params(6);
rhs =y(63)*(1-y(29))*y(46);
residual(3)= lhs-rhs;
lhs =y(63);
rhs =params(1)*y(56)*y(22)/y(84)*y(92);
residual(4)= lhs-rhs;
lhs =y(44)+y(30);
rhs =y(25);
residual(5)= lhs-rhs;
lhs =y(25);
rhs =T53*T55;
residual(6)= lhs-rhs;
lhs =y(47);
rhs =y(25)*y(63)*(1+params(7))*(1+params(40))/(1+params(40)+params(7)*params(40))*y(48)*T74+T85*y(88);
residual(7)= lhs-rhs;
lhs =y(49);
rhs =T74*y(63)*y(25)+T96*y(89);
residual(8)= lhs-rhs;
lhs =y(51);
rhs =y(63)*y(25)*params(7)*params(40)/(1+params(40)+params(7)*params(40))+y(56)*params(1)*params(10)*T80*y(90);
residual(9)= lhs-rhs;
lhs =y(47);
rhs =y(49)*y(52)-y(51)*T114;
residual(10)= lhs-rhs;
lhs =y(50);
rhs =1+params(40)-params(40)*y(54);
residual(11)= lhs-rhs;
lhs =y(50);
rhs =y(55);
residual(12)= lhs-rhs;
lhs =y(26);
rhs =1/(1+params(40))*(y(50)/y(53))^T112+params(40)/(1+params(40));
residual(13)= lhs-rhs;
lhs =y(53)^T133;
rhs =(1-params(10))*y(52)^T133+params(10)*(T139*y(11))^T133;
residual(14)= lhs-rhs;
lhs =y(54);
rhs =y(52)*(1-params(10))+params(10)*params(41)/y(21)*y(12);
residual(15)= lhs-rhs;
lhs =y(55)^T94;
rhs =(1-params(10))*y(52)^T94+params(10)*(T139*y(13))^T94;
residual(16)= lhs-rhs;
lhs =y(48);
rhs =y(46)*1/y(81)*y(80)/T169;
residual(17)= lhs-rhs;
lhs =y(22);
rhs =T177*T181*exp(y(79));
residual(18)= lhs-rhs;
lhs =y(27);
rhs =y(30)+y(1)/y(21)*y(3)-y(77)*y(44)-y(45)*y(29)*y(46)-y(28);
residual(19)= lhs-rhs;
lhs =y(28)/params(15);
rhs =params(16)/params(15)+params(17)*T209;
residual(20)= lhs-rhs;
lhs =y(29)/params(15);
rhs =params(3)/params(15)+T209*params(37);
residual(21)= lhs-rhs;
lhs =T222/(1+y(77));
rhs =params(1)*y(56)*y(24)*T230/(1+y(95));
residual(22)= lhs-rhs;
lhs =T237/T222;
rhs =(1-y(64))/(1+y(77))*y(59);
residual(23)= lhs-rhs;
lhs =y(59);
rhs =T52*y(81)*(1-params(9))/(1+params(7))*T248;
residual(24)= lhs-rhs;
lhs =y(30)+y(57);
rhs =y(60);
residual(25)= lhs-rhs;
lhs =y(60);
rhs =y(81)*T52*T254;
residual(26)= lhs-rhs;
lhs =y(61);
rhs =y(30)+y(2)*y(15)-y(77)*y(57)-y(58)*y(64)*y(59)-y(62);
residual(27)= lhs-rhs;
lhs =y(62)/params(15);
rhs =params(16)/params(15)+params(17)*T272;
residual(28)= lhs-rhs;
lhs =y(64)/params(15);
rhs =params(3)/params(15)+params(37)*T272;
residual(29)= lhs-rhs;
lhs =y(20);
rhs =log(T179);
residual(30)= lhs-rhs;
lhs =y(23);
rhs =y(22)/y(84);
residual(31)= lhs-rhs;
lhs =y(30)-params(22);
rhs =params(19)*(y(4)-params(22))+x(it_, 2);
residual(32)= lhs-rhs;
lhs =y(31)-params(23);
rhs =params(20)*(y(5)-params(23))+x(it_, 1);
residual(33)= lhs-rhs;
lhs =y(56)-(steady_state(37));
rhs =params(20)*(y(14)-(steady_state(37)))+x(it_, 3);
residual(34)= lhs-rhs;
lhs =y(80)-(steady_state(61));
rhs =params(20)*(y(18)-(steady_state(61)))+x(it_, 4);
residual(35)= lhs-rhs;
lhs =y(79)-(steady_state(60));
rhs =0.7*(y(17)-(steady_state(60)))+x(it_, 5);
residual(36)= lhs-rhs;
lhs =y(81)-(steady_state(62));
rhs =params(20)*(y(19)-(steady_state(62)))+x(it_, 6);
residual(37)= lhs-rhs;
residual(38) = y(78);
lhs =params(6)*y(65)+(y(66)-y(43))/(params(5)*(1-params(29)));
rhs =y(67)-y(41)/(1-params(3))-y(78)/(1+params(2));
residual(39)= lhs-rhs;
lhs =0;
rhs =(y(66)-y(43))/(params(5)*(1-params(29)))+y(76)+y(34)-y(86)-(y(93)-y(87))/(params(5)*(1-params(29)))-(y(96)-y(78))/(1+params(2));
residual(40)= lhs-rhs;
lhs =params(4)*y(66)+params(22)*y(42);
rhs =params(15)*y(37);
residual(41)= lhs-rhs;
lhs =y(37);
rhs =y(83)+(1-params(9))*y(65);
residual(42)= lhs-rhs;
lhs =y(33);
rhs =params(1)*y(86)+T392*y(68);
residual(43)= lhs-rhs;
lhs =y(68);
rhs =y(67)+y(82)+params(9)*y(65)-y(83);
residual(44)= lhs-rhs;
lhs =y(34);
rhs =y(79)+params(13)*y(33)+params(14)*(y(37)-y(71));
residual(45)= lhs-rhs;
lhs =y(39);
rhs =params(22)*y(42)+T412*(y(6)-y(33))+T411*y(9)-y(66)*params(2)*params(4)-params(4)*y(78)-y(41)*params(30)*params(31)-params(31)*params(3)*params(30)*(y(65)+y(67))-y(40);
residual(46)= lhs-rhs;
lhs =y(40);
rhs =params(17)*y(9);
residual(47)= lhs-rhs;
lhs =y(41);
rhs =params(37)*y(9);
residual(48)= lhs-rhs;
lhs =0;
rhs =y(76)+y(36)-(y(94)-y(87))/(params(5)*(1-params(29)))+(y(69)-y(43))/(params(5)*(1-params(29)))-(y(96)-y(78))/(1+params(2));
residual(49)= lhs-rhs;
lhs =(y(69)-y(43))/(params(5)*(1-params(29)))+params(6)*y(74);
rhs =y(70)-y(75)/(1-params(3))-y(78)/(1+params(2));
residual(50)= lhs-rhs;
lhs =y(70);
rhs =y(83)+(-params(9))*y(74);
residual(51)= lhs-rhs;
lhs =params(22)*y(42)+params(4)*y(69);
rhs =params(15)*y(71);
residual(52)= lhs-rhs;
lhs =y(71);
rhs =y(83)+(1-params(9))*y(74);
residual(53)= lhs-rhs;
lhs =y(72);
rhs =params(22)*y(42)+T412*y(7)+T411*y(16)-params(2)*params(4)*y(69)-params(4)*y(78)-params(30)*params(31)*y(75)-params(31)*params(3)*params(30)*(y(74)+y(70))-y(73);
residual(54)= lhs-rhs;
lhs =y(73);
rhs =params(17)*y(16);
residual(55)= lhs-rhs;
lhs =y(75);
rhs =params(37)*y(16);
residual(56)= lhs-rhs;
lhs =y(32);
rhs =y(37)-y(71);
residual(57)= lhs-rhs;
lhs =y(35);
rhs =y(34)-y(86);
residual(58)= lhs-rhs;
lhs =y(42);
rhs =(y(30)-params(22))/params(22);
residual(59)= lhs-rhs;
lhs =y(43);
rhs =x(it_, 1)+params(20)*y(10);
residual(60)= lhs-rhs;
lhs =y(38);
rhs =params(10)*y(8);
residual(61)= lhs-rhs;
lhs =y(76);
rhs =(y(56)-(steady_state(37)))/(steady_state(37));
residual(62)= lhs-rhs;
lhs =y(82);
rhs =(y(80)-(steady_state(61)))/(steady_state(61));
residual(63)= lhs-rhs;
lhs =y(83);
rhs =(y(81)-(steady_state(62)))/(steady_state(62));
residual(64)= lhs-rhs;
if nargout >= 2,
  g1 = zeros(64, 102);

  %
  % Jacobian matrix
  %

T520 = getPowerDeriv(T139*y(11),T133,1);
T529 = getPowerDeriv(T139*y(13),T94,1);
T586 = getPowerDeriv(T179,params(14),1);
T599 = 1/params(15);
T614 = getPowerDeriv(y(44)-params(4)*y(31),T18,1);
T618 = getPowerDeriv(y(57)-params(4)*y(31),T18,1);
T625 = getPowerDeriv(y(91)-params(4)*y(85),T18,1);
T643 = (-1)/(params(5)*(1-params(29)));
T670 = getPowerDeriv(y(50),(1+params(40))*(1+params(7))/params(7),1);
T676 = getPowerDeriv(y(50)/y(53),T112,1);
T774 = 1/(params(5)*(1-params(29)));
T794 = 1/(1+params(2));
  g1(1,77)=1;
  g1(2,31)=(-((-params(4))*T614/(1+y(77))));
  g1(2,44)=(-(T614/(1+y(77))));
  g1(2,63)=1;
  g1(2,77)=(-((-T19)/((1+y(77))*(1+y(77)))));
  g1(3,29)=(-(y(46)*(-y(63))));
  g1(3,45)=getPowerDeriv(y(45),params(6),1);
  g1(3,46)=(-(y(63)*(1-y(29))));
  g1(3,63)=(-((1-y(29))*y(46)));
  g1(4,84)=(-(y(92)*(-(params(1)*y(56)*y(22)))/(y(84)*y(84))));
  g1(4,22)=(-(y(92)*params(1)*y(56)/y(84)));
  g1(4,56)=(-(y(92)*params(1)*y(22)/y(84)));
  g1(4,63)=1;
  g1(4,92)=(-(params(1)*y(56)*y(22)/y(84)));
  g1(5,25)=(-1);
  g1(5,30)=1;
  g1(5,44)=1;
  g1(6,25)=1;
  g1(6,26)=(-(T55*T52*y(81)*getPowerDeriv(y(26),(-1),1)));
  g1(6,45)=(-(T53*getPowerDeriv(y(45),1-params(9),1)));
  g1(6,81)=(-(T55*T48*T52));
  g1(7,84)=(-(y(88)*y(56)*params(1)*params(10)*(-params(41))/(y(84)*y(84))*getPowerDeriv(T80,(1+params(40))*(-(1+params(7)))/params(7),1)));
  g1(7,25)=(-(T74*y(63)*(1+params(7))*(1+params(40))/(1+params(40)+params(7)*params(40))*y(48)));
  g1(7,47)=1;
  g1(7,88)=(-T85);
  g1(7,48)=(-(y(25)*y(63)*(1+params(7))*(1+params(40))/(1+params(40)+params(7)*params(40))*T74));
  g1(7,50)=(-(y(25)*y(63)*(1+params(7))*(1+params(40))/(1+params(40)+params(7)*params(40))*y(48)*T670));
  g1(7,56)=(-(y(88)*params(1)*params(10)*T84));
  g1(7,63)=(-(T74*y(48)*y(25)*(1+params(7))*(1+params(40))/(1+params(40)+params(7)*params(40))));
  g1(8,84)=(-(y(89)*y(56)*params(1)*params(10)*(-params(41))/(y(84)*y(84))*getPowerDeriv(T80,T94,1)));
  g1(8,25)=(-(y(63)*T74));
  g1(8,49)=1;
  g1(8,89)=(-T96);
  g1(8,50)=(-(y(63)*y(25)*T670));
  g1(8,56)=(-(y(89)*params(1)*params(10)*T95));
  g1(8,63)=(-(y(25)*T74));
  g1(9,84)=(-(y(90)*y(56)*params(1)*params(10)*(-params(41))/(y(84)*y(84))));
  g1(9,25)=(-(y(63)*params(7)*params(40)/(1+params(40)+params(7)*params(40))));
  g1(9,51)=1;
  g1(9,90)=(-(y(56)*params(1)*params(10)*T80));
  g1(9,56)=(-(y(90)*params(1)*params(10)*T80));
  g1(9,63)=(-(y(25)*params(7)*params(40)/(1+params(40)+params(7)*params(40))));
  g1(10,47)=1;
  g1(10,49)=(-y(52));
  g1(10,51)=T114;
  g1(10,52)=(-(y(49)-y(51)*getPowerDeriv(y(52),1+T112,1)));
  g1(11,50)=1;
  g1(11,54)=params(40);
  g1(12,50)=1;
  g1(12,55)=(-1);
  g1(13,26)=1;
  g1(13,50)=(-(1/(1+params(40))*1/y(53)*T676));
  g1(13,53)=(-(1/(1+params(40))*T676*(-y(50))/(y(53)*y(53))));
  g1(14,21)=(-(params(10)*y(11)*(-params(41))/(y(21)*y(21))*T520));
  g1(14,52)=(-((1-params(10))*getPowerDeriv(y(52),T133,1)));
  g1(14,11)=(-(params(10)*T139*T520));
  g1(14,53)=getPowerDeriv(y(53),T133,1);
  g1(15,21)=(-(y(12)*(-(params(10)*params(41)))/(y(21)*y(21))));
  g1(15,52)=(-(1-params(10)));
  g1(15,12)=(-(params(10)*params(41)/y(21)));
  g1(15,54)=1;
  g1(16,21)=(-(params(10)*y(13)*(-params(41))/(y(21)*y(21))*T529));
  g1(16,52)=(-((1-params(10))*getPowerDeriv(y(52),T94,1)));
  g1(16,13)=(-(params(10)*T139*T529));
  g1(16,55)=getPowerDeriv(y(55),T94,1);
  g1(17,45)=(-((-(y(46)*1/y(81)*y(80)*T52*(1-params(9))*getPowerDeriv(y(45),(-params(9)),1)))/(T169*T169)));
  g1(17,46)=(-(1/y(81)*y(80)/T169));
  g1(17,48)=1;
  g1(17,80)=(-(y(46)*1/y(81)/T169));
  g1(17,81)=(-(y(46)*y(80)*(-1)/(y(81)*y(81))/T169));
  g1(18,21)=(-(exp(y(79))*T181*params(12)*1/params(11)*getPowerDeriv(y(21)/params(11),params(13),1)));
  g1(18,22)=1;
  g1(18,25)=(-(exp(y(79))*T177*1/y(60)*T586));
  g1(18,60)=(-(exp(y(79))*T177*T586*(-y(25))/(y(60)*y(60))));
  g1(18,79)=(-(T177*T181*exp(y(79))));
  g1(19,21)=(-(y(3)*(-y(1))/(y(21)*y(21))));
  g1(19,1)=(-(y(3)*1/y(21)));
  g1(19,3)=(-(y(1)/y(21)));
  g1(19,27)=1;
  g1(19,28)=1;
  g1(19,29)=y(45)*y(46);
  g1(19,30)=(-1);
  g1(19,44)=y(77);
  g1(19,45)=y(29)*y(46);
  g1(19,46)=y(45)*y(29);
  g1(19,77)=y(44);
  g1(20,3)=(-(params(17)*T599));
  g1(20,28)=T599;
  g1(21,3)=(-(params(37)*T599));
  g1(21,29)=T599;
  g1(22,24)=(-(params(1)*y(56)*T230/(1+y(95))));
  g1(22,31)=(-params(4))*T618/(1+y(77));
  g1(22,85)=(-(params(1)*y(56)*y(24)*(-params(4))*T625/(1+y(95))));
  g1(22,56)=(-(T230*params(1)*y(24)/(1+y(95))));
  g1(22,57)=T618/(1+y(77));
  g1(22,91)=(-(params(1)*y(56)*y(24)*T625/(1+y(95))));
  g1(22,77)=(-T222)/((1+y(77))*(1+y(77)));
  g1(22,95)=(-((-(params(1)*y(56)*y(24)*T230))/((1+y(95))*(1+y(95)))));
  g1(23,31)=(-(T237*(-params(4))*T618))/(T222*T222);
  g1(23,57)=(-(T237*T618))/(T222*T222);
  g1(23,58)=getPowerDeriv(y(58),params(6),1)/T222;
  g1(23,59)=(-((1-y(64))/(1+y(77))));
  g1(23,64)=(-(y(59)*(-1)/(1+y(77))));
  g1(23,77)=(-(y(59)*(-(1-y(64)))/((1+y(77))*(1+y(77)))));
  g1(24,58)=(-(T52*y(81)*(1-params(9))/(1+params(7))*getPowerDeriv(y(58),(-params(9)),1)));
  g1(24,59)=1;
  g1(24,81)=(-(T248*T52*(1-params(9))/(1+params(7))));
  g1(25,30)=1;
  g1(25,57)=1;
  g1(25,60)=(-1);
  g1(26,58)=(-(y(81)*T52*getPowerDeriv(y(58),1-params(9),1)));
  g1(26,60)=1;
  g1(26,81)=(-(T52*T254));
  g1(27,2)=(-y(15));
  g1(27,30)=(-1);
  g1(27,57)=y(77);
  g1(27,58)=y(64)*y(59);
  g1(27,59)=y(58)*y(64);
  g1(27,15)=(-y(2));
  g1(27,61)=1;
  g1(27,62)=1;
  g1(27,64)=y(58)*y(59);
  g1(27,77)=y(57);
  g1(28,15)=(-(params(17)*T599));
  g1(28,62)=T599;
  g1(29,15)=(-(params(37)*T599));
  g1(29,64)=T599;
  g1(30,20)=1;
  g1(30,25)=(-(1/y(60)/T179));
  g1(30,60)=(-((-y(25))/(y(60)*y(60))/T179));
  g1(31,84)=(-((-y(22))/(y(84)*y(84))));
  g1(31,22)=(-(1/y(84)));
  g1(31,23)=1;
  g1(32,4)=(-params(19));
  g1(32,30)=1;
  g1(32,98)=(-1);
  g1(33,5)=(-params(20));
  g1(33,31)=1;
  g1(33,97)=(-1);
  g1(34,14)=(-params(20));
  g1(34,56)=1;
  g1(34,99)=(-1);
  g1(35,18)=(-params(20));
  g1(35,80)=1;
  g1(35,100)=(-1);
  g1(36,17)=(-0.7);
  g1(36,79)=1;
  g1(36,101)=(-1);
  g1(37,19)=(-params(20));
  g1(37,81)=1;
  g1(37,102)=(-1);
  g1(38,78)=1;
  g1(39,41)=1/(1-params(3));
  g1(39,43)=T643;
  g1(39,65)=params(6);
  g1(39,66)=T774;
  g1(39,67)=(-1);
  g1(39,78)=T794;
  g1(40,86)=1;
  g1(40,34)=(-1);
  g1(40,43)=(-T643);
  g1(40,87)=T643;
  g1(40,66)=(-T774);
  g1(40,93)=T774;
  g1(40,76)=(-1);
  g1(40,78)=(-1)/(1+params(2));
  g1(40,96)=T794;
  g1(41,37)=(-params(15));
  g1(41,42)=params(22);
  g1(41,66)=params(4);
  g1(42,37)=1;
  g1(42,65)=(-(1-params(9)));
  g1(42,83)=(-1);
  g1(43,33)=1;
  g1(43,86)=(-params(1));
  g1(43,68)=(-T392);
  g1(44,65)=(-params(9));
  g1(44,67)=(-1);
  g1(44,68)=1;
  g1(44,82)=(-1);
  g1(44,83)=1;
  g1(45,33)=(-params(13));
  g1(45,34)=1;
  g1(45,37)=(-params(14));
  g1(45,71)=params(14);
  g1(45,79)=(-1);
  g1(46,33)=T412;
  g1(46,6)=(-T412);
  g1(46,9)=(-T411);
  g1(46,39)=1;
  g1(46,40)=1;
  g1(46,41)=params(30)*params(31);
  g1(46,42)=(-params(22));
  g1(46,65)=params(31)*params(3)*params(30);
  g1(46,66)=params(2)*params(4);
  g1(46,67)=params(31)*params(3)*params(30);
  g1(46,78)=params(4);
  g1(47,9)=(-params(17));
  g1(47,40)=1;
  g1(48,9)=(-params(37));
  g1(48,41)=1;
  g1(49,36)=(-1);
  g1(49,43)=(-T643);
  g1(49,87)=T643;
  g1(49,69)=(-T774);
  g1(49,94)=T774;
  g1(49,76)=(-1);
  g1(49,78)=(-1)/(1+params(2));
  g1(49,96)=T794;
  g1(50,43)=T643;
  g1(50,69)=T774;
  g1(50,70)=(-1);
  g1(50,74)=params(6);
  g1(50,75)=1/(1-params(3));
  g1(50,78)=T794;
  g1(51,70)=1;
  g1(51,74)=params(9);
  g1(51,83)=(-1);
  g1(52,42)=params(22);
  g1(52,69)=params(4);
  g1(52,71)=(-params(15));
  g1(53,71)=1;
  g1(53,74)=(-(1-params(9)));
  g1(53,83)=(-1);
  g1(54,7)=(-T412);
  g1(54,42)=(-params(22));
  g1(54,69)=params(2)*params(4);
  g1(54,70)=params(31)*params(3)*params(30);
  g1(54,16)=(-T411);
  g1(54,72)=1;
  g1(54,73)=1;
  g1(54,74)=params(31)*params(3)*params(30);
  g1(54,75)=params(30)*params(31);
  g1(54,78)=params(4);
  g1(55,16)=(-params(17));
  g1(55,73)=1;
  g1(56,16)=(-params(37));
  g1(56,75)=1;
  g1(57,32)=1;
  g1(57,37)=(-1);
  g1(57,71)=1;
  g1(58,86)=1;
  g1(58,34)=(-1);
  g1(58,35)=1;
  g1(59,30)=(-(1/params(22)));
  g1(59,42)=1;
  g1(60,10)=(-params(20));
  g1(60,43)=1;
  g1(60,97)=(-1);
  g1(61,8)=(-params(10));
  g1(61,38)=1;
  g1(62,56)=(-(1/(steady_state(37))));
  g1(62,76)=1;
  g1(63,80)=(-(1/(steady_state(61))));
  g1(63,82)=1;
  g1(64,81)=(-(1/(steady_state(62))));
  g1(64,83)=1;

if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],64,10404);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],64,1061208);
end
end
end
end
